/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef ELIMINATOR_H
#define ELIMINATOR_H

#include "rationalFunction/RationalFunction.h"
#include "SparseMC.h"

namespace parametric {
  class Eliminator {
  public:
    enum EliminationOrder {forward, backward, random};
    
    void setGraph(Graph *);
    void setInitStates(StateSet &);
    void setTargetStates(StateSet &);
    void setStateRewards(RewardMap &);
    void setRewardAnalysis(bool);
    void setEliminationOrder(EliminationOrder);
    void eliminate(std::vector<Rational::RationalFunction> &);
  private:
    void collectNonInitNonTargetStates(StateSet &);
    void collectNonInitNonTargetStates(StateList &);
    void collectNonInitNonTargetStatesOrdered(StateList &);
    Rational::RationalFunction leavingSum(vertex_descriptor);
    void eliminateState(vertex_descriptor);
    void eliminateStates(StateList &);
    void prepareInitialStatesForUnbounded();
    
    Graph *graph;
    StateSet *initStates;
    StateSet *targetStates;
    RewardMap *stateRewards;
    bool rewardAnalysis;
    EliminationOrder eliminationOrder;
  };
}

#endif
