/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef PASS_STATE_EXPLORER_H
#define PASS_STATE_EXPLORER_H

#include <vector>
#include "expr.h"

namespace infamation {
  class Model2C;
}

namespace parametric {
  
  class SparseMC;
  
  class PASSStateExplorer {
  public:
    PASSStateExplorer(SparseMC &);
    void explore();
  private:
    void parseFormula();
    void loadModel(const std::string &, const std::string &);
    void prepareNondetVars(infamation::Model2C &);
    void constructMC(infamation::Model2C &);
    void exploreAllStates(infamation::Model2C &);
    
    SparseMC &mc;
    CVC3::Expr leftF;
    CVC3::Expr rightF;
    CVC3::Expr sinkF;
    vertex_descriptor targetState;
    vertex_descriptor sinkState;
    std::vector<CVC3::Expr> variables;
    bool encode;
    bool minimize;
  };
}

#endif
