/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include <iostream>
#ifndef __APPLE__
#include <malloc.h>
#endif
#include <iomanip>
#include "Statistics.h"

namespace parametric {
  
  using namespace std;
  
  /**
   * Print statistics to stream @a stream.
   *
   * @param stream output stream to print statistics to
   */
  void Statistics::print(std::ostream &stream) const {
    stream << "total-time: " << totalTime.Read() << endl;
    stream << "exploration-time: " << exploreTime.Read() << endl;
    stream << "lumping-time: " << lumpTime.Read() << endl;
    stream << "analysis-time: " << analysisTime.Read() << endl;
    stream << "number-model-states: " << numStatesModel << endl;
    stream << "number-model-transitions: " << numTransitionsModel << endl;
    stream << "number-quotient-states: " << numStatesQuotient << endl;
    stream << "number-quotient-transitions: "
           << numTransitionsQuotient << endl;
    stream << "memory-used: "
#ifndef __APPLE__
           << (mallinfo().arena / (1024.0 * 1024.0)) << endl;
#else
    << "?" << endl;
#endif
  }
  
  /**
   * Print statistics to standard output.
   */
  void Statistics::print() const {
    print(cout);
  }
  
  /**
   * Print statistics to file @a filename.
   *
   * @param filename filename of file to print statistics to
   */
  void Statistics::print(const std::string &filename) const {
    ofstream file(filename.c_str(), ios::out);
    print(file);
    file.close();
  }
}
