/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef TRANS_PROP_H
#define TRANS_PROP_H
  
#include <boost/graph/graph_traits.hpp>
#include <boost/graph/adjacency_list.hpp>
#include <boost/graph/dijkstra_shortest_paths.hpp>  
#include <boost/graph/graph_traits.hpp>
#include <boost/program_options.hpp>

#include "rationalFunction/RationalFunction.h"

namespace parametric {
  
  class TransProp {
  public:
    TransProp();
    TransProp(const Rational::RationalFunction &);
    TransProp(const TransProp &);
    ~TransProp();
    inline void setValue(const Rational::RationalFunction &__value) {
      value = __value;
    }
    inline void setReward(const Rational::RationalFunction &__reward) {
      reward = __reward;
    }
    inline const Rational::RationalFunction &getValue() const {
      return value;
    }
    inline const Rational::RationalFunction &getReward() const {
      return reward;
    }
    TransProp &operator=(TransProp const &other);
  private:
    Rational::RationalFunction value;
    Rational::RationalFunction reward;
  };
}

#endif
