/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include "SparseMC.h"
#include "ProgramOptions.h"
#include "rationalFunction/RationalFunction.h"

using namespace std;
namespace po = boost::program_options;
using namespace parametric;
using namespace Rational;

int main(int argc, char *argv[])
{
  try {
    po::variables_map vm = parseCommandLine(argc, argv);
    /* exit if requested or wrong syntax used */
    if (vm.count("help")) {
      return EXIT_SUCCESS;
    } else if (0 == vm.count("model-file")) {
      return EXIT_FAILURE;
    } else {
      SparseMC mc(vm);
      mc.parse();

      if (0 != vm.count("model-dot")) {
        mc.printDOT(vm["model-dot"].as<string>());
      }
      vector<RationalFunction> result;
      mc.execute(result);
      mc.printResult(result, vm["result-file"].as<string>());
      mc.printStatistics();
      
      return EXIT_SUCCESS;
    }
  } catch (exception &e) {
    cerr << "\nThe following problem occured:\n  " << e.what() << endl;
    
    return EXIT_FAILURE;
  }
}
