/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef BOUNDED_ITERATOR_H
#define BOUNDED_ITERATOR_H

#include "rationalFunction/RationalFunction.h"
#include "Controller.h"

namespace parametric {
  class PMC;

  class BoundedIterator {
    typedef HashMap<unsigned,Rational::RationalFunction> Results;
  public:
    void setPMC(PMC &);
    void setInitStates(StateSet &);
    void setTargetStates(StateSet &);
    void setTimeBound(double);
    void iterate(Results &);
  private:
    void multiply(StateMap &, StateMap &);
    PMC *pmc;
    StateSet *initStates;
    StateSet *targetStates;
    unsigned timeBound;
  };
}

#endif
