/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef ELIMINATOR_H
#define ELIMINATOR_H

#include "rationalFunction/RationalFunction.h"
#include "Controller.h"

namespace parametric {
  class GPMC;

  class Eliminator {
  public:
    enum EliminationOrder {forward, backward, random};
    
    void setPMC(GPMC &);
    void setInitStates(StateSet &);
    void setTargetStates(StateSet &);
    void setRewardAnalysis(bool);
    void setEliminationOrder(EliminationOrder);
    void eliminate(Results &);
  private:
    void collectStatesOrdered(StateList &);
    Rational::RationalFunction leavingSum(unsigned);
    void eliminateState(unsigned);
    void eliminateStates(StateList &);
    
    GPMC *pmc;
    StateSet *initStates;
    StateSet *targetStates;
    bool rewardAnalysis;
    EliminationOrder eliminationOrder;
  };
}

#endif
