/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include <utility>
#include <vector>
#include <list>
#include <gmpxx.h>
#include <boost/tuple/tuple.hpp>
#include "Controller.h"

#ifndef REGION_SCHEDULER_H
#define REGION_SCHEDULER_H

namespace parametric {
  typedef HashMap<PMM::state,Rational::RationalFunction> Results;
  typedef HashMap<PMM::state,unsigned> ParametricScheduler;
  typedef std::pair<mpq_class,mpq_class> Interval;
  typedef std::vector<Interval> Box;
  typedef std::list<Box> ToDoList;
  class RegionScheduler : public std::list<boost::tuples::tuple<Box,Results,ParametricScheduler> > {};
}

#endif
