
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         PRISMparse
#define yylex           PRISMlex
#define yyerror         PRISMerror
#define yylval          PRISMlval
#define yychar          PRISMchar
#define yydebug         PRISMdebug
#define yynerrs         PRISMnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 1 "PRISM.ypp"

/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2007-2010 Bjoern Wachter (Bjoern.Wachter@comlab.ox.ac.uk)
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include "Util.h"
#include "AST.h"
#include "PRISMParser.h"
#include "Substitutor.h"

using namespace prismparser_ast;
using namespace boost;
using namespace std;

// function forward declarations
extern int PRISMlex();
void PRISMerror(const char *s);
 
void PRISMerror(const std::string& s);
void PRISMwarning(const std::string& s );

namespace prismparser {
  extern prismparser_ast::Substitution constants;
  extern int line_number;
}

namespace prismparser {
  int line_number = 1;
  Alternative* alternative = 0;
  Command* command = 0;
  Module* module = 0;

  Substitution formulas;
  
  Exprs predicates;
  Exprs properties;
  Exprs invariants;
  
  Variables global_vars;
  
  shared_ptr<Expr> initial;
  StateRewards state_rewards;
  TransitionRewards transition_rewards;
  
  
  struct Subst {
    Substitution expr_subst;
    ActionSubstitution action_subst;
    Subst() {}
    Subst(Substitution& e, ActionSubstitution& a) : expr_subst(e), action_subst(a) {}
    void clear() { expr_subst.clear(); action_subst.clear(); } 
  } subst;

  struct Instantiation {
    std::string name;
    std::string original;
    Subst subst;
    
    Instantiation(const std::string& n, const std::string& o, const Subst& s) :
      name(n), original(o), subst(s) {}
  };

  /*
    Due to formula and const, we need to do delayed instantiation,
    i.e. first read <<const>> and <<formula>> and then do the actual instantiation.
  */
  class ModuleManager {
  public:
    ModuleManager(Substitution& f, Substitution& c) : formulas(f), constants(c) {}
    
    void addModule(Module* m) {
      assert(m);
      boost::shared_ptr<Module> mptr(m);
      modules.insert(std::pair<std::string,boost::shared_ptr<Module> >(m->name, mptr));
    } 
    
    typedef std::vector<Instantiation> Instantiations;  
    
    void addInstantiation(const Instantiation& instantiation) {
      instantiations.push_back(instantiation);
    }
    
    void addModules(prismparser_ast::Model& model) {
      // substitute formulas into original
      Apply(formulas,modules);
                
      // instantiate modules using original modules
      instantiateModules(instantiations,modules);
      // postcondition: the instantiated modules end up in modules
                
      // substitute constants into original and instantiated modules
      Apply(constants,modules);
      // postcondition: result ends up in modules
                
      // put the modules into the model
      for (Modules::const_iterator i (modules.begin ());
           i != modules.end (); ++i)
        {
          model.addModule(i->second);
        }
    }

    void clear() {
      modules.clear();
      instantiations.clear();
    }

  private:
    Substitution& formulas;
    Substitution& constants;
    Instantiations instantiations;
        
    Module* instantiate(const Instantiation& inst) {
        
      // (1) lookup the module to substitute into
      Modules::const_iterator it(modules.find(inst.original));
      if (it == modules.end())
        PRISMerror("Module "+ inst.original + " not found");
                        
      Module* instantiated_module(it->second.get());

      // (2) invoke instantiation code with substition vector
      std::string instance_module_name(inst.name);
      Module* instance( 
                       new Module(instance_module_name, 
                                  instantiated_module, 
                                  inst.subst.expr_subst,
                                  inst.subst.action_subst));
        
      if(!instance) 
        PRISMerror("Module "+ instance_module_name + " could not be created");
      return instance;
    }

    void Apply(const Substitution& s, Modules& modules) {
      Modules new_modules;
      for (Modules::const_iterator i (modules.begin ());
           i != modules.end (); ++i)
        {
          std::string key(i->first);
          boost::shared_ptr<Module> mptr(new Module(key,i->second.get(),s));
          new_modules.insert(std::pair<std::string,boost::shared_ptr<Module> >(key, mptr));
        }
      modules = new_modules;
    }
        
    void instantiateModules(const Instantiations& instantiations, Modules& modules) {
      for(Instantiations::const_iterator it = instantiations.begin();it!=instantiations.end();++it) {
        const Instantiation& inst(*it);
        boost::shared_ptr<Module> mptr(instantiate(inst));
        modules.insert(std::pair<std::string,boost::shared_ptr<Module> >(inst.name, mptr));
      }
    }

        

    Modules modules;
  };

  ModuleManager module_manager(formulas,constants);

}


using namespace prismparser; 




/* Line 189 of yacc.c  */
#line 268 "PRISM.tab.cpp"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     BOGY = 258,
     LE_OP = 259,
     GE_OP = 260,
     EQ_OP = 261,
     NE_OP = 262,
     MIN_OP = 263,
     MAX_OP = 264,
     LEFT_OP = 265,
     RIGHT_OP = 266,
     INPUT = 267,
     TRUE = 268,
     FALSE = 269,
     INTEGER = 270,
     BOOL = 271,
     LONG = 272,
     FLOAT = 273,
     DOUBLE = 274,
     BV = 275,
     SHARP = 276,
     NEWLINE = 277,
     UNTIL = 278,
     NEXT = 279,
     PROB = 280,
     PROBMAX = 281,
     PROBMIN = 282,
     STEADY = 283,
     STEADYMAX = 284,
     STEADYMIN = 285,
     FINALLY = 286,
     CUMULATIVE = 287,
     MODULE = 288,
     ENDMODULE = 289,
     CONSTANT = 290,
     GLOBAL = 291,
     PARAM = 292,
     STOCH = 293,
     NONDET = 294,
     PROBAB = 295,
     PRIMED = 296,
     ASSIGN = 297,
     DISTR = 298,
     BLOCK = 299,
     VAR = 300,
     INIT = 301,
     ENDINIT = 302,
     INVAR = 303,
     ENDINVAR = 304,
     PRED = 305,
     DOTS = 306,
     LABEL = 307,
     QUOTE = 308,
     INT_CONSTANT = 309,
     FLOAT_CONSTANT = 310,
     BOOL_CONSTANT = 311,
     BV_CONSTANT = 312,
     IDENTIFIER = 313,
     FORMULA = 314,
     STRING_LITERAL = 315,
     REWARDS = 316,
     ENDREWARDS = 317,
     REW = 318,
     I_REW = 319,
     REWMAX = 320,
     REWMIN = 321,
     UPLUS = 322,
     UMINUS = 323
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 187 "PRISM.ypp"

  Expr *node;
  std::vector<Expr> *vec;

  Alternative* a;
  Type* type;
  int int_const;
  double float_const;
  struct { long long value; unsigned size;} bv_const;

  char* string_const;
  bool b;
  
  Expr* prop;

  ModelType model_type;
  Kind kind;



/* Line 214 of yacc.c  */
#line 393 "PRISM.tab.cpp"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 405 "PRISM.tab.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  52
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1650

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  88
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  47
/* YYNRULES -- Number of rules.  */
#define YYNRULES  146
/* YYNRULES -- Number of states.  */
#define YYNSTATES  405

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   323

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    79,     2,     2,     2,    78,    70,     2,
      82,    84,    76,    74,    83,    75,     2,    77,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    68,    87,
      72,    71,    73,    67,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    85,     2,    86,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    69,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    80,    81
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    19,
      23,    26,    29,    33,    37,    41,    45,    49,    53,    57,
      61,    65,    72,    79,    82,    86,    90,    96,   100,   104,
     106,   113,   117,   119,   121,   123,   127,   129,   130,   135,
     138,   141,   144,   148,   149,   150,   157,   158,   161,   165,
     167,   168,   170,   173,   174,   176,   178,   180,   182,   184,
     190,   195,   202,   208,   215,   220,   226,   227,   230,   234,
     236,   240,   242,   246,   250,   252,   253,   260,   261,   262,
     273,   277,   279,   282,   287,   294,   302,   306,   307,   309,
     311,   313,   315,   317,   319,   321,   323,   325,   327,   329,
     332,   334,   337,   345,   347,   349,   351,   353,   355,   362,
     369,   376,   383,   390,   397,   404,   411,   418,   425,   432,
     439,   446,   453,   460,   467,   474,   481,   488,   495,   502,
     509,   516,   523,   531,   540,   549,   556,   563,   570,   576,
     582,   591,   595,   598,   601,   606,   611
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     129,     0,    -1,    54,    -1,    55,    -1,    89,    -1,    13,
      -1,    14,    -1,    58,    -1,    90,    71,    90,    -1,    90,
       7,    90,    -1,    74,    90,    -1,    75,    90,    -1,    90,
      74,    90,    -1,    90,    75,    90,    -1,    90,    76,    90,
      -1,    90,    77,    90,    -1,    90,    78,    90,    -1,    90,
      72,    90,    -1,    90,    73,    90,    -1,    90,     4,    90,
      -1,    90,     5,    90,    -1,     9,    82,    90,    83,    90,
      84,    -1,     8,    82,    90,    83,    90,    84,    -1,    79,
      90,    -1,    90,    70,    90,    -1,    90,    69,    90,    -1,
      90,    67,    90,    68,    90,    -1,    82,    90,    84,    -1,
      53,    58,    53,    -1,   133,    -1,    82,    90,    41,    71,
      90,    84,    -1,    92,    70,    91,    -1,    91,    -1,    92,
      -1,    13,    -1,    90,    68,    93,    -1,    94,    -1,    -1,
      94,    74,    96,    95,    -1,    43,    93,    -1,    43,    95,
      -1,    85,    86,    -1,    85,    58,    86,    -1,    -1,    -1,
      98,   100,    90,   101,    97,    87,    -1,    -1,   102,    99,
      -1,    46,    90,    47,    -1,   102,    -1,    -1,   108,    -1,
      46,    90,    -1,    -1,   106,    -1,    15,    -1,    18,    -1,
      19,    -1,    16,    -1,    85,    90,    51,    90,    86,    -1,
      20,    85,    90,    86,    -1,    36,    58,    68,   108,   107,
      87,    -1,    58,    68,   108,   107,    87,    -1,    35,   105,
      58,    71,    90,    87,    -1,    37,   108,    58,    87,    -1,
      59,    58,    71,    90,    87,    -1,    -1,   112,   110,    -1,
      50,   114,    87,    -1,   115,    -1,   114,    83,   115,    -1,
      90,    -1,    58,    71,    90,    -1,   117,    83,   116,    -1,
     116,    -1,    -1,    33,    58,   119,   112,   104,    34,    -1,
      -1,    -1,    33,    58,    71,    58,   120,    85,   117,    86,
     121,    34,    -1,    61,   123,    62,    -1,   124,    -1,   123,
     124,    -1,    90,    68,    90,    87,    -1,    85,    86,    90,
      68,    90,    87,    -1,    85,    58,    86,    90,    68,    90,
      87,    -1,    48,    90,    87,    -1,    -1,    40,    -1,    38,
      -1,    39,    -1,   109,    -1,   111,    -1,   118,    -1,   103,
      -1,   122,    -1,   125,    -1,   113,    -1,   132,    -1,   128,
     127,    -1,   127,    -1,   126,   128,    -1,    52,    53,    58,
      53,    71,    90,    87,    -1,    26,    -1,    27,    -1,    25,
      -1,    90,    -1,   130,    -1,   131,     5,    89,    85,   134,
      86,    -1,   131,    73,    89,    85,   134,    86,    -1,   131,
       4,    89,    85,   134,    86,    -1,   131,    72,    89,    85,
     134,    86,    -1,   131,    71,    67,    85,   134,    86,    -1,
     131,    71,    89,    85,   134,    86,    -1,    28,     5,    89,
      85,    90,    86,    -1,    28,    73,    89,    85,    90,    86,
      -1,    28,     4,    89,    85,    90,    86,    -1,    28,    72,
      89,    85,    90,    86,    -1,    28,    71,    67,    85,    90,
      86,    -1,    28,    71,    89,    85,    90,    86,    -1,    29,
       5,    89,    85,    90,    86,    -1,    29,    73,    89,    85,
      90,    86,    -1,    29,     4,    89,    85,    90,    86,    -1,
      29,    72,    89,    85,    90,    86,    -1,    29,    71,    67,
      85,    90,    86,    -1,    29,    71,    89,    85,    90,    86,
      -1,    30,     5,    89,    85,    90,    86,    -1,    30,    73,
      89,    85,    90,    86,    -1,    30,     4,    89,    85,    90,
      86,    -1,    30,    72,    89,    85,    90,    86,    -1,    30,
      71,    67,    85,    90,    86,    -1,    30,    71,    89,    85,
      90,    86,    -1,    63,    71,    67,    85,    31,    90,    86,
      -1,    63,    71,    67,    85,    32,     4,    89,    86,    -1,
      63,    71,    67,    85,    64,    71,    89,    86,    -1,    63,
      71,    67,    85,    28,    86,    -1,    65,    71,    67,    85,
      28,    86,    -1,    66,    71,    67,    85,    28,    86,    -1,
      90,    23,     5,    89,    90,    -1,    90,    23,     4,    89,
      90,    -1,    90,    23,    85,    89,    83,    89,    86,    90,
      -1,    90,    23,    90,    -1,    31,    90,    -1,    24,    90,
      -1,    24,     5,    89,    90,    -1,    24,     4,    89,    90,
      -1,    24,    85,    89,    83,    89,    86,    90,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   294,   294,   298,   306,   307,   310,   313,   317,   320,
     323,   327,   331,   334,   337,   340,   343,   346,   349,   352,
     355,   358,   361,   364,   368,   371,   374,   377,   380,   384,
     388,   396,   397,   401,   402,   406,   414,   419,   418,   428,
     431,   435,   436,   440,   451,   439,   462,   464,   468,   478,
     482,   484,   488,   493,   494,   498,   500,   502,   504,   506,
     508,   521,   533,   547,   556,   563,   573,   575,   579,   583,
     584,   588,   596,   614,   615,   621,   620,   631,   634,   631,
     651,   655,   656,   660,   665,   670,   680,   688,   689,   690,
     691,   695,   696,   697,   698,   699,   700,   701,   702,   706,
     707,   711,   780,   793,   794,   795,   799,   804,   808,   812,
     816,   820,   824,   827,   831,   835,   839,   843,   847,   850,
     854,   858,   862,   866,   870,   873,   877,   881,   885,   889,
     893,   896,   900,   903,   907,   912,   915,   918,   924,   927,
     930,   933,   936,   939,   942,   945,   948
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "BOGY", "LE_OP", "GE_OP", "EQ_OP",
  "NE_OP", "MIN_OP", "MAX_OP", "LEFT_OP", "RIGHT_OP", "INPUT", "TRUE",
  "FALSE", "INTEGER", "BOOL", "LONG", "FLOAT", "DOUBLE", "BV", "SHARP",
  "NEWLINE", "UNTIL", "NEXT", "PROB", "PROBMAX", "PROBMIN", "STEADY",
  "STEADYMAX", "STEADYMIN", "FINALLY", "CUMULATIVE", "MODULE", "ENDMODULE",
  "CONSTANT", "GLOBAL", "PARAM", "STOCH", "NONDET", "PROBAB", "PRIMED",
  "ASSIGN", "DISTR", "BLOCK", "VAR", "INIT", "ENDINIT", "INVAR",
  "ENDINVAR", "PRED", "DOTS", "LABEL", "QUOTE", "INT_CONSTANT",
  "FLOAT_CONSTANT", "BOOL_CONSTANT", "BV_CONSTANT", "IDENTIFIER",
  "FORMULA", "STRING_LITERAL", "REWARDS", "ENDREWARDS", "REW", "I_REW",
  "REWMAX", "REWMIN", "'?'", "':'", "'|'", "'&'", "'='", "'<'", "'>'",
  "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "UPLUS", "UMINUS", "'('",
  "','", "')'", "'['", "']'", "';'", "$accept", "numeric_constant",
  "expression", "single_assignment", "single_assignments", "update",
  "prob_assignment", "prob_assignment_list", "$@1", "distribution",
  "action", "command", "$@2", "$@3", "command_list", "init", "trans",
  "opt_type", "default_init", "opt_default_init", "type",
  "global_var_decl", "var_decl", "const_decl", "var_decl_list", "pred",
  "pred_list", "predicate", "subst", "subst_list", "module", "$@4", "$@5",
  "$@6", "rewards", "rewardlist", "reward", "invariant", "opt_model_type",
  "decl", "decl_list", "model", "label", "quant", "prop", "property",
  "pathproperty", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,    63,    58,   124,
      38,    61,    60,    62,    43,    45,    42,    47,    37,    33,
     322,   323,    40,    44,    41,    91,    93,    59
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    88,    89,    89,    90,    90,    90,    90,    90,    90,
      90,    90,    90,    90,    90,    90,    90,    90,    90,    90,
      90,    90,    90,    90,    90,    90,    90,    90,    90,    90,
      91,    92,    92,    93,    93,    94,    95,    96,    95,    97,
      97,    98,    98,   100,   101,    99,   102,   102,   103,   104,
     105,   105,   106,   107,   107,   108,   108,   108,   108,   108,
     108,   109,   110,   111,   111,   111,   112,   112,   113,   114,
     114,   115,   116,   117,   117,   119,   118,   120,   121,   118,
     122,   123,   123,   124,   124,   124,   125,   126,   126,   126,
     126,   127,   127,   127,   127,   127,   127,   127,   127,   128,
     128,   129,   130,   131,   131,   131,   132,   132,   133,   133,
     133,   133,   133,   133,   133,   133,   133,   133,   133,   133,
     133,   133,   133,   133,   133,   133,   133,   133,   133,   133,
     133,   133,   133,   133,   133,   133,   133,   133,   134,   134,
     134,   134,   134,   134,   134,   134,   134
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     3,     3,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     6,     6,     2,     3,     3,     5,     3,     3,     1,
       6,     3,     1,     1,     1,     3,     1,     0,     4,     2,
       2,     2,     3,     0,     0,     6,     0,     2,     3,     1,
       0,     1,     2,     0,     1,     1,     1,     1,     1,     5,
       4,     6,     5,     6,     4,     5,     0,     2,     3,     1,
       3,     1,     3,     3,     1,     0,     6,     0,     0,    10,
       3,     1,     2,     4,     6,     7,     3,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     2,     7,     1,     1,     1,     1,     1,     6,     6,
       6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
       6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
       6,     6,     7,     8,     8,     6,     6,     6,     5,     5,
       8,     3,     2,     2,     4,     4,     7
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      87,    89,    90,    88,     0,     0,     0,     0,     5,     6,
     105,   103,   104,     0,     0,     0,     0,    50,     0,     0,
       0,     0,     0,     0,     0,     2,     3,     7,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,   106,    94,
      91,    92,    97,    93,    95,    96,   100,   101,   107,     0,
      98,    29,     1,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      75,    55,    58,    56,    57,     0,     0,     0,    51,     0,
       0,     0,     0,    71,     0,    69,     0,     0,     0,     0,
       0,     0,    81,     0,     0,     0,    10,    11,    23,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    99,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    66,     0,     0,     0,     0,     0,    48,    86,     0,
      68,     0,    28,     0,     0,     0,     0,    80,    82,     0,
       0,     0,    27,    19,    20,     9,     0,    25,    24,     8,
      17,    18,    12,    13,    14,    15,    16,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    77,    46,     0,     0,     0,    53,    64,
      70,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
      67,    60,     0,     0,     0,    54,     0,     0,    65,     0,
       0,    83,     0,     0,     0,     0,     0,     0,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    22,    21,
     116,   114,   118,   119,   117,   115,   122,   120,   124,   125,
     123,   121,   128,   126,   130,   131,   129,   127,     0,     0,
       0,    43,    47,    76,    59,    63,    52,    61,     0,     0,
       0,   135,     0,     0,     0,   136,   137,     0,     0,     0,
     143,   142,     0,   110,   108,   112,   113,   111,   109,     0,
      74,     0,    53,     0,    41,     0,   102,     0,    84,   132,
       0,     0,     0,     0,     0,     0,     0,     0,   141,     0,
       0,    78,     0,    42,    44,    85,   133,   134,   145,   144,
       0,     0,     0,     0,    72,    73,     0,    62,     0,     0,
     139,   138,     0,    79,     0,     0,     0,     0,     5,     0,
       0,    32,    33,    39,    36,    40,    45,   146,     0,     0,
       0,     0,    37,   140,     0,    34,     0,    35,    31,     0,
       0,     0,    38,     0,    30
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    37,   271,   381,   382,   383,   384,   385,   399,   375,
     301,   302,   335,   368,   248,    39,   249,    77,   255,   256,
      78,    40,   250,    41,   204,    42,    84,    85,   330,   331,
      43,   141,   246,   366,    44,    91,    92,    45,     4,    46,
      47,     5,    48,    49,    50,    51,   272
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -81
static const yytype_int16 yypact[] =
{
      91,   -81,   -81,   -81,  1297,     3,   -80,   -54,   -81,   -81,
     -81,   -81,   -81,    17,    40,    43,   -23,   -11,   -12,   -11,
    1399,  1399,  1399,    -1,    27,   -81,   -81,   -81,    28,  1234,
      39,    55,    62,  1399,  1399,  1399,  1399,   -81,  1208,   -81,
     -81,   -81,   -81,   -81,   -81,   -81,   -81,  1297,   -81,    51,
     -81,   -81,   -81,  1399,  1399,   -35,   -35,   -40,   -35,   -35,
     -35,   -35,   -31,   -35,   -35,   -35,   -35,   -16,   -35,   -35,
      63,   -81,   -81,   -81,   -81,   -32,  1399,    79,   -81,    76,
      92,   967,     6,  1208,   -50,   -81,    95,   102,    99,   -52,
    1157,  1191,   -81,   105,   106,   108,   -81,   -81,   -81,  1023,
    1399,  1399,  1399,  1399,  1399,  1399,  1399,  1399,  1399,  1399,
    1399,  1399,  1399,  1399,   -81,   -35,   -35,   -13,   -35,   -35,
    1098,  1120,    86,    93,   114,   115,   116,   121,   123,   125,
     126,   127,   128,   129,   136,   137,   140,   142,   143,   145,
     118,   -81,  1399,  1324,   170,   -11,    90,   -81,   -81,  1399,
     -81,   189,   -81,  1399,   157,  1399,  1399,   -81,   -81,   159,
     160,   161,   -81,    65,    65,   250,  1472,   541,   616,   250,
      65,    65,    70,    70,   -81,   -81,   -81,   163,   166,   167,
     172,   173,   175,  1399,  1399,  1399,  1399,  1399,  1399,  1399,
    1399,  1399,  1399,  1399,  1399,  1399,  1399,  1399,  1399,  1399,
    1399,  1399,  1399,   -81,   203,   372,  1399,  1399,   201,   -81,
     -81,   191,    87,  1399,  1484,   162,   104,   235,   236,  1399,
    1356,  1356,  1356,  1356,  1356,  1356,  1045,  1066,   405,   425,
     447,   480,   500,   522,   555,   575,   597,   630,   650,   672,
     705,   725,   747,   780,   800,   822,   183,   211,   195,   248,
     -81,   -81,   855,   200,  1399,   -81,   196,  1399,   -81,  1497,
    1399,   -81,   198,  1399,   281,   227,   213,   214,   466,   950,
    1399,  1515,   215,   216,   217,   218,   221,   222,   -81,   -81,
     -81,   -81,   -81,   -81,   -81,   -81,   -81,   -81,   -81,   -81,
     -81,   -81,   -81,   -81,   -81,   -81,   -81,   -81,   251,   -11,
     -46,   -81,   -81,   -81,   -81,   -81,  1208,   -81,   219,  1399,
     330,   -81,   875,   -35,   -35,   -81,   -81,   -35,   -35,   -35,
    1208,  1208,   993,   -81,   -81,   -81,   -81,   -81,   -81,   239,
     -81,    42,   201,   225,   -81,  1399,   -81,   349,   -81,   -81,
     226,   228,  1399,  1399,   230,   -35,   -35,   -35,  1208,  1399,
     251,   -81,   242,   -81,  1208,   -81,   -81,   -81,  1208,  1208,
     -35,  1399,  1399,   234,  1208,   -81,   296,   -81,   289,   247,
    1208,  1208,   -35,   -81,  1442,   249,  1399,   254,   255,  1399,
    1527,   -81,   271,   -81,   269,   -81,   -81,  1208,  1399,   916,
      13,   262,   -81,  1208,   275,   -81,  1399,   -81,   -81,  1399,
    1399,  1572,   -81,  1082,   -81
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -81,     2,    -4,   -41,   -81,   -39,   -81,   -47,   -81,   -81,
     -81,   -81,   -81,   -81,   -81,   -81,   -81,   -81,   -81,    23,
     -18,   -81,   -81,   -81,   -81,   -81,   -81,   210,    10,   -81,
     -81,   -81,   -81,   -81,   -81,   -81,   270,   -81,   -81,   316,
     -81,   -81,   -81,   -81,   -81,   -81,    -5
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -35
static const yytype_int16 yytable[] =
{
      38,    80,    53,    52,    71,    72,   154,    73,    74,    75,
     100,   101,   333,   102,    25,    26,    81,    82,    83,    25,
      26,    55,    56,    25,    26,    90,   395,   124,    54,    96,
      97,    98,    99,   149,   155,    70,   130,   150,    25,    26,
     334,    25,    26,    38,    60,    61,    79,    65,    66,   120,
     121,   136,    86,   142,   179,   115,   116,   122,   123,   125,
     126,   127,   128,   129,   131,   132,   133,   134,   135,   137,
     138,   139,   143,   103,    76,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,    87,    88,    90,    57,    58,
      59,   100,   101,   148,   102,   396,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      93,    62,    63,    64,    67,    68,    69,   177,   178,   180,
     181,   182,   117,   118,   119,   350,    94,   208,   351,     1,
       2,     3,   262,    95,   140,   263,   264,   144,   205,   109,
     110,   111,   112,   113,   145,    83,   111,   112,   113,   212,
     146,   214,   215,   151,   103,   152,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   100,   101,   265,   102,
     153,   185,   159,   160,   258,   161,   203,   209,   186,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   187,
     188,   189,   252,   253,   100,   101,   190,   102,   191,   259,
     192,   193,   194,   195,   196,   268,   273,   274,   275,   276,
     277,   197,   198,   100,   101,   199,   102,   200,   201,   103,
     202,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   207,   211,   213,   216,   217,   218,   254,   220,   261,
     306,   221,   222,   308,   100,   101,   310,   223,   224,   312,
     225,   247,   257,   266,   267,   320,   321,   103,   298,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   299,
     300,   332,   303,   307,   311,   313,   103,   305,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   314,   315,
     316,   323,   324,   325,   326,   337,   336,   327,   328,   329,
     349,   353,   356,   360,   357,   340,   341,   372,   348,   342,
     343,   344,   107,   108,   109,   110,   111,   112,   113,   367,
     373,   354,   374,   376,   100,   101,   386,   102,   358,   359,
     388,   391,   -34,   392,   396,   364,   400,   361,   362,   363,
     398,   397,   402,   100,   101,   352,   102,   370,   371,   210,
     365,   158,   369,   114,     0,     0,     0,     0,     0,     0,
     380,     0,   387,     0,   377,   389,   100,   101,     0,   102,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,   401,     0,     0,   380,   403,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   103,   338,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,     0,   100,
     101,     0,   102,     0,     0,     0,   355,     0,     0,   103,
       0,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   100,   101,     0,   102,     0,     0,     0,   251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     100,   101,   103,   102,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,     0,
       0,   280,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,     0,
       0,   281,     0,     0,   103,     0,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   100,   101,     0,   102,
       0,     0,     0,   282,     0,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   100,   101,   103,   102,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   283,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   284,     0,     0,   103,
       0,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   100,   101,     0,   102,     0,     0,     0,   285,     0,
       0,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     100,   101,   103,   102,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,     0,
       0,   286,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,     0,
       0,   287,     0,     0,   103,     0,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   100,   101,     0,   102,
       0,     0,     0,   288,     0,     0,     0,   106,   107,   108,
     109,   110,   111,   112,   113,     0,     0,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   289,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   290,     0,     0,   103,
       0,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   100,   101,     0,   102,     0,     0,     0,   291,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,     0,
       0,   292,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,     0,
       0,   293,     0,     0,   103,     0,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   100,   101,     0,   102,
       0,     0,     0,   294,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   295,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   100,
     101,     0,   102,     0,     0,     0,   296,     0,     0,   103,
       0,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,     0,     0,     0,     0,     0,     0,     0,   297,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     100,   101,   103,   102,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,     0,     0,     0,     0,     0,     0,
       0,   304,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   317,   318,     0,   394,     6,     7,
       0,   339,     0,     8,     9,     0,     0,     0,     0,     0,
       0,   100,   101,     0,   102,    10,    11,    12,    13,    14,
      15,     0,     0,   103,     0,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,     0,     0,   345,   346,     0,
     162,     6,     7,    24,    25,    26,     8,     9,    27,     0,
       0,     0,     0,    30,   147,    31,    32,     0,    10,    11,
      12,    13,    14,    15,    33,    34,     0,   100,   101,    35,
     102,     0,    36,     0,   103,   319,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,    24,    25,    26,   100,
     101,    27,   102,     0,     0,     0,    30,     0,    31,    32,
       0,     0,     0,     0,     0,     0,     0,    33,    34,     0,
     100,   101,    35,   102,     0,    36,     0,     0,   347,     0,
       0,     0,     0,     0,     0,     0,   100,   101,     0,   102,
     103,     0,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   100,   101,     0,   102,     0,   162,     0,     0,
       0,     0,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   100,   101,     0,   102,     0,   278,
       0,     0,     0,   103,     0,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,     0,     0,     0,     0,   103,
     279,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   100,   101,     0,   102,   103,   404,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,     0,     0,     0,
       0,   183,     0,     0,     0,     0,     0,   103,     0,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,     6,
       7,     0,     0,   184,     8,     9,     0,     0,     0,     0,
       0,     0,   100,   101,     0,   102,    10,    11,    12,    13,
      14,    15,     0,     0,   103,   156,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,     0,     0,     0,     0,
       0,     0,     6,     7,    24,    25,    26,     8,     9,    27,
       0,     0,     0,   157,    30,     0,    31,    32,     0,    10,
      11,    12,    13,    14,    15,    33,    34,     0,     0,     0,
      35,     0,     0,    36,     0,   103,    89,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,    30,     0,    31,
      32,     0,     0,     0,     0,     6,     7,     0,    33,    34,
       8,     9,     0,    35,     0,     0,    36,     0,     0,    89,
       0,     0,    10,    11,    12,    13,    14,    15,   100,   101,
      16,   102,    17,    18,    19,     0,     0,     0,     0,     0,
       0,     0,     0,    20,     0,    21,     0,    22,     0,    23,
      24,    25,    26,     0,     0,    27,    28,     0,    29,     0,
      30,     0,    31,    32,     6,     7,     0,     0,     0,     8,
       9,    33,    34,     0,     0,   206,    35,     0,     0,    36,
     269,    10,    11,    12,    13,    14,    15,   270,     0,     0,
       0,   103,     0,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,     0,     0,     0,     0,     6,     7,    24,
      25,    26,     8,     9,    27,     0,     0,     0,     0,    30,
       0,    31,    32,     0,    10,    11,    12,    13,    14,    15,
      33,    34,     0,     0,     0,    35,     0,     0,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,    24,    25,    26,   378,     9,    27,     0,     0,
       0,     0,    30,     0,    31,    32,     0,    10,    11,    12,
      13,    14,    15,    33,    34,     0,   100,   101,    35,   102,
       0,    36,     0,     0,     0,     0,     0,     0,   100,   101,
       0,   102,     0,     0,     0,    24,    25,    26,     0,     0,
      27,   100,   101,     0,   102,    30,     0,    31,    32,     0,
       0,     0,     0,     0,     0,     0,    33,    34,     0,   100,
     101,    35,   102,     0,   379,     0,     0,     0,     0,     0,
       0,   100,   101,     0,   102,     0,     0,     0,   322,   103,
     219,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   103,   260,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,     0,   103,   309,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   100,   101,     0,   102,
       0,     0,   103,     0,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   103,   390,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,     0,     0,     0,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   103,
       0,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113
};

static const yytype_int16 yycheck[] =
{
       4,    19,    82,     0,    15,    16,    58,    18,    19,    20,
       4,     5,    58,     7,    54,    55,    20,    21,    22,    54,
      55,     4,     5,    54,    55,    29,    13,    67,    82,    33,
      34,    35,    36,    83,    86,    58,    67,    87,    54,    55,
      86,    54,    55,    47,     4,     5,    58,     4,     5,    53,
      54,    67,    53,    85,    67,     4,     5,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    76,    67,    85,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    58,    58,    91,    71,    72,
      73,     4,     5,    87,     7,    82,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
      71,    71,    72,    73,    71,    72,    73,   115,   116,   117,
     118,   119,    71,    72,    73,    83,    71,   145,    86,    38,
      39,    40,    28,    71,    71,    31,    32,    58,   142,    74,
      75,    76,    77,    78,    68,   149,    76,    77,    78,   153,
      58,   155,   156,    58,    67,    53,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,     4,     5,    64,     7,
      71,    85,    67,    67,    87,    67,    58,    87,    85,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,    85,
      85,    85,   206,   207,     4,     5,    85,     7,    85,   213,
      85,    85,    85,    85,    85,   219,   221,   222,   223,   224,
     225,    85,    85,     4,     5,    85,     7,    85,    85,    67,
      85,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    71,    53,    86,    85,    85,    85,    46,    85,    87,
     254,    85,    85,   257,     4,     5,   260,    85,    85,   263,
      85,    58,    71,    28,    28,   269,   270,    67,    85,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    68,
      85,   299,    34,    87,    86,     4,    67,    87,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    71,    86,
      86,    86,    86,    86,    86,   309,    87,    86,    86,    58,
      71,    86,    86,    83,    86,   313,   314,    83,   322,   317,
     318,   319,    72,    73,    74,    75,    76,    77,    78,    87,
      34,   335,    43,    86,     4,     5,    87,     7,   342,   343,
      86,    70,    87,    74,    82,   349,    71,   345,   346,   347,
     391,   390,   399,     4,     5,   332,     7,   361,   362,   149,
     350,    91,   360,    47,    -1,    -1,    -1,    -1,    -1,    -1,
     374,    -1,   376,    -1,   372,   379,     4,     5,    -1,     7,
      -1,    -1,    -1,    -1,   388,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   396,    -1,    -1,   399,   400,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    67,    87,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    -1,     4,
       5,    -1,     7,    -1,    -1,    -1,    87,    -1,    -1,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,     4,     5,    -1,     7,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,     5,    67,     7,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    -1,
      -1,    86,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    -1,
      -1,    86,    -1,    -1,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,     4,     5,    -1,     7,
      -1,    -1,    -1,    86,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,     4,     5,    67,     7,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    86,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    86,    -1,    -1,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,     4,     5,    -1,     7,    -1,    -1,    -1,    86,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
       4,     5,    67,     7,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    -1,
      -1,    86,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    -1,
      -1,    86,    -1,    -1,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,     4,     5,    -1,     7,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    86,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    86,    -1,    -1,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,     4,     5,    -1,     7,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    -1,
      -1,    86,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    -1,
      -1,    86,    -1,    -1,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,     4,     5,    -1,     7,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    86,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     4,
       5,    -1,     7,    -1,    -1,    -1,    86,    -1,    -1,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,     5,    67,     7,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,    41,     8,     9,
      -1,    86,    -1,    13,    14,    -1,    -1,    -1,    -1,    -1,
      -1,     4,     5,    -1,     7,    25,    26,    27,    28,    29,
      30,    -1,    -1,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,     4,     5,    -1,
      84,     8,     9,    53,    54,    55,    13,    14,    58,    -1,
      -1,    -1,    -1,    63,    47,    65,    66,    -1,    25,    26,
      27,    28,    29,    30,    74,    75,    -1,     4,     5,    79,
       7,    -1,    82,    -1,    67,    85,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    53,    54,    55,     4,
       5,    58,     7,    -1,    -1,    -1,    63,    -1,    65,    66,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    -1,
       4,     5,    79,     7,    -1,    82,    -1,    -1,    85,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     4,     5,    -1,     7,
      67,    -1,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,     4,     5,    -1,     7,    -1,    84,    -1,    -1,
      -1,    -1,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,     4,     5,    -1,     7,    -1,    84,
      -1,    -1,    -1,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    -1,    -1,    67,
      84,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,     4,     5,    -1,     7,    67,    84,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    -1,    -1,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,     8,
       9,    -1,    -1,    83,    13,    14,    -1,    -1,    -1,    -1,
      -1,    -1,     4,     5,    -1,     7,    25,    26,    27,    28,
      29,    30,    -1,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    -1,    -1,    -1,    -1,
      -1,    -1,     8,     9,    53,    54,    55,    13,    14,    58,
      -1,    -1,    -1,    62,    63,    -1,    65,    66,    -1,    25,
      26,    27,    28,    29,    30,    74,    75,    -1,    -1,    -1,
      79,    -1,    -1,    82,    -1,    67,    85,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    53,    54,    55,
      -1,    -1,    58,    -1,    -1,    -1,    -1,    63,    -1,    65,
      66,    -1,    -1,    -1,    -1,     8,     9,    -1,    74,    75,
      13,    14,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      -1,    -1,    25,    26,    27,    28,    29,    30,     4,     5,
      33,     7,    35,    36,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    48,    -1,    50,    -1,    52,
      53,    54,    55,    -1,    -1,    58,    59,    -1,    61,    -1,
      63,    -1,    65,    66,     8,     9,    -1,    -1,    -1,    13,
      14,    74,    75,    -1,    -1,    51,    79,    -1,    -1,    82,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    -1,    -1,     8,     9,    53,
      54,    55,    13,    14,    58,    -1,    -1,    -1,    -1,    63,
      -1,    65,    66,    -1,    25,    26,    27,    28,    29,    30,
      74,    75,    -1,    -1,    -1,    79,    -1,    -1,    82,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       8,     9,    53,    54,    55,    13,    14,    58,    -1,    -1,
      -1,    -1,    63,    -1,    65,    66,    -1,    25,    26,    27,
      28,    29,    30,    74,    75,    -1,     4,     5,    79,     7,
      -1,    82,    -1,    -1,    -1,    -1,    -1,    -1,     4,     5,
      -1,     7,    -1,    -1,    -1,    53,    54,    55,    -1,    -1,
      58,     4,     5,    -1,     7,    63,    -1,    65,    66,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    -1,     4,
       5,    79,     7,    -1,    82,    -1,    -1,    -1,    -1,    -1,
      -1,     4,     5,    -1,     7,    -1,    -1,    -1,    23,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,     4,     5,    -1,     7,
      -1,    -1,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    41,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    38,    39,    40,   126,   129,     8,     9,    13,    14,
      25,    26,    27,    28,    29,    30,    33,    35,    36,    37,
      46,    48,    50,    52,    53,    54,    55,    58,    59,    61,
      63,    65,    66,    74,    75,    79,    82,    89,    90,   103,
     109,   111,   113,   118,   122,   125,   127,   128,   130,   131,
     132,   133,     0,    82,    82,     4,     5,    71,    72,    73,
       4,     5,    71,    72,    73,     4,     5,    71,    72,    73,
      58,    15,    16,    18,    19,    20,    85,   105,   108,    58,
     108,    90,    90,    90,   114,   115,    53,    58,    58,    85,
      90,   123,   124,    71,    71,    71,    90,    90,    90,    90,
       4,     5,     7,    67,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,   127,     4,     5,    71,    72,    73,
      90,    90,    89,    89,    67,    89,    89,    89,    89,    89,
      67,    89,    89,    89,    89,    89,    67,    89,    89,    89,
      71,   119,    85,    90,    58,    68,    58,    47,    87,    83,
      87,    58,    53,    71,    58,    86,    68,    62,   124,    67,
      67,    67,    84,    90,    90,    90,    90,    90,    90,    90,
      90,    90,    90,    90,    90,    90,    90,    89,    89,    67,
      89,    89,    89,    83,    83,    85,    85,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    85,    85,    85,    85,
      85,    85,    85,    58,   112,    90,    51,    71,   108,    87,
     115,    53,    90,    86,    90,    90,    85,    85,    85,    68,
      85,    85,    85,    85,    85,    85,    90,    90,    90,    90,
      90,    90,    90,    90,    90,    90,    90,    90,    90,    90,
      90,    90,    90,    90,    90,    90,   120,    58,   102,   104,
     110,    86,    90,    90,    46,   106,   107,    71,    87,    90,
      68,    87,    28,    31,    32,    64,    28,    28,    90,    24,
      31,    90,   134,   134,   134,   134,   134,   134,    84,    84,
      86,    86,    86,    86,    86,    86,    86,    86,    86,    86,
      86,    86,    86,    86,    86,    86,    86,    86,    85,    68,
      85,    98,    99,    34,    86,    87,    90,    87,    90,    68,
      90,    86,    90,     4,    71,    86,    86,     4,     5,    85,
      90,    90,    23,    86,    86,    86,    86,    86,    86,    58,
     116,   117,   108,    58,    86,   100,    87,    90,    87,    86,
      89,    89,    89,    89,    89,     4,     5,    85,    90,    71,
      83,    86,   107,    86,    90,    87,    86,    86,    90,    90,
      83,    89,    89,    89,    90,   116,   121,    87,   101,    89,
      90,    90,    83,    34,    43,    97,    86,    89,    13,    82,
      90,    91,    92,    93,    94,    95,    87,    90,    86,    90,
      68,    70,    74,    90,    41,    13,    82,    93,    91,    96,
      71,    90,    95,    90,    84
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 295 "PRISM.ypp"
    {
        (yyval.node) =  new Expr((yyvsp[(1) - (1)].int_const));
      ;}
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 299 "PRISM.ypp"
    {
        (yyval.node) = new Expr((yyvsp[(1) - (1)].float_const));
      ;}
    break;

  case 5:

/* Line 1455 of yacc.c  */
#line 307 "PRISM.ypp"
    {
          (yyval.node) = new Expr(true);
      ;}
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 310 "PRISM.ypp"
    {
          (yyval.node) = new Expr(false);
      ;}
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 313 "PRISM.ypp"
    {
         (yyval.node) = new Expr((yyvsp[(1) - (1)].string_const));
         free((yyvsp[(1) - (1)].string_const));
      ;}
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 317 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Eq, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 320 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Neq, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 324 "PRISM.ypp"
    { 
          (yyval.node) = (yyvsp[(2) - (2)].node);
      ;}
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 328 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Uminus,(yyvsp[(2) - (2)].node));
      ;}
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 331 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Plus, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 334 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Minus, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 337 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Mult, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 340 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Div, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 343 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Mod, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 346 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Lt, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 349 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Gt, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 352 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Le, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 355 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Ge, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 358 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Max, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].node));
      ;}
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 361 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Min, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].node));
      ;}
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 365 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Not,(yyvsp[(2) - (2)].node));
      ;}
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 368 "PRISM.ypp"
    {
                (yyval.node) = new Expr(And, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 371 "PRISM.ypp"
    {
                (yyval.node) = new Expr(Or, (yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
      ;}
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 374 "PRISM.ypp"
    { 
                (yyval.node) = new Expr(Ite, (yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].node));
      ;}
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 377 "PRISM.ypp"
    {
                (yyval.node) = (yyvsp[(2) - (3)].node);
      ;}
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 380 "PRISM.ypp"
    {
                (yyval.node) = new Expr((yyvsp[(2) - (3)].string_const));
                free((yyvsp[(2) - (3)].string_const));
      ;}
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 389 "PRISM.ypp"
    {
        assert(alternative);
        alternative->update.Assign((yyvsp[(2) - (6)].node),(yyvsp[(5) - (6)].node));
      ;}
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 407 "PRISM.ypp"
    {                 
        assert(alternative);
        alternative->setWeight((yyvsp[(1) - (3)].node));
      ;}
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 415 "PRISM.ypp"
    {
          assert(command);
        ;}
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 419 "PRISM.ypp"
    {
          assert(command);
          alternative = new Alternative();
          command->addAlternative(alternative);
        ;}
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 428 "PRISM.ypp"
    {
        alternative->setWeight(new Expr(1.0));
      ;}
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 435 "PRISM.ypp"
    { (yyval.string_const) = 0; ;}
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 436 "PRISM.ypp"
    { (yyval.string_const) = (yyvsp[(2) - (3)].string_const); ;}
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 440 "PRISM.ypp"
    {
        std::string action((yyvsp[(1) - (1)].string_const) ? (yyvsp[(1) - (1)].string_const) : "");
        if ((yyvsp[(1) - (1)].string_const)) {
          free((yyvsp[(1) - (1)].string_const));
        }
        command = new Command(action);
        assert(module); 
        module->addCommand(command);
        if(action!="") PRISMParser::astModel.actions.insert(action);
      ;}
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 451 "PRISM.ypp"
    {
        alternative = new Alternative();
        command->addAlternative(alternative);
      ;}
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 456 "PRISM.ypp"
    {
        assert(command);
        command->setGuard((yyvsp[(3) - (6)].node));
      ;}
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 469 "PRISM.ypp"
    {
    assert((yyvsp[(2) - (3)].node));
    shared_ptr<Expr> eptr(new Expr((yyvsp[(2) - (3)].node),constants));
    delete (yyvsp[(2) - (3)].node);
    initial = eptr ;
  ;}
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 484 "PRISM.ypp"
    { delete (yyvsp[(1) - (1)].type); ;}
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 489 "PRISM.ypp"
    { (yyval.node) = (yyvsp[(2) - (2)].node); ;}
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 493 "PRISM.ypp"
    { (yyval.node) = 0; ;}
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 499 "PRISM.ypp"
    { (yyval.type) = new Type(1); ;}
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 501 "PRISM.ypp"
    { (yyval.type) = new Type(1.0); ;}
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 503 "PRISM.ypp"
    { (yyval.type) = new Type(1.0); ;}
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 505 "PRISM.ypp"
    { (yyval.type) = new Type(true); ;}
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 507 "PRISM.ypp"
    { (yyval.type) = new Type((yyvsp[(2) - (5)].node),(yyvsp[(4) - (5)].node)); ;}
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 509 "PRISM.ypp"
    { 
        Expr size_expr = *(yyvsp[(3) - (4)].node);
        int width;
        if(size_expr.kind == Int) {
                width = size_expr.getInt();
        } else PRISMerror("ill-specified size of bit vector type  bitvector"
			  + size_expr.toString());
    ;}
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 522 "PRISM.ypp"
    {
        std::string name ((yyvsp[(2) - (6)].string_const));
        free((yyvsp[(2) - (6)].string_const));

        Variable* vptr(new Variable(name,(yyvsp[(4) - (6)].type),(yyvsp[(5) - (6)].node)));
        global_vars.insert(std::pair<std::string, boost::shared_ptr<Variable> > (name, shared_ptr<Variable> (vptr) ));
  ;}
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 534 "PRISM.ypp"
    {
        std::string name ((yyvsp[(1) - (5)].string_const));
        free((yyvsp[(1) - (5)].string_const));

        Variable* vptr(new Variable(name,(yyvsp[(3) - (5)].type),(yyvsp[(4) - (5)].node)));
        if(!module) {
                yyerror("Global variable \"" + name + "\" must be declared \"global\"\n");
        }
        module->addVariable(vptr);
  ;}
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 548 "PRISM.ypp"
    {
        assert((yyvsp[(5) - (6)].node));
        assert((yyvsp[(3) - (6)].string_const));
        shared_ptr<Expr> se((yyvsp[(5) - (6)].node));

        constants.insert(std::pair<std::string, boost::shared_ptr<Expr> > ((yyvsp[(3) - (6)].string_const) , se));
        free((yyvsp[(3) - (6)].string_const));
  ;}
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 557 "PRISM.ypp"
    {
        Variable* vptr (new Variable((yyvsp[(3) - (4)].string_const),(yyvsp[(2) - (4)].type)));
        vptr->is_parameter = true;
        free((yyvsp[(3) - (4)].string_const));
        PRISMParser::astModel.addVariable(vptr);
  ;}
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 564 "PRISM.ypp"
    {
        assert((yyvsp[(2) - (5)].string_const));
        assert((yyvsp[(4) - (5)].node));
        shared_ptr<Expr> eptr((yyvsp[(4) - (5)].node));
        formulas.insert(std::pair<std::string, boost::shared_ptr<Expr> > ((yyvsp[(2) - (5)].string_const),eptr)) ;
        free((yyvsp[(2) - (5)].string_const));
  ;}
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 589 "PRISM.ypp"
    { 
                shared_ptr<Expr> eptr((yyvsp[(1) - (1)].node));
                predicates.push_back( eptr );
        ;}
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 596 "PRISM.ypp"
    { // action label
            assert((yyvsp[(3) - (3)].node));
            shared_ptr<Expr> eptr((yyvsp[(3) - (3)].node));
                subst.expr_subst[(yyvsp[(1) - (3)].string_const)] = eptr;
                
                std::string original_action((yyvsp[(1) - (3)].string_const));
        free((yyvsp[(1) - (3)].string_const));
                if (PRISMParser::astModel.actions.count(original_action) > 0) {
                        std::string action_name((yyvsp[(3) - (3)].node)->getIdentifier());
                        subst.action_subst[original_action] = action_name;
                        PRISMParser::astModel.actions.insert(action_name);
                }        
        ;}
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 621 "PRISM.ypp"
    {
        module = new Module((yyvsp[(2) - (2)].string_const));
        module_manager.addModule(module);
        free((yyvsp[(2) - (2)].string_const));
  ;}
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 627 "PRISM.ypp"
    {
        module = 0;
  ;}
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 631 "PRISM.ypp"
    { 
        // initialize the subst_list vector
        subst.clear();
  ;}
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 634 "PRISM.ypp"
    {
        // (1) lookup the module to substitute into
        std::string module_name ((yyvsp[(2) - (8)].string_const));
        free((yyvsp[(2) - (8)].string_const));
        std::string instantiated_module_name ((yyvsp[(4) - (8)].string_const));
        free((yyvsp[(4) - (8)].string_const));

        // schedule instantiation
        Instantiation inst (module_name,instantiated_module_name,subst); 

        module_manager.addInstantiation(inst);        

          ;}
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 661 "PRISM.ypp"
    {
      shared_ptr<Expr> eptr1((yyvsp[(1) - (4)].node)), eptr2((yyvsp[(3) - (4)].node));
      state_rewards.push_back(StateReward(eptr1, eptr2));
    ;}
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 666 "PRISM.ypp"
    {
      shared_ptr<Expr> eptr1((yyvsp[(3) - (6)].node)), eptr2((yyvsp[(5) - (6)].node));
      PRISMParser::astModel.transition_rewards.push_back( TransitionReward ( "", StateReward(eptr1,eptr2)));
    ;}
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 671 "PRISM.ypp"
    {
      std::string label((yyvsp[(2) - (7)].string_const));
      shared_ptr<Expr> eptr1((yyvsp[(4) - (7)].node)), eptr2((yyvsp[(6) - (7)].node));
      transition_rewards.push_back( TransitionReward ( label, StateReward(eptr1,eptr2)));
      free((yyvsp[(2) - (7)].string_const));
    ;}
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 681 "PRISM.ypp"
    { 
          shared_ptr<Expr> iptr((yyvsp[(2) - (3)].node));
    invariants.push_back(iptr);
  ;}
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 688 "PRISM.ypp"
    { (yyval.model_type) = Unspecified; ;}
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 689 "PRISM.ypp"
    { (yyval.model_type) = DTMC; ;}
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 690 "PRISM.ypp"
    { (yyval.model_type) = CTMC; ;}
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 691 "PRISM.ypp"
    { (yyval.model_type) = MDP; ;}
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 711 "PRISM.ypp"
    {
        if (Unspecified != (yyvsp[(1) - (2)].model_type)) {
          PRISMParser::astModel.model_type = (yyvsp[(1) - (2)].model_type);
        }

	Substitutor(constants, formulas);

        /*! TODO:
                1) replace constants in formulas
                2) replace formulas in formulas
                3) unite constants and formulas in one substitution
                4) apply this substitution to everything that follows
         */

        for (Variables::const_iterator i = global_vars.begin(); i!= global_vars.end(); ++i) {
                shared_ptr<Variable> vptr(i->second);
                PRISMParser::astModel.addVariable(new Variable(vptr.get(),constants));
        }

        module_manager.addModules(PRISMParser::astModel);
        module_manager.clear();        

        for(Exprs::const_iterator i=predicates.begin();i!=predicates.end();++i) {
                shared_ptr<Expr> eptr(new Expr(i->get(),constants));
                PRISMParser::astModel.predicates.push_back(eptr);
        }
        predicates.clear();
        
        for(Exprs::const_iterator i=invariants.begin();i!=invariants.end();++i) {
                shared_ptr<Expr> eptr(new Expr(i->get(),constants));
                PRISMParser::astModel.invariants.push_back(eptr);
        }
        invariants.clear();
        
        // rewards
        for(StateRewards::const_iterator i=state_rewards.begin();i!=state_rewards.end();++i) {
                StateReward sr(shared_ptr<Expr>(new Expr(i->first.get(),constants)),
                               shared_ptr<Expr>(new Expr(i->second.get(),constants)));
                
                PRISMParser::astModel.state_rewards.push_back(sr);
        }
        state_rewards.clear();

        for(TransitionRewards::const_iterator i=transition_rewards.begin();i!=transition_rewards.end();++i) {
                StateReward sr(shared_ptr<Expr>(new Expr(i->second.first.get(),constants)),
                               shared_ptr<Expr>(new Expr(i->second.second.get(),constants)));
                TransitionReward tr(i->first,sr);
                
                PRISMParser::astModel.transition_rewards.push_back(tr);
        }
        transition_rewards.clear();
        
        if(initial.get())
        PRISMParser::astModel.setInitial(new Expr(initial.get(),constants));
        

        Substitution subst;
        

          for(Exprs::const_iterator i=properties.begin();i!=properties.end();++i) {
                PRISMParser::astModel.properties.push_back(shared_ptr<Expr>(new Expr(i->get(),formulas)));
        }
        properties.clear();
  ;}
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 781 "PRISM.ypp"
    {
          assert((yyvsp[(3) - (7)].string_const));
          assert((yyvsp[(6) - (7)].node));
        boost::shared_ptr<Expr> eptr((yyvsp[(6) - (7)].node));
        formulas.insert(std::pair<std::string, boost::shared_ptr<Expr> >((yyvsp[(3) - (7)].string_const),eptr));
        free((yyvsp[(3) - (7)].string_const));
  ;}
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 793 "PRISM.ypp"
    { (yyval.kind) = Pmax; ;}
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 794 "PRISM.ypp"
    { (yyval.kind) = Pmin; ;}
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 795 "PRISM.ypp"
    { (yyval.kind) = P;    ;}
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 799 "PRISM.ypp"
    {
                  shared_ptr<Expr> pptr(new Expr((yyvsp[(1) - (1)].node),constants));
        delete (yyvsp[(1) - (1)].node);
                properties.push_back(pptr);
    ;}
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 808 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr((yyvsp[(1) - (6)].kind), new Expr(Ge,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 812 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
          (yyval.node) = new Expr((yyvsp[(1) - (6)].kind), new Expr(Gt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 816 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr((yyvsp[(1) - (6)].kind), new Expr(Le,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node)); 
  ;}
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 820 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr((yyvsp[(1) - (6)].kind), new Expr(Lt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 824 "PRISM.ypp"
    {
        (yyval.node) = new Expr((yyvsp[(1) - (6)].kind), new Expr(true), (yyvsp[(5) - (6)].node));
  ;}
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 827 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr((yyvsp[(1) - (6)].kind), new Expr(Eq,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 831 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(Steady, new Expr(Ge,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 835 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
          (yyval.node) = new Expr(Steady, new Expr(Gt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 839 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(Steady, new Expr(Le,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node)); 
  ;}
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 843 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(Steady, new Expr(Lt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 847 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Steady, new Expr(true), (yyvsp[(5) - (6)].node));
  ;}
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 850 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(Steady, new Expr(Eq,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 854 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMax, new Expr(Ge,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 858 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
          (yyval.node) = new Expr(SteadyMax, new Expr(Gt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 862 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMax, new Expr(Le,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node)); 
  ;}
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 866 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMax, new Expr(Lt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 870 "PRISM.ypp"
    {
        (yyval.node) = new Expr(SteadyMax, new Expr(true), (yyvsp[(5) - (6)].node));
  ;}
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 873 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMax, new Expr(Eq,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 877 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMin, new Expr(Ge,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 881 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
          (yyval.node) = new Expr(SteadyMin, new Expr(Gt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 885 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMin, new Expr(Le,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node)); 
  ;}
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 889 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMin, new Expr(Lt,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 893 "PRISM.ypp"
    {
        (yyval.node) = new Expr(SteadyMin, new Expr(true), (yyvsp[(5) - (6)].node));
  ;}
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 896 "PRISM.ypp"
    {
        double probability ((yyvsp[(3) - (6)].node)->isDouble() ? (yyvsp[(3) - (6)].node)->getDouble() : (yyvsp[(3) - (6)].node)->getInt());
        (yyval.node) = new Expr(SteadyMin, new Expr(Eq,new Expr("p"),new Expr(probability)),(yyvsp[(5) - (6)].node));
  ;}
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 900 "PRISM.ypp"
    {
        (yyval.node) = new Expr(ReachabilityReward,(yyvsp[(6) - (7)].node));
  ;}
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 903 "PRISM.ypp"
    {
        double reward ((yyvsp[(7) - (8)].node)->isDouble() ? (yyvsp[(7) - (8)].node)->getDouble() : (yyvsp[(7) - (8)].node)->getInt());
        (yyval.node) = new Expr(CumulativeReward,new Expr(reward));
  ;}
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 907 "PRISM.ypp"
    {
        double reward ((yyvsp[(7) - (8)].node)->isDouble() ? (yyvsp[(7) - (8)].node)->getDouble() : (yyvsp[(7) - (8)].node)->getInt());

        (yyval.node) = new Expr(InstantaneousReward, new Expr(reward));
  ;}
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 912 "PRISM.ypp"
    {
          (yyval.node) = new Expr(SteadyStateReward, new Expr(true));
  ;}
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 915 "PRISM.ypp"
    {
        (yyval.node) = new Expr(SteadyStateRewardMax, new Expr(true));
  ;}
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 918 "PRISM.ypp"
    {
        (yyval.node) = new Expr(SteadyStateRewardMin, new Expr(true));
  ;}
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 924 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Until, (yyvsp[(1) - (5)].node),(yyvsp[(5) - (5)].node), (yyvsp[(4) - (5)].node), new Expr());
  ;}
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 927 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Until, (yyvsp[(1) - (5)].node),(yyvsp[(5) - (5)].node), new Expr(),(yyvsp[(4) - (5)].node));
  ;}
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 930 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Until, (yyvsp[(1) - (8)].node),(yyvsp[(8) - (8)].node), (yyvsp[(4) - (8)].node),(yyvsp[(6) - (8)].node));
  ;}
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 933 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Until,(yyvsp[(1) - (3)].node),(yyvsp[(3) - (3)].node));
  ;}
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 936 "PRISM.ypp"
    {
          (yyval.node) = new Expr(Until,new Expr(true),(yyvsp[(2) - (2)].node));
  ;}
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 939 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Next,(yyvsp[(2) - (2)].node));
  ;}
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 942 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Next,(yyvsp[(4) - (4)].node), (yyvsp[(3) - (4)].node), new Expr());
  ;}
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 945 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Next,(yyvsp[(4) - (4)].node), new Expr(),(yyvsp[(3) - (4)].node));
  ;}
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 948 "PRISM.ypp"
    {
        (yyval.node) = new Expr(Next,(yyvsp[(7) - (7)].node), (yyvsp[(3) - (7)].node),(yyvsp[(5) - (7)].node));
  ;}
    break;



/* Line 1455 of yacc.c  */
#line 3314 "PRISM.tab.cpp"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 953 "PRISM.ypp"


extern char PRISMtext[];
//extern int PRISM::line_number;
extern std::string file_name;
extern int column;

void PRISMerror(const char *s)
{
  throw prismparser::ParseError("PRISMParser: file: "+ file_name + " @line "+prismparser::intToString(line_number) + " " + s);
}


void PRISMerror(char *s)
{
  throw prismparser::ParseError("PRISMParser: file: "+ file_name + " @line "+prismparser::intToString(line_number) + " " + s);
}

void PRISMerror(const std::string& s) {
  throw prismparser::ParseError("PRISMParser: file: "+ file_name + " @line "+prismparser::intToString(line_number) + " " + s);
}



void PRISMwarning( const std::string& s ) {
  std::cerr << "warning: " << line_number << " " << s << std::endl;
}



