/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef EXPR_TO_NUMBER_H
#define EXPR_TO_NUMBER_H

#include <vector>

namespace CVC3 {
  template<class T> class ExprHashMap;
  class Expr;
}

namespace prismparser {
  class Properties;
  class Property;
}

namespace parametric {
  class ExprToNumber {
  public:
    ExprToNumber();
    ~ExprToNumber();
    void setProperties(const prismparser::Properties &);
    void build();
    const CVC3::Expr &getExprByNumber(unsigned) const;
    unsigned getNumberByExpr(const CVC3::Expr &) const;
    unsigned getNumExprs() const;
  private:
    void buildExprToNumber(const prismparser::Property *);

    const prismparser::Properties *props;
    CVC3::ExprHashMap<unsigned> *mapExpr;
    std::vector<CVC3::Expr> *mapNumber;
  };
}

#endif
