/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef BOUNDED_ITERATOR_H
#define BOUNDED_ITERATOR_H

#include "rationalFunction/RationalFunction.h"
#include "SparseMC.h"

namespace parametric {
  class BoundedIterator {
  public:
    void setGraph(Graph *);
    void setInitStates(StateSet &);
    void setTargetStates(StateSet &);
    void setTimeBound(double);
    void iterate(std::vector<Rational::RationalFunction> &);
  private:
    void multiply(StateMap &, StateMap &);
    Graph *graph;
    StateSet *initStates;
    StateSet *targetStates;
    RewardMap *stateRewards;
    unsigned timeBound;
  };
}

#endif
