/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef REFINER_H
#define REFINER_H

#include "SparseMC.h"
#include "Partition.h"

namespace parametric {
  
  class Quotient;
  
  class Refiner {
  public:
    Refiner(Quotient &);
    virtual ~Refiner();
    virtual void createInitialPartition(Partition &);
    virtual void refineClass(EqClass &) = 0;
    virtual void createQuotient(Partition &) = 0;
    inline void setPartition(Partition &__partition) {
      partition = &__partition;
    }
    
  protected:
    Quotient &quot;
    SparseMC &mc;
    Graph &graph;
    inline Graph &getGraph() {
      return *mc.graph;
    }
    
    Partition *partition;
  };
}

#endif
