/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef CVC3_CONVERTER_H
#define CVC3_CONVERTER_H

#include <string>
#include <tr1/unordered_map>

namespace CVC3 {
  class Expr;
}

namespace rational {
  class RationalFunction;
  class CVC3Converter {
  public:
    CVC3Converter();
    RationalFunction operator()(const CVC3::Expr &);
    void addSymbols(const CVC3::Expr &);
  private:
    RationalFunction convert(const CVC3::Expr &);
    typedef std::tr1::unordered_map<std::string, unsigned> ParamNumbersMap;
    ParamNumbersMap paramNumbers;
  };
}

#endif
