/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include "MayChange.h"

namespace parametric {
  
  using namespace std;
  
  MayChange::MayChange(SparseMC &__mc) 
    : mc(__mc) {
    if ("small-first" == mc.vm["refine-order"].as<string>()) {
      topOrder = smallFirst;
    } else if ("big-first" == mc.vm["refine-order"].as<string>()) {
      topOrder = bigFirst;
    } else if ("first-first" == mc.vm["refine-order"].as<string>()) {
      topOrder = firstFirst;
    } else if ("last-first" == mc.vm["refine-order"].as<string>()) {
      topOrder = lastFirst;
    } else {
      throw runtime_error("Unsupported refine order");
    }
    
    if (smallFirst == topOrder) {
      smallFirstQueue.reset(new MayChangePQSmallFirst());
    } else if (bigFirst == topOrder) {
      bigFirstQueue.reset(new MayChangePQBigFirst());
    } else if (firstFirst == topOrder) {
      mchList.reset(new MayChangeList());
    } else if (lastFirst == topOrder) {
      mchList.reset(new MayChangeList());
    }  
  }
  
  
  void MayChange::push(PartitionList::iterator it) {
    if (alreadyContained.find(it) == alreadyContained.end()) {
      if (smallFirst == topOrder) {
        smallFirstQueue->push(it);
      } else if (bigFirst == topOrder) {
        bigFirstQueue->push(it);
      } else if (firstFirst == topOrder) {
        mchList->push_back(it);
      } else if (lastFirst == topOrder) {
        mchList->push_back(it);
      }
      alreadyContained.insert(it);
    }
  }
  
  PartitionList::iterator MayChange::top() const {
    if (smallFirst == topOrder) {
      return smallFirstQueue->top();
    } else if (bigFirst == topOrder) {
      return bigFirstQueue->top();
    } else if (firstFirst == topOrder) {
      return mchList->front();
    } else if (lastFirst == topOrder) {
      return mchList->back();
    }
  }
  
  void MayChange::pop() {
    alreadyContained.erase(top());
    if (smallFirst == topOrder) {
      smallFirstQueue->pop();
    } else if (bigFirst == topOrder) {
      bigFirstQueue->pop();
    } else if (firstFirst == topOrder) {
      mchList->pop_front();
    } else if (lastFirst == topOrder) {
      mchList->pop_back();
    }  
  }
  
  bool MayChange::empty() {
    if (smallFirst == topOrder) {
      return smallFirstQueue->empty();
    } else if (bigFirst == topOrder) {
      return bigFirstQueue->empty();
    } else if (firstFirst == topOrder) {
      return mchList->empty();
    } else if (lastFirst == topOrder) {
      return mchList->empty();
    }

    throw runtime_error("Unsupported partition refine order");
  }
}

