/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include "Partition.h"

namespace parametric {
  
  using namespace std;
  
  Partition::Partition(SparseMC &__mc) : mc(__mc) {
    mayChange.reset(new MayChange(mc));
  }
  
  void Partition::calcMayChange(EqClass *uEqClass) {
    EqClass::iterator uIt;
    for (uIt = uEqClass->begin(); uIt != uEqClass->end(); uIt++) {    
      vertex_descriptor u =  *uIt;
      // mayChange->push(uEqClass);
      pair<in_edge_iterator, in_edge_iterator> it;
      for (it = in_edges(u, *graph); it.first != it.second; ++it.first) {
        edge_descriptor e = *it.first;
        vertex_descriptor v = source(e, *graph);
        EqClass *vEqClass = &*P_map[v];
        if (vEqClass->size() > 0) {
          mayChange->push(P_map[v]);
        }
      }
    }
  }
}

