/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef QUOTIENT_H
#define QUOTIENT_H

#include "Partition.h"
#include "rationalFunction/RationalFunction.h"

namespace parametric {
  
  class SparseMC;
  class Partition;
  
  class Quotient {
  public:
    typedef enum bisim_enum {bisim_def, strong, weak} bisim_t;
    
    Quotient(SparseMC &);
    inline void setBisim(bisim_t _bisim) {
      bisim = _bisim;
    }
    inline bisim_t getBisim() const {
      return bisim;
    }
    inline SparseMC &getSparseMC() {
      return mc;
    }
    
    void quot();
  private:
    void quotSigref();
    
    SparseMC &mc;
    bisim_t bisim;
  };
}

#endif
