/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <sstream>
#include <boost/property_map.hpp>
#include <boost/graph/copy.hpp>
#include <boost/graph/named_function_params.hpp>
#include "TransProp.h"
#include "SparseMC.h"

namespace parametric {
  
  using namespace std;
  
  TransProp::TransProp() {
  }
  
  TransProp::TransProp(const Rational::RationalFunction &__value) {
    value = __value;
  }
  
  TransProp::TransProp(const TransProp &orig) {
    value = orig.value;
    reward = orig.reward;
  }
  
  TransProp::~TransProp() {
  }
  
  TransProp &TransProp::operator=(TransProp const &other) {
    value = other.value;
    reward = other.reward;
    return *this;
  }
}

