/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef WEAK_REFINER_H
#define WEAK_REFINER_H

#include "SparseMC.h"
#include "Refiner.h"

namespace parametric {
  
  class WeakRefiner : public Refiner {
  public:
    WeakRefiner(Quotient &);
    void createInitialPartition(Partition &);
    void refineClass(EqClass &);
    void createQuotient(Partition &);
    
  private:
    std::map<vertex_descriptor, std::vector<unsigned> > refined;
    bool weakIsSilent(vertex_descriptor, EqClass &);
    void silentSplit
      (EqClass &, std::list<vertex_descriptor> &,
       std::map<vertex_descriptor,std::vector<bool> > &,
       std::map<vertex_descriptor,unsigned> &);
    Rational::RationalFunction weakP_Chi
      (vertex_descriptor, EqClass &, EqClass &);
  };
}

#endif
