/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef CANCELLATOR_COCOA_H
#define CANCELLATOR_COCOA_H

#include <vector>
#include <string>

namespace CoCoA {
  class SparsePolyRing;
  class RingElem;
  class RingHom;
}

namespace Rational {
  class Polynomial;

  class CancellatorCoCoA {
  public:
    inline static void addSymbol(const std::string &symbol) {
      symbolStrings.push_back(symbol);
    }
    static void start();
    static void clear();
    static void convert(const Polynomial *, CoCoA::RingElem &);
    static void convert(const CoCoA::RingElem &, Polynomial *);
    static void cancel(Polynomial *, Polynomial *);
    static void cancel(CoCoA::RingElem &, CoCoA::RingElem &);
    
  private:
    static std::string int2string(unsigned);
    static std::vector<std::string> symbolStrings;
    static CoCoA::SparsePolyRing *polyRing;
    static CoCoA::SparsePolyRing *polyRingGCD;
    static CoCoA::RingHom *forth;
    static CoCoA::RingHom *back;
    static int cleanupInt;
  };
}

#endif
