/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef GPMC_H
#define GPMC_H

#include <vector>
#include "rationalFunction/RationalFunction.h"
#include "PMC.h"

namespace parametric {
  class state_iter;

  class GPMC : public PMC {
  public:
    GPMC();
    ~GPMC();
    void reserveRowsMem(unsigned);
    void reserveColsMem(unsigned);
    void reserveTransRewardsMem(unsigned);
    void reserveStateRewardsMem(unsigned);
    void setStateReward(Rational::RationalFunction);
    void addSucc(state, Rational::RationalFunction);
    void addSucc(state, Rational::RationalFunction, Rational::RationalFunction);
    void finishState();
    void computeBackTransitions();

    unsigned getNumStates() const;
    unsigned getNumTrans() const;
    unsigned getNumSuccStates(state) const;
    state getSuccState(state, unsigned) const;
    Rational::RationalFunction getSuccProb(state, unsigned) const;
    Rational::RationalFunction getStateReward(state) const;
    Rational::RationalFunction getSuccReward(state, unsigned) const;

    unsigned getNumPredStates(state) const;
    state getPredState(state, unsigned) const;
    state getSuccNrBySuccState(state, state) const;
    Rational::RationalFunction getPredProb(state, unsigned) const;
    Rational::RationalFunction getPredReward(state, unsigned) const;

    void removeSuccTrans(state, unsigned);
    void addSucc(state, state, Rational::RationalFunction);
    void addSucc(state, state, Rational::RationalFunction,
		 Rational::RationalFunction);

    void setSuccProb(state, unsigned, Rational::RationalFunction);
    void setSuccReward(state, unsigned, Rational::RationalFunction);
    void makeAbsorbing(state);
  private:
    unsigned numStates;
    std::vector<unsigned> *succStates;
    std::vector<Rational::RationalFunction> *succProbs;
    std::vector<Rational::RationalFunction> *succRewards;
    Rational::RationalFunction *stateRewards;
    std::vector<unsigned> *predStates;
  };
}

#endif
