/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef QUOTIENT_H
#define QUOTIENT_H

#include "PMC.h"
#include "Partition.h"
#include "rationalFunction/RationalFunction.h"

namespace parametric {
  
  class SparseMC;
  class Partition;
  
  class Quotient {
  public:
    typedef enum bisim_enum {strong, weak} bisim_t;

    Quotient();
    ~Quotient();
    void setBisim(bisim_t);
    void setRewardAnalysis(bool);
    void setOldPMC(PMC &);
    void setOldInitStates(StateSet &);
    void setOldTargetStates(StateSet &);
    void setOldStateRewards(RewardMap &);
    void setNewPMC(PMC &);
    void setNewInitStates(StateSet &);
    void setNewTargetStates(StateSet &);
    void setNewStateRewards(RewardMap &);
    void setPartRefOrder(PartRefOrder);
    Partition &getPartition();
    QuotMap &getQuotMap();
    void quot();
  private:
    Refiner *refiner;
    bool rewardAnalysis;
    PMC *oldPMC;
    StateSet *oldInitStates;
    StateSet *oldTargetStates;
    RewardMap *oldStateRewards;
    PMC *newPMC;
    StateSet *newInitStates;
    StateSet *newTargetStates;
    RewardMap *newStateRewards;
    bisim_t bisim;
    PartRefOrder partRefOrder;
    Partition *partition;
  };
}

#endif
