/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef REFINER_H
#define REFINER_H

#include "Controller.h"
#include "Partition.h"

namespace parametric {
  class Refiner {
  public:
    Refiner();
    virtual ~Refiner();
    virtual void createInitialPartition(Partition &);
    virtual void refineClass(EqClass &) = 0;
    virtual void createQuotient(Partition &) = 0;
    void setPartition(Partition &);
    void setRewardAnalysis(bool);
    void setOldInitStates(StateSet &);
    void setOldTargetStates(StateSet &);
    void setOldStateRewards(RewardMap &);
    void setOldPMC(PMC &);
    void setNewTargetStates(StateSet &);
    void setNewStateRewards(RewardMap &);
    void setNewPMC(PMC &);
    void setNewInitStates(StateSet &);
    QuotMap &getQuotMap();
    
  protected:
    Partition *partition;
    bool isRewardAnalysis;
    PMC *oldPMC;
    StateSet *oldInitStates;
    StateSet *oldTargetStates;
    RewardMap *oldStateRewards;
    PMC *newPMC;
    StateSet *newInitStates;
    StateSet *newTargetStates;
    RewardMap *newStateRewards;
    QuotMap quotMap;
  };
}

#endif
