/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef RESULT_PRINTER_H
#define RESULT_PRINTER_H

#include <string>
#include "RegionScheduler.h"

namespace parametric {
  class ResultPrinter {
  public:
    void setOutputPrefix(const std::string &);
    void setOutputFormat(const std::string &);
    void setResult(const RegionScheduler &);
    void setPlotStep(const mpq_class &);
    void setPlotStep(const std::string &);
    void setMinimize(bool);
    void print();

  private:
    void printRegionMap();
    void printGnuplotFile();
    void printDATFile();
    void printBox(const Box &, std::ostream &);

    std::string outputPrefix;
    std::string outputFormat;
    mpq_class plotStep;
    bool minimize;
    RegionScheduler result;
  };
}

#endif
