/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef WEAK_REFINER_H
#define WEAK_REFINER_H

#include <boost/dynamic_bitset_fwd.hpp>
#include "Controller.h"
#include "Refiner.h"

namespace parametric {
  
  class WeakRefiner : public Refiner {
  public:
    WeakRefiner();
    void createInitialPartition(Partition &);
    void refineClass(EqClass &);
    void createQuotient(Partition &);
    
  private:
    std::map<PMM::state, std::vector<unsigned> > refined;
    bool weakIsSilent(PMM::state, EqClass &);
    void silentSplit
      (EqClass &, std::list<PMM::state> &,
       std::map<PMM::state,std::vector<bool> > &,
       std::map<PMM::state,unsigned> &);
    Rational::RationalFunction weakP_Chi
      (PMM::state, EqClass &, EqClass &);
    void backSearch(boost::dynamic_bitset<> &, PMM::state);
  };
}

#endif
