/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2007-2010 Bjoern Wachter (Bjoern.Wachter@comlab.ox.ac.uk)
 * Copyright 2009-2010 Ernst Moritz Hahn (emh@cs.uni-sb.de)
 */

#ifndef __NODE_H__
#define __NODE_H__

#include <string>

namespace prismparser {

//other classes needed
class DFSAdapter;

class Node
{
 public:
  //virtual destructor
  virtual ~Node() {}

  //get a string representation
  virtual std::string toString() const = 0;

  //used to walk a AST
  virtual void Apply(DFSAdapter &a) const = 0;

};

 inline std::ostream &operator<<(std::ostream &os, const Node &node) {
   os << node.toString();
   return os;
 }
 
}

/*********************************************************************/
//include headers for concrete ast classes
/*********************************************************************/
//#include "Stmt.h"
//#include "StdcAst.h"

#endif //__NODE_H__

/*********************************************************************/
//end of Node.h
/*********************************************************************/
