#ifndef ITERATION_VECTORS_MDP_H
#define ITERATION_VECTORS_MDP_H

#include <utility>
#include <cmath>
#include <limits>
#include <assert.h>
#include "SparseNonDet.h"

namespace prohver {
  class IterationVectorsMDP {
  public:
    typedef enum {relative, absolute} StopCriterion;

    IterationVectorsMDP(SparseNonDet &);
    ~IterationVectorsMDP(){};
    void setStopCriterion(const StopCriterion);
    void setPrecision(const double);
    void setMinProb(const bool);
    void boundedReachBackwardsBounded(const double);
    void unboundedReachBackwards();
    void resize(const unsigned);
    void backwardIterate(const double);
    void backwardIterate();
    double precision;
    std::vector<unsigned> decisions;
    std::vector<double> result;
    std::vector<bool> targets;
    std::vector<unsigned> scheduler;
    const SparseNonDet &getModel() const;
    SparseNonDet &getModel();

  private:
    bool unboundedPreciseEnough();
    void matrixVectorMultiply(SparseNonDet &, const std::vector<double> &,
			      std::vector<double> &);
    void matrixVectorMultiply();
    SparseNonDet &mc;
    StopCriterion stopCriterion;
    void computeScheduler();
    /* TODO: how to avoid this explicit import of each field? */
    std::vector<double> unifProbs;
    std::vector<double> unifProbsPrimed;
    bool minProb;
  };

}

#endif
