#include "PARAMExporter.h"
#include <fstream>
#include <stdexcept>
#include <boost/dynamic_bitset.hpp>
#include "IterationVectorsMDP.h"
#include "SparseNonDet.h"
#include <iostream>

namespace prohver {
  using namespace std;
  using namespace boost;

  void PARAMExporter::exportGraph() {
    ofstream ostream(outFn.c_str(), ios::out);

    if (printMarkovChain) {
      exportMC(ostream);
    } else {
      exportMDP(ostream);
    }
  }

  void PARAMExporter::exportMC(ofstream &ostream) {
    const SparseNonDet &mdp(iters->getModel());
    const unsigned numStates(mdp.getNumStates());
    const vector<bool> &targets(iters->targets);
    const vector<unsigned> &scheduler(iters->scheduler);
    dynamic_bitset<> includeStates;
    computeIncludeStates(includeStates);

    dynamic_bitset<> isInit(numStates);
    for (unsigned initNr(0); initNr < mdp.getInit().size(); initNr++) {
      isInit[mdp.getInit()[initNr]] = true;
    }

    vector<unsigned> stateMap(mdp.getNumStates());
    unsigned numPARAMStates(0);
    unsigned numPARAMTrans(0);
    for (unsigned state(0); state < numStates; state++) {
      if (includeStates[state]) {
	stateMap[state] = numPARAMStates;
	numPARAMStates++;
	const unsigned choice(scheduler[state]);
	unsigned choiceBegin(mdp.getChoiceBegin(choice));
	unsigned choiceEnd(mdp.getChoiceEnd(choice));
	if (!targets[state]) {
	  numPARAMTrans += choiceEnd - choiceBegin;
	}
      }
    }

    ostream << "STATES " << numPARAMStates << "\n";
    ostream << "TRANSITIONS " << numPARAMTrans << "\n";
    ostream << "INIT ";
    for (unsigned state(0); state < numStates; state++) {
      if (includeStates[state] && isInit[state]) {
	ostream << stateMap[state] + 1 << " ";
      }
    }
    ostream << "\n";
    ostream << "TARGET ";
    for (unsigned state(0); state < numStates; state++) {
      if (includeStates[state] && targets[state]) {
	ostream << stateMap[state] + 1 << " ";
      }
    }
    ostream << "\n";
    ostream << "PARAM\n";

    for (unsigned state(0); state < numStates; state++) {
      if (includeStates[state]) {
	if (!targets[state]) {
	  const unsigned choice(scheduler[state]);
	  unsigned choiceBegin(mdp.getChoiceBegin(choice));
	  unsigned choiceEnd(mdp.getChoiceEnd(choice));
	  for (unsigned succNr(choiceBegin); succNr < choiceEnd; succNr++) {
	    const unsigned succState(mdp.getSuccState(succNr));
	    const double succProb(mdp.getSuccProb(succNr));
	    const unsigned PARAMState(stateMap[state] + 1);
	    const unsigned PARAMTarget(stateMap[succState] + 1);
	    ostream << PARAMState << " " << PARAMTarget << " "
		    << int(succProb*10000000) << "/10000000\n";
	  }
	}
      }
    }    
  }

  void PARAMExporter::exportMDP(ofstream &ostream) {
    const SparseNonDet &mdp(iters->getModel());
    const unsigned numStates(mdp.getNumStates());
    const vector<bool> &targets(iters->targets);

    dynamic_bitset<> isInit(numStates);
    for (unsigned initNr(0); initNr < mdp.getInit().size(); initNr++) {
      isInit[mdp.getInit()[initNr]] = true;
    }
    
    ostream << "digraph \"" << outFn << "\" {\n";

    for (unsigned state(0); state < numStates; state++) {
      ostream << "  s"  << state << "[label=\"" << state << "\" "
	      << "style=\"filled\" fillcolor=\""
	      << nodeColor(isInit[state], targets[state]) << "\"]\n";
    }
    ostream << "\n";
    for (unsigned state(0); state < numStates; state++) {
      for (unsigned choice(mdp.getStateBegin(state));
	   choice < mdp.getStateEnd(state); choice++) {
	ostream << "  c"  << choice << "[label=\"" << choice << "\" "
		<< "style=\"filled\" fillcolor=\"black\"]\n";	
      }
    }
    ostream << "\n";

    for (unsigned state(0); state < numStates; state++) {
      for (unsigned choice(mdp.getStateBegin(state));
	   choice < mdp.getStateEnd(state); choice++) {
	ostream << "  s" << state << " -> c" << choice
		<< " [label=\"\"]" << ";\n";
	unsigned choiceBegin(mdp.getChoiceBegin(choice));
	unsigned choiceEnd(mdp.getChoiceEnd(choice));
	for (unsigned succNr(choiceBegin); succNr < choiceEnd; succNr++) {
	  const unsigned succState(mdp.getSuccState(succNr));
	  const double succProb(mdp.getSuccProb(succNr));
	  ostream << "  c" << choice << " -> s" << succState
		  << " [label=\"" << succProb << "\"]" << ";\n";
	}
      }    
    }
    ostream << "}\n";
  }
}
