

//#include <ilcplex/ilocplex.h>
#include "DHR_Rational.h"
#include "general.h"
//#include "display.h"

// DHR_Rational num2Rat(IloNum x)
// {
// 	Integer num = (Integer)(x*10);
// 	Integer den = 10;
// 	if (num%2 == 0) {num/=2; den/=2;}
// 	if (num%5 == 0) {num/=5; den/=5;}
// 
// 	DHR_Rational result = new Integer[2];
// 	result[0] = num; result[1] = den;
// 	return result;
// }


// DHR_Rational** numArray2ToRatArray2(IloEnv env, IloNumArray2 numArray2)
// {
// 	DHR_Rational** result = new DHR_Rational*[numArray2.getSize()];
// 	
// 	for(IloInt i=0; i<numArray2.getSize(); i++)
// 	{
// 		result[i] =  new DHR_Rational[numArray2[i].getSize()];
// 		for(IloInt j=0; j<numArray2[i].getSize(); j++)
// 		{
// 			//result[i][j] = new Integer[2];
// 			result[i][j] = num2Rat(numArray2[i][j]);
// 			//displayRat(env, result[i][j]);
// 			//env.out() << " ";
// 		}
// 		//env.out() << endl;
// 	}
// 	return result;
// }

DHR_Rational copyRat(DHR_Rational x)
{
	DHR_Rational result = new Integer[2];
	result[0] = x[0];
	result[1] = x[1];
	return result;
}


DHR_Rational addRat(DHR_Rational x, DHR_Rational y)
{
	DHR_Rational result = new Integer[2];
	result[0] = x[0] * y[1] + x[1] * y[0];
	result[1] = x[1] * y[1];
	return result;
}

DHR_Rational subRat(DHR_Rational x, DHR_Rational y)
{
	DHR_Rational result = new Integer[2];
	result[0] = x[0] * y[1] - x[1] * y[0];
	result[1] = x[1] * y[1];
	return result;
}
DHR_Rational minusRat(DHR_Rational x)
{
	DHR_Rational result = new Integer[2];
	result[0] = - x[0];
	result[1] = x[1];
	return result;
}

DHR_Rational mulRat(DHR_Rational x, DHR_Rational y)
{
	DHR_Rational result = new Integer[2];
	result[0] = x[0] * y[0];
	result[1] = x[1] * y[1];
	return result;
}

DHR_Rational divRat(DHR_Rational x, DHR_Rational y)
{
	DHR_Rational result = new Integer[2];
	result[0] = x[0] * y[1];
	result[1] = x[1] * y[0];
	return result;
}

// return(x > y)
bool gtRat(DHR_Rational x, DHR_Rational y)
{
	assert((x[1] > 0) && (y[1] > 0));
	return(x[0]*y[1] > y[0]*x[1]);
}

// return(x >= y)
bool geqRat(DHR_Rational x, DHR_Rational y)
{
	assert((x[1] > 0) && (y[1] > 0));
	return(x[0]*y[1] >= y[0]*x[1]);
}

DHR_Rational maxRat(DHR_Rational x, DHR_Rational y)
{
	if(gtRat(x,y)) return copyRat(x);
	else  return copyRat(y);
}

DHR_Rational minRat(DHR_Rational x, DHR_Rational y)
{
	if(gtRat(x,y)) return copyRat(y);
	else  return copyRat(x);
}

Integer gcd(Integer p, Integer q)
{
	if (p<0) p=-p;
	if (q<0) q=-q;
	if (q > p) return(gcd(q,p));
	if ((p == 0) && (q == 0)) return 1;
	if (q == 0) return(p);
	return(gcd(q, p%q));
}
void simplifyRat(DHR_Rational x)
{
	//displayRat(x);	
	Integer factor = gcd(x[0],x[1]);
	x[0] /= factor;
	x[1] /= factor;
	//cout << "factor = " << factor << endl;
	//displayRat(x);
}

void displayRat(DHR_Rational rational)
{
	if (rational[1] == 1) cout << rational[0];
	else cout << rational[0] << "/" << rational[1];
}

void displayRange(DHR_Rational** range, char c)
{
	cout << "> " << c << "1 in [";
	displayRat(range[0][0]);
	cout << " , ";
	displayRat(range[0][1]);
	cout << "]" << endl;

	cout << "> " << c << "2 in [";
	displayRat(range[1][0]);
	cout <<  " , ";
	displayRat(range[1][1]);
	cout << "]" << endl << flush;
}

void displayMatrix(DHR_Rational** range, unsigned int dim_rows, unsigned int dim_columns)
{	
	for (uint i=0; i<dim_columns; ++i)
	{
		for (uint j=0; j<dim_rows; ++j)
		{
			displayRat(range[i][j]);
			cout << " ";
		};
		cout << endl;
	}
	cout << flush;
}



