/***************************************************************************
                          automaton_compose.cpp  -  description
                             -------------------
    begin                : Tue Jun 8 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "automaton.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;
 
// ---------------------------------------------------------------------------
// Composition
// ---------------------------------------------------------------------------

bool
automaton::add_location_from_composition(location_ref_to_location_ref_pair_map& loc_map, const automaton& aut1, const location_ref& loc1, const automaton& aut2, const location_ref& loc2, const PFunction& pfunc1, const PFunction& pfunc2)
{
  // add location only if not yet in loc_map
  // returns true if location already exists
  
//  clock_val_set inv;
//  time_elapse_poly univ_tp(dim),tp(dim);
  location_ref_pair lrp(loc1,loc2);
  location_ref loc;

if (DEBUG_OUTPUT>0) {
cout << "Searching for " << lrp << flush;
cout << " in map size " << loc_map.size() << flush;
};
  // if location is not already in passed list
  if (!loc_map.find(lrp,loc,false)) // if not found
  {
if (DEBUG_OUTPUT>0) {
cout << "Creating new loc, ";
};
		location l(aut1.locations[loc1]);
      l.add_space_dimensions_and_embed(dim-aut1.dim);
      l.map_space_dimensions(pfunc1);
      
		location l2(aut2.locations[loc2]);
      l2.add_space_dimensions_and_embed(dim-aut2.dim);
      l2.map_space_dimensions(pfunc2);
      
    l.intersection_assign(l2);
		
		loc=add_location(aut1.locations[loc1].name+"~"+aut2.locations[loc2].name,l);
if (DEBUG_OUTPUT>0) {
cout << "added as " << loc << endl;
};
// aut1.locations[loc1].print();
// aut2.locations[loc2].print();
// cout << "Composed:" << endl;
// locations[loc].print();

   if (loc!=locations.size())
   {
      // add reference to map
      loc_map.insert( location_ref_to_location_ref_pair_map::value_type(loc,lrp) );
   
      return false;
   }
   else
      return true; // no location -> we consider it exists
  }
  else
  {
if (DEBUG_OUTPUT>0) {
cout << ", already exists as " << loc << endl;
//aut.locations[loc].print();
};
    return true;
  };
}

void
automaton::add_transition_from_composition(location_ref& loc1, location_ref& loc2, const automaton& aut1, const transition_ref& t1, const map <label_ref,label_ref>& label1_to_common_label, const automaton& aut2, const transition_ref& t2, const map <label_ref,label_ref>& label2_to_common_label, const PFunction& pfunc1, const PFunction& pfunc2, distribution_ref distr, unsigned int distr_entry)
{
  // Assumptions: labels are identical in t1 and t2
  clock_val_set mu,mu2;
  bool urgent = aut1.transitions[t1].is_urgent() || aut2.transitions[t2].is_urgent();
if (DEBUG_OUTPUT>0) {
cout << "Comp. synch Transitions" << flush;
};
if (DEBUG_OUTPUT>0) {
//aut1.transitions[t1].mu.print();
//aut2.transitions[t2].mu.print();
};

  mu=aut1.transitions[t1].unrestricted_mu();
  mu.add_space_dimensions_and_embed_double(dim-aut1.dim);
  PFunction pfunc(pfunc1);
  PartialFunction_Double(pfunc,dim);
  mu.map_space_dimensions(pfunc);
  
  mu2=aut2.transitions[t2].unrestricted_mu();
  mu2.add_space_dimensions_and_embed_double(dim-aut2.dim);
  pfunc=pfunc2;
  PartialFunction_Double(pfunc,dim);
  mu2.map_space_dimensions(pfunc);
  
  mu.intersection_assign(mu2);
//      mu.simplify();

//cout << "Adding transition with label " << aut1.transitions[t1].label << endl;
  add_transition(loc1,label1_to_common_label.find(aut1.transitions[t1].label)->second,mu,loc2, urgent, distr, distr_entry);
}

void
automaton::add_indep_transition_from_composition(location_ref& loc1, location_ref& loc2, const automaton& aut1, const transition_ref& t1, const map <label_ref,label_ref>& label_to_common_label, const automaton& aut2, const PFunction& pfunc1, const PFunction& pfunc2, distribution_ref distr, unsigned int distr_entry)
{
  // transition is independent of aut2
  clock_val_set mu;
if (DEBUG_OUTPUT>0) {
cout << "Adding indep. Transition" << flush;
};
  mu=aut1.transitions[t1].unrestricted_mu();       // now the other variables not in aut1 must stay the same, therefore add constraints
  
  mu.add_space_dimensions_and_embed_double(dim-aut1.dim);
  PFunction pfunc(pfunc1);
  PartialFunction_Double(pfunc,dim);
  mu.map_space_dimensions(pfunc);

  // add constraints so that uncontrolled variables and parameters remain constant
  for (unsigned int i=0;i<dim;++i)
    if ((!(aut1.variables.contains(pfunc1.get_premap(i)) || aut1.parameters.contains(pfunc1.get_premap(i)))) && (aut2.variables.contains(pfunc2.get_premap(i)) || aut2.parameters.contains(pfunc2.get_premap(i))))
      mu.add_constraint(Variable(i)==Variable(i+dim));

//cout << "Adding indep. transition with label " << aut1.transitions[t1].label << endl;
   //label_ref lr=*label_to_common_label.find(aut1.transitions[t1].label);
  add_transition(loc1,label_to_common_label.find(aut1.transitions[t1].label)->second,mu,loc2, aut1.transitions[t1].is_urgent(), distr, distr_entry);
}

symb_states_type
automaton::minimize_reachable()
{
  // Delete all unreachable locations

  stopwatch sw(2100,"minimize_reachable");
  clock_val_set cvs,cvs2,E;
  set<location_ref> delete_set,set2;
  //set<location_ref>::iterator iter;

  unsigned int count_del=0;
  location_ref l;

//automaton oldaut=*this; // only for testing

cout << "Minimizing based on reachable states" << endl << flush;
cout << "Starting with " << locations.size() << " locations." << endl << flush;
  // restrict ini_states to invariants
  // -  this is just to avoid modelling errors, because the invariants are easily forgotten
  restrict_to_invariant(ini_states);

  // Get reachable states
  symb_states_type reachP;

  bool dum=USE_CONVEX_HULL;
  if (COMPOSE_USE_CONVEX_HULL_FOR_REACH)
    USE_CONVEX_HULL=true;
  reachP=get_reach_set();
  USE_CONVEX_HULL=dum;

cout << reachP.size() << " reachable locations." << endl << flush;


  // Replace locations that are not reachable
  for (unsigned int i=0;i<locations.size();++i)
  {
//        if (!delete_set.contains(i)) // not necessary
    {
//cout << i << ":" << (reachP.find(i)==reachP.end()) << ";" << locations.size() << endl;
    if (reachP.find(i)==reachP.end())
    {
      // erase all incoming transitions
      while (locations[i].in_trans.begin() != locations[i].in_trans.end())
      {
//cout << "Erasing in-transition: " << *(locations[i].in_trans.begin()) << endl << flush;
        erase_transition(*(locations[i].in_trans.begin()));
//check_consistency();
      };
      // erase all outgoing transitions
      while (locations[i].out_trans.begin() != locations[i].out_trans.end())
      {
//cout << "Erasing out-transition: " << *(locations[i].out_trans.begin()) << endl << flush;

        erase_transition(*(locations[i].out_trans.begin()));
//check_consistency();
      };
      // finally delete i alltogether
      delete_set.insert(i); // don't do it here, because they'll be found later in deletion of unreachable states


      ++count_del;
    };
    };
  };

cout << "Deleting " << delete_set.size() << " locations." << endl << flush;

  // delete locations
  // note delete_set must be ordered
  while (delete_set.size()>0)
  {
    l=*(delete_set.begin());
    delete_set.erase(delete_set.begin());
if (ini_states.find(l) != ini_states.end())
throw_error("tried to delete ini_state");
    erase_location(l);
    // now correct the other entries in the delete_set
    set2.clear();
    for (set<location_ref>::iterator i=delete_set.begin();i!=delete_set.end();++i)
    {
      if (*i>l) // don't need to check if ordered, but won't hurt
        set2.insert(*i-1);
      else
        set2.insert(*i);
    };
    delete_set=set2;
  };

cout << endl << "Finished minimization: " << locations.size() << " locations remaining."  << endl;


/*
// test it
bool test1,test2;
test1=is_simulation(cvs_equiv,oldaut);
test2=oldaut.is_simulation(cvs_equiv,*this);
if (!(test1 && test2) )
{
cout << "Error: minimization produces fault:" << endl << flush;
cout << "P <= M :" << test1;
cout << "M <= P :" << test2;
cout << "Original:" << endl;
oldaut.print();
cout << "Minimized:" << endl;
print();
pause_key();
};
*/
//check_consistency();

  return ini_states;
}

string 
get_composed_aut_name(const string& n1, const string& n2)
{
  return n1 + "~" + n2;
}

void
get_common_labels(const map <string,label_ref>& lrm1,
                  const label_ref_set& l1,
                  const map <string,label_ref>& lrm2,
                  const label_ref_set& l2,
                  map <string,label_ref>& lrm_res,
                  label_ref_set& l_res,
                  map <label_ref,label_ref>& label1_to_label2,
                  map <label_ref,label_ref>& label2_to_label1,
                  map <label_ref,label_ref>& label1_to_clabels,
                  map <label_ref,label_ref>& label2_to_clabels)
{
  // build label maps
  // note: using tmp variables in case &lrm1==&lrm_res
  label_ref_set l_tmp=l1;
  map <string,label_ref> lrm_tmp=lrm1;
  // cycle through labels of automaton
  string label_name;
  label_ref lab;

//  spec_aut.labels.clear(); // are now replaced by the variables of composition
  for (map <string,label_ref>::const_iterator kk=lrm2.begin();kk!=lrm2.end();++kk)
  {
    label_name=kk->first;
    // 1. Find the variable in the set so far
    if (lrm_tmp.find(label_name)!=lrm_tmp.end())
    {
      lab=lrm_tmp[label_name];
      label2_to_label1.insert(make_pair(kk->second,lab));
      label1_to_label2.insert(make_pair(lab,kk->second));
    }
    else
    // 2. If not found, add new label
    {
      lab=l_tmp.size(); // chose the next position as id
      // todo: should really pick a new label and make sure it's new
      lrm_tmp.insert(make_pair(label_name,lab));
      l_tmp.insert(lab);
    }
    label2_to_clabels.insert(make_pair(kk->second,lab));
  }
  
  // for aut1, labels stay the same
  for (map <string,label_ref>::const_iterator kk=lrm1.begin();kk!=lrm1.end();++kk)
  {
   label1_to_clabels.insert(make_pair(kk->second,kk->second));
  }
  
  // assign outputs
  l_res=l_tmp;
  lrm_res=lrm_tmp;
}

location_ref_to_location_ref_pair_map
compose_discrete(automaton& caut, const automaton& aut, const automaton& spec_aut ) 
{
  // Composition of *this and spec_aut. Result includes only locations reachable by discrete transition
  // from initial states
  // Cont. transition relations and invariants are appended
  // Result: caut = *this || spec_aut
  // Assumptions: alphabets of *this and spec_aut are identical
  //              variable spaces are disjunct (they are simply appended)
  stopwatch sw(32200,"compose_discrete");

  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  trans_ref_set::iterator k,j;
  location_ref_to_location_ref_pair_map loc_map;
  bool found;

  location_ref loc1,loc2;
  clock_val_set cvs,cvs2;

message(16200, "Composing automata " + aut.name + " and " + spec_aut.name );


  caut.clear();

  caut.dim=aut.dim;
  caut.name=get_composed_aut_name(aut.name,spec_aut.name);
//  caut.labels.union_assign(spec_aut.labels);

  // ---------------------------------------------------------
  // fix variables
  // ---------------------------------------------------------
//message(128200,"Fixing variables");

  // Remap the variable ids to a common set
  string var_name;
  PFunction pfunc1,pfunc2;
  dimension_type newdim=aut.dim;

  // build variable maps
  // cycle through variables of automaton

//gf 05.12.06
//cout << "from: " << aut.var_id_map << spec_aut.var_id_map << endl;
	
   get_common_var_names(aut.var_id_map, spec_aut.var_id_map, caut.var_id_map, pfunc1, pfunc2, newdim);	

//cout << "to: " << caut.var_id_map << endl;
//cout << pfunc << endl << flush;

  caut.dim=newdim;
	// Determine the new set of variables and parameters
	// Variables = union
   clock_ref_set v1,v2;
   v1=remap(aut.variables,pfunc1);
   v2=remap(spec_aut.variables,pfunc2);
   
   v1.union_assign(v2);
   caut.variables=v1;
  // Parameters = union minus (union of variables)
	v1=remap(aut.parameters,pfunc1);
	v2=remap(spec_aut.parameters,pfunc2);
   v1.union_assign(v2);
   v1.difference_assign(caut.variables);
	caut.parameters=v1;

/*  // expand variable space of *this
//cout << "1:" << newdim-dim << endl << flush;
  aut.add_space_dimensions_and_embed(newdim-aut.dim);
  // expand variable space of spec_aut
//cout << "2:" << newdim-spec_aut.dim << endl << flush;
  spec_aut.add_space_dimensions_and_embed(newdim-spec_aut.dim);
  // remap variables of spec_aut
//cout << "3" << endl << flush;
  spec_aut.map_space_dimensions(pfunc);
	*/
  // ---------------------------------------------------------
  // fix labels
  // ---------------------------------------------------------
//message(128200,"Fixing labels");
  // Remap the label ids to a common set
   label_ref lab;

  // build label maps
   map <label_ref,label_ref> label2_to_label1;
   map <label_ref,label_ref> label1_to_label2;
   map <label_ref,label_ref> label1_to_clabels,label2_to_clabels;
   get_common_labels(aut.label_name_to_label_ref_map, aut.labels, spec_aut.label_name_to_label_ref_map, spec_aut.labels, caut.label_name_to_label_ref_map, caut.labels, label1_to_label2, label2_to_label1, label1_to_clabels, label2_to_clabels);
  
  // ---------------------------------------------------------

  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent
  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  for (symb_states_type::const_iterator i=aut.ini_states.begin(); i!=aut.ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=spec_aut.ini_states.begin(); h!=spec_aut.ini_states.end(); ++h)
    {
      found=caut.add_location_from_composition(loc_map,aut,i->first,spec_aut,h->first,pfunc1,pfunc2);
      // note: if the location does not exist (e.g., invariant empty), it's not in the loc_map
      lrp=location_ref_pair(i->first,h->first);
      // add to initial states of composition
      if (loc_map.find(lrp,loc1))
      {
         waiting.add(lrp);
         cvs=i->second;
         cvs.add_space_dimensions_and_embed(newdim-aut.dim);
         cvs.map_space_dimensions(pfunc1);
         cvs2=h->second;
         cvs2.add_space_dimensions_and_embed(newdim-spec_aut.dim);
         cvs2.map_space_dimensions(pfunc2);
         cvs.intersection_assign(cvs2);
         cvs.minimize_memory();
         caut.ini_states.add(loc1,cvs);
      }
    }
  }
	// give the ini_states the new variables
	caut.ini_states.var_names_assign(caut.get_var_names());	
	

  while (!waiting.empty())
  {
//cout << "." << flush;
    progress_dot();

    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

    loc_map.find(lrp,loc1);

    // for all outgoing transitions in P
    k = aut.locations[lrp.first].out_trans.begin();
    if (!STOP_COMPOSE_AT_ERROR || aut.locations[lrp.first].name.find(ERROR_LOCATION_STRING)==string::npos)
    while(k != aut.locations[lrp.first].out_trans.end())
    {
      // First tau-transitions of P
//      if ((aut.transitions[*k].label==0) || (!spec_aut.labels.contains(label1_to_label2[aut.transitions[*k].label])))
      if ((aut.transitions[*k].label==0) || (label1_to_label2.find(aut.transitions[*k].label)==label1_to_label2.end()))
      {
	distribution_ref distr_index = aut.transitions[*k].distribution;
	
	distribution new_distr;
	distribution_ref new_distr_index = 0;
	if(distr_index > 0) 
	{
		new_distr = distribution(aut.distributions[distr_index]);
		new_distr_index = caut.distributions.size();
	}
	
	do
	{
		lrp2=location_ref_pair(aut.transitions[*k].target_loc(),lrp.second);
		found = caut.add_location_from_composition(loc_map,aut,lrp2.first,spec_aut,lrp2.second,pfunc1,pfunc2);
		// if not already visited put target on waiting list
		if (!found)
		{
			waiting.add(lrp2);
		};
	
		// add transition
		// look for the appropriate locations first
		if (loc_map.find(lrp2,loc2))
		caut.add_indep_transition_from_composition(loc1,loc2,aut,*k,label1_to_clabels,spec_aut,pfunc1,pfunc2, new_distr_index, aut.transitions[*k].distribution_entry);
		++k;
        } while (k != aut.locations[lrp.first].out_trans.end() && distr_index == aut.transitions[*k].distribution && distr_index > 0);
        
        if(new_distr_index > 0) caut.add_distribution(new_distr);
      } // end if
      else
      {
        // try all outgoing transitions in Q with the same label
        trans_ref_set::iterator first_k = k;
        j = spec_aut.locations[lrp.second].out_trans.begin();
        while(j != spec_aut.locations[lrp.second].out_trans.end())
        {
          if (label1_to_label2[aut.transitions[*k].label]==spec_aut.transitions[*j].label)
          {
		trans_ref_set::iterator first_j = j;
		distribution_ref distr_index = aut.transitions[*k].distribution;
		distribution_ref spec_distr_index = spec_aut.transitions[*j].distribution;
		
		distribution new_distr;
		distribution_ref new_distr_index = 0;
		if(distr_index + spec_distr_index > 0) 
		{
			new_distr = distribution(aut.distributions[distr_index].size() * spec_aut.distributions[spec_distr_index].size());
			new_distr_index = caut.distributions.size();
		}
		unsigned int entry = 0;
          
		do
		{
			j = first_j;
			do
			{
				lrp2=location_ref_pair(aut.transitions[*k].target_loc(),spec_aut.transitions[*j].target_loc());
				found = caut.add_location_from_composition(loc_map,aut,lrp2.first,spec_aut,lrp2.second,pfunc1,pfunc2);
			
				// if not already visited put target on waiting list
				if (!found)
				{
				waiting.add(lrp2);
				};
				
				if(new_distr_index > 0)
					new_distr[entry] = aut.distributions[distr_index][aut.transitions[*k].distribution_entry] * spec_aut.distributions[spec_distr_index][spec_aut.transitions[*j].distribution_entry];
			
				// add transition
				// look for the appropriate locations first
				if (loc_map.find(lrp2,loc2))
				caut.add_transition_from_composition(loc1,loc2,aut,*k,label1_to_clabels,spec_aut,*j,label2_to_clabels,pfunc1,pfunc2, new_distr_index, entry);
				
				entry++;
				++j;
			} while (j != spec_aut.locations[lrp.second].out_trans.end() && spec_distr_index == spec_aut.transitions[*j].distribution && spec_distr_index > 0);
			++k;
		} while (k != aut.locations[lrp.first].out_trans.end() && distr_index == aut.transitions[*k].distribution && distr_index > 0);
		
		if(new_distr_index > 0) caut.add_distribution(new_distr);
          }
          else
          {
          	++j;
          }; // end if
        }; // end for (j=...
        
        k = first_k;
        distribution_ref distr_index = aut.transitions[*k].distribution;
        do ++k;
        while(k != aut.locations[lrp.first].out_trans.end() && distr_index == aut.transitions[*k].distribution && distr_index > 0);
        
      }; // end if
    }; // end for (k...
    
    // now independent and tau-transitions of Q
    j = spec_aut.locations[lrp.second].out_trans.begin();
    if (!STOP_COMPOSE_AT_ERROR || spec_aut.locations[lrp.second].name.find(ERROR_LOCATION_STRING)==string::npos)
    while(j != spec_aut.locations[lrp.second].out_trans.end())
    {
//      if ((spec_aut.transitions[*j].label==0) || (!aut.labels.contains(label2_to_label1[spec_aut.transitions[*j].label])))
      if ((spec_aut.transitions[*j].label==0) || (label2_to_label1.find(spec_aut.transitions[*j].label)==label2_to_label1.end()))
      {
      	distribution_ref spec_distr_index = spec_aut.transitions[*j].distribution;
	
	distribution new_distr;
	distribution_ref new_distr_index = 0;
	if(spec_distr_index > 0) 
	{
		new_distr = distribution(spec_aut.distributions[spec_distr_index]);
		new_distr_index = caut.distributions.size();
	}
	
	do
	{
		lrp2=location_ref_pair(lrp.first,spec_aut.transitions[*j].target_loc());
		found = caut.add_location_from_composition(loc_map,aut,lrp2.first,spec_aut,lrp2.second,pfunc1,pfunc2);
		// if not already visited put target on waiting list
		if (!found)
		{
			waiting.add(lrp2);
		};
	
		// add transition
		// look for the appropriate locations first
		if (loc_map.find(lrp2,loc2))
		caut.add_indep_transition_from_composition(loc1,loc2,spec_aut,*j,label2_to_clabels,aut,pfunc2,pfunc1, new_distr_index, spec_aut.transitions[*j].distribution_entry);
		++j;
        } while (j != spec_aut.locations[lrp.second].out_trans.end() && spec_distr_index == spec_aut.transitions[*j].distribution && spec_distr_index > 0);
        
        if(new_distr_index > 0) caut.add_distribution(new_distr);
      }
      else
      {
      	++j;
      }; // end if
    }; // end for (j=...
  }; // end while
  progress_dot_end();

  // fix the location names
  caut.ini_states.loc_names_assign(caut.get_loc_names_map());


//cout << endl << "Composition finished. " << caut.locations.size() << " locs, " << caut.transitions.size() << " trans. " << endl << flush;
message(32200,"Composition finished. " + int2string(caut.locations.size()) + " locs, " + int2string(caut.transitions.size()) + " trans. ");
if (VERBOSE_LEVEL>=128000)
   caut.get_memory();

//   int dummy;
//cin >> dummy;
   
if (COMPOSE_WITH_REACH_MIN)
caut.minimize_reachable();

  return loc_map;
}

bool
get_or_add_location(automaton& caut, const vector<automaton>& aut, map <loc_ref_vec, location_ref>& glmap, const loc_ref_vec& lvec_ref, location_ref& loc)
{
   // returns true if location already exists
   // precondition: variables of aut[i] are already mapped to the variables of caut
   assert(aut.size()>=1);
   map <loc_ref_vec, location_ref>::const_iterator glit=glmap.find(lvec_ref);
   if (glit!=glmap.end())
   {
      loc=glit->second;
      return true;
   }
   else
   {
      // add location to location_map
      location l(aut[0].locations[lvec_ref[0]]);
      string n=aut[0].locations[lvec_ref[0]].name;
      for (uint i=1;i<lvec_ref.size();++i)
      {
         l.intersection_assign(aut[i].locations[lvec_ref[i]]);
         n+="~"+aut[i].locations[lvec_ref[i]].name;
      }
		
		loc=caut.add_location(n,l);
      if (loc!=caut.locations.size())
      {
         glmap[lvec_ref]=loc;
         return false;
      }
      else
         return true;
   }
}

label_ref_set get_outgoing_labels(const automaton& aut, const location_ref& loc)
{
   label_ref_set labs;
   for (trans_ref_set::const_iterator it=aut.locations[loc].out_trans.begin();it!=aut.locations[loc].out_trans.end();++it)
   {
      labs.insert(aut.transitions[*it].label);
   }
   return labs;
}


label_ref_set get_nonblocking_labels(const automaton& aut)
{
   label_ref_set labs=aut.labels;
   // simple version: nonblocking if outgoing transition in every location
   for (uint i=0;i<aut.locations.size();++i)
   {
      labs.intersection_assign(get_outgoing_labels(aut,i));
   }
   return labs;
}
      
location_ref_to_location_ref_pair_map
compose_by_vector(automaton& caut, vector<automaton>& aut) 
{
  // Composition of *this and spec_aut. Result includes only locations reachable by discrete transition
  // from initial states
  // Cont. transition relations and invariants are appended
  // Result: caut = *this || spec_aut
  // Assumptions: alphabets of *this and spec_aut are identical
  //              variable spaces are disjunct (they are simply appended)
  
  assert(aut.size()>=1);
  
  stopwatch sw(32200,"compose_discrete - vector");

  location_ref_pair lrp,lrp2;
  list<loc_ref_vec > waiting;
  trans_ref_set::iterator k,j;
  location_ref_to_location_ref_pair_map loc_map;
  bool found;

  location_ref loc1,loc2;
  clock_val_set cvs,cvs2;

  caut.clear();
  
  uint n_aut=aut.size();

   caut.name=aut[0].name;
   for (uint i=1;i<n_aut;++i)
      caut.name=get_composed_aut_name(caut.name,aut[i].name);
   message(16200, "Composing automata " + caut.name);
   //  caut.labels.union_assign(spec_aut.labels);

   dimension_type newdim(0);
   PFunction pfunc1,pfunc2;
   // get common variables -- just the collection, not mappings
   for (uint i=0;i<n_aut;++i)
   {
      get_common_var_names(caut.var_id_map, aut[i].var_id_map, caut.var_id_map, pfunc1, pfunc2, newdim);	
   }
   caut.dim=newdim;
   
//cout << caut.var_id_map;
//cout << newdim;   
  // ---------------------------------------------------------
  // fix variables
  // ---------------------------------------------------------
//message(128200,"Fixing variables");

  // Remap the variable ids to a common set
  string var_name;

   // build variable maps for each automaton and map its variables
   variable_id_map tmp_map;
   clock_ref_set tmp_vars,tmp_input_vars,tmp_params;
   for (uint i=0;i<n_aut;++i)
   {
      get_common_var_names(caut.var_id_map, aut[i].var_id_map, tmp_map, pfunc1, pfunc2, newdim);	
// cout <<       caut.dim-aut[i].dim << endl << flush;
      aut[i].add_space_dimensions_and_embed(caut.dim-aut[i].dim);
      aut[i].map_space_dimensions(pfunc2);
      tmp_vars.union_assign(aut[i].variables);
      tmp_input_vars.union_assign(aut[i].input_variables);
      tmp_params.union_assign(aut[i].parameters);
   }
   caut.variables=tmp_vars;
   tmp_input_vars.difference_assign(tmp_vars);
   caut.input_variables=tmp_input_vars;
//cout << tmp_params;   
   tmp_params.difference_assign(tmp_vars);
//cout << "after: " << tmp_params;
   caut.parameters=tmp_params;

  // ---------------------------------------------------------
  // fix labels
  // ---------------------------------------------------------
//message(128200,"Fixing labels");
  // Remap the label ids to a common set

  // build label maps
   map <label_ref,label_ref> label2_to_label1;
   map <label_ref,label_ref> label1_to_label2;
   map <label_ref,label_ref> label1_to_clabels,label2_to_clabels;
   for (uint i=0;i<n_aut;++i)
   {
      get_common_labels(caut.label_name_to_label_ref_map, caut.labels, aut[i].label_name_to_label_ref_map, aut[i].labels, caut.label_name_to_label_ref_map, caut.labels, label1_to_label2, label2_to_label1, label1_to_clabels, label2_to_clabels);
   }
   // now caut has the proper labels and label_ef_map
   // so map each of the automata to those 
   for (uint i=0;i<n_aut;++i)
   {
      get_common_labels(caut.label_name_to_label_ref_map, caut.labels, aut[i].label_name_to_label_ref_map, aut[i].labels, caut.label_name_to_label_ref_map, caut.labels, label1_to_label2, label2_to_label1, label1_to_clabels, label2_to_clabels);
      aut[i].map_or_add_labels(caut.label_name_to_label_ref_map);
   }
  
  // ---------------------------------------------------------

  map <loc_ref_vec, location_ref> gloc_to_loc_map;
  loc_ref_vec lv(n_aut);
  location_ref loc;
  
  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent
  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  vector<symb_states_type::const_iterator > vec_it_begin(n_aut),vec_it_end(n_aut);
  // initialize vec_it
   for (uint i=0;i<n_aut;++i)
   {
      vec_it_begin[i]=aut[i].ini_states.begin();
      vec_it_end[i]=aut[i].ini_states.end();
   }
   iterator_vector<symb_states_type::const_iterator> vec_it(vec_it_begin,vec_it_end);
   
   int iter_aut=aut.size()-1;
   bool increased_succ;
   while (vec_it!=vec_it_end)
   {
      progress_dot();
      //get_or_add_location(automaton& caut, const vector<automaton>& aut, map <vector<location_ref >, location_ref>& glmap, const vector<location_ref >& lvec_ref)
      for (uint j=0;j<n_aut;++j)
         lv[j]=vec_it[j]->first;
//cout << lv << flush;
      if (find(waiting.begin(),waiting.end(),lv)==waiting.end())         
      {
         waiting.push_back(lv);
//cout << "new";         
      }
      get_or_add_location(caut,aut,gloc_to_loc_map,lv,loc);
      
      if (loc!=caut.locations.size())
      {
         // intersect the states
         cvs=clock_val_set(caut.dim);
         for (uint j=0;j<n_aut;++j)
            cvs.intersection_assign(vec_it[j]->second);
         if (!cvs.is_empty())
         {
            cvs.minimize_memory();
            caut.ini_states.add(loc,cvs);
         }
      }
      
      // ++vec_it
      ++vec_it;
   }

	// give the ini_states the new variables
	caut.ini_states.var_names_assign(caut.get_var_names());	
	
   //
   ofstream log_file("out_comm_graph_discr.dot");	
   communication_graph(aut,log_file,true,false);
   log_file.close();
   log_file.open("out_comm_graph_cont.dot");	
   communication_graph(aut,log_file,false,true);
   log_file.close();
   
   // assumption: every location on the waiting list also exists in the automaton  
   vector<trans_ref_set::const_iterator > trans_it_begin(n_aut),trans_it_end(n_aut);
   iterator_vector<trans_ref_set::const_iterator> trans_it(trans_it_begin,trans_it_end);
      
  loc_ref_vec tlv(n_aut);   // target location
  location_ref nloc; // new location
  vector<bool> aut_part(n_aut); // aut i is participating in the transition
  bool aut_ok; // all aut have to be ok with the transition
  label_ref lab;
  bool found_one; // found at least one participating automaton
  clock_val_set mu;
  bool is_new;
  clock_ref_set const_vars; // those variables that remain constant in the transition
  clock_ref_set already_contr_vars; 
  label_ref_set out_labs;
  uint change_aut; // which transition to change
  
cout << "waiting" << endl << flush;  

   list <pair<transition,int> > trans_list;
   clock_val_set myguard,myguard2;
   transition mytrans;
   int mypriority;
   bool is_urgent;
   
  while (!waiting.empty())
  {
//cout << "." << flush;
    progress_dot();

    lv=*(waiting.begin());
    waiting.erase(waiting.begin());
//cout << lv;
    loc=gloc_to_loc_map[lv];    

    // for all outgoing transitions in P
    if (!STOP_COMPOSE_AT_ERROR || caut.locations[loc].name.find(ERROR_LOCATION_STRING)==string::npos)
    {
      trans_list.clear();
      mypriority=INT_MIN;
      // iterate through all outgoing transitions
      // first, initialize trans_it
      for (uint i=0;i<n_aut;++i)
      {
         trans_it_begin[i]=aut[i].locations[lv[i]].out_trans.begin();
         trans_it_end[i]=aut[i].locations[lv[i]].out_trans.end();
      }
      
      // get all outgoing labels
      out_labs.clear();
      for (uint i=0;i<n_aut;++i)
      {
         out_labs.union_assign(get_outgoing_labels(aut[i],lv[i]));
      }
      
      for (label_ref_set::const_iterator lab_it=out_labs.begin();lab_it!=out_labs.end();++lab_it) // try all labels occuring in this set 
      {
         trans_it=iterator_vector<trans_ref_set::const_iterator>(trans_it_begin,trans_it_end);
         lab=*lab_it;
//cout << lab << "," << flush;      
         while (trans_it!=trans_it_end)
         {
/*         // get possible labels
         out_labs.clear();
         for (uint j=0;j<n_aut;++j)
         {
            if (trans_it[j]!=trans_it_end[j])
            {
               out_labs.insert(aut[j].transitions[*trans_it[j]].label);
            }
         }
cout << out_labs << endl;         
         for (label_ref_set::const_iterator lab_it=out_labs.begin();lab_it!=out_labs.end();++lab_it) // try all labels occuring in this set of transitions
         {*/
            aut_ok=true;
//cout << ":" << flush;            
            const_vars=caut.parameters;
            change_aut=n_aut-1;
            is_urgent=false;
            // check for participating labels
            for (uint i=0;i<n_aut;++i)
            {
               if (trans_it[i]!=trans_it_end[i] || USE_HIOA_AUTOMATA) // not at end, so must participate
               {
                  if (aut[i].transitions[*trans_it[i]].label==lab || (USE_HIOA_AUTOMATA && aut[i].transitions[*trans_it[i]].label==0 && !aut[i].labels.contains(lab)))
                  {  
                     aut_part[i]=true;
                     if (!(USE_HIOA_AUTOMATA && aut[i].transitions[*trans_it[i]].label==0 && !aut[i].labels.contains(lab))) // don't consider priority of tau-transitions
                        mypriority=max(mypriority,aut[i].priority);
                  }
                  else
                  {
                     aut_ok=false;
                     change_aut=i;
                     break;
                  }
               }
               else
               { // at end, possibly allows the transition if it's not in the alphabet
                  aut_part[i]=false;
                  if (!aut[i].labels.contains(lab)) // it's an independent transition
                  {
                     // add constant vars to mu
                     const_vars.union_assign(aut[i].variables); // attention: correct if controlled vars are disjoint
                     // aut_ok stays true
                  }
                  else
                  {
                     aut_ok=false;
                     change_aut=i; // need to change automaton i for this label
//cout << "c" << change_aut << " " << flush;                     
                     break;
                  }
               }
            }
//cout << "t" << change_aut << flush;            
            if (aut_ok) // all aut are either participating or its not in their alphabets
            {
               mu=clock_val_set(caut.dim*2);
               // add the target location
               for (uint i=0;i<n_aut;++i)
               {
                  if (aut_part[i])
                  {
                     mu.intersection_assign(aut[i].transitions[*trans_it[i]].unrestricted_mu());
                     tlv[i]=aut[i].transitions[*trans_it[i]].target_loc();
                     is_urgent=is_urgent || aut[i].transitions[*trans_it[i]].is_urgent();
                  }
                  else
                     tlv[i]=lv[i]; // location doesn't change
               }            
               is_new=!get_or_add_location(caut,aut,gloc_to_loc_map,tlv,nloc);
               if (nloc!=caut.locations.size())
               {
                  if (is_new)
                  {
                     waiting.push_back(tlv);
                  }
                  
                  // add transition
cout << endl << lv << "->" << tlv << " l:" << caut.locations.size() << " t:" << caut.transitions.size() << " w: " << waiting.size() << ", " << caut.get_label_name(lab);            
   
                  for (uint i=0;i<n_aut;++i)
                  {
                     if (aut_part[i])
                        const_vars.difference_assign(aut[i].variables);
                  }
                  // add constraints so that uncontrolled variables and parameters remain constant
                  if (!USE_HIOA_AUTOMATA)
                  for (clock_ref_set::const_iterator it=const_vars.begin();it!=const_vars.end();++it)
                  {
                     mu.add_constraint(Variable(*it)==Variable(*it+caut.dim));
                  }
                  //caut.add_transition(loc,lab,mu,nloc);
                  mytrans=transition(loc,lab,mu,nloc);
                  mytrans.set_urgent(is_urgent);
                  trans_list.push_back(make_pair(mytrans,mypriority));
               }
            }
            if (USE_HIOA_AUTOMATA)
               trans_it.incr_iter(change_aut); // don't need end iterators here, indep. transitions must synch with TAU
            else
               trans_it.incr_iter_to_end(change_aut);
         } // while (trans_it!=trans_it_end)
      } // for (label_ref_set::const_iterator lab_it=out_labs.begin()
      
      // add transitions according to their priorities
      bool must_prioritize;
      for (list <pair<transition,int> >::const_iterator tit=trans_list.begin();tit!=trans_list.end();++tit)
      {
         must_prioritize=false;
         if (tit->second < INT_MAX)
         {
            for (list <pair<transition,int> >::const_iterator tit2=trans_list.begin();tit2!=trans_list.end() && !must_prioritize;++tit2)
            {
               if (tit2->first.label!=0 && tit2->second > mypriority)
               {
                  must_prioritize=true;
               }
            }
         }
         if (must_prioritize)
         {
            mypriority=tit->second;
            myguard=tit->first.unrestricted_mu();
            if (tit->first.label!=0)
            {
               myguard=tit->first.mu(caut.locations[tit->first.source_loc()].invariant(),caut.locations[tit->first.target_loc()].invariant());
               myguard.remove_space_dimensions(caut.dim,2*caut.dim-1); // project onto guard
               
      //cout << "before: " << myguard ;               
               // remove the guards of all transitions with higher priority, regardless of label
               for (list <pair<transition,int> >::const_iterator tit2=trans_list.begin();tit2!=trans_list.end() && !myguard.is_empty();++tit2)
               {
                  if (tit2->first.label!=0 && tit2->second > mypriority)
                  {
                     myguard2=tit2->first.mu(caut.locations[tit2->first.source_loc()].invariant(),caut.locations[tit2->first.target_loc()].invariant());
                     myguard2.remove_space_dimensions(caut.dim,2*caut.dim-1); // project onto guard
      //cout << "---- " << myguard2 ;               
                     myguard.difference_assign(myguard2);
                     myguard.simplify();
                  }
               }
      //cout << "after: " << myguard ;               
               // simplify
               myguard.add_space_dimensions_and_embed(caut.dim);
               myguard.intersection_assign(tit->first.unrestricted_mu());
               myguard.simplify();
            }
            
            // add transition
            caut.add_transition(tit->first.source_loc(),tit->first.label,myguard,tit->first.target_loc(),tit->first.is_urgent());
         }
         else
            caut.add_transition(tit->first.source_loc(),tit->first.label,tit->first.unrestricted_mu(),tit->first.target_loc(),tit->first.is_urgent());
      }
    } // if
  }; // end while
  progress_dot_end();

  // fix the location names
  caut.ini_states.loc_names_assign(caut.get_loc_names_map());


//cout << endl << "Composition finished. " << caut.locations.size() << " locs, " << caut.transitions.size() << " trans. " << endl << flush;
message(32200,"Composition finished. " + int2string(caut.locations.size()) + " locs, " + int2string(caut.transitions.size()) + " trans. ");
if (VERBOSE_LEVEL>=128000)
   caut.get_memory();

//   int dummy;
//cin >> dummy;
   
  return loc_map;
}



/*
location_ref_to_location_ref_pair_map
automaton::compose_discrete(automaton& caut, automaton& spec_aut )
{
  // Composition of *this and spec_aut. Result includes only locations reachable by discrete transition
  // from initial states
  // Cont. transition relations and invariants are appended
  // Result: caut = *this || spec_aut
  // Assumptions: alphabets of *this and spec_aut are identical
  //              variable spaces are disjunct (they are simply appended)
  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  trans_ref_set::iterator k,j;
  location_ref_to_location_ref_pair_map loc_map;
  bool found;
  location_ref loc1,loc2;
  clock_val_set cvs;

  caut.clear();

  caut.dim=dim;
  caut.name=name + "~" + spec_aut.name;
  caut.labels=labels;
  caut.labels.union_assign(spec_aut.labels);
  // fix variables
  caut.variables=variables;
  caut.variables.union_assign(spec_aut.variables);

cout << "Composing automata " << name << " and " << spec_aut.name << ":" << endl << flush;

  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent
  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  for (symb_states_type::const_iterator i=ini_states.begin(); i!=ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=spec_aut.ini_states.begin(); h!=spec_aut.ini_states.end(); ++h)
    {
      found=caut.add_location_from_composition(loc_map,*this,i->first,spec_aut,h->first);
      lrp=location_ref_pair(i->first,h->first);
      waiting.add(lrp);
      // add to initial states of composition
      if (true) // (!found)
      {
        loc_map.find(lrp,loc1);
        cvs=i->second;
        cvs.intersection_assign(h->second);
        caut.ini_states.add(loc1,cvs);
      };
    };
  };

  while (!waiting.empty())
  {
cout << "." << flush;

    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

    loc_map.find(lrp,loc1);

    // for all outgoing transitions in P
    for (k=locations[lrp.first].out_trans.begin();k!=locations[lrp.first].out_trans.end();k++)
    {
      // First tau-transitions of P
      if ((transitions[*k].label==0) || (!spec_aut.labels.contains(transitions[*k].label)))
      {
        lrp2=location_ref_pair(transitions[*k].target_loc,lrp.second);
        found = caut.add_location_from_composition(loc_map,*this,lrp2.first,spec_aut,lrp2.second);
        // if not already visited put target on waiting list
        if (!found)
        {
          waiting.add(lrp2);
        };

        // add transition
        // look for the appropriate locations first
        loc_map.find(lrp2,loc2);
        caut.add_transition_from_composition(loc1,loc2,*this,*k,spec_aut);
      } // end if
      else
      {
        // try all outgoing transitions in Q with the same label

        for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
        {
          if (transitions[*k].label==spec_aut.transitions[*j].label)
          {
            lrp2=location_ref_pair(transitions[*k].target_loc,spec_aut.transitions[*j].target_loc);
            found = caut.add_location_from_composition(loc_map,*this,lrp2.first,spec_aut,lrp2.second);
            // if not already visited put target on waiting list
            if (!found)
            {
              waiting.add(lrp2);
            };

            // add transition
            // look for the appropriate locations first
            loc_map.find(lrp2,loc2);
            caut.add_transition_from_composition(loc1,loc2,*this,*k,spec_aut,*j);
          }; // end if

        }; // end for (j=...
      }; // end if
    }; // end for (k...
    // now tau-transitions of Q
    for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
    {
      if ((spec_aut.transitions[*j].label==0) || (!labels.contains(spec_aut.transitions[*j].label)))
      {
        lrp2=location_ref_pair(lrp.first,spec_aut.transitions[*j].target_loc);
        found = caut.add_location_from_composition(loc_map,*this,lrp2.first,spec_aut,lrp2.second);
        // if not already visited put target on waiting list
        if (!found)
        {
          waiting.add(lrp2);
        };

        // add transition
        // look for the appropriate locations first
        loc_map.find(lrp2,loc2);
        caut.add_transition_from_composition(loc1,loc2,spec_aut,*j,*this);
      }; // end if
    }; // end for (j=...
  }; // end while


cout << endl << "Composition finished. " << caut.locations.size() << " locs, " << caut.transitions.size() << " trans. " << endl << flush;

if (COMPOSE_WITH_REACH)
caut.minimize_reachable();

  return loc_map;
};
*/

/*location_ref_to_location_ref_pair_map
automaton::compose_discrete_intersect(automaton& caut, automaton& spec_aut )
{
  // Composition of *this and spec_aut. Result includes only locations reachable from initial states by discrete transition
  // Cont. transition relation and invariants are simply intersected.
  //
  // Result: caut = *this || spec_aut
  // Assumptions: alphabets of *this and spec_aut are identical
  //              *this and spec_aut are over the same variable space
  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  trans_ref_set::iterator k,j;
  location_ref_to_location_ref_pair_map loc_map;
  bool found;
  location_ref loc1,loc2;
  clock_val_set cvs;

  caut.clear();

  caut.dim=dim;
  caut.name=name + "~" + spec_aut.name;
  caut.labels=labels;
  caut.labels.union_assign(spec_aut.labels);

cout << "Composing automata " << name << " and " << spec_aut.name << ":" << endl << flush;

  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent

  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  for (symb_states_type::const_iterator i=ini_states.begin(); i!=ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=spec_aut.ini_states.begin(); h!=spec_aut.ini_states.end(); ++h)
    {
      found=caut.add_location_from_composition(loc_map,*this,i->first,spec_aut,h->first,pfunc1,pfunc2);
      lrp=location_ref_pair(i->first,h->first);
      waiting.add(lrp);
      // add to initial states of composition
      if (true) // (!found)
      {
        loc_map.find(lrp,loc1);
        cvs=i->second;
        cvs.intersection_assign(h->second);
        caut.ini_states.add(loc1,cvs);
      };
    };
  };

  while (!waiting.empty())
  {
//cout << "." << flush;
    progress_dot();

    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

    loc_map.find(lrp,loc1);

    // for all outgoing transitions in P
    for (k=locations[lrp.first].out_trans.begin();k!=locations[lrp.first].out_trans.end();k++)
    {
      // First tau-transitions of P
      if ((transitions[*k].label==0) || (!spec_aut.labels.contains(transitions[*k].label)))
      {
        lrp2=location_ref_pair(transitions[*k].target_loc(),lrp.second);
        found = caut.add_location_from_composition(loc_map,*this,lrp2.first,spec_aut,lrp2.second);
        // if not already visited put target on waiting list
        if (!found)
        {
          waiting.add(lrp2);
        };
        // add transition
        loc_map.find(lrp2,loc2);
        caut.add_transition_from_composition(loc1,loc2,*this,*k,spec_aut);
      } // end if
      else // non tau-transitions
      {
        // try all outgoing transitions in Q with the same label
        for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
        {
          if (transitions[*k].label==spec_aut.transitions[*j].label)
          {
            lrp2=location_ref_pair(transitions[*k].target_loc(),spec_aut.transitions[*j].target_loc());
            found = caut.add_location_from_composition(loc_map,*this,lrp2.first,spec_aut,lrp2.second);
            // if not already visited put target on waiting list
            if (!found)
            {
              waiting.add(lrp2);
            };

            // add transition
            loc_map.find(lrp2,loc2);
            caut.add_transition_from_composition(loc1,loc2,*this,*k,spec_aut,*j);
          }; // end if
        }; // end for (j=...
      }; // end if
    }; // end for (k...
    // now tau-transitions of Q
    for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
    {
      if ((spec_aut.transitions[*j].label==0) || (!labels.contains(spec_aut.transitions[*j].label)))
      {
        lrp2=location_ref_pair(lrp.first,spec_aut.transitions[*j].target_loc());
        found = caut.add_location_from_composition(loc_map,*this,lrp2.first,spec_aut,lrp2.second);
        // if not already visited put target on waiting list
        if (!found)
        {
          waiting.add(lrp2);
        };

        // add transition
        // look for the appropriate locations first
        loc_map.find(lrp2,loc2);
        caut.add_transition_from_composition(loc1,loc2,spec_aut,*j,*this);
      }; // end if
    }; // end for (j=...
  }; // end while
  progress_dot_end();

cout << endl << "Composition finished. " << caut.locations.size() << " locs, " << caut.transitions.size() << " trans. " << endl << flush;

if (COMPOSE_WITH_REACH_MIN)
caut.minimize_reachable();

  return loc_map;
}
*/


void
communication_graph(const vector<automaton>& aut, ostream& o, bool do_discr, bool do_cont)
{
   label_ref_set shared,notinany,nonblock_j,nonblock_i,bothblocked,rest;
   
   // preamble
   o << "digraph comm {" << endl;
   o << "size=\"10.5,7\";" << endl;
   o << "orientation=landscape;" << endl;
//   o << "rankdir=LR;	size=\"8,5\";" << endl;
   o << "rankdir=LR;" << endl;
   
   // get global variable names
   dimension_type newdim(0);
   PFunction pfunc1,pfunc2;
   variable_id_map var_id_map;
   clock_ref_set vvars;
   // get common variables -- just the collection, not mappings
   for (uint i=0;i<aut.size();++i)
   {
//      get_common_var_names(var_id_map, aut[i].var_id_map, var_id_map, pfunc1, pfunc2, newdim);	
      vvars.clear();
      vvars.union_assign(aut[i].variables);
      vvars.union_assign(aut[i].input_variables);
      vvars.union_assign(aut[i].parameters);
      for (clock_ref_set::const_iterator jj=vvars.begin();jj!=vvars.end();++jj)
         var_id_map.insert(*jj,aut[i].var_id_map.get_name(*jj));
   }
      
   // -----------------------------------------------------------
   // get global inputs and outputs
   clock_ref_set global_inputs,global_outputs;
   for (uint i=0;i<aut.size();++i)
   {
      global_inputs.union_assign(aut[i].input_variables);
      global_outputs.union_assign(aut[i].variables);
   }
   global_inputs.difference_assign(global_outputs);
   
   // make an environment node if there are any inputs
   if (!global_inputs.empty())
   {
      o << "environment" << " [ shape=none, label=\"" << "environment" << "\\n";
      // output list of input variables
      if (do_cont){
      o << "(";
      for (clock_ref_set::const_iterator it=global_inputs.begin();it!=global_inputs.end();++it)
      {
         if (it!=global_inputs.begin())
            o << ",";
         o << var_id_map.get_name(*it);
      }
      o << ")";
      }
      
      o << "\" ]" << endl;
   }
   
   variable_id_map vnvec;
   
   clock_ref_set gi_vars;
   
   // -----------------------------------------------------------
   // global nonblocking labels
   label_ref_set global_labels,global_nonblocking,tmp_labs;
   for (uint i=0;i<aut.size();++i)
   {
      global_labels.union_assign(aut[i].labels);
   }
   global_nonblocking=global_labels;
   for (uint i=0;i<aut.size();++i)
   {
      tmp_labs=aut[i].labels;
      tmp_labs.difference_assign(get_nonblocking_labels(aut[i]));
      global_nonblocking.difference_assign(tmp_labs);
   }
   global_nonblocking.difference_assign(0); // remove TAU-label
   // -----------------------------------------------------------
   
   for (uint i=0;i<aut.size();++i)
   {
      vnvec=aut[i].get_var_names();
   
      // get notinany labels
      notinany=aut[i].labels;
      for (uint j=0;j<aut.size();++j)
      {
         if (j!=i)
            notinany.difference_assign(aut[j].labels);
      }
   
      o << aut[i].name << " [ shape=circle, label=\"" << aut[i].name << "\\n";
      
      // output list of controlled variables
      if (do_cont)
      if (!aut[i].variables.empty())
      {
         o << "(";
         for (clock_ref_set::const_iterator it=aut[i].variables.begin();it!=aut[i].variables.end();++it)
         {
            if (it!=aut[i].variables.begin())
               o << ",";
            o << vnvec.get_name(*it);
         }
         o << ")";
         o << "\\n";      
      }
      // output list of non-shared labels
      if (do_discr)
      for (label_ref_set::const_iterator it=notinany.begin();it!=notinany.end();++it)
         o << aut[i].get_label_name(*it) << "\\n";
      
      o << "\" ]" << endl;
      
      // global input vars 
      if (do_cont)
      if (!global_inputs.empty())
      {
         gi_vars=aut[i].input_variables;
         gi_vars.intersection_assign(global_inputs);
         // make transition from environment
         if (!gi_vars.empty())
         {
            o << "environment" << " -> " << aut[i].name << "[ dir=forw, style=dotted, label=\"";
            o << "(";
            for (clock_ref_set::const_iterator it=gi_vars.begin();it!=gi_vars.end();++it)
            {
               if (it!=gi_vars.begin())
                  o << ",";
               o << vnvec.get_name(*it);
            }
            o << ")";
                  o << "\" ]" << endl;
         }         
         o << endl;
      }
      
      // if there's a globally nonblocking label, draw an edge from the environment
      tmp_labs=aut[i].labels;
      tmp_labs.intersection_assign(global_nonblocking);
      if (do_discr)
      if (!tmp_labs.empty())
      {
         o << "environment" << " -> " << aut[i].name << "[ dir=forw, label=\"";
         for (label_ref_set::const_iterator it=tmp_labs.begin();it!=tmp_labs.end();++it)
            o << aut[i].get_label_name(*it) << "\\n";
         o << "\" ]" << endl;
      }         
      o << endl;      
   }
   
   clock_ref_set i_input_vars,j_input_vars;
   for (uint i=0;i+1<aut.size();++i)
   {
      for (uint j=i+1;j<aut.size();++j)
      {
         if (do_discr)
         {
         // get the labels between i and j
         shared=aut[i].labels;
         shared.difference_assign(label_ref(0)); // remove tau-label
         shared.intersection_assign(aut[j].labels);
         
         // nonblocking in j
         nonblock_j=shared;
         nonblock_j.intersection_assign(get_nonblocking_labels(aut[j]));
         
         // nonblocking in i
         nonblock_i=shared;
         nonblock_i.intersection_assign(get_nonblocking_labels(aut[i]));

         bothblocked=shared;
         bothblocked.difference_assign(nonblock_j);
         bothblocked.difference_assign(nonblock_i);
         
         rest=shared;
         rest.difference_assign(nonblock_i);
         rest.difference_assign(nonblock_j);
         rest.difference_assign(bothblocked);
         
         if (!nonblock_j.empty())
         {
            o << aut[i].name << " -> " << aut[j].name << "[ dir=forw, label=\"";
            for (label_ref_set::const_iterator it=nonblock_j.begin();it!=nonblock_j.end();++it)
               o << aut[i].get_label_name(*it) << "\\n";
            o << "\" ]" << endl;
         }
         if (!nonblock_i.empty())
         {
            o << aut[j].name << " -> " << aut[i].name << "[ dir=forw, label=\"";
            for (label_ref_set::const_iterator it=nonblock_i.begin();it!=nonblock_i.end();++it)
               o << aut[i].get_label_name(*it) << "\\n";
            o << "\" ]" << endl;
         }         
         if (!bothblocked.empty())
         {
            o << aut[i].name << " -> " << aut[j].name << "[ dir=none, label=\"";
            for (label_ref_set::const_iterator it=bothblocked.begin();it!=bothblocked.end();++it)
               o << aut[i].get_label_name(*it) << "\\n";
            o << "\" ]" << endl;
         }
         if (!rest.empty())
         {
            o << aut[i].name << " -> " << aut[j].name << "[ dir=none, style=dashed, label=\"";
            for (label_ref_set::const_iterator it=rest.begin();it!=rest.end();++it)
               o << aut[i].get_label_name(*it) << "\\n";
            o << "\" ]" << endl;
         }         o << endl;
         }
         
         // Variable dependencies
//         shared_vars=clock_ref_set(max(aut[i].dim,aut[j].dim)); // max not neccessary, because they all have the same dim, but what the heck
         if (do_cont)
         {
         j_input_vars=aut[j].input_variables;
         j_input_vars.intersection_assign(aut[i].variables);
         vnvec=aut[i].get_var_names();
         if (!j_input_vars.empty())
         {
            o << aut[i].name << " -> " << aut[j].name << "[ dir=forw, style=dotted, label=\"";
            o << "(";
            for (clock_ref_set::const_iterator it=j_input_vars.begin();it!=j_input_vars.end();++it)
            {
               if (it!=j_input_vars.begin())
                  o << ",";
               o << vnvec.get_name(*it);
            }
            o << ")";
            o << "\" ]" << endl;
         }         
         o << endl;
         i_input_vars=aut[i].input_variables;
         i_input_vars.intersection_assign(aut[j].variables);
         vnvec=aut[j].get_var_names();
         if (!i_input_vars.empty())
         {
            o << aut[j].name << " -> " << aut[i].name << "[ dir=forw, style=dotted, label=\"";
            o << "(";
            for (clock_ref_set::const_iterator it=i_input_vars.begin();it!=i_input_vars.end();++it)
            {
               if (it!=i_input_vars.begin())
                  o << ",";
               o << vnvec.get_name(*it);
            }
            o << ")";
            o << "\" ]" << endl;
         }         
         }
         o << endl;
      }
   }
   
   // postamble
   o << "}" << endl;   
}
