/***************************************************************************
                          automaton_reach.cpp  -  description
                             -------------------
    begin                : Tue Jun 8 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "automaton.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

	
void 
automaton::clear_priority(symb_state_maplist& states)
{
	// clear any priority information in all the locations
	for (vector<location>::iterator it=locations.begin();it!=locations.end();++it)
		it->priority=-1; // color white
}
	
void 
automaton::assign_priority(symb_state_maplist& states, const location_ref& loc, int& time, bool reachable_only)
{
	// assign priority to the location loc, based on what is reachable in states
	locations[loc].priority=0; // color gray
	if (time < INT_MAX)
		++time;
	location_ref tloc;
//	clock_val_set cvs;
	for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
	{
		tloc=transitions[*i].target_loc();
		if (true || transitions[*i].label==REFINEMENT_LABEL) // only prioritize locations that are reachable by refinement transitions
		{
//			if (locations[tloc].is_fully_refined && locations[tloc].priority<0 && (!reachable_only || !states.is_empty(tloc))) // it is white
			if (locations[tloc].priority<0 && (!reachable_only || !states.is_empty(tloc))) // it is white
			{
				// don't sort locations that are already fully reachable
	//			if (!states.is_empty(tloc))
	//				cvs=states.get_clock_val_set(tloc);
	//			if (states.is_empty(tloc) || !cvs.contains(locations[tloc].invariant()))
					assign_priority(states,tloc,time,reachable_only);
	//			else
	//				locations[tloc].priority=0;
			};
		}
		else  
		{
			if (locations[tloc].priority<0 && (!reachable_only || !states.is_empty(tloc))) // it is white
			{
//					forget_time=INT_MAX;
//					locations[tloc].priority=INT_MAX;
//time-=1000;
					assign_priority(states,tloc,time,reachable_only);
//time+=1000;
			};
		};
	};
	if (time < INT_MAX)
		++time;
	locations[loc].priority=time;
}
	
void 
automaton::assign_priority(symb_state_maplist& states, const symb_state_plist& new_states, bool reachable_only)
{
	clear_priority(states);
	int time=0;
	for (symb_state_plist::const_iterator it=new_states.begin();it!=new_states.end();++it)
	{
		if (locations[(*it)->loc].priority<0)
			assign_priority(states,(*it)->loc,time,reachable_only);
	};
}
	
bool 
automaton::get_strongly_connected_locs(symb_state_maplist& states, location_ref& loc, int hor, loc_ref_set& lrs)
{ // adds the strongly connected successors of loc to lrs,
  // i.e., the states that are reachable by hor transitions.
	
	bool found_new=false;
	loc_ref_set lrs2;
	if (hor>0)
	{
		location_ref tloc;
		for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
		{
			tloc=transitions[*i].target_loc();
			if (lrs.find(tloc)==lrs.end())
			{
				lrs2.clear();
//				get_post_locs(states,tloc,1,lrs2);  // for strictly strongly connected
				get_post_locs(states,tloc,hor,lrs2,true);
				if (lrs2.find(loc)!=lrs2.end() && !states.is_empty(tloc))
				{
					lrs.insert(tloc);
					if (hor>1)
						get_strongly_connected_locs(states,tloc,hor-1,lrs);
				};
				found_new=true;
			};
		};
	};
	return found_new;
}

void 
automaton::add_post_locs(symb_state_maplist& states, int hor, loc_ref_set& lrs, bool reachable_only)
{ // adds the discrete successors of loc to lrs,
  // i.e., the states that are reachable by hor transitions.
	
	if (hor>0)
	{
		location_ref loc,tloc;
		for (loc_ref_set::const_iterator j=lrs.begin();j!=lrs.end();++j)
		{
			loc =*j;
			for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
			{
				tloc=transitions[*i].target_loc();
				if (lrs.find(tloc)==lrs.end() && (!reachable_only || !states.is_empty(tloc)))
				{
					lrs.insert(tloc);
				};
			};
		};
		if (hor>1)
			add_post_locs(states,hor-1,lrs, reachable_only);
	};
}

void 
automaton::get_post_locs(symb_state_maplist& states, location_ref& loc, int hor, loc_ref_set& lrs, bool reachable_only)
{ // adds the discrete successors of loc to lrs,
  // i.e., the states that are reachable by hor transitions.
	
	if (hor>0)
	{
		location_ref tloc;
		for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
		{
			tloc=transitions[*i].target_loc();
			if (lrs.find(tloc)==lrs.end() && (!reachable_only || !states.is_empty(tloc)))
			{
				lrs.insert(tloc);
				if (hor>1)
					get_post_locs(states,tloc,hor-1,lrs,reachable_only);
			};
		};
	};
}

void 
automaton::get_pre_locs(symb_state_maplist& states, location_ref& loc, int hor, loc_ref_set& lrs, bool reachable_only)
{ // adds the discrete successors of loc to lrs,
  // i.e., the states that are reachable by hor transitions.
	
	if (hor>0)
	{
		location_ref tloc;
		for (trans_ref_set::const_iterator i=locations[loc].in_trans.begin();i!=locations[loc].in_trans.end();++i)
		{
			tloc=transitions[*i].source_loc();
			if (lrs.find(tloc)==lrs.end() && (!reachable_only || !states.is_empty(tloc)))
			{
				lrs.insert(tloc);
				if (hor>1)
					get_pre_locs(states,tloc,hor-1,lrs,reachable_only);
			};
		};
	};
}

double
automaton::get_active_post_loc_ratio(symb_state_maplist& states, location_ref& loc, int hor, const symb_state_plist& new_states)
{
	// find ratio of successor locations of loc over the horizon hor that are also included in new_states
	
	// get successors
	loc_ref_set post_locs;
	get_post_locs(states,loc,hor,post_locs); 
	
	if (post_locs.size()==0) return 1;
	
	// find active ones
	bool found;
	symb_state_plist::const_iterator it=new_states.begin();
	int found_count(0);
	for (loc_ref_set::const_iterator loc_it=post_locs.begin();loc_it!=post_locs.end();++loc_it)
	{
		found=false;
		it=new_states.begin();
		while (!found && it!=new_states.end())
		{
			if ((*it)->loc == *loc_it)
			{
				found=true;
				++found_count;				
			};
			++it;
		};	
	};
//cout << found_count << "/" << pre_locs.size() << ".";
	return (double)found_count/(double)post_locs.size();
}

double
automaton::get_active_pre_loc_ratio(symb_state_maplist& states, location_ref& loc, int hor, const symb_state_plist& new_states)
{
	// find ratio of predecessor locations of loc over the horizon hor that are also included in new_states
	
	// get predecessors
	loc_ref_set pre_locs;
	get_pre_locs(states,loc,hor,pre_locs); 
	
	if (pre_locs.size()==0) return 1;
	
	// find active ones
	bool found;
	symb_state_plist::const_iterator it=new_states.begin();
	int found_count(0);
	for (loc_ref_set::const_iterator loc_it=pre_locs.begin();loc_it!=pre_locs.end();++loc_it)
	{
		found=false;
		it=new_states.begin();
		while (!found && it!=new_states.end())
		{
			if ((*it)->loc == *loc_it)
			{
				found=true;
				++found_count;				
			};
			++it;
		};	
	};
//cout << found_count << "/" << pre_locs.size() << ".";
	return (double)found_count/(double)pre_locs.size();
}

double
automaton::loc_distance(symb_state_maplist& states, location_ref& source_loc, location_ref& target_loc)
{
	int max_hor=20;
	double max_dist=1000;
	loc_ref_set post_locs;
	
	post_locs.insert(source_loc);
	for (int i=1;i<=max_hor;++i)
	{
		add_post_locs(states,1,post_locs,false);
//		if (get_strongly_connected_locs(states,source_loc,i,post_locs)) // returns true if found new ones
//		{
			if (post_locs.find(target_loc)!=post_locs.end())
				return (double)i;
//		}
//		else
//			return max_dist;
	};
	return max_dist;
}

symb_state_maplist::iterator 
automaton::pop_maplist_iter(symb_state_maplist& states, symb_state_plist& new_states, location_ref& last_loc)
{
	symb_state_maplist::iterator it=*new_states.begin();
	
	if (SEARCH_METHOD==2 && new_states.size()>1) 
	{
		// find the one with the lowest predecessor ratio

		int hor=2; // search horizon
		int hor_connected=2; // horizon over which to look for strongly connected states
		
		double dist_scale=10;
			
		double min_rat=1e10; // just anything larger than what the cost function could be
		double check_rat=0; // doesn't matter
		double check_postrat=2.0;
		
		// get strongly connected locations to last_loc
		loc_ref_set last_loc_set;
		get_strongly_connected_locs(states,last_loc,hor_connected,last_loc_set);
		
		symb_state_plist::iterator min_it=new_states.begin();
		for (symb_state_plist::iterator j=new_states.begin();j!=new_states.end();++j)
		{
// cout << get_active_pre_loc_ratio((*it)->loc,hor,new_states) << endl;
//			check_rat=get_active_pre_loc_ratio((*j)->loc,hor,new_states);
			check_postrat=get_active_post_loc_ratio(states,(*j)->loc,hor,new_states);
//			check_rat=get_active_pre_loc_ratio((*j)->loc,hor,new_states)-check_postrat/100;
			if (check_postrat>0)
				check_rat=get_active_pre_loc_ratio(states,(*j)->loc,hor,new_states)/check_postrat;
			else
			{
				check_rat=1; //5-get_active_pre_loc_ratio((*j)->loc,hor+1,new_states);
			};
			if (last_loc_set.find((*j)->loc)!=last_loc_set.end())
				check_rat+=dist_scale*loc_distance(states,last_loc,(*j)->loc); //*log(loc_distance(last_loc,(*j)->loc)*1000+0.1);
			else
				check_rat+=dist_scale*2*hor_connected;
//cout << check_rat << "(" << get_active_pre_loc_ratio(states,(*j)->loc,hor,new_states) << ")" << ",";		
			if (check_rat < min_rat)
			{
				min_rat=check_rat;
				min_it=j;
			};
		};
//cout << ":" << min_rat << endl;		
  
//     // Block overapproximation in strongly connected pieces --> doesn't work in practise
// 		if (loc_distance(states,last_loc,(*min_it)->loc)<1000) // if strongly connected
// 			BLOCK_OVERAPPROXIMATION=true;
// 		else
// 			BLOCK_OVERAPPROXIMATION=false;
		it=*min_it;
		new_states.erase(min_it);
		return it;
	}
	else if (SEARCH_METHOD==5 && new_states.size()>1) 
	{
		// find the one with the least predecessors in the waiting list

		int hor=3; // search horizon

		double min_rat=1e10;		
		double check_rat=min_rat;
		
		symb_state_plist::iterator min_it=new_states.begin();
		loc_ref_set lrs;
		for (symb_state_plist::iterator j=new_states.begin();j!=new_states.end() && min_rat>0;++j)
		{
			lrs.clear();
			get_pre_locs(states, (*j)->loc, hor, lrs, true);
			check_rat=lrs.size();
			
			if (check_rat < min_rat)
			{
				min_rat=check_rat;
				min_it=j;
			};
		};
//cout << ":" << min_rat << endl;		
  
//     // Block overapproximation in strongly connected pieces --> doesn't work in practise
// 		if (loc_distance(states,last_loc,(*min_it)->loc)<1000) // if strongly connected
// 			BLOCK_OVERAPPROXIMATION=true;
// 		else
// 			BLOCK_OVERAPPROXIMATION=false;
		it=*min_it;
		new_states.erase(min_it);
		return it;
	}	
	else if (SEARCH_METHOD==6 && new_states.size()>1) 
	{
		// find the one with the highest priority according to a topological sort 
		clear_priority(states); // clear them first
//		assign_priority(states,new_states,false); // assign the priorities
		
		// add ini_states
		int time=0; // 100000000
//		for (symb_states_type::const_iterator sit=ini_states.begin();sit!=ini_states.end();++sit)
//		{
//			locations[sit->first].priority=0; // assign the priorities
//		};
		for (symb_states_type::const_iterator sit=ini_states.begin();sit!=ini_states.end();++sit)
		{
			if (locations[sit->first].priority<=0)
				assign_priority(states,sit->first,time,false); // assign the priorities
		};
		
		int max_prio=-INT_MAX; // start with sth lower than the minimum
		
		symb_state_plist::iterator max_it=new_states.begin();
		for (symb_state_plist::iterator j=new_states.begin();j!=new_states.end();++j)
		{
			if (locations[(*j)->loc].priority > max_prio && locations[(*j)->loc].priority < INT_MAX)
			{
				max_prio=locations[(*j)->loc].priority;
				max_it=j;
			};
		};
//cout << ":" << max_prio << endl;		
  
//     // Block overapproximation in strongly connected pieces --> doesn't work in practise
// 		if (loc_distance(states,last_loc,(*min_it)->loc)<1000) // if strongly connected
// 			BLOCK_OVERAPPROXIMATION=true;
// 		else
// 			BLOCK_OVERAPPROXIMATION=false;
//cout << max_prio << ";";
		it=*max_it;
		new_states.erase(max_it);
		return it;
	}	
	else if (SEARCH_METHOD==7 && new_states.size()>1) 
	{
		// find the one with the highest priority according to a topological sort 
		clear_priority(states); // clear them first
		assign_priority(states,new_states,true); // assign the priorities
		
		int max_prio=-2; // start with sth lower than the minimum
		
		symb_state_plist::iterator max_it=new_states.begin();
		for (symb_state_plist::iterator j=new_states.begin();j!=new_states.end();++j)
		{
			if (locations[(*j)->loc].priority > max_prio && locations[(*j)->loc].priority < INT_MAX)
			{
				max_prio=locations[(*j)->loc].priority;
				max_it=j;
			};
		};
//cout << ":" << max_prio << endl;		
  
//cout << max_prio << ";";
		it=*max_it;
		new_states.erase(max_it);
		return it;
	}	
	else
	{
		new_states.pop_front();
		return it;
	};
}

void
automaton::insert_maplist_iter(symb_state_maplist& states, symb_state_plist& new_states, const symb_state_maplist::iterator& new_iter)
{
	if (new_iter!=states.end() && new_states.find(new_iter)==new_states.end())
	{
		if (SEARCH_METHOD==1 && new_states.size()>0) // check horizon of length SEARCH_METHOD
		{
// good for a while			int hor1 = locations.size()/10; //SEARCH_METHOD; // horizon of comparison
// not so good			int hor1 = new_states.size()+2; //SEARCH_METHOD; // horizon of comparison
		  int hor1 = locations.size()/20; //SEARCH_METHOD; // horizon of comparison   
			int hor2 = 2; // these successors must be contained
			
			loc_ref_set post_locs,pl2;
			get_post_locs(states,new_iter->loc,hor1,post_locs); // get the post locs in the horizon
						
			// put before at the last state that is contained in post_locs
			symb_state_plist::iterator it=new_states.end();
			--it;
			while (it!=new_states.begin() && post_locs.find((*it)->loc)!=post_locs.end())
			{
				--it;
			};
			
			
//			symb_state_plist::iterator it=new_states.begin();
//			while (it!=new_states.begin() && post_locs.find((*it)->loc)==post_locs.end())
//       pl2.clear();
// 			get_post_locs(states,(*it)->loc,hor2,pl2);
// 			while (it!=new_states.end() && !includes(post_locs.begin(),post_locs.end(),pl2.begin(),pl2.end()))
// 			{
// 				++it;
// 				pl2.clear();
// 				get_post_locs(states,(*it)->loc,hor2,pl2);
// 			};
			
// 			// put before at the last state that is contained in post_locs
// 			symb_state_plist::iterator it=new_states.end();
// 			--it; // point to the last element
// //			while (it!=new_states.begin() && post_locs.find((*it)->loc)==post_locs.end())
//       pl2.clear();
// 			get_post_locs((*it)->loc,hor2,pl2);
// 			while (it!=new_states.begin() && includes(post_locs.begin(),post_locs.end(),pl2.begin(),pl2.end()))
// 			{
// 				--it;
// 				pl2.clear();
// 				get_post_locs((*it)->loc,hor2,pl2);
// 			};
// 			// insert puts the element BEFORE the iterator, therefore add one to it
// 			// except if it pointed to the first element, and it is also a post state
// //			if (it==new_states.begin() && post_locs.find((*it)->loc)==post_locs.end())
// 			if (it==new_states.begin() && includes(post_locs.begin(),post_locs.end(),pl2.begin(),pl2.end()))
// 			{} // do nothing
// 			else
// 				++it; // move so that new_iter is inserted aftger it
			new_states.insert(it,new_iter);        // it has expanded, so it's a new state
		}
		else if (SEARCH_METHOD==2 && new_states.size()>0) // predecessor ratio
		{
			// prioritize ratio of predecessors in waiting list
/*			int hor=2; // search horizon
			
//cout << get_active_pre_loc_ratio(new_iter->loc,hor,new_states) <<"!"; 			
			double new_rat=get_active_pre_loc_ratio(new_iter->loc,hor,new_states);
cout << "checking: " << new_rat << endl;			
			symb_state_plist::iterator it=new_states.end();
			--it;
cout << get_active_pre_loc_ratio((*it)->loc,hor,new_states) << endl;
			while (it!=new_states.begin() && get_active_pre_loc_ratio((*it)->loc,hor,new_states)>new_rat)
			{
cout << get_active_pre_loc_ratio((*it)->loc,hor,new_states) << endl;
				--it;
			};
			new_states.insert(it,new_iter);        // it has expanded, so it's a new state*/
			new_states.push_back(new_iter);        // it has expanded, so it's a new state
		}
		else if (SEARCH_METHOD==3) // depth first
		{
			new_states.push_front(new_iter);        // it has expanded, so it's a new state
		}
		else // breadth first
		{
			new_states.push_back(new_iter);        // it has expanded, so it's a new state
		};
	};
}

void
automaton::simplify_successor(location_ref& loc, clock_val_set& cvs)
{
	bool changed=false;
	bool changed_now=false;
	
	if (!BLOCK_OVERAPPROXIMATION)
	{
		if (REACH_USE_BBOX)
		{
			clock_val_set cvs2(dim);
			cvs.ccvs_shrink_bounding_box(cvs2);
			cvs=cvs2;
			changed=true;
		}
		else if (REACH_CONSTRAINT_LIMIT>0)
		{
	//		changed_now=cvs.limit_constraints(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
	if (!USE_CONVEX_HULL)		
	changed_now=cvs.limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
			changed = changed || changed_now;
		};
	
	// todo: use invariant information to limit bits only for those constraints
		//       that are not in the invariant
		// for now:
		//       limit all constraints
		
		if (CONSTRAINT_BITSIZE>0 && REACH_CONSTRAINT_LIMIT<=0) // don't do this if constraints have been limited
		{
	if (!USE_CONVEX_HULL)		
	changed_now=cvs.limit_significant_bits(CONSTRAINT_BITSIZE);
			changed = changed || changed_now;
		};
		
		if (changed)
		{
			cvs.intersection_assign(locations[loc].invariant());
		};
	};
	
}

void
automaton::time_post_assign_convex(location_ref& loc, clock_val_set& cvs)
{
  // succ operator - part that's independent of transition
	
  if (TIME_POST_ITER <=0)
	{
		
      // todo: this is just temp, until nonlinear derivatives are included properly in the location
      if (REFINE_USE_FP && !locations[loc].is_time_post_poly_uptodate())
      {
         convex_clock_val_set ccvs(get_loc_deriv(*this,loc));
         if (reversed) ccvs.pointmirror_assign();
   //cout << "tp: " << ccvs << endl;	
         bool changed=false;
         changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
         if (!changed)
            ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
         locations[loc].time_post_poly_assign(ccvs);
      };
   
      if (REFINE_DERIVATIVE_METHOD != 4) // not cone fixpoint
      { 
         cvs.time_elapse_assign(locations[loc].time_post_poly());
         cvs.intersection_assign(locations[loc].invariant());
      }
   
      if (REFINE_DERIVATIVE_METHOD == 4) // cone fixpoint
      {
         // save normal tp for later
         convex_clock_val_set ccvs,ccvs2,p_old,p_new,p_static;
         clock_val_set inv_cvs;
         unsigned count(TIME_POST_CONE_ITER);      
         TNT::Array2D<Integer> A(dim,dim);
         TNT::Array1D<Integer> b(dim),den(dim);
         locations[loc].get_linear_system_matrices(A, b, den);
//cout << "System matrices: " << A << ";" << b << ";" << den << "." << endl;         
         
         for (list<convex_clock_val_set>::iterator it=cvs.ccvs_list.begin();it!=cvs.ccvs_list.end();++it)
         {
            // get static time elapse
            p_static=*it;
            p_static.time_elapse_assign(locations[loc].time_post_poly());
            // get the convex part inside the invariant
            if (locations[loc].invariant().ccvs_list.size()>1)
            {
               inv_cvs=clock_val_set(p_static);
               inv_cvs.intersection_assign(locations[loc].invariant());
               inv_cvs.convex_hull_assign();
               p_static=*inv_cvs.ccvs_list.begin();
            }
            else
               p_static.intersection_assign(*locations[loc].invariant().ccvs_list.begin());
                        
            count=TIME_POST_CONE_ITER;      
            
            p_new=*it;
            p_old=convex_clock_val_set(dim,Parma_Polyhedra_Library::EMPTY);
            while (!p_old.contains(p_new))
            {
               p_old=p_new;
               ccvs=get_cone(p_new);
//cout << "cone: " << ccvs << endl;
               ccvs2=map_cone(ccvs,A,b,den,TIME_POST_LAMBDA);
//cout << "mapped cone: " << ccvs2 << endl;               
               ccvs.intersection_assign(ccvs2);
               p_new=get_poly_from_cone(ccvs);
//cout << "poly        : " << p_new << endl;
               p_new.BHRZ03_widening_assign(p_old,&count);
//cout << "poly widened: " << p_new << endl;
//cout << "poly widened: " << p_new.constraint_size() << " con, bits: " << p_new.max_bit_size() << endl;
//cout << REACH_BITSIZE_TRIGGER << "," << CONSTRAINT_BITSIZE;
if (REACH_BITSIZE_TRIGGER>0 && p_new.max_bit_size()>REACH_BITSIZE_TRIGGER)
{
   p_new.limit_constraints(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
//cout << "poly limited: " << p_new << endl;
//cout << "poly limited:" << p_new.is_bounded() << p_new.constraint_size() << " con, bits: " << p_new.max_bit_size() << endl;
}
               p_new.intersection_assign(p_static);
//cout << "poly interse: " << p_new << endl;
//cout << "poly interse: " << p_new.constraint_size() << " con, bits: " << p_new.max_bit_size() << endl;
            }
            swap(*it,p_new);
         }
      }
      

	}
	else
	{
//void
//automaton::time_post_assign_convex(location_ref& loc, clock_val_set& cvs)
//{
  // succ operator - part that's independent of transition
	// this version restricts the variable time part to the reachable set in time_iter iterations.
	// experiments showed hardly any improvements, so it's scrapped for now
	
//	unsigned int time_iter=2;
	
	unsigned int iter=0;
	
	bool changed=false;
	
	clock_val_set restr(locations[loc].invariant());
	clock_val_set rcvs(dim);
	convex_clock_val_set ccvs(dim);	

	// do the first iteration as usual
	if (REFINE_USE_FP && !locations[loc].is_time_post_poly_uptodate())
	{
		convex_clock_val_set ccvs(get_loc_deriv(*this,loc));
		if (reversed) ccvs.pointmirror_assign();
//cout << "tp: " << ccvs << endl;	
		bool changed=false;
		changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
		if (!changed)
			ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
		locations[loc].time_post_poly_assign(ccvs);
	};
	
	rcvs=cvs;
	//	rcvs.time_elapse_assign(locations[loc].time_post_poly_starting_from(cvs));
	rcvs.time_elapse_assign(locations[loc].time_post_poly());
	restr.intersection_assign_from(rcvs,locations[loc].invariant());
	
	++iter;
			
	while ((int)iter<TIME_POST_ITER)
	{
		++iter;
		// todo: this is just temp, until nonlinear derivatives are included properly in the location
		if (REFINE_USE_FP)
		{
			ccvs=get_loc_deriv(*this,loc,restr);
			if (reversed) ccvs.pointmirror_assign();
		}
		else
			ccvs=locations[loc].time_post_poly(restr);

		changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
		if (!changed)
			ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
						
		rcvs=cvs;
		rcvs.time_elapse_assign(ccvs);
		restr.intersection_assign_from(rcvs,locations[loc].invariant());
	};
	
	cvs.swap(restr);
	};
}

void
automaton::time_post_assign(clock_val_set& w, const clock_val_set& inv, const time_elapse_poly& tp)
{

  clock_val_set Eold(w.dim,EMPTY),E(w.dim,EMPTY);
  clock_val_set cvs2,Efaces;
  list<convex_clock_val_set>::const_iterator j;

  // prime with intersection
  for (j = inv.ccvs_list.begin(); j != inv.ccvs_list.end(); ++j)
  {

    cvs2=w;
    cvs2.time_elapse_assign(tp,clock_val_set(*j));
    E.union_assign(cvs2);
  };

//cout << "Init with:" << endl;
//E.print();

  while (!Eold.contains(E))
  {
    Eold=E;
//        Efaces=time_relevant_faces(E,tp);
    for (j = inv.ccvs_list.begin(); j != inv.ccvs_list.end(); ++j)
    {
      cvs2=cvs_adj_faces(*j,Eold);  // used Eold because don't want to change E here, so use old one
//cout << "Adjacent faces" << endl << flush;
//cvs2.print();
      cvs2.time_elapse_assign(tp);
//cout << "elapsed" << endl << flush;
//cvs2.print();
      cvs2.intersection_assign(clock_val_set(*j));
      cvs2.simplify();
//cout << "intersected" << endl << flush;
//cvs2.print();
      E.union_assign(cvs2);
    };
  };
  E.simplify();

  w=E;
}

void
automaton::time_post_assign(location_ref& loc, clock_val_set& cvs)
{
//	stopwatch sw(2048000,"time_post_assign");
// cout << "Before time post: " << cvs << endl;
// cout << loc << ":" << locations[loc].time_post_poly() << endl;
  if (locations[loc].invariant().size()<=1)
	{
     time_post_assign_convex(loc,cvs);
	}
  else
  {
throw_error("deprecated syntax, please use convex invariants");  
    time_post_assign(cvs,locations[loc].invariant(),locations[loc].time_post_poly());
  };
//  cout << "after time post: " << cvs << endl;	
//if (DEBUG_OUTPUT>1 && sw.value() > 0.1) 
//  cout << endl << "Exceeding time in time_post_assign, took " << sw.value() << " for " << cvs.size() << " polyhedra" << endl << flush; 

}

void
automaton::time_post_assign(symb_state_maplist& states, symb_state_plist& check_states)
{
  // returns the post states that are not already contained in states
	location_ref loc;
//      clock_val_set cvs;
  clock_val_set newcvs;

	symb_state_plist new_states;
  list< symb_state >::iterator state_it;
	list<symb_state>::iterator new_iter;
  while (!check_states.empty())
  {
    state_it=*check_states.begin();
		check_states.pop_front();
		
    loc=state_it->loc;
//        cvs=state_it->second;

    newcvs=*state_it;
    time_post_assign(loc,newcvs);
		if (!USE_CONVEX_HULL)
			new_iter = states.add(loc,newcvs);
		else
			new_iter = states.convex_hull_add(loc,newcvs);
		// only add to newstates if it's not already on it!
    insert_maplist_iter(states,new_states,new_iter);
  }; // end while
	
	// copy new states to output
	check_states.swap(new_states);
	//check_states=new_states;
}

symb_states_type
automaton::trans_and_time_post(const symb_states_type& states)

{
  // returns all post states of "states", reachable by taking a transition and letting time elapse

  location_ref loc,tloc;
  clock_val_set cvs,newcvs;
  symb_states_type post_states;
  trans_ref_set::iterator k;

  for (symb_states_type::const_iterator state_it=states.begin();state_it!=states.end();++state_it)
  {
    loc=state_it->first;
    cvs=state_it->second;

    for (k=locations[loc].out_trans.begin();k!=locations[loc].out_trans.end();k++)
    {
      tloc=transitions[*k].target_loc();


      // succ operator - part that depends on transition
      newcvs=cvs;
      newcvs.add_space_dimensions_and_embed(dim); // make room for u', is u,u'
      newcvs.intersection_assign(get_restricted_mu(*k));
      newcvs.remove_space_dimensions(0,dim-1); // remove u

      if (!newcvs.is_empty())
      {
if (DEBUG_OUTPUT>0) {
cout << "after clock reset:";
newcvs.print();
};

        time_post_assign(tloc,newcvs);
        post_states.add(tloc,newcvs);
      }; // end if
    }; // end for
  }; // end for
  return post_states;
}

void
automaton::trans_and_time_post_assign(symb_state_maplist& states, symb_state_plist& check_states, symb_states_type& f_states, bool& f_states_reachable, label_ref_set dontchecklabs, bool checktime)
{
//REFINE_PARTITION_LEVEL_MAX=1;
if (REFINE_PARTITION_INSIDE)
set_surface_flag(false);
  // returns the post states that are not already contained in states
	stopwatch sw(10000000,"trans_and_time_post_assign"); // this is never officially used
	symb_state_plist new_states;
	if (!check_states.empty())
	{				
  location_ref loc,tloc;
//      clock_val_set cvs;
  clock_val_set newcvs,newcvs2,newcvs3;
  bool check_all_labels=dontchecklabs.empty();
	transition_ref tr;
	trans_ref_set tr_checked;
	loc_ref_set succ_locs;
	loc_ref_set lrs;

  list< symb_state >::iterator state_it;
	bool was_refined(false);
	
  symb_state_maplist::iterator new_iter;	
	
	int iter_count=0;
	bool changed=false;
	
	bool add_to_new=(SEARCH_METHOD<1); // add to new_states if anything but horizon search
	location_ref last_loc((*check_states.begin())->loc);
	
	string movie_filename="out_mov";
	bool part_ok=false;
	
bool temp_flag=USE_CONVEX_HULL;	

// gf,060306
      loc_ref_set scl_lrs;	
      
      // determine whether to check for intersection with forbidden states
      bool check_for_forbidden=!f_states.is_empty();
      f_states_reachable=f_states_reachable && false;

  while (!check_states.empty() && (add_to_new || REACH_MAX_ITER==0 || GLOBAL_ITER_COUNT < REACH_MAX_ITER) && (!check_for_forbidden || !f_states_reachable))
  {
		++iter_count;
		++GLOBAL_ITER_COUNT;
/*    state_it=*check_states.begin();
		check_states.pop_front();*/
    state_it=pop_maplist_iter(states,check_states,last_loc);

    loc=state_it->loc;
//cout << loc << *state_it << endl;    
		last_loc=loc;
		part_ok=check_partitioning(states,state_it,check_states, loc, iter_count, checktime);

		++locations[loc].nr_checks;
		//		cout << loc << ":" << locations[loc].nr_checks << ",";
		
		if (!part_ok)
		  {
		    //  insert_maplist_iter(states,check_states,new_iter);
		  }
else
		{
		
if (temp_flag)
{										
										if (!BLOCK_OVERAPPROXIMATION)
											if ((REACH_BITSIZE_TRIGGER <= 0 || REACH_CONSTRAINT_TRIGGER <= 0) || state_it->max_bit_size() > REACH_BITSIZE_TRIGGER || state_it->max_constraint_size() > REACH_CONSTRAINT_TRIGGER)
											{
												changed=state_it->limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE) || changed;
											};
										if (changed || USE_CONSTRAINT_HULL)
											state_it->intersection_assign(locations[loc].invariant());
										
										// For convex hull, do time elapse in the location after convex hull operation
										if (checktime && ELAPSE_TIME && !USE_CONSTRAINT_HULL)
											time_post_assign(loc,*state_it);


};											
		
/*// gf, 051026
state_it->print_gen_fp_raw(cout);
// sleep(0.1);
 cout << flush;		*/
 
 // check for intersection with forbidden states
      if (check_for_forbidden)
         if (f_states.is_intersecting(locations[state_it->loc].name,(clock_val_set)(*state_it)))
            f_states_reachable=true;
 
		
//        cvs=state_it->second;
		tr_checked.clear();
		while (!tr_checked.contains(locations[loc].out_trans))  // can't simply iterate through out_trans because they can change through refinement splitting
    {
			// reserve this transition as not removable
			tr=tr_checked.non_contained_element(locations[loc].out_trans);
			tr_checked.insert(tr);
//cout << "loc " << loc << " trans_checked " << tr_checked << endl;
//			DONT_REMOVE_TRANS.insert(tr);
			
      if (check_all_labels || !dontchecklabs.contains(transitions[tr].label))
      {
        tloc=transitions[tr].target_loc();

        // succ operator - part that depends on transition
        newcvs=*state_it;
				if (transitions[tr].is_ident())
				{
//cout << "is_ident" << endl;				
					newcvs.intersection_assign(transitions[tr].exit_set(locations[transitions[tr].source_loc()].invariant(),locations[transitions[tr].target_loc()].invariant()));					
				}
				else
				{
//cout << "not_ident" << endl;				
					newcvs.add_space_dimensions_and_embed(dim); // make room for u', is u,u'
					newcvs.intersection_assign(get_restricted_mu(tr));
					newcvs.remove_space_dimensions(0,dim-1); // remove u
				};
        if (!newcvs.is_empty())
        {
					simplify_successor(tloc,newcvs); // doesn't do anything if convex hull is on
// to do: should be after refinement!!! (only relevant if not convex hull)

//cout << newcvs;
					
					// Refine location
					succ_locs.clear();
					was_refined=refine_location_otf(*this,tloc,newcvs,states,check_states,new_states,succ_locs,USE_CONVEX_HULL); 
//					succ_locs.insert(tloc);
/*cout << "Check" << endl << flush;
check_states.print();
cout << "New" << endl << flush;
new_states.print();
cout << "States" << endl << flush;
states.print();*/

// gf, 060306
// add time elapse of strongly connected locs
  if (false)
    {
      scl_lrs.clear();
      get_strongly_connected_locs(states,loc,1,scl_lrs);
    }

					
					for (loc_ref_set::const_iterator i=succ_locs.begin(); i!=succ_locs.end(); ++i)
					{
						tloc=*i;
//cout << "orig: " << newcvs << endl;				
						if (was_refined)
							newcvs2.intersection_assign_from(newcvs,locations[tloc].invariant());
						else
							newcvs2=newcvs;
							
						if (!newcvs2.is_empty())
						{
if (DEBUG_OUTPUT>1)
  cout << "'" << flush;

// gf, 060306
 if (false)
   {
     // if bidirectly connected, apply time elapse and propagate back to here
     if (scl_lrs.find(tloc)!=scl_lrs.end() && USE_CONVEX_HULL)
       {
	 cout << "@";
	 newcvs3=newcvs2;
	 time_post_assign(tloc,newcvs3);
	 // todo: apply transition properly
	 newcvs3.intersection_assign(transitions[tr].exit_set(locations[transitions[tr].source_loc()].invariant(),locations[transitions[tr].target_loc()].invariant()));					
	 states.convex_hull_add(loc,newcvs3);
       }
   }


						
							if (checktime && ELAPSE_TIME && (!USE_CONVEX_HULL || USE_CONSTRAINT_HULL))
								time_post_assign(tloc,newcvs2);
// cout << "after: " << tloc << ":" << newcvs << endl;											
	
							if (!REACH_ONLY_EXPLORE)
							{
								if (!USE_CONVEX_HULL)
								{
									if (!BLOCK_OVERAPPROXIMATION)
										newcvs2.limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
									newcvs2.intersection_assign(locations[tloc].invariant());
									
									new_iter = states.add(tloc,newcvs2);
								}
								else
								{
									new_iter = states.convex_hull_add(tloc,newcvs2);
											
									if (new_iter != states.end())
									{
										// simplify again
										// Note: in convex hull, there is only one iterator per location
										changed=false;
/*										if ((REACH_BITSIZE_TRIGGER <= 0) || new_iter->max_bit_size() > REACH_BITSIZE_TRIGGER)
										{
											changed=new_iter->limit_constraints_and_bits(0,CONSTRAINT_BITSIZE) || changed;
										};
										if ((REACH_CONSTRAINT_TRIGGER <= 0) || new_iter->max_constraint_size() > REACH_CONSTRAINT_TRIGGER)
										{
											changed=new_iter->limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,0) || changed;
										};*/
if (!temp_flag)
{										
										if (!BLOCK_OVERAPPROXIMATION)
											if ((REACH_BITSIZE_TRIGGER <= 0 || REACH_CONSTRAINT_TRIGGER <= 0) || new_iter->max_bit_size() > REACH_BITSIZE_TRIGGER || new_iter->max_constraint_size() > REACH_CONSTRAINT_TRIGGER)
											{
												changed=new_iter->limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE) || changed;
											};
										if (changed || USE_CONSTRAINT_HULL)
											new_iter->intersection_assign(locations[tloc].invariant());
										
										// For convex hull, do time elapse in the location after convex hull operation
										if (checktime && ELAPSE_TIME && !USE_CONSTRAINT_HULL)
											time_post_assign(tloc,*new_iter);
};											
									};
								};
								// add new iterator to new_states
								if (add_to_new)
									insert_maplist_iter(states,new_states,new_iter);
								else
									insert_maplist_iter(states,check_states,new_iter);
/*		if (new_iter!=states.end() && new_states.find(new_iter)==new_states.end())
		{
			new_states.push_back(new_iter);        // it has expanded, so it's a new state
		};
					*/				
							}
							else // only follow new states
								states.copy_new(tloc,newcvs2,new_states);
						};
//cout << "rest: " << newcvs << endl;											
					};
// new_states.print();					
        }; // end if
      }; // end if
			
			// clear the reservation
			// todo: should keep track of how many reservations are made before clearing 
			//       but that would seem like overkill right now.
			//       Let's consider this as atomic enough.
//			DONT_REMOVE_TRANS.erase(tr);
    }; // end for
		};
		if (SNAPSHOT_INTERVAL>0 && GLOBAL_ITER_COUNT%SNAPSHOT_INTERVAL==0)
			print_snapshot_fp_raw(states,movie_filename+"_"+int2string(1000000+GLOBAL_ITER_COUNT));		
			
		if (!add_to_new && iter_count%10==0) // we're going to stay in this loop
		{ 
		  // do some reporting
			message(128200,"Iter " + int2string(iter_count) + ": tot " + int2string(states.loc_size()) + " loc, " + int2string(states.cvs_size()) + " poly (" + int2string(check_states.size()) + " waiting) in " + double2string(sw.delta()) + " sec.");
		};
  }; // end while
	
	};
	// put the new_states back on the list
	check_states.swap(new_states);
	//check_states=new_states;
}

bool
automaton::check_partitioning(symb_state_maplist& states, list< symb_state >::iterator& state_it, symb_state_plist& check_states, const location_ref& loc, const int iter_count, bool checktime)
{
	// returns true if the everything is ok, false if location needs to be revisited
	string movie_filename="out_mov";
	

	// gf, 060306
	// partition further if number of checks is too high
        if (REFINE_MAX_CHECKS>0 && locations[loc].nr_checks>REFINE_MAX_CHECKS)
	  {
	    locations[loc].nr_checks=0;
	symb_state_plist dum;
        loc_ref_set dum_lrs;
        clock_val_set cvs(dim);
	REFINE_FORCE_SPLITTING=true;
	// we already took this off the waiting list, so put it back on
	insert_maplist_iter(states,check_states,state_it);
	refine_location_otf(*this,loc,cvs,states,check_states,dum,dum_lrs,USE_CONVEX_HULL); 
	REFINE_FORCE_SPLITTING=false;
	return false;
	  }


//if (!locations[loc].is_fully_refined && !locations[loc].is_surface)		// only check if not surface
if (REFINE_PARTITION_INSIDE)
{
		loc_ref_set lrs;
		symb_state_maplist::iterator new_iter;	

// for now: check surface of all					
		location_is_surface(loc,states);
		// check if loc is still in post of waiting list
		lrs.clear();
		// put the states of the waiting list in lrs
		for (symb_state_plist::const_iterator it=check_states.begin();it!=check_states.end();++it)
			lrs.insert((*it)->loc);
		add_post_locs(states,1,lrs,true);
		//get_post_locs(states,loc,1,lrs,true);
		if (lrs.find(loc)==lrs.end())
		{
		// if not, check if surface and not yet fully refined
//cout << "test3: ended, ref?" << locations[loc].is_fully_refined << ", surf?" << location_is_surface(loc,states) << endl << flush;		
//cout << "test3: ended, ref?" << locations[loc].is_fully_refined << ", surf?" << location_is_surface(loc,states) << endl << flush;		
			if (!locations[loc].is_fully_refined && locations[loc].is_surface)
			{
				// set REFINE_MAX_PARTITION_LEVEL to level of current location and restart
//				REFINE_PARTITION_LEVEL_MAX=locations[loc].partition_level+REFINE_PARTITION_LEVEL_DELTA;
//				++count_ref;
//print_snapshot_fp_raw(states,movie_filename+"_"+int2string(1000000+iter_count));		
//cout << "test5:" << REFINE_PARTITION_LEVEL_MAX << endl << flush;
				//reach_init(ini_states, states, check_states, checktime);
				
				// clear l and put predecessors back on waiting list
				if (ini_states.find(loc)!=ini_states.end())
				{
/*					states.assign_empty(loc,check_states);
					// it's an initial state, so reassign
					if (!USE_CONVEX_HULL)
							new_iter=states.add(loc,ini_states[loc]);
					else
							new_iter=states.convex_hull_add(loc,ini_states[loc]);
					insert_maplist_iter(states,check_states,new_iter);*/
					reach_init(ini_states, states, check_states, checktime);
					return false;
				}
				else
				{
					states.assign_empty(loc,check_states);
				
				location_ref sloc;
				for (trans_ref_set::const_iterator it=locations[loc].in_trans.begin();it!=locations[loc].in_trans.end();++it)
				{
					sloc=transitions[*it].source_loc();
					if (!states.is_empty(sloc))
					{
						// put all symbolic states from source_loc() back on the waiting list
						for (list< list<symb_state>::iterator >::const_iterator j=states.iter_map[sloc].begin(); j!=states.iter_map[sloc].end(); ++j)
							insert_maplist_iter(states,check_states,*j);
					};
				};
				};
				return false;
			};
		}
		else
		{
//cout << "still in queue" << endl << flush;		
		};
};
	return true;
}

void 
automaton::reach_init(symb_states_type i_states, symb_state_maplist& states, symb_state_plist& new_states, bool checktime)
{
	// initialize the reachable states "states" and the waiting list "new_states" with "i_states"

	unlock_locations(); // clear the is_fully_refined flags;
	
	new_states.clear();
  //states=symb_state_maplist(i_states,new_states);
	i_states.map_locations(get_loc_names_map());
	states.initialize(i_states,new_states,false); // don't use convex hull here 
	
	refine_states(*this,states,new_states); // partition the state space

	if (USE_CONVEX_HULL)
		{
			// get states back
			i_states=states.transfer_symb_states();
			// now re-initialize with convex hull
			states.initialize(i_states,new_states,USE_CONVEX_HULL); // now use convex hull here 
		}

  new_states.clear();
  states.get_all_states(new_states); // put all states on waiting list
	
  // init with time_post
	if (checktime)
		time_post_assign(states,new_states);
 
  new_states.clear();
  
	for (symb_state_maplist::iterator it=states.begin();it!=states.end();++it)
	{
		insert_maplist_iter(states,new_states,it);		
	};
}

symb_states_type
automaton::get_reach_set(const symb_states_type& i_states, symb_states_type& f_states, bool& f_states_reachable, label_ref_set dontchecklabs, bool checktime)
{
  stopwatch sw(16100,"get_reach_set");
  symb_states_type symb_states;
  int iter_count=0;
	GLOBAL_ITER_COUNT=0;

  message(16100,"Computing reachable states of " + name);
ofstream log_file("phaver_log.csv");	
//ofstream log_file;
//log_file.open("log.txt");
log_file << "Iteration" <<","<< "total locs" <<","<< "total cvs" << "," << "new cvs" << "," << "total time" << "," << "diff. time";
  if (VERBOSE_LEVEL>512200) 
		log_file << "," << "max. constraints" << "," << "max. bits";
log_file << endl;

  symb_state_plist new_states;
	symb_state_maplist states;
   f_states_reachable=false;

	reach_init(i_states, states, new_states, checktime);
//exit(0);	
	uint old_size_new_states=0;
	bool manual_REACH_USE_BBOX=REACH_USE_BBOX;
	bool restore_REACH_USE_BBOX(false);
	int bbox_iter_count=0;
	double last_time_delta=0;
	double time_delta=sw.delta();
	uint old_loc_size=0;
  while ((!new_states.empty())  && (REACH_MAX_ITER==0 || iter_count < REACH_MAX_ITER) && (!(!f_states.is_empty()) || !f_states_reachable))
  {
    ++iter_count;
    ++bbox_iter_count;
		
		if (bbox_iter_count >= REACH_USE_BBOX_ITER && old_size_new_states<=new_states.size() && last_time_delta < time_delta && (!REACH_STOP_USE_CONVEX_HULL_SETTLE || (old_loc_size == states.loc_size()))) 
			{
				bbox_iter_count=0;
				REACH_USE_BBOX=true; 
				restore_REACH_USE_BBOX=true;
				message(128200,"Applying bounding box to new states in this iteration.");
			};
		if (iter_count == REACH_STOP_USE_CONVEX_HULL_ITER) {USE_CONVEX_HULL=false; message(128200,"Stopping to use convex hull.");};
		if (iter_count == REACH_STOP_USE_BITSIZE) {CONSTRAINT_BITSIZE=0; message(128200,"Stopping to use CONSTRAINT_BITSIZE.");};
		
		old_size_new_states=new_states.size();
		last_time_delta=time_delta;
		old_loc_size=states.loc_size();
		
		trans_and_time_post_assign(states,new_states,f_states,f_states_reachable,dontchecklabs,checktime);
		
		time_delta=sw.delta();
		if (restore_REACH_USE_BBOX) {REACH_USE_BBOX=manual_REACH_USE_BBOX; restore_REACH_USE_BBOX=false;}

//    cout << "Iteration " << iter_count << ", " << new_states.size() << " new symbolic states. " << flush;
//    cout << "Total " << states.loc_size() << " loc, " << states.cvs_size() << " polyhedra." << endl << flush;
//cout << "." << flush;

log_file << iter_count <<","<< states.loc_size() <<","<< states.cvs_size() << "," << new_states.size() << "," << sw.value() << "," << time_delta;

    if (VERBOSE_LEVEL<128200) progress_dot();
    else
		{
    message(128200,"Iter " + int2string(iter_count) + "(" + int2string(GLOBAL_ITER_COUNT)+ ")" + ": tot " + int2string(states.loc_size()) + " loc, " + int2string(states.cvs_size()) + " poly (" + int2string(new_states.size()) + " new) in " + double2string(time_delta) + " sec.");
    if (VERBOSE_LEVEL>512200) 
		{
			int con_size=states.max_constraint_size(new_states);
			int bit_size=states.max_bit_size(new_states);
			message(512200,"     max. " + int2string(con_size) + " new constr with max " + int2string(bit_size) + " bits.");
			log_file  << "," << states.max_constraint_size(new_states) << "," << states.max_bit_size(new_states);
			
		};
if (!REFINE_CONSTRAINTRATPAIRLIST.empty()) {print_size(); cout << endl;};		
		
		};
		
log_file << endl;

//states.print();
//pause_key();
//        print(states,*this);
  };
  if (VERBOSE_LEVEL<128200) progress_dot_end();

//cout << endl;
  message(32100,"Terminated after " + int2string(iter_count) + " iterations.");
  message(32100,"Total " + int2string(states.loc_size()) + " loc, " + int2string(states.cvs_size()) + " polyhedra.");

//states.print();

//      return states.get_symb_states(dim,locations.size());
  symb_states=states.transfer_symb_states();
  symb_states.var_names_assign(get_var_names());
	symb_states.loc_names_assign(get_loc_names_map());
  return symb_states;
}

symb_states_type
automaton::get_reach_set(label_ref_set dontchecklabs, bool checktime)
{
  ini_states.loc_names_assign(get_loc_names_map());
  symb_states_type dummystates;
  bool dummybool;
  return get_reach_set(ini_states,dummystates,dummybool,dontchecklabs,checktime);
}

bool
automaton::is_reachable(symb_states_type& orig_target,symb_states_type& reach_set,label_ref_set dontchecklabs, bool checktime)
{
  ini_states.loc_names_assign(get_loc_names_map());
  
	symb_states_type target_states(orig_target);
	
	// map the target states
  //target_states.map_locations(get_loc_names_map());
  target_states.map_variables(get_var_names());
  
  bool is_reachable;
  reach_set=get_reach_set(ini_states,target_states,is_reachable,dontchecklabs,checktime);
  return is_reachable;
}

bool
automaton::is_reachable_fb(symb_states_type& orig_target,symb_states_type& reach_set,label_ref_set dontchecklabs, bool checktime)
{
  symb_states_type dummystates;
  bool dummybool;
	// start with initial states
	ini_states.loc_names_assign(get_loc_names_map());
	
	symb_states_type source_states(ini_states);
	symb_states_type target_states(orig_target);
	
	// map the target states
	target_states.map_locations(get_loc_names_map());
	
	//symb_states_type reach_set;
	symb_states_type temp_target; //gf
	
	// memorize original constraints
	list <ConstraintRatPair> orig_constraints(REFINE_CONSTRAINTRATPAIRLIST);
	double orig_angle=REFINE_DERIV_MINANGLE;
	
	bool refinement_possible=true;
	// set constraints to highest level
	// check whether the maximal level is 0
	if (true || orig_angle>=1)
	for (list <ConstraintRatPair>::iterator it=REFINE_CONSTRAINTRATPAIRLIST.begin();it!=REFINE_CONSTRAINTRATPAIRLIST.end();++it)
	{
		if (it->second.second != 0)
		{
			it->second.first = it->second.second; // start with the max size
		}
		else
		{
			message(0,"Error: Must specify max. size in set_refine_constraints.");
			refinement_possible=false;
		};
	};
	
	list <ConstraintRatPair>::iterator orig_it;
	
	int count=0;
	string movie_filename("out_mov");
	bool is_reachable=true;
	list <ConstraintRatPair>::iterator it,max_it;
	symb_states_type rs2;
	clock_ref_set crs;
	while ((refinement_possible && is_reachable) || (REACH_FB_REFINE_METHOD/10==1 && count%2==0))  // || finish on forward
	{
		reach_set=get_reach_set(source_states,dummystates,dummybool,dontchecklabs,checktime);	
		
		if (dim>2)
		{
		  for (uint i1=0;i1+1<dim;++i1)
		    {
		      for (uint i2=i1+1;i2<dim;++i2)
			{
			  // make clock set
			  crs.clear();
			  for (uint i=0;i<dim;++i)
			    if (i!=i1 && i!=i2) crs.insert(i);

			  rs2=reach_set;
			  rs2.remove_space_dimensions(crs);
			  rs2.save_gen_fp_raw(movie_filename+"_x"+int2string(i1)+"x"+int2string(i2)+"_"+int2string(1000000+count));		
			};
		    };

		}
		else
			reach_set.save_gen_fp_raw(movie_filename+"_r_"+int2string(1000000+count));		
		
		invariant_assign(reach_set,false);// false : no need to map locations
		//		reach_set.intersection_assign(target_states,true); 
		temp_target=target_states;
		temp_target.intersection_assign(reach_set,true);
		//		cout << "temp_target.ccvs_size " << temp_target.ccvs_size();
		temp_target.simplify();
		//		cout << "temp_target.ccvs_size after simplify " << temp_target.ccvs_size();
		if (temp_target.is_empty())
		{
			is_reachable=false;
		}
		else
		{
			target_states=source_states;
if (REACH_FB_REFINE_METHOD/10==1) // intersect the continous target and source states		       
  {
    clock_val_set mycvs=temp_target.union_over_locations();
    target_states.intersection_assign(mycvs);
  };
			source_states=temp_target;
			
			// tighten the constraints
/*			if (orig_angle>=1)
			{*/
if (REACH_FB_REFINE_METHOD%2==0) // method 0: scale them all			
{
				orig_it=orig_constraints.begin();
				refinement_possible=false;
				for (it=REFINE_CONSTRAINTRATPAIRLIST.begin();it!=REFINE_CONSTRAINTRATPAIRLIST.end();++it)
				{
					it->second.first=it->second.first/Rational(2); // just a guess: halve it
					if (it->second.first < orig_it->second.first)
					{
						it->second.first = orig_it->second.first; // if it's too small, go back to the original minimum
					}
					else
						refinement_possible=true; // at least one of these must have changed, otherwise it's mute
					++orig_it;
				};
}
else if (REACH_FB_REFINE_METHOD%2==1) // method 1: scale the largest one	
{
				orig_it=orig_constraints.begin();
				max_it=REFINE_CONSTRAINTRATPAIRLIST.begin();
				Rational min_ratio=100000000;
				refinement_possible=false;
				for (it=REFINE_CONSTRAINTRATPAIRLIST.begin();it!=REFINE_CONSTRAINTRATPAIRLIST.end();++it)
				{
					if (it->second.first/Rational(2) >= orig_it->second.first && (it->second.second/it->second.first<min_ratio))
					{
						max_it=it;
						min_ratio=it->second.second/it->second.first;
						refinement_possible=true; // at least one of these must have changed, otherwise it's mute
					};
					++orig_it;
				};
				if (refinement_possible)
					max_it->second.first=max_it->second.first/Rational(2);
}
else
{
	throw_error("REACH_FB_REFINE_METHOD="+int2string(REACH_FB_REFINE_METHOD)+" not recognized.");
};
/*			}
			else
			{*/
/*			if (orig_angle<1)
				REFINE_DERIV_MINANGLE=pow(REFINE_DERIV_MINANGLE,0.5);
// 			};
*/			
			++count;
			reverse();
		};
	};
	
	if (count%2!=0)
		reverse();
	REFINE_CONSTRAINTRATPAIRLIST=orig_constraints;
	REFINE_DERIV_MINANGLE=orig_angle;

return is_reachable;

}


// with partitioning level, didn't work
symb_states_type
automaton::get_reach_set_forwarditer(int delta, label_ref_set dontchecklabs, bool checktime)
{
  // refine partitioning by successively increasing partition level by delta
	
  stopwatch sw(16100,"get_reach_set_forwarditer");

  symb_states_type dummystates;
  bool dummybool;
	symb_states_type ss,ss_old;
	int max_level=REFINE_PARTITION_LEVEL_MAX;
	
	REFINE_PARTITION_LEVEL_MAX=0; //3;
	bool unlocked_surface=true;
	int unl_level=0;
	
	bool first_time=true;
	loc_ref_set lrs;
	int count=0;
  ofstream file_out;
	string filename="out_surface_";
	
	while (unlocked_surface)
	{
		++count;
		REFINE_PARTITION_LEVEL_MAX+=delta; //REFINE_CONSTRAINTRATPAIRLIST.size();
message(16100,"Setting max. partition level to " + int2string(REFINE_PARTITION_LEVEL_MAX));		
		ss_old=ss;
		ss=get_reach_set(ini_states,dummystates,dummybool,dontchecklabs,checktime);
		lrs.clear();
		unl_level=add_surface_locations(ss,lrs); // add all surface locs to lrs (assign locs to surface), and get min. level of not fully refined loc
cout << "unl:" << unl_level << "fr:" << is_fully_refined(lrs);		
//		if (unl_level>=0 && (unl_level<=REFINE_PARTITION_LEVEL_MAX && (first_time || !ss.contains(ss_old)))) // tbd: this termination condition stinks
		if (!is_fully_refined(lrs) && (unl_level<REFINE_PARTITION_LEVEL_MAX || first_time || (unl_level==REFINE_PARTITION_LEVEL_MAX && !is_fully_refined(lrs)))) 
		{
				unlocked_surface=true;
				REFINE_PARTITION_LEVEL_MAX=unl_level;
		}
		else
			unlocked_surface=false;
		first_time=false;
/*					file_out.open( (filename + int2string(count)).c_str() );
					print_surface_fp_raw(file_out);
					file_out.close();*/
	};
	
	REFINE_PARTITION_LEVEL_MAX=max_level;
  return ss;
}



// ---------------------------------------------------------------------------
// Parametric Reachability
// new 10/2003
// ---------------------------------------------------------------------------

clock_val_set
automaton::get_param_reach(symb_states_type& forb_states, clock_ref_set params, bool stop_iter, bool prime_convex_hull)
{
  stopwatch sw(16100,"get_param_reach");
  unsigned int iter_count=0;

  symb_states_type dstates;
  symb_states_type pini_states=ini_states;
  clock_val_set cvs,cvs2;
  clock_ref_set nonparams=variables;
  nonparams.difference_assign(params);
cout << variables << "!!!";
cout << params << "!!";
cout << nonparams << "!";
  // ------------
  // create a map from variables in space params to positions in full variable space
  PFunction mapfunc;
  clock_ref_set::const_iterator j=params.begin();
  for (dimension_type i = 0; i < params.size(); ++i)
  {
    mapfunc.insert(i,*j);
    ++j;
  };
  // add maps for nonparams to their old places
  j=nonparams.begin();
  for (dimension_type i = 0; i < nonparams.size(); ++i)
  {
    mapfunc.insert(params.size()+i,*j);
    ++j;
  };
  // ------------
  // for operations with conv_hull to make sure only parameters that count are considered:
  // ------------
  clock_val_set always_good_params;
  pini_states.remove_space_dimensions(nonparams);
  always_good_params=pini_states.intersection_over_locations();
  pini_states=ini_states;
  // ------------

  bool dum=USE_CONVEX_HULL;
  if (prime_convex_hull)
    USE_CONVEX_HULL=true;


  bool forbidden_reachable;
  dstates=get_reach_set(pini_states,forb_states,forbidden_reachable);

  if (prime_convex_hull)
    USE_CONVEX_HULL=dum;

  bool first_iter_and_conv_hull=prime_convex_hull;
  while (!dstates.is_empty())  // still found bad states
  {
    ++iter_count;
    dstates.simplify();
    dstates.remove_space_dimensions(nonparams);
    cvs=dstates.union_over_locations();
//        cvs.remove_space_dimensions(nonparams);  // alternatively to above: dstates.remove_space_dimensions(nonparams);

cout << "Bad params" << endl;
cvs.print();
    // negate
    // if convex_hull primed, don't negate, but examine only bad states
    if (first_iter_and_conv_hull)
    {
      always_good_params.difference_assign(cvs);  // these will be added at the end to the good parameters
      always_good_params.simplify();
cout << "Found good params by convex hull:" << endl;
always_good_params.print();
    }

    else
      cvs.negate();  // now good params
//cout << "Bad params negated" << endl;
//cvs.print();
    cvs.simplify();
    cvs.add_space_dimensions_and_embed(params.size());
    cvs.map_space_dimensions(mapfunc);
    // create new ini_states with only good parameters
    pini_states.intersection_assign(cvs);
    pini_states.simplify();
cout << "New ini states" << endl;
pini_states.print();

    // reinitialize states and start new iteration
    if (stop_iter || first_iter_and_conv_hull)
      dstates=get_reach_set(pini_states,forb_states,forbidden_reachable);
    else
      dstates.clear();
    first_iter_and_conv_hull=false;
  };
  cout << "Terminated after " << iter_count << " iterations." << endl;

//states.print();
  cout << "Good Parameters:" << endl;
  pini_states.remove_space_dimensions(nonparams);
  cvs=pini_states.intersection_over_locations();
  if (prime_convex_hull)
  {
    cvs.union_assign(always_good_params);
    cvs.simplify();
  };
  cvs.print();

  return cvs;
}

