/***************************************************************************
                          automaton_sim.cpp  -  description
                             -------------------
    begin                : Tue Jun 8 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "automaton.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

// ---------------------------------------------------------------------------
// Simulation Relation
// new 08/2003
// ---------------------------------------------------------------------------

// Transition-Conform States

// ---------- here mu is presumed not to be intersected with the invariants ---->
clock_val_set
automaton::sim_states_EP_OLD(const transition_ref& tr) const
{
  clock_val_set E(dim),cvs(dim);

//cout << "Calc EP" << endl << flush;

  E=locations[transitions[tr].source_loc()].invariant();  // is u

//cout << "EP-1" << endl;
//E.print();
  E.add_space_dimensions_and_embed(dim); // is u,u'

  cvs=locations[transitions[tr].target_loc()].invariant(); // is u'
//cout << "EP-2" << endl;
//E.print();
  cvs.add_space_dimensions_and_embed(dim); // is u',u
  cvs.dimension_move_assign(0,dim-1,dim); // is u,u'
  E.intersection_assign(cvs);
//cout << "EP-3" << endl;
//E.print();

  E.intersection_assign(get_restricted_mu(tr));
//cout << "EP-4" << endl;
//E.print();

  return E;
}

clock_val_set
automaton::sim_states_EQ_OLD(const transition_ref& tr, const clock_val_set& R, const dimension_type& pdim) const
{
  clock_val_set E(dim),cvs(dim);

//cout << "Calc EQ" << endl << flush;
  if (!R.is_empty())
  {

if (DEBUG_OUTPUT>0) {
cout << "B1" << flush;
};
  E=locations[transitions[tr].source_loc()].invariant(); // is v
  E.add_space_dimensions_and_embed(pdim+dim);  // is v,u',v'
  E.dimension_move_assign(0,dim-1,pdim); // make room for u', is u',v,v'


if (DEBUG_OUTPUT>0) {
cout << "B2" << flush;
};
  cvs=locations[transitions[tr].target_loc()].invariant(); // is v'
  cvs.add_space_dimensions_and_embed(pdim+dim); // is v',u',v
  cvs.dimension_move_assign(0,dim-1,pdim+dim); // move v' up, is u',v,v'
  E.intersection_assign(cvs);

if (DEBUG_OUTPUT>0) {
cout << "B3" << flush;
};
  cvs=get_restricted_mu(tr); // is v,v'
  cvs.add_space_dimensions_and_embed(pdim); // make room for u'
  cvs.dimension_move_assign(0,2*dim-1,pdim); // move v,v' up, is u',v,v'
if (DEBUG_OUTPUT>0) {
cout << "E-dim:" << E.dim << "/" << E.ccvs_list.begin()->space_dimension() << ","<< dim;
cout << "cvs-dim" << cvs.dim << "/" << cvs.ccvs_list.begin()->space_dimension() << ","<< dim;
};

  E.intersection_assign(cvs);

if (DEBUG_OUTPUT>0) {
cout << "B4" << flush;
};
  cvs=R; // is u',v'
  cvs.add_space_dimensions_and_embed(dim); // make room for v, is u',v',v
  cvs.dimension_move_assign(pdim,pdim+dim-1,pdim+dim); // move v' up, is u',v,v'
  E.intersection_assign(cvs);

if (DEBUG_OUTPUT>0) {
cout << "B5" << flush;
};


  E.remove_space_dimensions(pdim+dim,pdim+2*dim-1); // get rid of v', is u',v
  }
  else
  {
    E=clock_val_set(pdim+dim,EMPTY);
  };

//E.print();
  return E;
}
// <-----------------------------------

clock_val_set
automaton::sim_states_EP(const transition_ref& tr) const
{
  return get_restricted_mu(tr);
}

clock_val_set
automaton::sim_states_EQ(const transition_ref& tr, const clock_val_set& R, const dimension_type& pdim) const
{
  clock_val_set E(2*dim),cvs(dim);
//if (DEBUG_OUTPUT>0) {
stopwatch sw(512000,"sim_states_EQ");
//};

//cout << "Calc EQ" << endl << flush;
  if (!R.is_empty())
  {

if (DEBUG_OUTPUT>0) {
cout << "B1" << flush;
};
  E=get_restricted_mu(tr); // is v,v'
  E.add_space_dimensions_and_embed(pdim); // make room for u'
  E.dimension_move_assign(0,2*dim-1,pdim); // move v,v' up, is u',v,v'
if (DEBUG_OUTPUT>0) {
cout << "E-dim:" << E.dim << "/" << E.ccvs_list.begin()->space_dimension() << ","<< dim;
cout << "cvs-dim" << cvs.dim << "/" << cvs.ccvs_list.begin()->space_dimension() << ","<< dim;
};

if (DEBUG_OUTPUT>0) {
cout << "B4" << flush;

};
  cvs=R; // is u',v'
  cvs.add_space_dimensions_and_embed(dim); // make room for v, is u',v',v
  cvs.dimension_move_assign(pdim,pdim+dim-1,pdim+dim); // move v' up, is u',v,v'
  E.intersection_assign(cvs);

if (DEBUG_OUTPUT>0) {
cout << "B5" << flush;
};

  E.remove_space_dimensions(pdim+dim,pdim+2*dim-1); // get rid of v', is u',v
  }
  else
  {
    E=clock_val_set(pdim+dim,EMPTY);
  };

//E.print();
  return E;
}

clock_val_set
automaton::sim_states_Btr(const transition_ref& s, const location_ref_pair& lrp, state_relation& R, const automaton& spec_aut)
{
  if (R.find(lrp)!=R.end())
  {
    if (!R[lrp].is_empty())
    {
    clock_val_set E(2*dim),F(dim+spec_aut.dim),cvs(dim+spec_aut.dim);
    location_ref_pair lrp2;

//cout << "Calc Btr" << endl << flush;
if (DEBUG_OUTPUT>0) {
cout << "A1" << flush;
};

    E=sim_states_EP(s);  // is u,u'
    E.add_space_dimensions_and_embed(spec_aut.dim); // is u,u',v
if (DEBUG_OUTPUT>0) {
cout << endl << "Enabled in P for transition " << s << " (in u,u',v):" << endl;
E.print();
};
    // try all outgoing transitions in Q with the same label
    for (trans_ref_set::const_iterator j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
    {
      if (transitions[s].label==spec_aut.transitions[*j].label)
      {
//      F=complement(spec_aut.sim_states_EQ(t,R[location_ref_pair(transitions[s].target_loc,spec_aut.transitions[t].target_loc)]));
//      F.add_space_dimensions_and_embed(dim);
//      F.dimension_move_assign(0,2*dim-1,dim);
//      E.intersection_assign(F);
if (DEBUG_OUTPUT>0) {
cout << "A2" << flush;
};
      lrp2 = location_ref_pair(transitions[s].target_loc(),spec_aut.transitions[*j].target_loc());
      if (R.find(lrp2)==R.end())
        cvs=clock_val_set(dim+spec_aut.dim,EMPTY); // is u',v'
      else
        cvs=R[lrp2];

      F=spec_aut.sim_states_EQ(*j,cvs,dim); // is u',v
if (DEBUG_OUTPUT>0) {
cout << "A3" << flush;
};
      F.add_space_dimensions_and_embed(dim); // is u',v,u
      F.dimension_move_assign(0,dim+spec_aut.dim-1,dim); // is u,u',v

if (DEBUG_OUTPUT>0) {
cout << endl << "Enabled in Q for spec-transition " << *j << " (in u,u',v):" << endl;
F.print();
};
      E.difference_assign(F);
if (DEBUG_OUTPUT>0) {
cout << "A4" << flush;
};
      };
    };

    E.remove_space_dimensions(dim,2*dim-1); // get rid of u'
if (DEBUG_OUTPUT>0) {
cout << endl << "Bad states in P for transition " << s << ":" << endl;
E.print();
};
    E.intersection_assign(R[lrp]);
if (DEBUG_OUTPUT>0) {
cout << endl << "Bad states in P and R for transition " << s << ":" << endl;
E.print();
};
//cout << endl << "Bad tr " << s <<":" << endl;
//E.print();
    return E;
    }; // end if
  }; // end if
  return clock_val_set(dim+spec_aut.dim,EMPTY);
}

// Time-Conform States

clock_val_set
automaton::elapse_succ_set(clock_val_set cvs, time_elapse_poly tp, clock_val_set inv)
{
  // initial states cvs in u, inv in u
  // cvs and tp end up as variable sets for (u,u',t)
  dimension_type dimm(cvs.dim);

  cvs.add_space_dimensions_and_embed(dimm); // add variable space for u'
  for (dimension_type i=0; i<dimm; ++i)
  {
    cvs.add_constraint(Variable(i)==Variable(dimm+i)); // at t=0, u=u'
  };
  cvs.add_space_dimensions_and_project(1); // add a clock with initial value 0

  // adapt time_elapse_poly, so that time elapses for u', but not for u
  tp.add_space_dimensions_and_project(dimm); // add variables with no time elapse
  tp.dimension_move_assign(0,dimm-1,dimm); // now time elapses for u' instead of u
  tp.add_space_dimensions_and_embed(1); // add the clock
  tp.add_constraint(Variable(2*dimm)==1); // derivative of the clock

  // adapt invariant
  inv.add_space_dimensions_and_embed(dimm+1);
  inv.dimension_move_assign(0,dimm-1,dimm); // the invariant is now for u'

  // let time elapse
  cvs.time_elapse_assign(tp,inv);

  return cvs;
}

clock_val_set
automaton::elapse_succ_set_from(dimension_type dimm, clock_val_set cvs, time_elapse_poly tp, clock_val_set inv)
{
  // starts from initial states in (u,u',t) rather than just u
  // cvs and tp end up as variable sets for (u,u',t)

  // adapt time_elapse_poly, so that time elapses for u', but not for u
  tp.add_space_dimensions_and_project(dimm); // add variables with no time elapse
  tp.dimension_move_assign(0,dimm-1,dimm); // now time elapses for u' instead of u
  tp.add_space_dimensions_and_embed(1); // add the clock
  tp.add_constraint(Variable(2*dimm)==1); // derivative of the clock

  // adapt invariant
  inv.add_space_dimensions_and_embed(dimm+1);
  inv.dimension_move_assign(0,dimm-1,dimm); // the invariant is now for u'

  // let time elapse
  cvs.time_elapse_assign(tp,inv);

  return cvs;
}

clock_val_set
automaton::good_elapse_states_in_Q(const location_ref& k, const location_ref& l, state_relation& R, const automaton& spec_aut)
{
  clock_val_set cvs,Ev,Ste;

  location_ref_pair lrp;

stopwatch sw(512000,"good_elapse_states_in_Q");
cout << "Getting good elapse states in Q with respect to tau transitions" << endl << flush;

cout << "TickA1" << endl << flush;

  // do a reachability analysis
  symb_state_maplist states;
  symb_state_plist new_states;

  // Start at v,v'=v,t=0
  dimension_type dimm(spec_aut.dim);

  cvs=clock_val_set(spec_aut.dim); // initial
  cvs.add_space_dimensions_and_embed(dimm); // add variable space for u'
  for (dimension_type i=0; i<dimm; ++i)
  {
    cvs.add_constraint(Variable(i)==Variable(dimm+i)); // at t=0, u=u'
  };
  cvs.add_space_dimensions_and_project(1); // add a clock with initial value 0

  Ev=elapse_succ_set_from(spec_aut.dim,cvs,spec_aut.locations[l].time_post_poly(),spec_aut.locations[l].invariant());

  list< symb_state >::iterator state_it;
  
	state_it = states.add(l,Ev);
	if (state_it != states.end() && new_states.find(state_it)==new_states.end())
		new_states.push_back(state_it);

cout << "TickA2" << endl << flush;
  // Reach iteration
  // Note: doesn't have to terminate
  // to do: force termination, e.g. by upper bound on t (could be obtained from Eu(u,u',t)
  clock_val_set newcvs;
  location_ref loc,tloc;

  symb_state_plist::iterator plist_it=new_states.begin();
  while (plist_it != new_states.end())
  {
    state_it=*plist_it;
    loc=state_it->loc;

cout << "TickA2.1" << endl << flush;
cout << "Looking at" << endl << flush;
state_it->print();
    // add all tau-successors
    for (trans_ref_set::const_iterator j=spec_aut.locations[loc].out_trans.begin();j!=spec_aut.locations[loc].out_trans.end();j++)
    {

      if (spec_aut.transitions[*j].label==0)  // it's a tau-transition
      {
        // apply post operator to v'
        cvs=spec_aut.get_restricted_mu(*j); // is v',v''
        cvs.add_space_dimensions_and_embed(spec_aut.dim+1); // make room for v,t, is v',v'',v,t
        cvs.dimension_move_assign(0,2*spec_aut.dim-1,spec_aut.dim); // move v',v'' up, is v,v',v'',t
        newcvs=*state_it; // is v,v',t
        newcvs.add_space_dimensions_and_embed(spec_aut.dim); // make room for v'', is v,v',t,v''
        newcvs.dimension_move_assign(2*spec_aut.dim,2*spec_aut.dim,3*spec_aut.dim); // move t up, is v,v',v'',t
        newcvs.intersection_assign(cvs);
        newcvs.remove_space_dimensions(spec_aut.dim,2*spec_aut.dim-1); // remove v', is v,v'',t

cout << "Probing transition " << *j << endl;
newcvs.print();
        if (!newcvs.is_empty())
        {
          tloc=spec_aut.transitions[*j].target_loc();
cout << "Examining new loc " << tloc << endl;
          // get elapse states from new starting region
          Ev=elapse_succ_set_from(spec_aut.dim,newcvs,spec_aut.locations[tloc].time_post_poly(),spec_aut.locations[tloc].invariant());
          state_it=states.add(tloc,Ev);
					if (state_it != states.end() && new_states.find(state_it)==new_states.end())
						new_states.push_back(state_it);
        };
      }; // end if
    }; // end for

    plist_it=new_states.erase(plist_it);
    plist_it=new_states.begin();
  }; // end while

  // turn maplist into symb_states
  symb_states_type symb_states;

  // this simplifies the states
//      symb_states=states.get_symb_states(2*spec_aut.dim+1,0);
  symb_states=states.get_symb_states();
cout << "TickA3" << endl << flush;
symb_states.print();

  // Intersect states with R
  Ste=clock_val_set(dim+2*spec_aut.dim+1,EMPTY); // is u',v,v',t
  for (symb_states_type::iterator i=symb_states.begin();i!=symb_states.end();++i)
  {
cout << "TickA31" << endl << flush;
    Ev=i->second;
    Ev.add_space_dimensions_and_embed(dim); // add space for u', is v,v',t,u'
    Ev.dimension_move_assign(0,2*spec_aut.dim,dim); // move v,v',t up by dim, is u',v,v',t
cout << "TickA32" << endl << flush;
    lrp=location_ref_pair(k,i->first);
    if (R.find(lrp)!=R.end())
      cvs=R[lrp]; // this time R is evaluated at u',v'
    else
      cvs=clock_val_set(dim+spec_aut.dim,EMPTY);

    cvs.add_space_dimensions_and_embed(spec_aut.dim+1); // make room for v,t, is u',v',v,t
    cvs.dimension_move_assign(dim,dim+spec_aut.dim-1,dim+spec_aut.dim); // move v' up by spec_aut.dim, is u',v,v',t
cout << "TickA33" << endl << flush;
    Ev.intersection_assign(cvs);

cout << "TickA34" << endl << flush;
    Ste.union_assign(Ev);
  };
cout << "TickA4" << endl << flush;
Ste.print();

  return Ste;
}

clock_val_set
automaton::sim_states_Bte(const location_ref& k, const location_ref& l, state_relation& R, const automaton& spec_aut, const clock_val_set& equiv_cvs)
{
//if (DEBUG_OUTPUT>0) {
  stopwatch sw (512000,"sim_states_Bte");
//}
  clock_val_set Ste, Eu(2*dim+1), Ev(2*spec_aut.dim+1), Bte, cvs;
  location_ref_pair lrp(k,l);

  if (R.find(lrp)!=R.end())
  {
    if (!R[lrp].is_empty())
    {

  // initialize elapse_succ_set with the set of u in R
  // could also initialize with universe, but should be faster this way
//      cvs=R[lrp];
//      cvs.remove_space_dimensions(dim,dim+spec_aut.dim-1); // remove v
  cvs=clock_val_set(dim);
//cvs.join_convex_ccvs();
  Eu=elapse_succ_set(cvs,locations[k].time_post_poly(),locations[k].invariant()); // is u,u',t

//Eu.remove_redundant();
  Eu.add_space_dimensions_and_embed(spec_aut.dim); // add space for v
  Eu.dimension_move_assign(2*dim,2*dim,2*dim+spec_aut.dim); // move t behind v, is u,u',v,t
if (DEBUG_OUTPUT>0) {
cout << " Eu-s:" << Eu.size() << flush;
};
// intersect with R[lrp]


cvs=R[lrp]; // for intersecting u and v
cvs.add_space_dimensions_and_embed(dim+1);   // make room for u' and t, is u,v,u',t
cvs.dimension_move_assign(dim,dim+spec_aut.dim-1,2*dim); // move v up, is u,u',v,t
Eu.intersection_assign(cvs);

if (DEBUG_OUTPUT>0) {
cout << " Eu-s after intersect: " << Eu.size() << flush;
};

  // -------------------------------------------------
  // Successor states in Q as (v,v',t)
  // -------------------------------------------------

  if (CHECK_FOR_TAU_IN_Q)
    Ste=good_elapse_states_in_Q(k,l,R,spec_aut);
  else
  {
//      // initialize elapse_succ_set with the set of v in R
//      // could also initialize with universe, but should be faster this way
//      cvs=R[lrp];
//      cvs.remove_space_dimensions(0,dim-1); // remove u
//cvs.join_convex_ccvs();
  cvs=clock_val_set(spec_aut.dim);
  Ev=elapse_succ_set(cvs,spec_aut.locations[l].time_post_poly(),spec_aut.locations[l].invariant());
Ev.remove_redundant();
  Ev.add_space_dimensions_and_embed(dim); // add space for u', is v,v',t,u'
  Ev.dimension_move_assign(0,2*spec_aut.dim,dim); // move v,v',t up by dim, is u',v,v',t
if (DEBUG_OUTPUT>0) {
cout << "Ev-s" << Ev.size() << flush;
};
  Ste=Ev;
  if (true) //!Q_IS_DETERMINISTIC)
    cvs=R[lrp]; // this time R is evaluated at u',v'
  else

    cvs=equiv_cvs;
  cvs.add_space_dimensions_and_embed(spec_aut.dim+1); // make room for v,t, is u',v',v,t
  cvs.dimension_move_assign(dim,dim+spec_aut.dim-1,dim+spec_aut.dim); // move v' up by spec_aut.dim, is u',v,v',t
  Ste.intersection_assign(cvs);
  };

  // -------------------------------------------------
if (DEBUG_OUTPUT>0) {
cout << "Ste-s" << Ste.size() << flush;
};
//Ste.remove_redundant();
//cout << "Ste-s after remove red" << Ste.size() << flush;
//Ste.join_convex_ccvs();
//cout << "Ste-s after join_conv" << Ste.size() << flush;
  Ste.remove_space_dimensions(dim+spec_aut.dim,dim+2*spec_aut.dim-1); // remove v' out of u',v,v',t, is u',v,t
if (DEBUG_OUTPUT>0) {
cout << "Ste-s after remove dim" << Ste.size() << flush;
};
  Bte=Eu; // is (u,u',v,t)
//      Ste=complement(Ste);
//      Bte.intersection_assign(Ste); // is u,u',v,t
  Ste.add_space_dimensions_and_embed(dim); // make room for u, is u',v,t,u
  Ste.dimension_move_assign(0,dim+spec_aut.dim,dim); // move everything up by dim, is u,u',v,t

  Bte.difference_assign(Ste);
//      Bte.difference_assign_and_remove_dimension(Ste,dim,2*dim-1);
if (DEBUG_OUTPUT>0) {
cout << "Bte-s after difference" << Bte.size() << flush;
};
  Bte.remove_space_dimensions(dim,2*dim-1); // remove u', is u,v,t
  Bte.remove_space_dimensions(dim+spec_aut.dim,dim+spec_aut.dim); // remove t, is u,v
if (DEBUG_OUTPUT>0) {
cout << "Bte-s after remove" << Bte.size() << flush;
cout << endl << "Bad te " << k << "," << l <<":" << endl;
Bte.print();
};
  return Bte;
  }; // end if
  }; // end if

  return clock_val_set(dim+spec_aut.dim,EMPTY);
}

void
automaton::void_sim_rel(state_relation& R)
{
  // make somehow sure that R is definitely violating everything
  // -> make it empty
  R.clear();
}

bool
automaton::get_sim_rel(state_relation& R, automaton& spec_aut, const clock_val_set& equiv_cvs, bool get_ident_bisim, label_ref_set dontchecklabs, bool checktime)
{
  // iterate over R until convergence
  stopwatch sw(8500,"get_sim_rel");

  message(8500,"Fixpoint computation on simulation relation");

if (DEBUG_OUTPUT>1)
{
  print();
  spec_aut.print();
};
  variable_id_map vnvec=get_var_names();
  vnvec.shifted_union_assign(spec_aut.get_var_names(),"'");

  unsigned int iter_count=0;
  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  clock_val_set B,Bs,Bte,Btr,cvs;
  trans_ref_set::const_iterator k,j;
  bool found_bad=false;
  bool found_any_bad=false;
  bool check_all_labels=dontchecklabs.empty();

  if (get_ident_bisim)
    R.assign_ident_symmetric();

  waiting=R.get_location_ref_pairs(); // prime waiting list with R

  while (!waiting.empty())

  {
    ++iter_count;
    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

//    cout << "." << flush;
    progress_dot();
//cout << endl << "Examining locations " << lrp << "( R size " << R[lrp].size() << ")" << endl;
if (DEBUG_OUTPUT>0) {
R.print();
};
if (R.find(lrp)==R.end())
{
cout << "Referred to a non-existing location " << lrp << " in R!" << endl << flush;
pause_key();
};


//        G=R[lrp];

    B=clock_val_set(dim+spec_aut.dim,EMPTY); // create an empty cvs
    Btr=clock_val_set(dim+spec_aut.dim,EMPTY); // create an empty cvs
    Bte=clock_val_set(dim+spec_aut.dim,EMPTY); // create an empty cvs
    found_bad=false;

    // Transition-conform states
    // -------------------------
    // for all outgoing transitions in P
    for (k=locations[lrp.first].out_trans.begin();k!=locations[lrp.first].out_trans.end();k++)
    {
//          indep_trans=!spec_aut.labels.contains(transitions[*k].label); // note: 0-transitions (tau) are not independent!

      if (check_all_labels || !dontchecklabs.contains(transitions[*k].label))
      {
        if (SHOW_BAD_STATES)
        {
          cvs=sim_states_Btr(*k,lrp,R,spec_aut);
          if (!cvs.is_empty())
          {
            Btr.union_assign(cvs);
            cout << endl << "Found bad transitions states in " << lrp << "=" << locations[lrp.first].name << "," << spec_aut.locations[lrp.second].name ;
            cout << " label " << get_label_name(transitions[*k].label) << endl;
            cvs.print(vnvec);
//R.print();
          };
        }
        else
          Btr.union_assign(sim_states_Btr(*k,lrp,R,spec_aut));
      };
    };
if (DEBUG_OUTPUT>0) {
  sw.report_delta("After computing Transition-conform states");
};
    if (!Btr.is_empty())
    {
      found_bad=true;
      if (STOP_AT_BAD_STATES) // this is for deterministic systems with reach set priming
      {
        cout << "Stopping because bad state found." << endl;
        void_sim_rel(R);
        return found_bad;
      };
      // now subtract the bad states, so they are already propagated in the time-conform states
//B.remove_redundant();
//B.join_convex_ccvs();
      R[lrp].difference_assign(Btr);
//cout << "R after diff Btr before join: "<<R[lrp].size()<<endl;
if (SIM_SIMPLIFY_R)
R[lrp].simplify();
//cout << "R after diff Btr after join: "<<R[lrp].size()<<endl;
      if (get_ident_bisim)
        R.intersect_ident_symmetric(lrp);
      B.union_assign(Btr);
    };
//cout << endl << "after diff" << "(" << R[lrp].size() << ")" << endl;
//cout << "R after Btr: "<<R[lrp].size()<<endl;
if (DEBUG_OUTPUT>0) {
R[lrp].print();
};
if (DEBUG_OUTPUT>0) {
  sw.report_delta("After treating Transition-conform states");
};
//R.print();
//cout << "C" << flush;
    // Time-conform states
    // -------------------------
    if (checktime)
      Bte=sim_states_Bte(lrp.first,lrp.second,R,spec_aut,equiv_cvs);
//cout << endl << "B" << "(" << B.size() << ")" << endl;
//        Bte.intersection_assign(R[lrp]); // this is just for the emptiness-test
//cout << endl << "B after inters" << "(" << B.size() << ")" << endl;
//        if (!Bte.is_empty())
    if (!Bte.is_empty() && !Bte.is_disjoint_from(R[lrp]))
    {
      found_bad=true;
      if (SHOW_BAD_STATES && !cvs.is_empty())

      {
        cout << endl << "Found bad time-elapse states in " << lrp << "=" << locations[lrp.first].name << "," << spec_aut.locations[lrp.second].name<< ":" << endl;
        cvs.print(vnvec);
      };
      if (STOP_AT_BAD_STATES) // this is for deterministic systems with reach set priming
      {
        cout << "Stopping because bad state found." << endl;
        void_sim_rel(R);
        return found_bad;
      };
      // now subtract the bad states, so they are already propagated in the time-conform states
      R[lrp].difference_assign(Bte);
//cout << "R after diff Bte before join: "<<R[lrp].size()<<endl;
if (SIM_SIMPLIFY_R)
R[lrp].simplify();
//cout << "R after diff Bte after join: "<<R[lrp].size()<<endl;
      if (get_ident_bisim)
        R.intersect_ident_symmetric(lrp);
      B.union_assign(Bte);
    };
if (DEBUG_OUTPUT>0) {
  sw.report_delta("After treating Time-conform states");
};
//cout << "R after Bte: "<<R[lrp].size()<<endl;
if (DEBUG_OUTPUT>0) {
R[lrp].print();
cout << "D" << flush;

};
    // put predecessors on waiting list if bad states found
    // todo: just check predecessors whose entry sets intersect with the bad states
    if (found_bad)
    {
      found_any_bad=true;

      for (k=locations[lrp.first].in_trans.begin();k!=locations[lrp.first].in_trans.end();k++)
      {
//          indep_trans=!spec_aut.labels.contains(transitions[*k].label); // note: 0-transitions (tau) are not independent!
        if (check_all_labels || !dontchecklabs.contains(transitions[*k].label))
        {
          // follow only those transitions that lead to bad states
          cvs=get_restricted_entry_set(*k);
          cvs.add_space_dimensions_and_embed(spec_aut.dim);
          if (!cvs.is_disjoint_from(B))
          {
            // try all outgoing transitions in Q with the same label
            for (j=spec_aut.locations[lrp.second].in_trans.begin();j!=spec_aut.locations[lrp.second].in_trans.end();j++)
            {
              if (transitions[*k].label==spec_aut.transitions[*j].label)
              {
                // follow only those transitions that lead to bad states
                cvs=spec_aut.get_restricted_entry_set(*j);
                cvs.add_space_dimensions_and_embed(dim);
                cvs.dimension_move_assign(0,spec_aut.dim-1,dim);
                if (!cvs.is_disjoint_from(B))
                {
                  // add only those who are in the simulation
                  lrp2=location_ref_pair(transitions[*k].source_loc(),spec_aut.transitions[*j].source_loc());
                  if (R.find(lrp2)!=R.end())
                  {
                    if (!R[lrp2].is_empty())
                      waiting.add(lrp2);
                  };

                };  // end if
              }; // end if
            }; // end for
          }; // end if
        }; // end if
      }; // end for : trying joint transitions of P and Q
      // try all outgoing transitions in Q with the label 0
      for (j=spec_aut.locations[lrp.second].in_trans.begin();j!=spec_aut.locations[lrp.second].in_trans.end();j++)
      {
        if (spec_aut.transitions[*j].label==0)
        {
          // follow only those transitions that lead to bad states
          cvs=spec_aut.get_restricted_entry_set(*j);
          cvs.add_space_dimensions_and_embed(dim);
          cvs.dimension_move_assign(0,spec_aut.dim-1,dim);
          if (!cvs.is_disjoint_from(B))
          {
            // add only those who are in the simulation
            lrp2=location_ref_pair(lrp.first,spec_aut.transitions[*j].source_loc());
            if (R.find(lrp2)!=R.end())
            {
              if (!R[lrp2].is_empty())
                waiting.add(lrp2);
            };
          };  // end if
        }; // end if
      }; // end for
    };
if (DEBUG_OUTPUT>10) {
cout << endl << "R after iteration" << lrp << endl;
R[lrp].print();
};
if (DEBUG_OUTPUT>0) {
  sw.report_delta("After putting predecessors on waiting list");
};

    if (R[lrp].is_empty())
    {
      R.erase(lrp);
      // also take it off the waiting list
      waiting.remove(lrp);
    };
  };
  progress_dot_end();

  if (!get_ident_bisim)
    message(16300,"Simulation Relation converged after " + int2string(iter_count) + " iterations.");
  else
    message(16300,"Bisimulation Relation converged after "  + int2string(iter_count) + " iterations.");

  if (!found_any_bad)
    message(16300,"Found no bad states.");

//  cout << "Relation Size:" << endl;
//  R.print_size();
  R.message_size(16300);

//  R.print();

  return found_any_bad;
}

void
automaton::get_bisim_rel(state_relation& R, automaton& spec_aut, const clock_val_set& equiv_cvs)
{
  // For a bisimulation, make R symmetric
  bool convergence=false;
  clock_val_set equiv_cvsT=equiv_cvs;
  equiv_cvsT.dimension_move_assign(0,dim-1,spec_aut.dim);

  state_relation RT;

  while (!convergence)
  {
    get_sim_rel(R,spec_aut,equiv_cvs);  // turn R into a simulation relation for P<=Q

    RT=R.transpose(dim,spec_aut.dim);

    convergence=!spec_aut.get_sim_rel(RT,*this,equiv_cvsT);  // turn RT into a simulation relation for Q<=P
    if (!convergence)
      R=RT.transpose(spec_aut.dim,dim);
  };
}

void
automaton::reach_discrete_assign(state_relation& R, const clock_val_set& cvs_equiv, const automaton& spec_aut)
{
  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  trans_ref_set::iterator k,j;

  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent
  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  for (symb_states_type::const_iterator i=ini_states.begin(); i!=ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=spec_aut.ini_states.begin(); h!=spec_aut.ini_states.end(); ++h)
    {
//          R[location_ref_pair(i->first,h->first)]=cvs_equiv;
      waiting.add(location_ref_pair(i->first,h->first));
    };
  };

//      waiting=R.get_location_ref_pairs(); // prime waiting list with R

  while (!waiting.empty())
  {
    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

    R[lrp]=locations[lrp.first].invariant();
    R[lrp].concatenate_assign(spec_aut.locations[lrp.second].invariant());
    R[lrp].intersection_assign(cvs_equiv);
    R[lrp].join_convex_ccvs();


    // for all outgoing transitions in P
    for (k=locations[lrp.first].out_trans.begin();k!=locations[lrp.first].out_trans.end();k++)
    {
//          indep_trans=!spec_aut.labels.contains(transitions[*k].label); // note: 0-transitions (tau) are not independent!

      if (transitions[*k].label!=0)   // no tau
      {
        // try all outgoing transitions in Q with the same label
        for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
        {
          if (transitions[*k].label==spec_aut.transitions[*j].label)
          {
            lrp2=location_ref_pair(transitions[*k].target_loc(),spec_aut.transitions[*j].target_loc());
            // if not already visited
            if (R.find(lrp2)==R.end())
              waiting.add(lrp2);
          };
        };
      }
      else // tau-transition
      {
        lrp2=location_ref_pair(transitions[*k].target_loc(),lrp.second);

        // if not already visited
        if (R.find(lrp2)==R.end())
          waiting.add(lrp2);

      };
    };

    // now tau-transitions of Q
    for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)

    {
      if (spec_aut.transitions[*j].label==0)
      {
        lrp2=location_ref_pair(lrp.first,spec_aut.transitions[*j].target_loc());
        // if not already visited
        if (R.find(lrp2)==R.end())
          waiting.add(lrp2);
      };
    };
  }; // end while
}

void
automaton::reach_assign(state_relation& R, const clock_val_set& cvs_equiv, automaton& spec_aut, label_ref_set dontchecklabs, bool checktime, bool discrete_reach)
{
  stopwatch sw(256000,"reach_assign");
  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  trans_ref_set::iterator k,j;
  clock_val_set cvs;
  bool check_all_labels=dontchecklabs.empty();

  // get the reach sets

  symb_states_type reachP,reachQ;
	if (!discrete_reach)
	{
		reachP=get_reach_set(dontchecklabs,checktime);
		reachQ=spec_aut.get_reach_set(dontchecklabs,checktime);
	};
//reachP.print();
//reachQ.print();

  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent
  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  for (symb_states_type::const_iterator i=ini_states.begin(); i!=ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=spec_aut.ini_states.begin(); h!=spec_aut.ini_states.end(); ++h)
    {
//          R[location_ref_pair(i->first,h->first)]=cvs_equiv;
      waiting.add(location_ref_pair(i->first,h->first));
    };
  };

//      waiting=R.get_location_ref_pairs(); // prime waiting list with R

  while (!waiting.empty())
  {
    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

		if (!discrete_reach)
		{
			R[lrp]=reachP[lrp.first];
			R[lrp].concatenate_assign(reachQ[lrp.second]);
			R[lrp].intersection_assign(cvs_equiv);
			R[lrp].simplify();
		}
		else
			R[lrp]=cvs_equiv;
		
    // for all outgoing transitions in P
    for (k=locations[lrp.first].out_trans.begin();k!=locations[lrp.first].out_trans.end();k++)
    {
//          indep_trans=!spec_aut.labels.contains(transitions[*k].label); // note: 0-transitions (tau) are not independent!
      if (check_all_labels || !dontchecklabs.contains(transitions[*k].label))
      {
        // follow only those transitions that are reachable
//        if (!transitions[*k].exit_set.is_disjoint_from(reachP[lrp.first]))
        if (discrete_reach || !reachP[lrp.first].is_disjoint_from(get_restricted_exit_set(*k)))
        {
          if (spec_aut.labels.contains(transitions[*k].label))
          {
            // try all outgoing transitions in Q with the same label
            for (j=spec_aut.locations[lrp.second].out_trans.begin();j!=spec_aut.locations[lrp.second].out_trans.end();j++)
            {
              if (transitions[*k].label==spec_aut.transitions[*j].label)
              {

                // follow only those transitions that are reachable
  //              if (!spec_aut.transitions[*j].exit_set.is_disjoint_from(reachQ[lrp.second]))
                if (discrete_reach || !reachQ[lrp.second].is_disjoint_from(spec_aut.get_restricted_exit_set(*j)))
                {
                  lrp2=location_ref_pair(transitions[*k].target_loc(),spec_aut.transitions[*j].target_loc());
                  // if not already visited
                  if (R.find(lrp2)==R.end())
                    waiting.add(lrp2);
                }; // end if
              }; // end if
            }; // end for
          }
          else
          { // otherwise it's an indpendent transition
            lrp2=location_ref_pair(transitions[*k].target_loc(),lrp.second);
            // if not already visited
            if (R.find(lrp2)==R.end())
              waiting.add(lrp2);
          }; // end if
        }; // end if
      }; // end if
    }; // end for

  }; // end while
}


void
automaton::restrict_to_invariant(symb_states_type& states) const
{
  for (symb_states_type::iterator i=states.begin(); i!=states.end(); ++i)
  {
    i->second.intersection_assign(locations[i->first].invariant());
// aleady included:    i->second.remove_redundant();
    i->second.join_convex_ccvs();
    i->second.minimize_memory();
  };
  states.remove_empty();
}

state_relation automaton::prime_R(const clock_val_set& cvs_equiv, automaton& spec_aut, bool get_bisimimulation, label_ref_set dontchecklabs, bool checktime)
{
  state_relation R;

  // Prime R with discretely reachable states
//      reach_discrete_assign(R,cvs_equiv,ini_states,spec_aut,spec_aut.ini_states);
  if (PRIME_R_WITH_REACH)
  {
if (USE_CONVEX_HULL_FOR_PRIMING)
  message(16200,"Priming simulation relation (convex hull reach)");
else
  message(16200,"Priming simulation relation (exact reach)");

    bool dum=USE_CONVEX_HULL;
    if (USE_CONVEX_HULL_FOR_PRIMING)
      USE_CONVEX_HULL=true;
    reach_assign(R,cvs_equiv,spec_aut,dontchecklabs,checktime);
    USE_CONVEX_HULL=dum;
  }
  else if (PRIME_R_WITH_DISCRETE_REACH)
	{
		message(16200,"Assigning discretely reachable states to simulation relation");
		reach_assign(R,cvs_equiv,spec_aut,dontchecklabs,checktime,true);
	}
	else
	{
		message(16200,"Assigning equivalence relation to simulation relation");
		// initialize with universal sets
		for (location_ref i=0;i<locations.size();++i)
		{
			for (location_ref j=0;j<spec_aut.locations.size();++j)
			{
				R[location_ref_pair(i,j)]=cvs_equiv; // clock_val_set(dim+spec_aut.dim);
			};
		};
	};
  return R;
}

bool automaton::check_ini_in_rel(const clock_val_set& cvs_equiv, automaton& spec_aut, state_relation& R)
{
  // Find if for all states in ini_states there is a state in spec_ini_states and in R
  state_relation ini_rel;

if (DEBUG_OUTPUT>0) {
cout << "Concatenating ini states";
ini_states.print();
spec_aut.ini_states.print();
};
  for (symb_states_type::const_iterator i=ini_states.begin(); i!=ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=spec_aut.ini_states.begin(); h!=spec_aut.ini_states.end(); ++h)
    {
      ini_rel[location_ref_pair(i->first,h->first)]=i->second;
      ini_rel[location_ref_pair(i->first,h->first)].concatenate_assign(h->second);
      ini_rel[location_ref_pair(i->first,h->first)].intersection_assign(cvs_equiv);
    };
  };


//cout << "R:" << endl;
//R.print();
  // get good ini_states by intersecting with R
//cout << "Initial relation:" << endl;


//ini_rel.print();
if (DEBUG_OUTPUT>0) {
cout << "Interesting ini states and relation";
};
  ini_rel.intersection_assign(R);
//cout << "Ini in R:" << endl;
//ini_rel.print();
  // good u = the ones where there exists a v
  symb_states_type good_ini,bad_ini;
  good_ini=ini_rel.project_to_first(dim); // these are a subset of the good ini states
                                       // must subtract these from the ini_states in order to find bad states

//cout << "Good ini:" << endl;
//good_ini.print();

  bad_ini=ini_states;
  bad_ini.difference_assign(good_ini);

//cout << "Bad ini:" << endl;
//bad_ini.print();
  if (!bad_ini.is_empty())
    return false;
  else
    return true;
}


bool
automaton::is_simulation(const clock_val_set& cvs_equiv, automaton& spec_aut, bool get_bisimimulation, label_ref_set dontchecklabs, bool checktime, state_relation* pR)
{
  bool sim_result=true;
  stopwatch sw(2100,"is_simulation");



//message(4100,"Checking for simulation");
message(2100,"Checking " + name + " <= " + spec_aut.name);

  // ---------------------------------------------------------
  // fix labels
  // ---------------------------------------------------------
message(128100,"Fixing labels");

  map <string,label_ref> label_map;

  map_or_add_labels(label_map);
  spec_aut.map_or_add_labels(label_map);

  // until Sigma-Simulation is implemented:
  // add self-loops for labels that don't occur
  expand_labels(spec_aut.labels,spec_aut.label_name_to_label_ref_map);
  spec_aut.expand_labels(labels,label_name_to_label_ref_map);

  // restrict ini_states to invariants
  restrict_to_invariant(ini_states);
  spec_aut.restrict_to_invariant(spec_aut.ini_states);

  // Priming R
  state_relation R=prime_R(cvs_equiv, spec_aut, get_bisimimulation, dontchecklabs, checktime);

if (DEBUG_OUTPUT>0) {
message(16100,"Computing simulation relation");
};
  // Turn R into a simulation relation
  get_sim_rel(R,spec_aut,cvs_equiv,get_bisimimulation,dontchecklabs,checktime);

//R.print();

  // Find if for all states in ini_states there is a state in spec_ini_states and in R
  sim_result=check_ini_in_rel(cvs_equiv, spec_aut, R);

message(4100,"Ini states in simulation relation: " + (string)((sim_result) ? "yes" : "no"));

//      cout << endl << "Finished checking for simulation " << sim_result << ", " << iter_count << " reach iter," << fiter_count << " forb. iter."  << endl;
//cout << endl << "Finished checking for simulation. " << endl;

  if (pR != NULL)
  {
    *pR = R;
  };

  return sim_result;
}

bool
automaton::is_simulation(automaton& spec_aut, state_relation* pR, bool get_bisimimulation)
{
  clock_val_set equiv_cvs=get_cvs_equiv(spec_aut);
//  bool is_simulation(const clock_val_set& cvs_equiv, automaton& spec_aut, bool get_bisimimulation=false, label_ref_set dontchecklabs=empty_label_ref_set(), bool checktime=true, state_relation* pR=NULL);
  return is_simulation(equiv_cvs,spec_aut,get_bisimimulation,empty_label_ref_set(),ELAPSE_TIME,pR);
}


void
automaton::map_or_add_labels(map<string,label_ref> &label_map)
{
  // if the label is in label_map, remap its label_ref accordingly in *this,
  // otherwise add label with a new reference to label_map

//cout << "Remapping labels" << endl << flush;
  // Remap the label ids to a common set
  label_ref lab;
  string label_name;

  // build label maps
  // cycle through labels of automaton
  label_ref_set old_labels=labels;
  map <label_ref,label_ref> label_rep_map;
  map <string,label_ref> new_map;

  for (map <string,label_ref>::const_iterator kk=label_name_to_label_ref_map.begin();kk!=label_name_to_label_ref_map.end();++kk)
  {
    label_name=kk->first;
    // 1. Find the variable in the set so far
    if (label_map.find(label_name)!=label_map.end())
    {
      lab=label_map[label_name];
    }
    else
    // 2. If not found, add new label
    {
      if (kk->second!=0) // 0=tau gets special treatment
      {
        lab=1;
        //while (map_val_find(label_map.begin(),label_map.end(),lab)!=label_map.end())
        while (find(label_map,label_map.begin(),label_map.end(),lab)!=label_map.end())
        {
//          cout << lab << find(label_map,lab)->second << flush;
          ++lab;
        };
      }
      else
        lab=0;
      label_map.insert(make_pair(label_name,lab));
    };
    new_map[label_name]=lab;
    label_rep_map.insert(make_pair(kk->second,lab));
  };
  // Replace labels in automaton
  // Comment: Have to do this as a whole map in order to avoid ambiguities
  //          E.g., {1,2} with 1->2,2->1 would turn to {1} if done separately
  replace_labels(label_rep_map);
  label_name_to_label_ref_map=new_map;
//cout << "New labels:" << endl;
//print_labels();
}

