/***************************************************************************
                          clock_val_set.cpp  -  description
                             -------------------
    begin                : Fri Feb 6 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "clock_val_set.h"

bool CHECK_FOR_EMPTY_CCVS=true;

// -------------------------------------------------------------------------------
// Note: this is how an inherited class object can be assigned:
//  instead of "(*this)::time_elapse_type=te;};" use:
//  (*this).time_elapse_type::operator=(te);};

   
// -------------------------------------------------------------------------------
// clock_val_set: disjunction of convex_clock_val_set

  clock_val_set::clock_val_set() :dim((size_t) 1)
  {
    convex_clock_val_set poly(dim);
    ccvs_list.push_back(poly);
  }
  clock_val_set::clock_val_set(size_t d):dim(d) // Constructor: create a single, universe, convex_clock_val_set of dimension dim
  {
    convex_clock_val_set poly(dim);
    ccvs_list.push_back(poly);
    //cout << ccvs_list.size();
  }
  clock_val_set::clock_val_set(size_t d, Degenerate_Element kind):dim(d) // Constructor: create a single, universe, convex_clock_val_set of dimension dim
  {
    convex_clock_val_set poly(d,kind);
    ccvs_list.push_back(poly);
    //cout << ccvs_list.size();
  }
  clock_val_set::clock_val_set(const convex_clock_val_set &ccvs):dim(ccvs.space_dimension()) // Constructor: create a single, universe, convex_clock_val_set of dimension dim
  {
    ccvs_list.push_back(ccvs);
    //cout << ccvs_list.size();
  }
  /*
  clock_val_set(size_t d, const Constraint_List CL):dim(d)
  {
    convex_clock_val_set poly(d);
    ccvs_list.push_back(poly);
    add_constraint(CL));
    return cvs;
  };
  */
  clock_val_set::~clock_val_set() {}  // Destructor: default

  // other methods
  
  int 
  clock_val_set::get_memory() const
  {
    int res=0;
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      res+=i->get_memory();
    };
    return res;
  }
    
  bool
  clock_val_set::is_empty() const // check for emptiness
  {
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      if (!(i->is_empty())) return false;
    };
    return true; // if he makes it to here, they were all false
  }

  unsigned int
  clock_val_set::size() const
  {
    return ccvs_list.size();
  }
	
	size_t
	clock_val_set::get_real_dimension() const
	{
		// The real dimension is equal to dim - # of equality constraints
		size_t rd=0;
		size_t ccvs_rd=0;
		
    for (list<convex_clock_val_set>::const_iterator i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      ccvs_rd=i->get_real_dimension();
			if (ccvs_rd>rd)
				rd=ccvs_rd;
    };
		return rd;
	}

  void 
  clock_val_set::get_and_add_generators(Generator_List& l) const
  {
    for (list<convex_clock_val_set>::const_iterator i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->get_and_add_generators(l);
    };
  }

  // ----------------------------------------
  // Methods for modifying dimensions

  void
  clock_val_set::map_space_dimensions(const PFunction& pfunc)
  {
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      (*i).map_space_dimensions(pfunc);
    };
    dim=ccvs_list.begin()->space_dimension(); // might be safer
  }

  /*
  void
  clock_val_set::dimension_move_assign(const PFunction& pfunc)
  {
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      (*i).map_space_dimensions(pfunc);
    };
  };         */

  void
  clock_val_set::dimension_swap_assign(const dimension_type& x1, const dimension_type& x2, const dimension_type& y)
  {
    PFunction pfunc;
    pfunc.swap_assign(x1,x2,y,dim);
    map_space_dimensions(pfunc);
  }

  void
  clock_val_set::dimension_move_assign(const dimension_type& x1, const dimension_type& x2, const dimension_type& y)
  {
		stopwatch sw(1024000,"dimension_move_assign");
    PFunction pfunc;
    pfunc.move_assign(x1,x2,y,dim);
    map_space_dimensions(pfunc);
  }

  void
  clock_val_set::add_space_dimensions_and_embed(dimension_type m )
  {
		stopwatch sw(1024000,"add_space_dimensions_and_embed");
		if (m>0)
		{
			list<convex_clock_val_set>::iterator i;
			for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
			{
				(*i).add_space_dimensions_and_embed(m);
			};
			dim=ccvs_list.begin()->space_dimension(); // might be safer
		};
  }

  void
  clock_val_set::add_space_dimensions_and_embed_double(dimension_type m )
  {
		// for sets of the form (x_0, ..., x_(n-1),y_0, ..., y_(n-1))
		// Note: This implies that the number of dimensions is even
		
		if (dim % 2 == 0)
		{
         dimension_type olddim=dim;
         add_space_dimensions_and_embed(2*m);
         if (olddim>0)
            dimension_move_assign(olddim/2,olddim-1,(olddim/2)+m);
		}
		else
			throw_error("Odd number of dimensions in add_space_dimensions_and_embed_double");
	}
  
	void
  clock_val_set::add_space_dimensions_and_embed_before(dimension_type m )
  {
		stopwatch sw(1024000,"add_space_dimensions_and_embed_before");
		if (m>0)
		{
			dimension_type old_dim=dim;
			add_space_dimensions_and_embed(m);
			if (old_dim>0)
				dimension_move_assign(0,old_dim-1,m);
		};
  }

  void
  clock_val_set::add_space_dimensions_and_project(dimension_type m )
  {
		stopwatch sw(1024000,"add_space_dimensions_and_project");
		if (m>0)
		{
			list<convex_clock_val_set>::iterator i;
			for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
			{
				(*i).add_space_dimensions_and_project(m);
			};
//    dim=dim + m;
			dim=ccvs_list.begin()->space_dimension(); // might be safer
		};
  }

//   void
//   clock_val_set::remove_space_dimensions( const Variables_Set& to_be_removed)
//   {
// stopwatch sw(1024000,"remove_dimensions");
//     list<convex_clock_val_set>::iterator i;
//     for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
//     {
//       (*i).remove_space_dimensions(to_be_removed);
//     };
//     dim=ccvs_list.begin()->space_dimension(); // might be safer
// 
//     minimize_constraints();
//   }

  void
  clock_val_set::remove_space_dimensions( const clock_ref_set& to_be_removed)
  {
//stopwatch sw(1024000,"remove_dimensions");
//     Variables_Set vs;
//     for (clock_ref_set::const_iterator i=to_be_removed.begin(); i!= to_be_removed.end(); ++i)
//     {
//       vs.insert(Variable(*i));
//     };
//     remove_space_dimensions(to_be_removed);
stopwatch sw(1024000,"remove_dimensions");
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      (*i).remove_space_dimensions(to_be_removed);
    };
    dim=ccvs_list.begin()->space_dimension(); // might be safer
//    minimize_constraints();
  }

  void
  clock_val_set::remove_space_dimensions(const dimension_type& x1, const dimension_type& x2)
  {
stopwatch sw(1024000,"remove_dimensions");
    clock_ref_set vs;
    for (dimension_type i=x1; i<=x2; ++i)
    {
      vs.insert(i);
    };
    remove_space_dimensions(vs);
//     minimize_constraints();
  }
  
  void
  clock_val_set::concatenate_assign(const clock_val_set& cvs)
  {
//this->print();
//cout << ":" << dim << endl;
//cvs.print();
//cout << ":" << cvs.dim << endl;

    list<convex_clock_val_set>::iterator i = ccvs_list.begin();
    list<convex_clock_val_set>::const_iterator j;
    while (i != ccvs_list.end())
    {
      for (j = cvs.ccvs_list.begin(); j != cvs.ccvs_list.end(); ++j)
      {
        ccvs_list.push_front(*i); // insert a copy of ccvs
        ccvs_list.begin()->concatenate_assign(*j);
      };
      i=ccvs_list.erase(i);
    };

    if (ccvs_list.empty()) throw_error("Empty list at concatenate_assign");

    dim=ccvs_list.begin()->space_dimension(); // might be safer
//this->print();
//cout << ":" << dim << endl;
  }

  // --------------------------------------
	
	void 
	clock_val_set::swap(clock_val_set& cvs)
	{
		ccvs_list.swap(cvs.ccvs_list);
		dimension_type dum=dim;
		dim=cvs.dim;
		cvs.dim=dum;
	}
	

  void
  clock_val_set::add_constraint(const Constraint& cs)
  {
    if (cs.space_dimension()>dim)
		{
			cout << endl << *this << endl;
			cout << "Constraint (" << cs.space_dimension() <<"): " << cs << endl << flush;
      throw_error("Dimension incompatible at add_constraint");
		};
    
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			if (ADD_CONSTRAINT_MINIMIZED)
				(*i).add_constraint_and_minimize(cs);
			else
				(*i).add_constraint(cs);
    };
    remove_empty_ccvs(ccvs_list.begin(),ccvs_list.end());
  }

  void
  clock_val_set::add_constraint(const Constraint_List& CL)
  {
    Constraint_List::const_iterator i;
    for (i = CL.begin(); i != CL.end(); ++i)
    {
      add_constraint(*i);
    };
  }

  void
  clock_val_set::union_assign(const convex_clock_val_set& ccvs)
  {
    // to do: increase dimension appropriately
    if (!ccvs.is_empty()) // don't add redundant empty ccvs
    {
      ccvs_list.push_back(ccvs);
      // fix dim
      if (dim < ccvs.space_dimension()) dim = ccvs.space_dimension();

      if (ccvs_list.size()==2) // if first and only element is empty, it must be removed
      remove_empty_ccvs(ccvs_list.begin(),++ccvs_list.begin()); // check if first element is empty
    };
  }

  void
  clock_val_set::union_assign(const clock_val_set& cvs)
  {
    if (cvs.dim!=dim)
    {
      this->print();
      cvs.print();
      throw_error("Dimension incompatible at clock_val_set::union_assign");
    };

    list<convex_clock_val_set>::const_iterator i;
    for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
    {
      union_assign(*i);
    };
  }

  void
  clock_val_set::intersection_assign_from(const clock_val_set& cvs, const clock_val_set& cvs2)
  {
    // note: newcvs and *this must be two different objects!
    // assigns to *this the intersection of cvs and cvs2
    // intersection of two disjunctions = intersection of pairs
  stopwatch sw (1024000,"intersection_assign_from");

    dim=cvs.dim;
    ccvs_list.clear();

    list<convex_clock_val_set>::const_iterator i;
    list<convex_clock_val_set>::const_iterator j;
    for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
    {
      for (j = cvs2.ccvs_list.begin(); j != cvs2.ccvs_list.end(); ++j)
      {
        ccvs_list.push_front(*i);
				if (INTERSECT_MINIMIZED)
					ccvs_list.begin()->intersection_assign_and_minimize(*j);
				else
					ccvs_list.begin()->intersection_assign(*j);
      };
    };

    if (ccvs_list.empty()) throw_error("Empty list at intersection");

    if (CHECK_FOR_EMPTY_CCVS)
      remove_empty_ccvs(ccvs_list.begin(),ccvs_list.end());
if (sw.value() > 0.1) { if (DEBUG_OUTPUT>1)
  cout << endl << "Exceeding intersection time, took " << sw.value() << " for " << cvs.size() << " polyhedra" << endl << flush;
//  print();
//  cvs.print();
};
  }

  void
  clock_val_set::intersection_assign(const clock_val_set& cvs, bool adapt_dimensions)
  {
    // intersection of two disjunctions = intersection of pairs
    // need to make copy of ccvs_list for each of the elements
    // of the other list
  stopwatch sw (1024000,"intersection_assign");
if (DEBUG_OUTPUT>20) {
  cout << "Intersecting size " << size() << " with size " << cvs.size() << endl << flush;
}    
    if (cvs.dim!=dim && !adapt_dimensions)
    {
      this->print();
      cvs.print();
      throw_error("Dimension incompatible at clock_val_set::intersection_assign");
    }
		else
		{
			
			if (cvs.dim<dim)
			{
				clock_val_set cvs2(cvs);
				cvs2.add_space_dimensions_and_embed(dim-cvs.dim);
				intersection_assign(cvs2);
				return;
			}
			else
			{
				add_space_dimensions_and_embed(cvs.dim-dim);
			};
		};

    list<convex_clock_val_set>::iterator i = ccvs_list.begin();
    list<convex_clock_val_set>::const_iterator j;
    while (i != ccvs_list.end())
    {
      for (j = cvs.ccvs_list.begin(); j != cvs.ccvs_list.end(); ++j)
      {
        ccvs_list.push_front(*i); // insert a copy of ccvs
				if (INTERSECT_MINIMIZED)
					ccvs_list.begin()->intersection_assign_and_minimize(*j);
				else
					ccvs_list.begin()->intersection_assign(*j);
      }
      i=ccvs_list.erase(i);
    }

if (sw.value() > 0.1) { if (DEBUG_OUTPUT>1)
  cout << endl << "Exceeding intersection time, took " << sw.value() << " for " << cvs.size() << " polyhedra" << endl << flush;
//  print();
//  cvs.print();
};
    if (ccvs_list.empty()) throw_error("Empty list at intersection");

    if (CHECK_FOR_EMPTY_CCVS)
      remove_empty_ccvs(ccvs_list.begin(),ccvs_list.end());
      
    remove_redundant();
    
    //minimize_memory();
  }

  convex_clock_val_set
  clock_val_set::get_convex_hull() const
  {
    // replaces itself by its convex hull
    if (ccvs_list.size()>1)
    {
			convex_clock_val_set ccvs(*ccvs_list.begin());
      list<convex_clock_val_set>::const_iterator i = ++ccvs_list.begin();
      while (i != ccvs_list.end())
      {
        ccvs.poly_hull_assign_and_minimize(*i);
        ++i;
      };
			return ccvs;
    }
		else
			return *ccvs_list.begin();
  }

  void
  clock_val_set::convex_hull_assign()
  {
    // replaces itself by its convex hull
    if (ccvs_list.size()>1)
    {
      list<convex_clock_val_set>::iterator i = ccvs_list.begin();
      list<convex_clock_val_set>::iterator j = ccvs_list.begin();
      ++i;
      while (i != ccvs_list.end())
      {
        j->poly_hull_assign_and_minimize(*i);
        i=ccvs_list.erase(i);
      };
    };
  }

  void
  clock_val_set::convex_hull_assign(const clock_val_set& cvs)
  {
    list<convex_clock_val_set>::iterator i = ccvs_list.begin();
    list<convex_clock_val_set>::const_iterator j;
    for (j = cvs.ccvs_list.begin(); j != cvs.ccvs_list.end(); ++j)
    {
			if (!USE_CONSTRAINT_HULL)
				i->poly_hull_assign_and_minimize(*j);
			else
				i->constraint_hull_assign(*j);
    };
  }
	
  void
  clock_val_set::constraint_hull_assign(const clock_val_set& cvs)
  {
    list<convex_clock_val_set>::iterator i = ccvs_list.begin();
    list<convex_clock_val_set>::const_iterator j;
    for (j = cvs.ccvs_list.begin(); j != cvs.ccvs_list.end(); ++j)
    {
      i->constraint_hull_assign(*j);
    };
  }	

  void
  clock_val_set::remove_redundant()
  {
    remove_redundant(ccvs_list.begin(),ccvs_list.end());
  }

  void
  clock_val_set::remove_redundant(list<convex_clock_val_set>::iterator i, list<convex_clock_val_set>::iterator iend)
  {
    // remove empty ccvs if they are redundant, i.e. x or false = x
    // iend points behind the end of the last item to be checked
    list<convex_clock_val_set>::iterator j;
    bool found=false;
    while ((ccvs_list.size()>1) && (i != ccvs_list.end()) && (i != iend))
    {
      found=0;
      for (j = ccvs_list.begin(); j != ccvs_list.end(); ++j)
      {
        if ((i != j) && (j->contains(*i)))
        {
          found=true;
          break;
        };
      };
      if (found) i=ccvs_list.erase(i);
      else i++;
    };
  }

  void
  clock_val_set::remove_empty_ccvs(list<convex_clock_val_set>::iterator i, list<convex_clock_val_set>::iterator iend)
  {
    // remove empty ccvs if they are redundant, i.e. x or false = x
    // iend points behind the end of the last item to be checked
    while ((ccvs_list.size()>1) && (i != ccvs_list.end()) && (i != iend))
    {
      if ((*i).is_empty()) i=ccvs_list.erase(i);
      else i++;
    };
  }

  void
  clock_val_set::remove_empty_ccvs()
  {
    remove_empty_ccvs(ccvs_list.begin(),ccvs_list.end());
  }

  void
  clock_val_set::join_convex_ccvs()
  {
    // remove empty ccvs if they are redundant, i.e. x or false = x
    // iend points behind the end of the last item to be checked
    list<convex_clock_val_set>::iterator i,j;
    clock_val_set newcvs(dim,EMPTY); // create an empty cvs
    clock_val_set diffcvs(dim,EMPTY); // create an empty cvs
    convex_clock_val_set poly(dim,EMPTY);
    convex_clock_val_set poly1(dim,EMPTY);
    convex_clock_val_set poly2(dim,EMPTY);

//cout << "Before join_convex_ccvs: " << endl;
//print();

    bool found=false;
    i=ccvs_list.begin();
    while ((ccvs_list.size()>1) && (i != ccvs_list.end()))
    {
      found=false;

      poly1=*i;
      if (!i->is_topologically_closed())
        poly1.topological_closure_assign();

      j=i;
      ++j;
      while ((ccvs_list.size()>1) && (j != ccvs_list.end()) && !found)
      {
//        if ((j!=i) && (i->action == j->action) && (i->cost_fun == j-> cost_fun))
        if (j!=i)
        {
          poly=*i;

          // only test if they intersect at closure

          poly2=*j;
          if (!j->is_topologically_closed())
            poly2.topological_closure_assign();
          if (!poly1.is_disjoint_from(poly2))
          {
//            poly.poly_hull_assign(*j);
            poly.poly_hull_assign_and_minimize(*j);
            diffcvs=clock_val_set(poly);
            diffcvs.difference_assign(*i);
            // if difference is empty, both can be joined
            // replace i and j by poly
//            diffcvs.difference_assign(*j);  // to do: could only test if difference is empty
//            if (diffcvs.is_empty())
            if (diffcvs.difference_is_empty(*j))
            {
              found=true;
              (*i)=poly;
              poly1=*i;
              if (!i->is_topologically_closed())
                poly1.topological_closure_assign();
              j=ccvs_list.erase(j);
            };
          };
        };
        if (!found)
        {
          if (j != ccvs_list.end()) ++j;
        }
        else
        {//j=i;
          //++j;
          j=ccvs_list.begin(); // have to check all of them again
          found=false;
        };
      };
      i++;
    };
//cout << "After join_convex_ccvs: " << endl;
//print();
  }

  void
  clock_val_set::minimize_constraints()
  {
    for (list<convex_clock_val_set>::iterator i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->minimized_constraints();
    };
  }

  void
  clock_val_set::minimize_memory()
  {
    for (list<convex_clock_val_set>::iterator i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->minimize_memory();
    };
  }
    
  void
  clock_val_set::simplify()
  {
stopwatch sw(2048000,"simplify");
//  cout << "Simplifying size " << size() << endl << flush;
    minimize_constraints();
    remove_redundant();
    join_convex_ccvs();
 if (DEBUG_OUTPUT>1 && sw.value() > 0.5) 
  cout << endl << "Exceeding time in simplify, took " << sw.value() << " for " << size() << " polyhedra" << endl << flush; 
		
  }

  void
  clock_val_set::difference_assign(const convex_clock_val_set& ccvs)
  {
    // Creates a disjoint cvs not containing any points in ccvs
    // With B=(b1 & ... & bm):
    // A\B=(!b1 & A) | (b1 & !b2 & A) | ... | (b1 & ... & b(m-1) & !bm & A)
    if (!ccvs.is_empty())
    {
    clock_val_set Acvs(dim,EMPTY); // create a copy of myself
    clock_val_set A2cvs=*this; // create a copy of myself
//    clock_val_set newcvs(dim,EMPTY); // create an empty cvs
    convex_clock_val_set c;

//cout << "Take " << ccvs << " away from " << endl;
//this->print();

//cout << "TickD1" << endl << flush;
//print();
//cout << "Take away" << endl << flush;
//ccvs.print();
//cout << flush;
    Acvs.ccvs_list.clear();
    // remove from Acvs the ccvs that are disjoint from ccvs or contained in it
    list<convex_clock_val_set>::iterator i=ccvs_list.begin();
    while (i!=ccvs_list.end())
    {
      if (!i->is_disjoint_from(ccvs))
      {
        if (!ccvs.contains(*i)) // if it's contained, just delete it
        {
          Acvs.ccvs_list.push_back(*i);
        };
        i=ccvs_list.erase(i);
      }
      else
        ++i;
    };
//cout << "TickD2" << endl << flush;
    if (!Acvs.ccvs_list.empty())
    {
      Constraint_List CL=Constraint_System_convert_equalities(ccvs.minimized_constraints()); // the list of constraints that have to be added
      for (Constraint_List::iterator j = CL.begin(); (j != CL.end()) && !Acvs.is_empty(); ++j)
      {
//cout << "TickD2.1" << endl << flush;
        A2cvs=Acvs;
        A2cvs.add_constraint(complement(*j));
//      newcvs.union_assign(A2cvs);   // contains remove_empty
        ccvs_list.insert(ccvs_list.end(),A2cvs.ccvs_list.begin(),A2cvs.ccvs_list.end());   // contains remove_empty
//cout << "TickD2.2" << endl << flush;
        Acvs.add_constraint(*j);  // contains remove_empty
//cout << "TickD2.3" << endl << flush;
      };
//    remove_empty_ccvs(newcvs.ccvs_list.begin(),++(newcvs.ccvs_list.begin()));
//    cout << "removed Empty cvs:";
//    newcvs.print();
//    cout << "!";
//    this->ccvs_list=newcvs.ccvs_list;
      remove_empty_ccvs(ccvs_list.begin(),ccvs_list.end());
      remove_redundant();
    };
    // check if ccvs_list wasn't emptied
//cout << "TickD3" << endl << flush;
    if (ccvs_list.empty())
    {
      ccvs_list.push_back(convex_clock_val_set(dim,EMPTY));
    };
//cout << "Differenced:" << endl;
//this->print();
//cout << "TickD4" << endl << flush;
    };
  }

  void
  clock_val_set::difference_assign(const clock_val_set& cvs)
  {
    // to do: do a check for disjointness first
    if (cvs.dim!=dim)
      throw_error("Incompatible dimension in difference_assign");
    
    list<convex_clock_val_set>::const_iterator i;
    for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
    {
      difference_assign(*i);
//      print_constraints(complement(i->constraints()));
    };
//    remove_empty_ccvs(ccvs_list.begin(),++ccvs_list.begin()); // check if first element is empty
  }


  bool
  clock_val_set::difference_is_empty(const convex_clock_val_set& ccvs)
  {
    // ATTENTION: Modifies *this, and *this is useless afterwards

    // Creates a disjoint cvs not containing any points in ccvs
    // With B=(b1 & ... & bm):
    // A\B=(!b1 & A) | (b1 & !b2 & A) | ... | (b1 & ... & b(m-1) & !bm & A)
    if (!ccvs.is_empty())
    {
      clock_val_set Acvs(dim,EMPTY); // create a copy of myself
      clock_val_set A2cvs=*this; // create a copy of myself
      convex_clock_val_set c;

      Acvs.ccvs_list.clear();
      // remove from Acvs the ccvs that are disjoint from ccvs or contained in it
      list<convex_clock_val_set>::iterator i=ccvs_list.begin();
      while (i!=ccvs_list.end())
      {
        if (!i->is_disjoint_from(ccvs))
        {
          if (!ccvs.contains(*i)) // if it's contained, just delete it
          {
            Acvs.ccvs_list.push_back(*i);
          };
          i=ccvs_list.erase(i);
        }
        else
          return false;
      };
      if (!Acvs.ccvs_list.empty())
      {
        Constraint_List CL=Constraint_System_convert_equalities(ccvs.minimized_constraints()); // the list of constraints that have to be added
        for (Constraint_List::iterator j = CL.begin(); (j != CL.end()) && !Acvs.is_empty(); ++j)
        {
          A2cvs=Acvs;
          A2cvs.add_constraint(complement(*j));
          if (!A2cvs.is_empty())
            return false;
          ccvs_list.insert(ccvs_list.end(),A2cvs.ccvs_list.begin(),A2cvs.ccvs_list.end());   // contains remove_empty
          Acvs.add_constraint(*j);  // contains remove_empty
        };
        remove_empty_ccvs(ccvs_list.begin(),ccvs_list.end());
      };
      // check if ccvs_list wasn't emptied
      if (ccvs_list.empty())
      {
        ccvs_list.push_back(convex_clock_val_set(dim,EMPTY));
      };
    };
    return is_empty();
  }

  void
  clock_val_set::negate()
  {
    clock_val_set newcvs(dim);
    newcvs.difference_assign(*this);
    *this=newcvs;
  }

  bool
  clock_val_set::is_disjoint() const
  {
    // test whether the ccvs of *this are disjoint
    convex_clock_val_set ccvs(dim);
    list<convex_clock_val_set>::const_iterator i,j,iend;
    if (ccvs_list.size() > 1)
    {
      i = ccvs_list.begin();
      iend = ccvs_list.end();
      --iend;
      while (i != iend)
      {
        j=i;
        ++j;
        while (j != ccvs_list.end())
        {
          ccvs=(*i);
          ccvs.intersection_assign(*j);
          if (!ccvs.is_empty()) // {print_constraints(*i); print_constraints(*j); print_constraints(ccvs);};
            return false;
          ++j;
        };
        ++i;
      };
    }
    else
      return true;
    return true;
  }


  bool
  clock_val_set::is_disjoint_from(const clock_val_set& cvs) const
  {
    bool found=false;
    convex_clock_val_set ccvs;

    list<convex_clock_val_set>::const_iterator i = ccvs_list.begin();
    list<convex_clock_val_set>::const_iterator j;
    while ((i != ccvs_list.end()) && (!found))
    {
      for (j = cvs.ccvs_list.begin(); j != cvs.ccvs_list.end(); ++j)
      {
        ccvs=*i;
        ccvs.intersection_assign(*j);
        if (!ccvs.is_empty())
        {
          found=true;
          break;
        };
      };
      ++i;
    };

    return !found;
  }
	
	bool
	clock_val_set::splits(const Constraint& con) const
	{
		// Return true if the constraint as well as its complement has a non-empty intersection with *this
		if (is_disjoint_from(clock_val_set(convex_clock_val_set(con))))
			return false;
		if (is_disjoint_from(clock_val_set(convex_clock_val_set(inequality_complement(con)))))
			return false;
			
		return true;
	}

  bool
  clock_val_set::contains(clock_val_set cvs) const
  {
    // does *this contain cvs
//this->print();
//cvs.print();

    cvs.difference_assign(*this);
    if (cvs.is_empty())
    {
      return true;
    }
    else
      return false;
  }

  bool
  clock_val_set::contains_return_others(clock_val_set& cvs) const
  {
    // does *this contain cvs
    // simple check: are all the ccvs of cvs each contained in one of the ccvs of *this

//this->print();
//cvs.print();

if (CHEAP_CONTAIN_RETURN_OTHERS)
{
    list<convex_clock_val_set>::const_iterator i;
    list<convex_clock_val_set>::iterator j;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      j = cvs.ccvs_list.begin();
      while (j != cvs.ccvs_list.end())
      {
        if (i->contains(*j))
          j=cvs.ccvs_list.erase(j);
        else
          ++j;
      };
    };
}
else
{
  cvs.difference_assign(*this);
  cvs.simplify();
};

//cout << cvs.is_empty();
//pause_key();
    if (cvs.is_empty())
    {
      return true;
    }
    else
      return false;
  }

  bool
  clock_val_set::contains_simple(clock_val_set cvs) const
  {
    // does *this contain cvs
    // simple check: are all the ccvs of cvs each contained in one of the ccvs of *this

//this->print();
//cvs.print();

    list<convex_clock_val_set>::const_iterator i;
    list<convex_clock_val_set>::iterator j;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      j = cvs.ccvs_list.begin();
      while (j != cvs.ccvs_list.end())
      {
        if (i->contains(*j))
          j=cvs.ccvs_list.erase(j);
        else
          ++j;
      };
    };

//cout << cvs.is_empty();
//pause_key();
    if (cvs.is_empty())
    {
      return true;
    }
    else
      return false;
  }

  void
  clock_val_set::clock_free(const clock_ref_set& r)
  {
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->clock_free(r);
    };
  }

  void
  clock_val_set::clock_reset(const clock_ref_set& r)
  {
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->clock_reset(r);
    };
  }

  void
  clock_val_set::time_elapse_assign(const convex_clock_val_set &tp)
  {
    // time elapse
    // attention: not disjunct
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->time_elapse_assign(tp);
    };
  }

  void
  clock_val_set::time_elapse_assign(const convex_clock_val_set &tp, const clock_val_set& inv)
  {
    // time elapse respecting the invariant inv
    // to do: this is not implemented yet!
    // attention: not disjunct

    // prime with the intersection
    intersection_assign(inv);

    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->time_elapse_assign(tp);
    };

    intersection_assign(inv);
  }
  
  void
  clock_val_set::topological_closure_assign()
  {
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->topological_closure_assign();
    };
  }
    
  void 
  clock_val_set::topological_interior_assign()
  {
      if (ccvs_list.size()==1)
      {
         // it's convex, so just transform nonstrict inequalities into strict inequalities
         Constraint_List cl=convex_clock_val_set_to_Constraint_List(*ccvs_list.begin());
         cl.strictify();
         *this=clock_val_set(convex_clock_val_set(cl,dim));
      }
      else
      {
         clock_val_set cvs(*this);
         cvs.negate();
         cvs.topological_closure_assign();
         cvs.simplify();
         cvs.negate();
         cvs.simplify();
         *this=cvs;
      }
  }  

  convex_clock_val_set
  clock_val_set::append(const convex_clock_val_set& ccvs)
  {
    // check if this is already contained in the waiting list
    list<convex_clock_val_set>::iterator i=ccvs_list.begin();
    bool found=false;
    bool erased=false;

    while (!found && i!=ccvs_list.end())
    {
      erased=false;
      if (!ccvs.is_disjoint_from(*i))
      {
        // test if ccvs is contained in i->second, or the other way around
        if (i->contains(ccvs))
          found=true;

        else if (ccvs.contains(*i))
        {
          // replace *i with ccvs
//          *i=ccvs;
//          found=true;
// remove that bit
i=ccvs_list.erase(i);
erased=true;
        }

      };
      if (!erased)
        ++i;
    };

    if (!found)
    {
      ccvs_list.push_back(ccvs);
      return ccvs;
    }
    else return convex_clock_val_set(dim,EMPTY);
  }


  clock_val_set
  clock_val_set::append(const clock_val_set &cvs)
  {
    // returns the part of cvs that was not ppreviously contained in *this
    clock_val_set newcvs(dim,EMPTY); // create an empty cvs
    convex_clock_val_set ccvs;

    list<convex_clock_val_set>::const_iterator i;
    for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
    {
      ccvs=(*this).append(*i);
      newcvs.ccvs_list.push_back(ccvs);
    };

    newcvs.remove_empty_ccvs();

//    join_convex_ccvs(); // new gf

    return newcvs;
  }

  clock_val_set
  clock_val_set::disj_union_assign(const convex_clock_val_set &ccvs)
  {
    // Disjunct union with ccvs
    // returns the actual new bits added to *this

    clock_val_set cvs(ccvs);

    list<convex_clock_val_set>::iterator i,j;
    clock_val_set diffcvs(dim);
    convex_clock_val_set intersection;

    j = ccvs_list.begin();
    while (j != ccvs_list.end())
    {
      i = cvs.ccvs_list.begin();
      while (i != cvs.ccvs_list.end())
      {
        intersection=*i;
				if (INTERSECT_MINIMIZED)
					intersection.intersection_assign_and_minimize(*j);
				else
					intersection.intersection_assign(*j);
        
        if (!intersection.is_empty())
        {
          // take away part from i
          diffcvs=clock_val_set(*i);
          diffcvs.difference_assign(intersection); // now take away what's already in j
          // add the result to the new cvs
          cvs.ccvs_list.insert(i,diffcvs.ccvs_list.begin(),diffcvs.ccvs_list.end());
          // delete the old bit and increase the pointer
          i=cvs.ccvs_list.erase(i);
        }
        if  (i != cvs.ccvs_list.end()) ++i;
      };
      ++j;
    };

    ccvs_list.insert(ccvs_list.end(),cvs.ccvs_list.begin(),cvs.ccvs_list.end());
    remove_empty_ccvs();

    return cvs;
  }

  clock_val_set
  clock_val_set::disj_union_assign(const clock_val_set &cvs)
  {
    // disjunct union of *this and cvs
    // returns the actual new bits added to *this
    clock_val_set newcvs(dim,EMPTY); // create an empty cvs
    clock_val_set newcvs2(dim,EMPTY);

    list<convex_clock_val_set>::const_iterator i;
    for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
    {
      newcvs2=disj_union_assign(*i);
      newcvs.ccvs_list.insert(newcvs.ccvs_list.end(),newcvs2.ccvs_list.begin(),newcvs2.ccvs_list.end());
    };

    newcvs.remove_empty_ccvs();

//    join_convex_ccvs(); // new gf

    return newcvs;
  }

  bool
  clock_val_set::operator==(const clock_val_set& cvs) const
  {
    return (contains(cvs) && cvs.contains(*this));
  }
	
	void 
	clock_val_set::set_empty()
	{
    clock_val_set newcvs(dim,EMPTY); // create an empty cvs
		*this=newcvs;
	}
	
	void
	clock_val_set::raise_lower_bound(dimension_type k, bool closed, const Integer& n, const Integer& d)
	{
		if (closed)
			add_constraint(0*Variable(dim-1)+d*Variable(k) >= n);
		else
			add_constraint(0*Variable(dim-1)+d*Variable(k) > n);
	}
			
	void									
  clock_val_set::lower_upper_bound(dimension_type k, bool closed, const Integer& n, const Integer& d)
	{
		if (closed)
			add_constraint(0*Variable(dim-1)+d*Variable(k) <= n);
		else
			add_constraint(0*Variable(dim-1)+d*Variable(k) < n);
	}
												
	bool
	clock_val_set::maximize(const Linear_Expression &expr, Integer &sup_n, Integer &sup_d, bool &maximum) const				
	{
		// Returns true if and only if *this is not empty and expr is bounded from above in *this, in which case the supremum value is computed. 
		bool empty=true;
		bool bounded=true;
		maximum=false;
		bool ccvs_maximum=false;
		Integer ccvs_sup_n;
		Integer ccvs_sup_d;
		bool first=true;
		
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			if (!i->is_empty())
			{
				empty=false;
				bounded=bounded && i->maximize(expr,ccvs_sup_n,ccvs_sup_d,ccvs_maximum); // it's only bounded if it's bounded in all of them
				if (first)
				{
					first=false;
					sup_n=ccvs_sup_n;
					sup_d=ccvs_sup_d;
				};
				if (ccvs_sup_n*sup_d>sup_n*ccvs_sup_d)
				{
					sup_n=ccvs_sup_n;
					sup_d=ccvs_sup_d;
					maximum=ccvs_maximum;
				}
				else if (ccvs_sup_n*sup_d==sup_n*ccvs_sup_d)
				{
					maximum=maximum || ccvs_maximum;					
				};
			};
    };
		
		return !empty && bounded;
	}

	bool
	clock_val_set::minimize(const Linear_Expression &expr, Integer &inf_n, Integer &inf_d, bool &minimum) const				
	{
		// Returns true if and only if *this is not empty and expr is bounded from below in *this, in which case the infimum value is computed.
		bool empty=true;
		bool bounded=true;
		minimum=false;
		bool ccvs_minimum=false;
		Integer ccvs_inf_n;
		Integer ccvs_inf_d;
		bool first=true;
		
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			if (!i->is_empty())
			{
				empty=false;
				bounded=bounded && i->minimize(expr,ccvs_inf_n,ccvs_inf_d,ccvs_minimum); // it's only bounded if it's bounded in all of them
				if (first)
				{
					first=false;
					inf_n=ccvs_inf_n;
					inf_d=ccvs_inf_d;
				};
				if (ccvs_inf_n*inf_d<inf_n*ccvs_inf_d)
				{
					inf_n=ccvs_inf_n;
					inf_d=ccvs_inf_d;
					minimum=ccvs_minimum;
				}
				else if (ccvs_inf_n*inf_d==inf_n*ccvs_inf_d)
				{
					minimum=minimum || ccvs_minimum;					
				};
			};
    };
		
		return !empty && bounded;
	}
	
	bool
	clock_val_set::limit_significant_bits(int bits) 
	{
	  bool changed=false;
		bool changed_now=false;
		
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			changed_now=i->limit_significant_bits(bits);
			changed = changed_now || changed;
		};
		return true; // todo: don't remember what the return was for
	}

	
  int 
	clock_val_set::max_bit_size() const
	{
		// returns the maximum number of constraints in any of the ccvs
	  int m=0;
		int dum;
		
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			dum=i->max_bit_size();
			if (dum>m)
				m=dum;
		};
		return m; 
	}
			
  int 
	clock_val_set::max_constraint_size() const
	{
		// returns the maximum number of constraints in any of the ccvs
	  int m=0;
		int dum;
		
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			dum=i->constraint_size();
			if (dum>m)
				m=dum;
		};
		return m; 
	}
	
  int 
	clock_val_set::constraint_size() const
	{
	  // returns the sum of the constraints of the ccvs
	  int m=0;
		
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			m+=i->constraint_size();
		};
		return m; 
	}
	
	bool 
	clock_val_set::limit_constraints(int n, int bits)
	{
		// Try to reduce the number of constraints to n, and the number of bits to bits
		if (n>0)
		{
			bool changed=false;
			bool changed_now=false;
			
			list<convex_clock_val_set>::iterator i;
			for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
			{
				changed_now=i->limit_constraints(n,bits);
				changed = changed_now || changed;
			};
			
			return changed;
		}
		else
			return false;
	}
	
	
	bool 
	clock_val_set::limit_constraints_or_bits(int n, int bits)
	{
		// Try to reduce the number of constraints to n, and the number of bits to bits
//cout << n << " test max bit size " << max_bit_size() << " of " << ccvs_list.size() << endl;		
		if (n>0 || bits>0)
		{
			bool changed=false;
			bool changed_now=false;
			
			list<convex_clock_val_set>::iterator i;
			for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
			{
				changed_now=i->limit_constraints(n,bits);
				if (!changed_now)
					changed_now=i->limit_significant_bits(bits);

				changed = changed_now || changed;
			};
			
//cout << "max bit size " << max_bit_size() << " of " << ccvs_list.size() << endl;
			
			return changed;
		}
		else
			return false;
	}
	
	void
	clock_val_set::ccvs_shrink_bounding_box(clock_val_set& cvs)
	{
		// Create a cvs containing the bounding boxes of the ccvs of *this.ccvs_list
		cvs=clock_val_set(dim,EMPTY); // create an empty cvs
		
		convex_clock_val_set ccvs(dim);
		
    list<convex_clock_val_set>::iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
			ccvs=convex_clock_val_set(dim);
			i->shrink_bounding_box(ccvs);
			cvs.union_assign(ccvs);
		};	
	}

	Rational
	clock_val_set::get_diameter()
	{
		clock_val_set cvs;
		ccvs_shrink_bounding_box(cvs);
		
		// for each variable, find max and min
		Integer v_max_n,v_max_d,v_min_n,v_min_d;
		Rational v_max,v_min;		
		Rational v;
		Rational d_max(0);

		bool first;
    list<convex_clock_val_set>::iterator it;
		Constraint_System cs;

		for (dimension_type i=0;i<dim;++i)
		{
			// Find min and max for variable i
			first=true;
			for (it = ccvs_list.begin(); it != ccvs_list.end(); ++it)
			{
				cs=it->constraints();
				for (Constraint_System::const_iterator j=cs.begin();j!=cs.end();++j)
				{
					// assume they are rectangulaer constraints
					// (which they should be, since these are bounding boxes)
					if (j->coefficient(Variable(i))!=0)
					{
						v=Rational(-j->inhomogeneous_term(),j->coefficient(Variable(i)));
						if (first || v<v_min)
							v_min=v;
						if (first || v>v_max)
							v_max=v;
						if (first)
							first=false;
					};
				};
			};	
			v=v_max-v_min;
			if (v>d_max)
				d_max=v;
		};
		return d_max;
	};
  
	void
  clock_val_set::print() const
  {
    list<convex_clock_val_set>::const_iterator i;
    int counter=0;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      cout << ++counter << "(" << i->space_dimension() << ")"<<": ";
      cout << *i << endl;
    };
  }

  void
  clock_val_set::print(const variable_id_map& vnvec) const
  {
    list<convex_clock_val_set>::const_iterator i;
    int counter=0;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
//      cout << ++counter << "(" << i->space_dimension() << ")"<<": ";
      cout << ++counter << ": ";
      i->print(vnvec);
      cout << endl;
    };
  }

  void
  clock_val_set::print_phaver(ostream& s, const variable_id_map& vnvec) const
  {
  		// Print in a from that can be parsed by PHAVer
    list<convex_clock_val_set>::const_iterator i;
	 
	 if (ccvs_list.size()>1)
	 	s << "(";
    i = ccvs_list.begin(); 
	 while (i != ccvs_list.end())
    {
      i->print_phaver(s,vnvec);
      //cout << endl;
		++i;
		if (i != ccvs_list.end())
			s << " | ";
    };
	 if (ccvs_list.size()>1)
	 	s << ")";
  }
      
  void
  clock_val_set::print_gen_fp_raw(ostream& s) const
  {
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->print_gen_fp_raw(s);
    };
  }

  void
  clock_val_set::print_con_fp_raw(ostream& s) const
  {
    list<convex_clock_val_set>::const_iterator i;
    for (i = ccvs_list.begin(); i != ccvs_list.end(); ++i)
    {
      i->print_con_fp_raw(s);
    };
  }

clock_val_set zero_cvs(const clock_dim_type& dim)
{
   clock_val_set zero_cvs(dim);
   for (unsigned int ii=0; ii!= dim; ++ii)
      zero_cvs.add_constraint(Variable(ii)==0*Variable(0));
   return zero_cvs;
}

void print_constraints(const clock_val_set& cvs)
{
  list<convex_clock_val_set>::const_iterator i;
  int counter=0;
  for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
  {
    cout << ++counter <<": ";
    print_constraints(*i);
  };
}

// -------------------------

std::ostream&
operator<<( std::ostream& os, const clock_val_set &c )
  {
    list<convex_clock_val_set>::const_iterator i;
    int counter=0;
    for (i = c.ccvs_list.begin(); i != c.ccvs_list.end(); ++i)
    {
//      cout << ++counter << "(" << i->space_dimension() << ")"<<": ";
			cout << ++counter << "(" << i->space_dimension() << ")"<<": ";
      os << *i;
      os << endl;
		};
    return os;
  }

clock_val_set clock_val_set_complement(size_t dim, const Constraint& cs)
{
  clock_val_set cvs(dim);
  Linear_Expression e = Constraint2Linear_Expression(&cs);
  if (cs.is_equality())
  {
    clock_val_set cvs2(cvs);
    cvs2.add_constraint(e<0);
    cvs.add_constraint(e>0);
    cvs.union_assign(cvs2);
  }
  else
  {
    if (cs.is_strict_inequality())
      cvs.add_constraint(e <= 0);
    else
      cvs.add_constraint(e < 0);
  };
  return cvs;
}

clock_val_set complement(const convex_clock_val_set& ccvs)
{
  // utility function: replace each (in)equality by its complement
  // Comment: This results in a list of constraints that's not a Constraint_System.
  clock_val_set cvs(ccvs.space_dimension(),EMPTY);
  convex_clock_val_set x(ccvs.space_dimension()),univ(ccvs.space_dimension());

  Constraint_System cs;
  cs=ccvs.minimized_constraints();
  Constraint_System::const_iterator i;
  for (i = cs.begin(); i != cs.end(); i++)
  {
    x=univ;
    Linear_Expression e = Constraint2Linear_Expression(&(*i));
    if (i->is_equality())
    {
      x.add_constraint(e<0);
      cvs.union_assign(x);
      x=univ;
      x.add_constraint(e>0);
    }
    else
    {
      if (i->is_strict_inequality())
        x.add_constraint(e <= 0);
      else
        x.add_constraint(e < 0);
    };
    cvs.union_assign(x);
  };
  return cvs;
}

clock_val_set complement(const clock_val_set& cvs)
{
  clock_val_set cvs2(cvs.dim);

  list<convex_clock_val_set>::const_iterator i;
  for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
  {
    cvs2.intersection_assign(complement(*i));
  };
  return cvs2;
}

// -------------------------

clock_val_set clock_ref_set_to_clock_val_set(const clock_ref_set& crs,const size_t& dim, const clock_ref_set& vars)
{
  // Create a transition relation over a set of variables 0..(dim-1):
  // If variable i is in the reset set crs, then (dim+i)==0.
  // Otherwise if i is in vars, then (i)==(dim+i), i.e. the variable is unchanged if it is in vars.
  clock_val_set cvs(2*dim);
  for (clock_ref i=0;i<dim;++i)
    {
      if (crs.contains(i))
        cvs.add_constraint(Variable(dim+i)==0);
      else
        if (vars.contains(i))
          cvs.add_constraint(Variable(i)==Variable(dim+i));
    };
  return cvs;
}

// -------------------------

clock_val_set identity_trans_clock_val_set(const size_t& dim)
{
  // Create a transition relation over a set of variables 0..(dim-1):
  // v(i)==v(dim+i), i.e. the variable is unchanged if it is in vars.
	// The returned cvs is of dimension 2*dim.
  clock_val_set cvs(2*dim);
  for (clock_ref i=0;i<dim;++i)
  {
    cvs.add_constraint(Variable(i)==Variable(dim+i));
  };
  return cvs;
}

// -----------------------------------

convex_clock_val_set cvs_to_ccvs(const clock_val_set& cvs)
	{ 
		return *(cvs.ccvs_list.begin());
	}


void add_cvs_to_double_point_list(const clock_val_set& cvs,double_point_list& pl)
{
  // add the vertices of cvs to pl
  // ATTENTION: pl is not cleared, points will be added!
  
 Generator_List gen_list;
 cvs.get_and_add_generators(gen_list);
 add_Generator_List_to_double_point_list(gen_list,pl);
}

// -------------------------------------------

bool is_time_relevant(const Constraint& cs, const convex_clock_val_set& tp) 
{
  // Returns whether the points in tp are outside of cs',
	// where cs' is cs without its homogenous term.
	// In case tp contains zero, it is substracted first.
	
  clock_val_set cvs(tp.space_dimension()),cvs2(tp);
//  Constraint_System cons=tp.minimized_constraints();
//  convex_clock_val_set ccvs(cons);
//  cvs2=clock_val_set(ccvs);
  cvs=clock_val_set_complement(tp.space_dimension(),constraint_homogenous_part(cs));
//  cvs.intersection_assign(cvs2);
	//cvs2=clock_val_set(tp);
  if (cvs.is_disjoint_from(cvs2))
    return false;
  else
	{
		// todo: add check whether cs is closed or not
		// make sure it's not just the zero
		clock_val_set z=zero_cvs(tp.space_dimension());
		if (!z.is_disjoint_from(cvs2))
			cvs.difference_assign(z);
		if (cvs.is_disjoint_from(cvs2))
			return false;
		else
			return true;
	};
}

clock_val_set time_relevant_faces(clock_val_set cvs, convex_clock_val_set& tp)
{
  clock_val_set cvs2(cvs.dim,EMPTY);
  Constraint_System cs,cs2;

  list<convex_clock_val_set>::const_iterator i;
  Constraint_System::const_iterator j;

  Constraint_System::const_iterator k;
  for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
  {
    cs=i->minimized_constraints();
    for (j = cs.begin(); j!= cs.end(); ++j)
    {
      if (j->is_strict_inequality()) // only open faces
      {
      // test if face is time relevant
      if (is_time_relevant(*j,tp))
      {
        // make a new consys where replacing *j by an equality
        cs2=Constraint_System(constraint_to_equality(*j));
        for (k = cs.begin(); k!= cs.end(); ++k)
        {

          if (k!=j)
            cs2.insert(*k);
        };
        cvs2.union_assign(convex_clock_val_set(cs2));
      };
      };
    };
  };
  return cvs2;
}

clock_val_set closed_faces(clock_val_set cvs)
{
  clock_val_set cvs2(cvs.dim,EMPTY);
  Constraint_System cs,cs2;


  list<convex_clock_val_set>::const_iterator i;
  Constraint_System::const_iterator j;
  Constraint_System::const_iterator k;
  for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
  {
    cs=i->minimized_constraints();
    for (j = cs.begin(); j!= cs.end(); ++j)
    {
      if (j->is_strict_inequality()) // only open faces
      {
      // make a new consys where replacing *j by an equality
      cs2=Constraint_System(constraint_to_equality(*j));
      for (k = cs.begin(); k!= cs.end(); ++k)
      {
        if (k!=j)


          cs2.insert(*k);
      };
      cvs2.union_assign(convex_clock_val_set(cs2));
      };
    };
  };
  return cvs2;
}

clock_val_set cvs_adj_faces(const convex_clock_val_set& cI, clock_val_set& E, clock_val_set Efaces, convex_clock_val_set& tp)
{
  // Efaces alread calculated
  clock_val_set cvs,I(cI);

  cvs=closed_faces(I);
//cout << "Closed I-faces:" << endl;
//cvs.print();
//cout << "Intersected with E:" << endl;
  cvs.intersection_assign(E);
  cvs.remove_redundant();
//cvs.print();

// only those faces that are not already in I anyway
Efaces=E;
Efaces.difference_assign(I);
//Efaces=time_relevant_faces(Efaces,tp);
Efaces=closed_faces(Efaces);

  Efaces.intersection_assign(I);
  Efaces.remove_redundant();
//cout << "Efaces intersected with I:" << endl;
//Efaces.print();

  cvs.union_assign(Efaces);
  cvs.remove_redundant();
  return cvs;
}

clock_val_set cvs_adj_faces(const convex_clock_val_set& cI, clock_val_set& E)

{
  // Efaces alread calculated
  clock_val_set cvs,I(cI),Efaces;

  cvs=closed_faces(I);
  cvs.intersection_assign(E);
  cvs.remove_redundant();

  // only those faces that are not already in I anyway
  Efaces=E;
  Efaces.difference_assign(I);
  Efaces=closed_faces(Efaces);

  Efaces.intersection_assign(I);
  Efaces.remove_redundant();

  cvs.union_assign(Efaces);
  cvs.remove_redundant();
  return cvs;
}


bool limit_bitsize(Constraint& c, clock_val_set& cvs, bool pos, int bits)
{
	// Limit the significant bits in c such that cvs is inside c!
	// (right now pos has no meaning)

	Linear_Expression e=ConstraintHom2Linear_Expression(&c);
	limit_bitsize(e,bits);
	
	// minimize e to get a lower bound inside cvs
	Integer n;
	Integer d;
	bool dummy; // is not used
	bool notemptyandbounded=false;
  notemptyandbounded=cvs.minimize(e, n, d, dummy);
	
	// Bring to form
	//   a_i x_i + b >= 0
	// For now it's given as:
	//   a_i' x_i >= n/d
	// so the new form must be:
	//   d*a_i' x_i - n >= 0
	// Therefore: round bits of n/d to negative!
	limit_bitsize(n,d,false,bits);
	
	if (c.is_strict_inequality())
		c=(d*e>n);
	else if (c.is_inequality())
		c=(d*e>=n);
	else
		c=(d*e==n);
			
	return notemptyandbounded;
}

bool minimize_constraint(Constraint& c, clock_val_set& cvs,dimension_type start_dim)
{
	bool minimum; // is not used
	bool notemptyandbounded=false;
  
	Integer n;
	Integer d;
	
	Linear_Expression e(Constraint2Linear_Expression(&c,start_dim));
	notemptyandbounded=cvs.minimize(e, n, d, minimum);
	
	// Bring to form
	//   a_i x_i + b >= 0
	// For now it's given as:
	//   a_i' x_i >= n/d
	// so the new form must be:
	//   d*a_i' x_i - n >= 0
	// Therefore: round bits of n/d to negative!
	
	// Todo: if it's only the infimum, shouldn't this be a strict inequality?
	
	if (notemptyandbounded)
	{
		if (c.is_strict_inequality())
			c=(d*e>n);
		else if (c.is_inequality())
			c=(d*e>=n);
		else
			c=(d*e==n);
	}
	else
	{
		// todo: check this
		// for now consider it unbounded, i.e., no constraint
		c=0*Variable(c.space_dimension()-1)>=0; // return a true contraint in same dimension
	};
			
	return notemptyandbounded;
}

bool minimize_constraint_from_dim(Constraint& c, const clock_val_set& cvs, dimension_type start_dim, Constraint& c2, bool& c2_active)
{
	// in a constraint a_0 x_0 + ... + a_(s-1) x_(s-1) + a_s x_s + ... + a_n x_n + b >< 0
	// minimize a_(s-1) x_(s-1) + a_s x_s + ...  in cvs to obtain a constraint
	// a_0 x_0 + ... + a_(s-1) x_(s-1) + b_new >< 0
	//
	// Input: c
	// Output: 	c (if c was an inequality)  -> c2_active=false
	//		c,c2 (if c was an equality) -> c2_active=true

	bool minimum; // is not used
	bool notemptyandbounded=false;
	c2_active=c.is_equality(); // this means we have to return 2 constraints, second one in c2

	assert(c.space_dimension()-start_dim-1>=0);
	c2=0*Variable(c.space_dimension()-start_dim-1)>=0; // initialize with a true contraint in same dimension
	
	Integer n(0);
	Integer d(1);
  
	// get dimension
	Linear_Expression e_low;
	if (start_dim > 0)
		e_low=ConstraintHom2Linear_Expression_up_to(&c,start_dim-1);
		
	// note: e_low only contains homogeneous terms, the inhomog. term will come from n,d through e
	
//cout << "orig constraint: " << c << endl;	
//cout << "e_low: " << e_low << endl;
		
	Linear_Expression e(Constraint2Linear_Expression_moved_down(&c,start_dim));
//	notemptyandbounded=cvs.minimize(e, n, d, minimum);
	notemptyandbounded=cvs.maximize(e, n, d, minimum);
	
// cout << "e: " << e << endl;
// cout << "min: " << n << "/" << d << ":" << notemptyandbounded << endl;
	
	// Bring to form
	//   a_i x_i + b >= 0
	// For now it's given as:
	//   a_i' x_i >= n/d
	// so the new form must be:
	//   d*a_i' x_i - n >= 0
	// Therefore: round bits of n/d to negative!
	
	// Todo: if it's only the infimum, shouldn't this be a strict inequality?
	
	if (notemptyandbounded)
	{
		if (c.is_strict_inequality() || (!minimum))
			c=(d*e_low>-n);
		else if (c.is_inequality())
			c=(d*e_low>=-n);
		else
			c=(d*e_low>=-n); // equality constraint #1
	}
	else
	{
		// todo: check this
		// for now consider it unbounded, i.e., no constraint
		c=0*Variable(c.space_dimension()-start_dim-1)>=0; // return a true contraint in same dimension
	};

	if (c2_active) // c was an equality, so return two non-strict inequalities: the first one in c, the second one in c2
	{
		notemptyandbounded=cvs.minimize(e, n, d, minimum);
	
// cout << "e: " << e << endl;
// cout << "min: " << n << "/" << d << ":" << notemptyandbounded << endl;
	
	// Bring to form
	//   a_i x_i + b >= 0
	// For now it's given as:
	//   a_i' x_i >= n/d
	// so the new form must be:
	//   d*a_i' x_i - n >= 0
	// Therefore: round bits of n/d to negative!
	
	// Todo: if it's only the infimum, shouldn't this be a strict inequality?
	
		if (notemptyandbounded)
		{
			if (minimum)
				c2=(d*e_low<=-n); // equality constraint #2
			else
				c2=(d*e_low<-n); // equality constraint #2	
		}
		else
		{
			// todo: check this
			// for now consider it unbounded, i.e., no constraint
			// Note: Boobytrap! c now already has the dimension dim instead of 2*dim
			c2=0*Variable(c.space_dimension()-1)>=0; // return a true contraint in same dimension
		};
	};
	
			
//cout << "constraint: " << c << endl;	
//cout << "constraint: " << c2 << c2_active << endl;	
	
	return notemptyandbounded;
}
