/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GUARD_myPFunction_h
#define GUARD_myPFunction_h

#include <iostream>
#include <map>
#include <stdexcept>
#include <ppl.hh>

#include "general.h"

using namespace Parma_Polyhedra_Library;
using namespace IO_Operators;

// --------------------------------------------------------------

// Mapping function for shifting dimensions of ccvs and cvs
// taken from PFunction.hh

class PFunction {
  friend std::ostream&
    operator<<( std::ostream& os, const PFunction &pf );

private:
  typedef Parma_Polyhedra_Library::dimension_type dim_t;

public:
  PFunction(); // : max(0)

  void swap_assign(dim_t x1, dim_t x2, dim_t y, dim_t n);

  void move_assign(dim_t x1, dim_t x2, dim_t y, dim_t n);

  bool has_empty_codomain() const;

  Parma_Polyhedra_Library::dimension_type max_in_codomain() const;

  bool in_domain(const dim_t& x) const;
  bool in_codomain(const dim_t& y) const;
//  dim_t get_map(dim_t x) const;
  Parma_Polyhedra_Library::dimension_type get_map(dim_t x) const;
  Parma_Polyhedra_Library::dimension_type get_premap(dim_t y) const;

  bool maps(dim_t x, dim_t& y) const;

  void fill_up_to(dim_t newdim);

  void print(std::ostream& s) const;

  void insert(dim_t x, dim_t y);
  
private:
  typedef std::map<unsigned, unsigned, std::less<dim_t> > Map;
  Map mymap;
  dim_t mymax;
};



#endif

