/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GUARD_rat_linexpression_h
#define GUARD_rat_linexpression_h

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>
#include <string>
//#include <stdlib.h>

//#include <ppl.hh>

#include "general.h"
#include "extended_ppl.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

class Rational : public mpq_class 
{
	public:
	Rational() : mpq_class(Integer(0),Integer(1)) {};
	Rational(const mpq_class& q) : mpq_class(q) {};
	Rational(const Integer& n, const Integer& d) : mpq_class(n,d) {};
	Rational(const Integer& n) : mpq_class(n,Integer(1)) {};
	Rational(const int& n) : mpq_class(Integer(n),Integer(1)) {};
	//Rational(const Rational& n, const Rational& d) : mpq_class(n.get_num()*d.get_den(),d.get_num()*n.get_den()) {};
	Rational(const string& str);
	double get_double() const
	{
		return get_d();
	};
   Integer get_Integer() const
   {
      return (get_num()/get_den());
   };
   int get_int() const
   {
      //Integer a(get_num()/get_den());
      //mpz_t z(get_num()/get_den());
      //return mpz_get_si(z);
      return (int)get_double();
   };   
};

// Operators
// bool operator<(const Rational& r1, const Rational& r2);
// bool operator<=(const Rational& r1, const Rational& r2);
// bool operator>(const Rational& r1, const Rational& r2);
// bool operator>=(const Rational& r1, const Rational& r2);
Rational operator-(const Rational& r);
Rational operator/(const Rational& r1, const Rational& r2);
Rational operator*(const Rational& r1, const Rational& r2);
Rational operator-(const Rational& r1, const Rational& r2);
Rational operator+(const Rational& r1, const Rational& r2);

class Rational_Linear_Expression : public Linear_Expression
{
	public:
	// Constructors
	Rational_Linear_Expression():Linear_Expression(Integer(0)),denominator(1){};
	Rational_Linear_Expression(const Linear_Expression& lexp):Linear_Expression(lexp),denominator(1)	{};
	Rational_Linear_Expression(const Linear_Expression& lexp, Integer& d):Linear_Expression(lexp),denominator(d)	{};
	Rational_Linear_Expression(const Integer& n):Linear_Expression(n),denominator(1) {};
	Rational_Linear_Expression(const string& str);
	
	// Copy Constructor
	Rational_Linear_Expression(const Rational_Linear_Expression& r):Linear_Expression(Integer(0)),denominator(1) 
	{
		this->Linear_Expression::operator=( (Linear_Expression)r );
		denominator=r.denominator;
	};
	
	Rational rat_inhomogeneous_term()
	{
		return Rational(Linear_Expression::inhomogeneous_term(),denominator);
	};
	
	// Properties
	Integer denominator;
};

// Operators
Rational_Linear_Expression operator+(const Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2);
Rational_Linear_Expression operator-(const Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2);
Rational_Linear_Expression& operator+=(Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2);
Rational_Linear_Expression& operator-=(Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2);
Rational_Linear_Expression operator*(const Rational& c, const Rational_Linear_Expression& l);

std::ostream&
operator<<( std::ostream& os, const Rational_Linear_Expression &r );
	
bool attempt_multiply(Rational_Linear_Expression& l1, Rational_Linear_Expression& l2);
bool attempt_division(Rational_Linear_Expression& l1, Rational_Linear_Expression& l2);

typedef pair <Constraint, pair <Rational,Rational> > ConstraintRatPair;

#endif
