#include "DHR_PolyhedronSet.h"
#include "DHR_split.h"


DHR_PolyhedronSet::DHR_PolyhedronSet()
{
	next = NULL;
	//numberSplitLocation=-1;
	polyhedron = NULL;
	sizeRange = NULL;
	maxSizeRange = NULL;
	reachable = true;
	reachableCount=0;
}

DHR_PolyhedronSet::~DHR_PolyhedronSet()
{
	if (polyhedron != NULL) delete polyhedron;
	if (sizeRange != NULL) deleteRange(sizeRange);
	if (maxSizeRange != NULL) delete[] maxSizeRange;
	if (next != NULL) delete next;
}

void DHR_PolyhedronSet::resetReachableAll()
{
	for(DHR_PolyhedronSet* cur = this; cur != NULL; cur=cur->next)
	{
		cur->reachableCount=0;
		cur->reachable = false;
	}
}


void DHR_PolyhedronSet::resetReachableFlag()
{
	for(DHR_PolyhedronSet* cur = this; cur != NULL; cur=cur->next)
	{
		cur->reachable = false;
	}
}



void DHR_PolyhedronSet::setReachable()
{
	reachable = true;
}

void DHR_PolyhedronSet::setReachable(int threshold)
{
	for(DHR_PolyhedronSet* cur = this; cur != NULL; cur=cur->next)
	{
		if (cur->reachableCount==threshold) cur->reachable = true;
	}
}


void DHR_PolyhedronSet::countReachable()
{
	for(DHR_PolyhedronSet* cur = this; cur != NULL; cur=cur->next)
	{
		if (cur->reachable) cur->reachableCount++;
		cur->reachable = false;
	}
}


void DHR_PolyhedronSet::add(C_Polyhedron* p, DHR_Rational** coeff, DHR_Rational* bound)
{
	DHR_PolyhedronSet* cur = this;
	if (polyhedron != NULL)
	{
		for(; cur->next != NULL; cur=cur->next);
		cur->next = new DHR_PolyhedronSet();
		cur = cur->next;
	}
	cur->polyhedron = p;
	if (coeff != NULL)
	{
		cur->sizeRange = getRangeDot(p, coeff, bound);
		cur->maxSizeRange = getSizeRange(cur->sizeRange);
	}
}

void DHR_PolyhedronSet::add_convex_hull(C_Polyhedron* p, DHR_Rational** coeff, DHR_Rational* bound)
{
	if (polyhedron != NULL)
	{
		polyhedron->poly_hull_assign(*p);
	}
	else
	{
		polyhedron = p;
	}
}


int DHR_PolyhedronSet::getSize()
{
	int result=0;
	if (polyhedron == NULL) return 0;
	for (DHR_PolyhedronSet* p = this; p != NULL;  p=p->next)
	{
		result++;
	}
	return result;
}

int DHR_PolyhedronSet::getSize(int count)
{
	int result=0;
	if (polyhedron == NULL) return 0;
	for (DHR_PolyhedronSet* p = this; p != NULL;  p=p->next)
	{
		if (p->reachableCount == count) result++;
	}
	return result;
}

void DHR_PolyhedronSet::display()
{
	int i=0;
	if(polyhedron != NULL)
	{
		for (DHR_PolyhedronSet* p = this; p != NULL;  p=p->next)
		{
			cout << "  **** Polyhedron " << i << " ****" << endl;
			cout << *(p->polyhedron) << endl; i++;
/*			if (p->sizeRange != NULL) displayRange(p->sizeRange, 'v');
			else cout << "> Unknown range.\n" ;
			if (reachable) cout << "Reachable.\n";
			else {cout << "Unreachable.\n>"; int q; cin >> q;}*/
		}
	}
	else
	{
		cout << "**** Empty set !! ****" << endl;
	}
}

void DHR_PolyhedronSet::displayFloat(ofstream & file)
{
	if(polyhedron != NULL)
	{
		for(DHR_PolyhedronSet* p = this; p != NULL;  p=p->next)
		{
			const Generator_System& gs = p->polyhedron->minimized_generators();
			for (Generator_System::const_iterator i = gs.begin(), gs_end = gs.end(); i != gs_end; ++i)
			{
				assert(i->is_point());
				// cout << *i << endl;
				mpq_class x(i->coefficient(Variable(0)), i->divisor());
				mpq_class y(i->coefficient(Variable(1)), i->divisor());
				file << x.get_d() << " " << y.get_d() << endl;
			}
			Generator_System::const_iterator i = gs.begin();
			mpq_class x(i->coefficient(Variable(0)), i->divisor());
			mpq_class y(i->coefficient(Variable(1)), i->divisor());
			file << x.get_d() << " " << y.get_d() << endl;
			file << endl;
		}
	}
}

void DHR_PolyhedronSet::computeRanges(DHR_Rational** coeff, DHR_Rational* bound)
{
	if (polyhedron != NULL)
	{
		for(DHR_PolyhedronSet* cur = this; cur != NULL; cur=cur->next)
		{
			cur->sizeRange = getRangeDot(cur->polyhedron, coeff, bound);
			cur->maxSizeRange = getSizeRange(cur->sizeRange);
		}
	}
}

void DHR_PolyhedronSet::interpretAsRange(DHR_Rational var1Min, DHR_Rational var1Max, DHR_Rational var2Min, DHR_Rational var2Max)
{
	for (DHR_PolyhedronSet* p = this; p!=NULL; p=p->next) 
	{
		const Constraint_System& cs = p->polyhedron->minimized_constraints();
		for (Constraint_System::const_iterator i = cs.begin(), cs_end = cs.end(); i != cs_end; ++i)
		{
			if (i->is_equality()) {cout << "Warning ! Singular range !!"; int q; cin >> q;}
			Integer coeff1 = i->coefficient(Variable(0));
			Integer coeff2 = i->coefficient(Variable(1));
			Integer coeff3 = i->inhomogeneous_term();
			//cout << coeff1 << "," << coeff2 << "," << coeff3 << endl;
			if (coeff1 == 0) 
			{
				if (coeff2 > 0) { var2Min[0] = -coeff3; var2Min[1] = coeff2; }
				else { var2Max[0] = coeff3; var2Max[1] = -coeff2; }
				if (i->is_equality())
				{
					if (coeff2 > 0) { var2Max[0] = -coeff3; var2Max[1] = coeff2; }
					else { var2Min[0] = coeff3; var2Min[1] = -coeff2; }
				}
			}
			else if (coeff2 == 0)
			{
				if (coeff1 > 0) { var1Min[0] = -coeff3; var1Min[1] = coeff1; }
				else { var1Max[0] = coeff3; var1Max[1] = -coeff1; }
				if (i->is_equality())
				{
					if (coeff1 > 0) { var1Max[0] = -coeff3; var1Max[1] = coeff1; }
					else { var1Min[0] = coeff3; var1Min[1] = -coeff1; }
				}
			}
			else
			{
				cerr << "Error ! Null coefficients for both variables !!"; exit(1);
			}
		}
	}
}	


// computes the intersection; returns NULL if empty.
DHR_PolyhedronSet* intersectionPolyhedronSet(DHR_PolyhedronSet* p1, DHR_PolyhedronSet* p2)
{
	DHR_PolyhedronSet* result = NULL;
	DHR_PolyhedronSet* intersect = NULL;
	if ((p1->polyhedron == NULL) || (p2->polyhedron == NULL)) return NULL;
	for(DHR_PolyhedronSet* cur1 = p1; cur1 != NULL; cur1 = cur1->next)
	{
		for(DHR_PolyhedronSet* cur2 = p2; cur2 != NULL; cur2 = cur2->next)
		{
			C_Polyhedron* p = new C_Polyhedron(*(cur1->polyhedron));
			p->intersection_assign_and_minimize(*(cur2->polyhedron));
			if (!(p->is_empty())) 
			{
				if (intersect == NULL)
				{
					intersect = new DHR_PolyhedronSet();
					intersect->polyhedron = p;
					result = intersect;
				}
				else
				{
					intersect->next = new DHR_PolyhedronSet();
					intersect = intersect->next;
					intersect->polyhedron = p;
				}
			}
		}
	}
	return result;
}

bool nonSingularIntersection(C_Polyhedron* p1, C_Polyhedron* p2)
{
	bool result;
	C_Polyhedron* p = new C_Polyhedron(*(p1));
	p->intersection_assign_and_minimize(*(p2));
	if (p->is_empty()) result=false;
	else
	{
		const Generator_System& gs = p->minimized_generators();
		int count=0;
		for (Generator_System::const_iterator i = gs.begin(), gs_end = gs.end(); (i != gs_end) && (count < 2); ++i)
		{
			count++;
		}
		if (count == 2) result=true;
		else result=false;
	}
	delete p;
	return result;
}

bool nonEmptyIntersection(C_Polyhedron* p1, C_Polyhedron* p2)
{
	bool result;
	C_Polyhedron* p = new C_Polyhedron(*(p1));
	p->intersection_assign_and_minimize(*(p2));
	if (p->is_empty()) result=false;
	else result=true;
	delete p;
	return result;
}

C_Polyhedron* readPolyhedron(ifstream& file, char* filename)
{	
	Integer coeff1, coeff2, freeTerm;
	Variable x(0);
	Variable y(1);
	Constraint_System cs;


	char bracket, comma;
	file >> bracket;
	if (bracket != '[') {cerr << "PolyhedronSet> Syntax error in file " << filename << endl; exit(1);}
	file >> bracket;
	while (bracket=='[')
	{
		file >> coeff1 >> comma >> coeff2 >> comma >> freeTerm;
		cs.insert(coeff1*x + coeff2*y <= freeTerm);
		file >> bracket >> comma;
		if (comma == ',') file >> bracket; 
	}
	
	C_Polyhedron* p = new C_Polyhedron(cs);
	return p;

}




