/***************************************************************************
                          automaton_general.cpp  -  description
                             -------------------
    begin                : Tue Jun 8 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "automaton.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

clock_val_set
automaton::get_union_of_exit_sets(const location_ref loc, const label_ref lab)
{
  // Get the union of all states that can leave location loc with label lab
  clock_val_set cvs(dim,EMPTY);

  if (labels.contains(lab))
  {
		if (locations.size()<=loc)
			throw_error("Couldn't find location in get_union_of_exit_sets");
    for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
    {
      if (transitions[*i].label==lab)
      {
        cvs.union_assign(get_restricted_exit_set(*i));
      };
    };
  };
  return cvs;
}


clock_val_set
automaton::get_cvs_equiv(automaton& spec_aut)
{
  clock_val_set cvs(dim+spec_aut.dim);

  // find variables with the same name and demand them to be equal
  variable_id_map::const_iterator k;
  variable_id_map::const_iterator kc;

   for (k=var_id_map.begin();k!=var_id_map.end();++k)
   {
      for (kc=spec_aut.var_id_map.begin();kc!=spec_aut.var_id_map.end();++kc)
      {
         if ((k->second==kc->second)) // same name
            cvs.add_constraint(Variable(k->first)==Variable(dim+kc->first));
      };
   };
if (DEBUG_OUTPUT>0) {
cout << "Equiv cvs:" << endl;
cvs.print();
};
  return cvs;
}

PFunction get_PFunction(automaton& P1,automaton& P1Q2,bool fill_up_to)
{
  // find the mapping from variables in P1 to those in P1Q2
  // assume that the other slots are free and don't matter, 
	// so fill them with the available spaces if fill_up_to==true
  //
  // Result has the dimension of P1Q2 only if fill_up_to==true
  PFunction pf;
  string nme;

  for (variable_id_map::const_iterator i=P1.var_id_map.begin();i!=P1.var_id_map.end();++i)
  {
    nme=i->second;
    if (P1Q2.var_id_map.contains_name(nme))
    {
      pf.insert(i->first,P1Q2.var_id_map.get_id(nme));
    }
    else
    {}; // is also used to project dimensions away, therefore no:  throw_error("Non-existent variable in get_PFunction!");
  };
//cout << "get_PFunction from " << P1.dim << " to " << P1Q2.dim << ":" << endl;
//cout << pf;
  if (fill_up_to)
		pf.fill_up_to(P1Q2.dim);
//cout << "after: " << pf;

  return pf;
}


void
automaton::restrict_mu_to_invariants(transition_ref& i)
{
  // intersect invariants
  transitions[i].mu_update_source(locations[transitions[i].source_loc()].invariant());
  transitions[i].mu_update_target(locations[transitions[i].target_loc()].invariant());
//  transitions[i].mu_simplify();
}

void 
automaton::restrict_mu_to_invariants_loc(location_ref loc)
{
  // incoming transitions
  for (trans_ref_set::const_iterator i=locations[loc].in_trans.begin();i!=locations[loc].in_trans.end();++i)
  {
    transitions[*i].mu_update_target(locations[loc].invariant());
  };
  // outgoing transitions
  for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
  {
    transitions[*i].mu_update_source(locations[loc].invariant());
  };  
}

void
automaton::restrict_mu_to_invariants()
{
  for (transition_ref i=0; i<transitions.size(); ++i)
  {
    restrict_mu_to_invariants(i);
  };
}


void
automaton::add_environment_transitions()
{
  // add epsilon label and self-loops which arbitrarily reset inputs with the invariants
  label_ref lab=add_label(TAU_LABEL_STRING);
  clock_val_set mu(2*dim);

  // all (state) variables stay the same
  for (clock_ref_set::iterator k=variables.begin();k!=variables.end();++k)
  {
    mu.add_constraint(Variable(*k)==Variable(*k+dim));
  };

  for (location_ref i=0; i<locations.size(); ++i)
  {
    // add transitions
    add_transition(i,lab,mu,i);
//    restrict_mu_to_invariants(i);
  };
}

void
automaton::assign_tts()
{ // turn *this into its tts by
  // 1. restricting mu to invariant
  // 2. adding environment transitions
  // 3. removing invariants
  // 4. existentializing derivatives of inputs

//  restrict_mu_to_invariants();

  add_environment_transitions();

  PFunction pf1,pf2;
  // Construct partial function that takes away the inputs
  // Construct partial function that puts the inputs back in
  unsigned int j=0;
  for (unsigned int i=0; i<dim; ++i)
  {
    if (variables.contains(i) || parameters.contains(i))        // inputs = not variables, not parameters
    {
      pf1.insert(i,j);
      pf2.insert(j,i);
      ++j;
    };
  };
  --j; // now j is the highest dimension of the quantified
  pf2.fill_up_to(dim);

  for (location_ref i=0; i<locations.size(); ++i)
  {
    // clear invariant
//    locations[i].invariant_assign(clock_val_set(dim));
    // exist. quantification of inputs
		
// todo: is this correct???
//    locations[i].time_post_poly.map_space_dimensions(pf1);
    // add new dimensions
//    locations[i].time_post_poly.add_space_dimensions_and_embed(dim-locations[i].time_post_poly.space_dimension());
    // put variables back in the right order
//    locations[i].time_post_poly.map_space_dimensions(pf2);
  };  
}
// ---------------------------------------------------------------
// ---------------------------------------------------------------
//    Obsolete???:
// ---------------------------------------------------------------
// ---------------------------------------------------------------

void
automaton::get_disabled_states(state_relation& R, const automaton& spec_aut, automaton& caut, label_ref_set& contr_labels, dimension_type d_dim, location_ref_to_location_ref_pair_map& lmap)
{
  clock_val_set cvs,cvs2,oldE;
  symb_states_type E;
  trans_ref_set::const_iterator j;
  location_ref ploc,sloc;
  location_ref_pair lrp;
//      location_ref_to_location_ref_pair_map::const_iterator lmap_it;
  list < location_ref > waiting;

cout << "Adding disabled transitions:" << endl << flush;

  // add chaos loc
  location_ref chaos_loc=caut.add_location(clock_val_set(dim),"chaos",Constraint_List(dim));

  // iterate over all controllable labels
  for (label_ref_set::const_iterator lab_it=contr_labels.begin();lab_it!=contr_labels.end();++lab_it)
  {
    E.clear();

cout << "Label " << *lab_it << endl << flush;

    // iterate over all locations in caut
    // initialize with not(mu)
    for (location_ref loc=0;loc<caut.locations.size();++loc)
    {
      if (loc != chaos_loc)
      {
        lrp=lmap[loc];
        ploc=lrp.first;
        // only if not yet done
        if (E.find(ploc)==E.end())
        {
          // union of all outgoing transitions
          cvs=clock_val_set(caut.dim,EMPTY);

          for (j=locations[ploc].out_trans.begin();j!=locations[ploc].out_trans.end();j++)
          {
            if (transitions[*j].label==*lab_it)
            {
              cvs2=get_restricted_mu(*j);
              cvs2.remove_space_dimensions(dim,2*dim-1); // u' doesn't matter
              cvs.union_assign(cvs2);
            };  // end if
          };  // end for
          E[ploc]=cvs;
        };
      };
    }
    // init E
    for (location_ref loc=0;loc<locations.size();++loc)
    {

      if (loc != chaos_loc)
      {
        if (E.find(loc)==E.end())
          E[loc]=clock_val_set(dim,EMPTY);
      };
    };

    // ----------------------------------
    // Now iterate on E until convergence
    // put all locs on waiting list
//cout << "Converging on E" << endl << flush;

    waiting.clear();
    for (symb_states_type::const_iterator i=E.begin();i!=E.end();++i)
    {
      waiting.push_front(i->first);
    };

    while (!waiting.empty())
    {
      // pop loc from waiting
      ploc=*(waiting.begin());
      waiting.erase(waiting.begin());

      oldE=E[ploc];
      // intersect with pre(D) of all uncontr. successors
      for (j=locations[ploc].out_trans.begin();j!=locations[ploc].out_trans.end();j++)
      {
        if (!contr_labels.contains(transitions[*j].label))
        {
          cvs2=E[transitions[*j].target_loc()];
          cvs2.add_space_dimensions_and_embed(dim); // is v',v
          cvs2.dimension_move_assign(0,dim-1,dim); // is v,v'
          // apply pre operator to v'
          cvs2.intersection_assign(get_restricted_mu(*j)); // is v,v'
          cvs2.remove_space_dimensions(dim,2*dim-1); // remove v', is v
          E[ploc].union_assign(cvs2);
        };  // end if
      };  // end for
      if (!oldE.contains(E[ploc]))
      {
        // put uncontr. predecessors on waiting list
        for (j=locations[ploc].in_trans.begin();j!=locations[ploc].in_trans.end();j++)
        {
          if (!contr_labels.contains(transitions[*j].label))

          {
            sloc=transitions[*j].source_loc();
            // to do: check for sloc on waiting list
//                if (waiting.find(sloc)==waiting.end())
              waiting.push_front(sloc);
          };  // end if
        };  // end for
      };
    }; // end while (!waiting.empty())

//E.print();
//cout << "Simplifying E" << endl << flush;

    // invert E and simplify
    for (symb_states_type::iterator i=E.begin();i!=E.end();++i)
    {
      cvs=clock_val_set(dim);

      cvs.difference_assign(i->second);
      cvs.simplify();
      cvs.add_space_dimensions_and_embed(dim);
      i->second=cvs;
    };
//E.print();

//cout << "Adding transitions in X to chaos location" << endl << flush;

    // now add transitions to chaos loc to X
    for (location_ref loc=0;loc<caut.locations.size();++loc)
    {
      if (loc != chaos_loc)
      {
        lrp=lmap[loc];
        ploc=lrp.first;

        if (!E[ploc].is_empty())
          caut.add_transition(loc,*lab_it,E[ploc],chaos_loc);
      };
    };
  };  // end for label

  // add chaos transitions
  for (label_ref_set::const_iterator lab_it=contr_labels.begin();lab_it!=contr_labels.end();++lab_it)
  {
    caut.add_transition(chaos_loc,*lab_it,clock_val_set(2*dim),chaos_loc);
  };

}

