/***************************************************************************
                          automaton_minim.cpp  -  description
                             -------------------
    begin                : Tue Jun 8 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "automaton.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;
 
// -------------------------------------------------------------------------------------------------------------------------
//  Minimization
// -------------------------------------------------------------------------------------------------------------------------
bool
automaton::check_consistency()
{
  // check if all transitions in_trans and out_trans actually exist

  bool consistent=true;
  trans_ref_set::iterator k;

  for (unsigned int i=0;i<locations.size();++i)
  {
    for (k=locations[i].in_trans.begin();k!=locations[i].in_trans.end();k++)
    {
      if (transitions[*k].target_loc() != i)
        consistent=false;
    };
    for (k=locations[i].out_trans.begin();k!=locations[i].out_trans.end();k++)
    {
      if (transitions[*k].source_loc() != i)
        consistent=false;
    };
    if (!consistent)
    {
      cout << "ERROR: NOT CONSISTENT IN LOC " << i  << endl;
      cout << "in_trans: " << locations[i].in_trans << endl;
      cout << "out_trans: " << locations[i].out_trans << endl;
      pause_key();

    };
  };
  if (!consistent)
  {
    cout << "ERROR: NOT CONSISTENT" << endl;
    pause_key();
  };

  return consistent;
}

void
automaton::erase_transition(transition_ref k)
{
  // take k out of in_trans of target
  locations[transitions[k].target_loc()].in_trans.erase(k);

  // take k out of out_trans of source
  locations[transitions[k].source_loc()].out_trans.erase(k);

  // decrease all references in in_trans and out_trans
  for (unsigned int i=0;i<locations.size();++i)
  {
//cout << "Decreasing by " << k << " in_trans:" << locations[i].in_trans ;
    locations[i].in_trans.decrease_refs(k);
//cout << " to " << locations[i].in_trans << endl;

//cout << "Decreasing by " << k << " out_trans:" << locations[i].out_trans ;
    locations[i].out_trans.decrease_refs(k);
//cout << " to " << locations[i].out_trans << endl;
  };

  // now delete it entirely
//      transitions.erase(k);
//      transitions.erase(transitions[k].iterator());
//cout << "G" << flush;

  transitions.erase(transitions.begin()+k);
}

void
automaton::erase_location(location_ref l)
{
  // have to decrease all references >l
  // - in source_loc and target_loc of transitions
  // ini_states has to be taken care of by calling function



  for (unsigned int i=0;i<transitions.size();++i)
  {
    if (transitions[i].source_loc()>l)
//      --transitions[i].source_loc;
			transitions[i].source_assign(transitions[i].source_loc()-1);
    if (transitions[i].target_loc()>l)
//      --transitions[i].target_loc;
			transitions[i].target_assign(transitions[i].target_loc()-1);
  };
  // now delete it entirely
//      locations.erase(l);
  locations.erase(locations.begin()+l);
}

symb_states_type
automaton::reach_assign_symmetric(state_relation& R, const clock_val_set& cvs_equiv)
{
  location_ref_pair lrp,lrp2;
  location_ref_pair_list waiting;
  trans_ref_set::iterator k,j;
  clock_val_set cvs;


  // get the reach sets
  symb_states_type reachP;
  reachP=get_reach_set();
//reachP.print();
//reachQ.print();

  // add the combinatorial product of ini_states and symb_ini_states
  // the continuous states must be equivalent
  // Note that the continuous initial states aren't used, because the reachable states are larger anyway
  for (symb_states_type::const_iterator i=ini_states.begin(); i!=ini_states.end(); ++i)
  {
    for (symb_states_type::const_iterator h=ini_states.begin(); h!=ini_states.end(); ++h)
    {
//          R[location_ref_pair(i->first,h->first)]=cvs_equiv;
      waiting.add(location_ref_pair(i->first,h->first));
    };
  };

//      waiting=R.get_location_ref_pairs(); // prime waiting list with R

  while (!waiting.empty())
  {
    lrp=*(waiting.begin());
    waiting.erase(waiting.begin());

    if (lrp.first<lrp.second)
    {
      R[lrp]=reachP[lrp.first];
      R[lrp].add_space_dimensions_and_embed(dim);
    }
    else
    {

      R[lrp]=clock_val_set(dim);
      R[lrp].concatenate_assign(reachP[lrp.second]);
    };
    R[lrp].intersection_assign(cvs_equiv);
    R[lrp].simplify();

    // for all outgoing transitions in P
    for (k=locations[lrp.first].out_trans.begin();k!=locations[lrp.first].out_trans.end();k++)
    {
//          indep_trans=!spec_aut.labels.contains(transitions[*k].label); // note: 0-transitions (tau) are not independent!
      // follow only those transitions that are reachable
//      if (!transitions[*k].exit_set.is_disjoint_from(reachP[lrp.first]))
      if (!reachP[lrp.first].is_disjoint_from(get_restricted_exit_set(*k)))
      {
        // try all outgoing transitions in Q with the same label
        for (j=locations[lrp.second].out_trans.begin();j!=locations[lrp.second].out_trans.end();j++)
        {
          if (transitions[*k].label==transitions[*j].label)
          {
            // follow only those transitions that are reachable
//            if (!transitions[*j].exit_set.is_disjoint_from(reachP[lrp.second]))
            if (!reachP[lrp.second].is_disjoint_from(get_restricted_exit_set(*j)))
            {
              lrp2=location_ref_pair(transitions[*k].target_loc(),transitions[*j].target_loc());
              // if not already visited
              if (R.find(lrp2)==R.end())
                waiting.add(lrp2);
            }; // end if
          }; // end if
        }; // end for
      }; // end if
    }; // end for

  }; // end while
  return reachP;
}

symb_states_type
automaton::minimize_locsim(const clock_val_set& cvs_equiv, bool use_bisimulation)
{
  // Minimize *this based on local similarity
  stopwatch sw(2100,"minimize_locsim");
  state_relation R;
  clock_val_set cvs,cvs2,E;
  trans_ref_set::iterator k;
  set<location_ref> delete_set,set2;
  //set<location_ref>::iterator iter;

  unsigned int count_del=0;
  location_ref l;

//automaton oldaut=*this; // only for testing

if (!use_bisimulation)
cout << "Minimizing based on local similarity" << endl << flush;
else
cout << "Minimizing based on bisimulation" << endl << flush;

cout << "Starting with " << locations.size() << " locations." << endl << flush;

  // restrict ini_states to invariants
  // -  this is just to avoid modelling errors, because the invariants are easily forgotten
  restrict_to_invariant(ini_states);

  symb_states_type reachP;
  // Prime R with cvs_equiv
  if (MINIM_PRIME_R_WITH_REACH)
  {
    bool dum=USE_CONVEX_HULL;
//        if (MINIM_USE_CONVEX_HULL_FOR_PRIMING)
//          USE_CONVEX_HULL=true;

    reachP=reach_assign_symmetric(R,cvs_equiv);
    for (location_ref i=0;i<locations.size();++i)
    {
      for (location_ref j=0;j<locations.size();++j)
      {
        if (R.find(location_ref_pair(i,j))==R.end())
          R[location_ref_pair(i,j)]=cvs_equiv;
      };
    };
    USE_CONVEX_HULL=dum;
  }
  else
  {
    reachP=get_reach_set();
    // leave R totally open
    // initialize with universal sets
    for (location_ref i=0;i<locations.size();++i)
    {
      for (location_ref j=0;j<locations.size();++j)
      {
        R[location_ref_pair(i,j)]=cvs_equiv;
      };
    };
  };

if (DEBUG_OUTPUT>0) {
cout << "Getting simrel R" << endl;
};

  bool oldstop = STOP_AT_BAD_STATES;
  STOP_AT_BAD_STATES = false;

  // Turn R into a simulation relation
  if (!use_bisimulation)
    get_sim_rel(R,*this,cvs_equiv);
  else
    get_sim_rel(R,*this,cvs_equiv,true);
//        get_bisim_rel(R,*this,cvs_equiv);  // this one is for unsymmetric R

  STOP_AT_BAD_STATES = oldstop;

//R.print();

  // Get reachable states
  //symb_states_type reachP;
  //reachP=get_reach_set();

  // Replace similar locations
  // to do: the order matters. for now, just do them by location number

  clock_val_set mucvs;
  for (unsigned int i=0;i<locations.size();++i)
  {
//        if (!delete_set.contains(i)) // not necessary
    if (reachP.find(i)==reachP.end())
      reachP[i]=clock_val_set(dim,EMPTY);
    for (unsigned int j=0;j<locations.size();++j)
    {
      if ((i!=j) && (delete_set.find(j)==delete_set.end()) && (R.find(location_ref_pair(i,j))!=R.end()) && (R.find(location_ref_pair(j,i))!=R.end()) )
      {

        cvs=R[location_ref_pair(j,i)];
        cvs.dimension_move_assign(0,dim-1,dim); // from v,u to u,v
        cvs.intersection_assign(R[location_ref_pair(i,j)]);
        cvs2=cvs;
        cvs2.remove_space_dimensions(dim,2*dim-1); // from u,v to u
        if (cvs2.contains(reachP[i]))
        {
          // adjust dimensions of cvs
          cvs.add_space_dimensions_and_embed(dim); // is u',v',u
          cvs.dimension_move_assign(0,2*dim-1,dim); // is u,u',v'

cout << "Replacing " << locations[i].name << " with " << locations[j].name << endl << flush;
          // replace i with j
          // ----------------
          // reroute incoming transitions to i
          // add them to in_trans of j
          // change their mu, and entry_set
          for (k=locations[i].in_trans.begin();k!=locations[i].in_trans.end();++k)
          {
            if (transitions[*k].source_loc() != i) // don't reroute self-loops!
            {
              // reroute
//              transitions[*k].target_loc=j;
              transitions[*k].target_assign(j);
							locations[j].in_trans.insert(*k);
              // change mu
              mucvs=get_restricted_mu(*k);
              mucvs.add_space_dimensions_and_embed(dim); // is u,u',v'
              mucvs.intersection_assign(cvs);
              mucvs.remove_space_dimensions(dim,2*dim-1); // is u,v'
              mucvs.simplify();
              transitions[*k].mu_assign(mucvs);
//cout << "." << flush;
    progress_dot();
            };
          };
          // erase all outgoing transitions
//              for (k=locations[i].out_trans.begin();k!=locations[i].out_trans.end();++k)
          while (locations[i].out_trans.begin() != locations[i].out_trans.end())
          {
            erase_transition(*(locations[i].out_trans.begin()));
          };
          // replace the location in ini_states
          cvs.remove_space_dimensions(0,dim-1); // is u,v
          if (ini_states.find(i)!=ini_states.end())
          {
            ini_states[i].add_space_dimensions_and_embed(dim);
            ini_states[i].intersection_assign(cvs);
            ini_states[i].remove_space_dimensions(0,dim-1); // is v
            if (ini_states.find(j)!=ini_states.end())
              ini_states[j].union_assign(ini_states[i]);
            else
              ini_states[j]=ini_states[i];
            ini_states.erase(i);
          };
          // finally delete i alltogether
          delete_set.insert(i); // don't do it here, because they'll be found later in deletion of unreachable states

          ++count_del;
          break;
        };
      };
    };
  };
  progress_dot_end();


cout << endl << count_del << " locations replaced." << endl << flush;

  // find locations that don't have any incoming transitions and are not in initial locations
  // to do: could also get reach set
  for (unsigned int i=0;i+1<locations.size();++i)
  {
    if (locations[i].in_trans.size()==0 && ini_states.find(i)==ini_states.end())
      delete_set.insert(i);
  };

cout << "Deleting " << delete_set.size() << " locations." << endl << flush;

  // delete locations
  // note delete_set must be ordered
  while (delete_set.size()>0)
  {
    l=*(delete_set.begin());
    delete_set.erase(delete_set.begin());
    erase_location(l);
    // now correct the other entries in the delete_set
    set2.clear();
    for (set<location_ref>::iterator i=delete_set.begin();i!=delete_set.end();++i)
    {
      if (*i>l) // don't need to check if ordered, but won't hurt
        set2.insert(*i-1);
      else
        set2.insert(*i);
    };
    delete_set=set2;
  };

cout << endl << "Finished minimization: " << locations.size() << " locations remaining."  << endl;


/*
// test it
bool test1,test2;

test1=is_simulation(cvs_equiv,oldaut);

test2=oldaut.is_simulation(cvs_equiv,*this);
if (!(test1 && test2) )
{
cout << "Error: minimization produces fault:" << endl << flush;
cout << "P <= M :" << test1;
cout << "M <= P :" << test2;
cout << "Original:" << endl;
oldaut.print();
cout << "Minimized:" << endl;
print();
pause_key();
};
*/
//check_consistency();

  return ini_states;
}

