/***************************************************************************
                          automaton_vec.cpp  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "automaton_vec.h"

//automaton_vec::automaton_vec(clock_dim_type d):dim(d) {};
automaton_vec::automaton_vec():dim(0) {}

unsigned int
automaton_vec::get_automaton_id(const string aut_name)
  {
    unsigned int id=0;
    for (automaton_vec::const_iterator i=begin();i!=end();++i)
    {
      if (i->name==aut_name)
        return id;
      ++id;
    };
    throw_error("Automaton " + aut_name + " not found in automaton_vec");
    return id;
  }
  
bool
automaton_vec::is_automaton_id(const string aut_name)
  {
    unsigned int id=0;
    for (automaton_vec::const_iterator i=begin();i!=end();++i)
    {
      if (i->name==aut_name)
        return true;
      ++id;
    };
    return false;
  }

void
automaton_vec::add_automaton(const automaton& aut)
{
//  unsigned int aut_nr=size();
  push_back(aut);
//  if (dim < aut.dim) dim=aut.dim;

  // Remap the variable ids to a global set
  PFunction pfunc1,pfunc2;
  dimension_type d;
  get_common_var_names(var_id_map,aut.var_id_map,var_id_map,pfunc1,pfunc2,d);


  // remap labels at composition!
}

// ---------------------------------------------------------------------------
// Composition
// ---------------------------------------------------------------------------

loc_ref_vec_to_loc_ref_map
automaton_vec::compose(automaton& aut)
{
  // Compose (*this)
cout << "Composing automaton_vec" << endl;
  
  stopwatch sw("compose");
  automaton aut2(dim),aut3(dim);
  loc_ref_vec_to_loc_ref_map lmap;
  location_ref_to_location_ref_pair_map lprmap;

  aut=(*this)[0];

  unsigned int i=1;
  while(i<this->size())
  {
    lprmap=compose_discrete(aut3,aut,(*this)[i]);
    lmap.remap(lprmap,i+1);
    aut=aut3;
    
    ++i;
  };

  /*
  // Redo the variable maps, just to be sure
  vector<clock_ref> clk_vec;
  for (unsigned int aut_nr=0;aut_nr<size();++aut_nr)
  {
    // cycle through variables of automaton
    spec_aut.variables.clear(); // are now replaced by the variables of composition
    for (map <string,clock_ref>::const_iterator kk=spec_aut.clock_name_to_clock_ref_map.begin();kk!=spec_aut.clock_name_to_clock_ref_map.end();++kk)
    {
      var_name=kk->first;
      // 1. Find the variable in the set so far
      if (clock_name_to_clock_ref_map.find(var_name)!=clock_name_to_clock_ref_map.end())
      {
        clk=clock_name_to_clock_ref_map[var_name];
      }
      else
      // 2. If not found, add new variable
      {
        ++newdim; // variable gets position at the end
        clk=newdim;
        clock_name_to_clock_ref_map.insert(make_pair(var_name,clk));
        pfunc.insert(kk->second,clk);
      };
      // 3. Add to map for automaton_vec
      spec_aut.variables.insert(clk);
    };
  };
  */
  
  cout << "Finished composition." << endl << flush;
  return lmap;
}

loc_ref_vec_to_loc_ref_map
automaton_vec::compose_minimized_up_to(const clock_val_set& equiv_cvs,automaton& aut,unsigned int imax,bool use_bisimulation, label_ref_set ulabs, bool test_satisfiability)
{
  // Compose (*this)[i], minimiziung the composed automaton aut up to i=imax
  // If ulabs is specified, replace labels out of ulabs by UNUSED_LABEL as soon as they don't occur in the rest of the automata.
  stopwatch sw("compose_minimized_up_to");
  automaton aut2(dim),aut3(dim),aut4(dim);
  bool dum;
  loc_ref_vec_to_loc_ref_map lmap;
  location_ref_to_location_ref_pair_map lprmap;
  label_ref_set labs;

  aut=(*this)[0];
//      aut.minimize_locsim(equiv_cvs,use_bisimulation);

  unsigned int i=1;
  while(i<this->size())
  {
    aut2=(*this)[i];
//        aut2.minimize_locsim(equiv_cvs,use_bisimulation);
//cout << "Minimized automaton aut2:" << endl;
//aut2.print();
    dum=COMPOSE_WITH_REACH_MIN;
    if (i+1==this->size()) // don't minimize the last one
      COMPOSE_WITH_REACH_MIN=false;

    lprmap=compose_discrete(aut3,aut,aut2);
    lmap.remap(lprmap,i+1);

    COMPOSE_WITH_REACH_MIN=dum;
//cout << "Composed automaton aut3:" << endl;
//aut3.print();
    aut=aut3;

    // replace unused labels, i.e. labels in ulabs that are not in (*this)[j] for j>i
    labs=ulabs;
    for (unsigned int j=i+1; j<(*this).size(); ++j)
    {
      labs.difference_assign((*this)[j].labels);
    };
    aut.replace_labels(labs,UNUSED_LABEL);

    if (i<=imax)
      aut.minimize_locsim(equiv_cvs,use_bisimulation);
//      else
//          cout << "no more minimization of composition" << endl;
//cout << "Minimized composed automaton aut:" << endl;
//aut.print();
    ++i;
  };
  cout << "Finished composition, minimized up to " << imax << "." << endl << flush;
  return lmap;
}

// ---------------------------------------------------------------------------
// Reachability
// ---------------------------------------------------------------------------
void
automaton_vec::loc_ref_vec_print(loc_ref_vec locs)
{
  // prints the locations by name
  // refers to the automata of *this
  cout << "[";
  if (locs.size()>0)
  {
    for (unsigned int i=0;i+1<locs.size();++i)
      cout << (*this)[i].locations[locs[i]].name << ",";
    cout << (*this)[locs.size()-1].locations[locs[locs.size()-1]].name;
  };
  cout << "]" << endl;
}

