/***************************************************************************
                          deriv_def  -  description
                             -------------------
    begin                : Sat Jul 24 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


 #include "deriv_ops.h"

 void get_jacobian(const string& name, TNT::Array1D< double > &x,TNT::Array2D< double > &Jx)
 {
  // Generic function:
  // returns the jacobian (df_i,dx_j) for the function dx/dt=f(x) defined by
  // void get_derivative(TNT::Array1D< surreal > &x,TNT::Array1D< surreal > &dx) 
  // in "deriv_def.cpp"
  
  // for now: h=1;
  const double h=1;

  TNT::Array1D< surreal > xs(x.dim());
  // initialize xs
  for (int j=0;j<x.dim();++j)
  {
    xs[j]=surreal(x[j],0.0);
  };
  
  TNT::Array1D< surreal > f(x.dim());
  
  for (int j=0;j<x.dim();++j)
  {
    // let x(j) vary
    xs[j]=surreal(x[j],h);
    get_derivative(name,xs,f);
    for (int i=0;i<x.dim();++i)
    {
      Jx[i][j]=imag(f[i])/h; 
    };
    // make x(j) constant again
    xs[j]=surreal(x[j],0.0);
  };
 }
 

