/***************************************************************************
                          symb_states.cpp  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "symb_states.h"
#include "automaton.h"
 

// ------------------------------------------------------------------------
// symb_states_pair_type::
//
void
symb_states_pair_type::print() const
{
  pair<location_ref,location_ref> loc_pair;
  pair<clock_val_set,clock_val_set> cvs_pair;
  clock_val_set cvs;
  symb_states_pair_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    loc_pair=i->first;
    cvs_pair=i->second;

    cout << "Location " << loc_pair.first << "," << loc_pair.second << ":" << endl;
    cvs_pair.first.print();
    cvs_pair.second.print();

    ++i;
  };
}

// ------------------------------------------------------------------------
// loc_ref_vec
// ------------------------------------------------------------------------

  ostream&
  operator<<( ostream& os, const loc_ref_vec &locs )
  {
    os << "[";
//      for (loc_ref_vec::const_iterator i=locs.begin();i!=locs.end();++i)
//        os << *i << ",";
    if (locs.size()>0)
    {
      for (unsigned int i=0;i+1<locs.size();++i)
        os << locs[i] << ",";
      os << locs[locs.size()-1];
    };
    os << "]";
    return os;
  }

bool
loc_ref_vec::compare_wildcard(const loc_ref_vec &locs, const unsigned int &wildcard) const
{
  bool equal=true;
  if (locs.size()==size())
  {
    for (unsigned int i=0;(i<locs.size()) && equal;++i)
    {
      if ((locs[i]!=wildcard) && (((*this)[i])!=wildcard) && (locs[i]!=(*this)[i]))
        equal=false;
    };
  }
  else equal = false;
//    cout << "Comparing: " << (*this) << " with " << locs << ":" << equal << endl;
  return equal;
}

bool
loc_ref_vec::contains_wildcard(const unsigned int &wildcard) const
{
  bool found=false;
    for (unsigned int i=0;(i<size()) && !found;++i)
    {
      if (((*this)[i])==wildcard)
        found=true;
    };
  return found;
}

// ------------------------------------------------------------------------
// location_ref_pair
// ------------------------------------------------------------------------


ostream&
  operator<<( ostream& os, const location_ref_pair &lrp )
  {
    os << "[" << lrp.first << "," << lrp.second << "]";
    return os;
  }

location_ref_pair::location_ref_pair() {}
location_ref_pair::location_ref_pair(const location_ref& a, const location_ref& b)
{
  first=a;
  second=b;
}
//  location_ref_pair(const location_ref& a, const location_ref& b) : location_ref_pair.first(a),location_ref_pair.second(b) {};

// ------------------------------------------------------------------------
//     location_ref_pair_list
// ------------------------------------------------------------------------

void
location_ref_pair_list::add(const location_ref_pair& lrp)
{
  bool found=false;
  for (list<location_ref_pair>::const_iterator i=this->begin();(i!=this->end()) && (!found);++i)
  {
    if ((*i)==lrp)
      found=true;
  };
  if (!found)
    push_front(lrp);
}

// ------------------------------------------------------------------------
// location_ref_to_location_ref_pair_map
// ------------------------------------------------------------------------

location_ref_to_location_ref_pair_map::iterator location_ref_to_location_ref_pair_map::find(location_ref& loc)
{
  return map <location_ref,location_ref_pair>::find(loc);
}

bool
location_ref_to_location_ref_pair_map::find(location_ref_pair& lrp, location_ref& loc, bool alarm)
{
  // returns true if lrp is found, loc is set to the iterator
  location_ref_to_location_ref_pair_map::iterator i=begin();
  while (i!=end())
  {
    if (i->second==lrp)
    {
      loc=i->first;
      return true;
    };
    ++i;
  };
  // nothing found
  if (alarm) throw_error("Failed to find element of location_ref_to_location_ref_pair_map!");

  return false;
}

void
location_ref_to_location_ref_pair_map::print()
{
  location_ref_to_location_ref_pair_map::iterator i=begin();
  cout << "location_ref_to_location_ref_pair_map(" << size() << ")" << endl;
  while (i!=end())
  {
    cout << i->first << "->" << i->second << endl;
    ++i;
  };
}


// ------------------------------------------------------------------------
// loc_ref_vec_to_loc_ref_map
// ------------------------------------------------------------------------

bool
loc_ref_vec_to_loc_ref_map::find(location_ref& loc, loc_ref_vec& lrv)
{
  loc_ref_vec_to_loc_ref_map::iterator i=begin();
  while (i!=end())
  {
    if (i->second==loc)
    {
      lrv=i->first;
      return true;
    };
    ++i;
  };
  return false;
}

void
loc_ref_vec_to_loc_ref_map::remap(location_ref_to_location_ref_pair_map& lprmap, unsigned int vec_size)
{
  // remap after composition
  // i.e. enhance the vector
  loc_ref_vec_to_loc_ref_map newmap;
  loc_ref_vec lrv;

  bool firsttime=false;
  if (empty())
    firsttime=true;

  for (location_ref_to_location_ref_pair_map::iterator i=lprmap.begin(); i!=lprmap.end(); ++i)
  {
    // initialize lrv with old vector
    lrv.clear();
    if (!firsttime)
    {
      if (!find(i->second.first,lrv))
      {
        //error("location not found");
        // location isn't found because it's unreachable
        for (unsigned int j=0; j<vec_size;++j)
          lrv.push_back(LOCATION_REF_UNREACHABLE);
      };
    }
    else
    {
      lrv.push_back(i->second.first);
    };
    // add the location of the new automaton to the vector
    lrv.push_back(i->second.second);

    // add lrv to the new map
    newmap[lrv]=i->first;
  };
  *this=newmap;
}

void
loc_ref_vec_to_loc_ref_map::print()
{
  loc_ref_vec_to_loc_ref_map::iterator i=begin();
  cout << "loc_ref_vec_to_loc_ref_map(" << size() << ")" << endl;
  while (i!=end())
  {
    cout << i->first << "->" << i->second << endl;
    ++i;
  };
}

// ------------------------------------------------------------------------
// symb_vec_states_type
// ------------------------------------------------------------------------

symb_vec_states_type::symb_vec_states_type() {}

symb_vec_states_type::symb_vec_states_type(const symb_states_type& states)
{
  // copy the states from states
  loc_ref_vec locs;
  symb_states_type::const_iterator i;
  for (i=states.begin();i!=states.end();++i)
  {
    locs.clear();
    locs.push_back(i->first);
    (*this)[locs]=i->second;
  };
}

symb_vec_states_type::symb_vec_states_type(const symb_states_type& states, const location_ref& loc)
{
  // copy the states from states and add loc to the location vector
  loc_ref_vec locs;
  symb_states_type::const_iterator i;
  for (i=states.begin();i!=states.end();++i)
  {
    locs.clear();
    locs.push_back(i->first);
    locs.push_back(loc);
    (*this)[locs]=i->second;
  };
}

bool
symb_vec_states_type::contains(const loc_ref_vec& tlocs, const clock_val_set& cvs) // const
{
  if (find(tlocs)!=end())
  {
    if ((*this)[tlocs].contains_simple(cvs))      // faster, but not always correct
//      if ((*this)[tlocs].contains(cvs))
      return true;
    else
      return false;
  }
  else
    return false;
}

void
symb_vec_states_type::add(const loc_ref_vec& locs, clock_val_set& cvs)
{
  // add cvs to reach set and process only the new bits
  // must use if case since otherwise reach_set[loc] is initialized with the default constructor,
  // which is a) universal and b) of dimension 1. Both are wrong in this case.
  if (find(locs)!=end())
  {
//          cvs=reach_set[locs].disj_union_assign(cvs);
      (*this)[locs].append(cvs); // new gf
//      (*this)[locs].union_assign_nocheck(cvs); // new gf
  }
  else
    (*this)[locs]=cvs;
}

bool
symb_vec_states_type::intersection_is_empty(const symb_vec_states_type& svs, const unsigned int &wildc) const
{
  bool found=false;
  loc_ref_vec locs;
  clock_val_set cvs;
  symb_vec_states_type::const_iterator i,j;
  i=this->begin();
  while ((i!=this->end()) && (!found))
  {
    j=svs.begin();
    while ((j!=svs.end()) && (!found))
    {
      if (i->first.compare_wildcard(j->first,wildc))
      {
        cvs=i->second;
        cvs.intersection_assign(j->second);
        if (!cvs.is_empty())
          found=true;
      };
      ++j;
    };
    ++i;
  };
  return !found;
}

bool
symb_vec_states_type::intersection_is_empty(const loc_ref_vec& locs, const clock_val_set& lcvs, const unsigned int &wildc) const
{
  bool found=false;
  clock_val_set cvs;
  symb_vec_states_type::const_iterator i;
  i=this->begin();
  while ((i!=this->end()) && (!found))
  {
    if (i->first.compare_wildcard(locs,wildc))
    {
//        cvs=lcvs;
//        cvs.intersection_assign(i->second);
      cvs.intersection_assign_from(lcvs,i->second);
      if (!cvs.is_empty())
        found=true;
    };
    ++i;
  };
  return !found;
}

symb_states_type
symb_vec_states_type::to_loc_ref(loc_ref_vec_to_loc_ref_map lmap, const unsigned int &wildc) const
{
  symb_states_type out_states;
  symb_vec_states_type::const_iterator i;
  i=this->begin();
  while (i!=this->end())
  {
    if (i->first.contains_wildcard(wildc))
    { // check all entries in map if they match (inefficient, but what the heck)
      for (loc_ref_vec_to_loc_ref_map::const_iterator j=lmap.begin();j!=lmap.end();++j)
      {
        if (i->first.compare_wildcard(j->first,wildc))
        {
          out_states.insert(symb_states_pair (lmap[j->first],i->second));
        };
      };
    }
    else // add mapped entry to out_states
    {
      out_states.insert(symb_states_pair (lmap[i->first],i->second));
    };
    ++i;
  };

  return out_states;
}

void
symb_vec_states_type::print() const
{
  loc_ref_vec locs;
  clock_val_set cvs;
  symb_vec_states_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    locs=i->first;
    cvs=i->second;

    cout << "Location " << locs << ":" << endl;
    cvs.print();

    ++i;
  };
}


// ------------------------------------------------------------------------
// symb_vec_ccvs_list
// ------------------------------------------------------------------------

void
symb_vec_ccvs_list::append(const loc_ref_vec& locs, const convex_clock_val_set& ccvs)
{
  // check if this is already contained in the waiting list
  symb_vec_ccvs_list::iterator i=begin();
  bool found=false, split=false;

  while (!found && !split && i!=end())
  {
    if (!ccvs.is_disjoint_from(i->second))
    {
      if (i->first==locs) // same location
      {
        // test if ccvs is contained in i->second, or the other way around
        if (i->second.contains(ccvs))
          found=true;
        else if (ccvs.contains(i->second))
        {
          // replace *i with ccvs
          i->second=ccvs;
          found=true;
        }
        else // it's not disjoint and no containment, therefore take away the intersection
        {
// new gf
//            split=true;
//            clock_val_set remains(ccvs);
//            remains.difference_assign(i->second);
//            append(locs,remains);
        };
      };
    };
    ++i;
  };

  if (!found && !split)
    push_back(symb_vec_ccvs_pair(locs,ccvs));
}

void
symb_vec_ccvs_list::append(const loc_ref_vec& locs, const clock_val_set& cvs)
{
  // only append non-empty cvs
  if (!cvs.is_empty())
  {
    list<convex_clock_val_set>::const_iterator i;
    for (i = cvs.ccvs_list.begin(); i != cvs.ccvs_list.end(); ++i)
    {
      append(locs, *i);
    };
  };
}

void
symb_vec_ccvs_list::print() const
{
  loc_ref_vec locs;
  convex_clock_val_set ccvs;
  symb_vec_ccvs_list::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    locs=i->first;
    ccvs=i->second;

    cout << "Location " << locs << ":" << endl;
    ccvs.print();

    ++i;
  };
}

// ------------------------------------------------------------------------
// state_relation
// ------------------------------------------------------------------------

location_ref_pair_list
state_relation::get_location_ref_pairs() const
{
  location_ref_pair_list lrp;
  for (state_relation::const_iterator i=begin();i!=end();++i)
  {
    lrp.push_back(i->first);
  };
  return lrp;
}

void
state_relation::intersection_assign(state_relation& R)
{
  location_ref_pair lrp;

  state_relation::iterator i=begin();
  while (i!=end())
  {
    lrp=i->first;
    if (R.find(lrp)!=R.end())
    {
      i->second.intersection_assign(R[lrp]);
    }
    else
    {
      (*i).second=clock_val_set(i->second.dim,EMPTY);
    };
    ++i;
  };

  // erase empty
  i=begin();
  while (i!=end())
  {
    if (i->second.is_empty())
    {
      erase(i);
      i=begin();
    }
    else
      ++i;
  };
}

void
state_relation::difference_assign(state_relation& R)
{
  location_ref_pair lrp;

  state_relation::iterator i=begin();
  while (i!=end())
  {
    lrp=i->first;
    if (R.find(lrp)!=R.end())
    {
      i->second.difference_assign(R[lrp]);
    }
    else
    {
      // don't do nothin' #####(*i).second=clock_val_set(i->second.dim,EMPTY);
    };
    ++i;
  };

  // erase empty
  i=begin();
  while (i!=end())
  {
    if (i->second.is_empty())
    {
      erase(i);
      i=begin();
    }
    else
      ++i;
  };
}

symb_states_type
state_relation::project_to_first(dimension_type& first_dim) const
{
  symb_states_type s;
  location_ref_pair lrp;
  clock_val_set cvs;

  for (state_relation::const_iterator i=begin(); i!=end(); ++i)
  {
    lrp=i->first;
    cvs=i->second;

    cvs.remove_space_dimensions(first_dim,cvs.dim-1);
    s.add(lrp.first,cvs);
  };

  return s;
}

symb_states_type
state_relation::project_to_first(const symb_states_type& q) const
{
	// return R^(-1)[q]
  symb_states_type s;
  location_ref_pair lrp;
  clock_val_set cvs;
	
	if (!q.is_empty() && !empty())
	{
		dimension_type first_dim=begin()->second.dim-q.begin()->second.dim;

		for (state_relation::const_iterator i=begin(); i!=end(); ++i)
		{
			lrp=i->first;
			// find the location in q
			if (q.find(lrp.second)!=q.end())
			{
				cvs=q.find(lrp.second)->second;
				cvs.add_space_dimensions_and_embed_before(i->second.dim-cvs.dim); // make room for the variables of the first automaton
				cvs.intersection_assign(i->second);
				
				cvs.remove_space_dimensions(first_dim,cvs.dim-1); // existential quantification over the variables of the second automaton
				s.add(lrp.first,cvs);
			};
		};
	};

  return s;
}

state_relation
state_relation::transpose(dimension_type dim1,dimension_type dim2)
{
  state_relation RT;
  location_ref_pair lrp;
  clock_val_set cvs;
  // transpose
  if (!empty())
  {
    if ((dim1+dim2)!=begin()->second.dim)
      throw_error("state_relation::transpose: Dimensions don't match.");
    for (state_relation::const_iterator i=begin();i!=end();++i)
    {
      lrp=i->first;
      cvs=i->second;
      cvs.dimension_move_assign(0,dim1-1,dim2); // swap first dim1 variables with the rest
      RT[location_ref_pair(lrp.second,lrp.first)]=cvs; // clock_val_set(dim+spec_aut.dim);
    };
  };
  return RT;
}

void
state_relation::intersect_ident_symmetric(const location_ref_pair& lrp)
{
  // make sure changes in R[lrp] also take place in RT[lrpT]
  // R must be in symmetric dimensions.
  location_ref_pair lrpT(lrp.second,lrp.first);
  clock_val_set cvs=(*this)[lrp];
  dimension_type dim1=cvs.dim/2;
  cvs.dimension_move_assign(0,dim1-1,dim1); // swap first dim1 variables with the rest
  (*this)[lrpT].intersection_assign(cvs);
  (*this)[lrpT].simplify();
}

void
state_relation::assign_ident_symmetric()
{
  // R into a symmetric relation. R must be of symmetric dimensions.
  location_ref_pair lrp,lrpT;
  for (state_relation::iterator i=begin();i!=end();++i)
  {
    lrp=i->first;
    lrpT=location_ref_pair(lrp.second,lrp.first);
    if ((*this).find(lrpT)==(*this).end()) // it's empty
      i->second=clock_val_set(i->second.dim,EMPTY);
    else
      (*this).intersect_ident_symmetric(lrp);
  };
}

void
state_relation::print() const
{
  cout << "State relation:" << endl;
  for (state_relation::const_iterator i=begin();i!=end();++i)
  {
    cout << i->first << ":" << endl;
    i->second.print();
  };
  print_size();  
  cout << "--." << endl;
}

void
state_relation::print_size() const
{
  cout << "State relation size:" << endl;
  cout << size() << " loc pairs, ";
  long int s=0;
  for (state_relation::const_iterator i=begin();i!=end();++i)
  {
    s+=i->second.size();
  };
  cout << s << " conv. polyh." << endl;
}

void
state_relation::message_size(unsigned int level) const
{
  long int s=0;
  for (state_relation::const_iterator i=begin();i!=end();++i)
  {
    s+=i->second.size();
  };
  message(level,"State relation size:" + int2string(size()) + " loc pairs, " + int2string(s) + " conv. polyh.");
}

// -----------------------------------------------------

symb_state::symb_state(const location_ref& l, const clock_val_set& cvs) : clock_val_set(cvs),loc(l)
{}

symb_state_maplist::symb_state_maplist() {}

symb_state_maplist::symb_state_maplist(const symb_states_type& states, symb_state_plist& newstates)
{
	// get all states from "states", and add references to them to "newstates"
	symb_state_maplist::iterator state_it;
  for (symb_states_type::const_iterator i=states.begin();i!=states.end();++i)
  {
//      cout << "." << flush;
  state_it = add(i->first,i->second);
	if (state_it != end() && newstates.find(state_it)==newstates.end())
		newstates.push_back(state_it);
  };
}

void 
symb_state_maplist::clear()
{
	// Erase all content
	this->list< symb_state >::clear();
  iter_map.clear();		
}

void
symb_state_maplist::initialize(const symb_states_type& states, symb_state_plist& newstates, bool use_convex_hull)
{
	// get all states from "states", and add references to them to "newstates"
	clear();
	
	symb_state_maplist::iterator state_it;
  for (symb_states_type::const_iterator i=states.begin();i!=states.end();++i)
  {
//      cout << "." << flush;
		if (!use_convex_hull)
			state_it = add(i->first,i->second);
		else
			state_it = convex_hull_add(i->first,i->second);

	if (state_it != end() && newstates.find(state_it)==newstates.end())
		newstates.push_back(state_it);
  };
}

symb_state_maplist::iterator 
symb_state_maplist::erase(const symb_state_maplist::iterator it)
{
   // remove iterator from iter_map
   location_ref loc=it->loc;
   if (iter_map.find(loc)!=iter_map.end())
   {
      iter_map[loc].erase(it);
      if (iter_map[loc].empty()) // get rid of the location if the iter_map is empty anyway
         iter_map.erase(loc);
   };
   return list< symb_state >::erase(it);
};

void
ssl_to_symb_state_plist_map::add(list<symb_state>::iterator from_p)
{
   // add just a node without successors
   
   // cycle through from_ps to find whether it exists
   my_list::iterator from_it=begin();
   while (from_it!=end() && from_it->first!=from_p)
      ++from_it;
   // if not found, add a new one
   if (from_it==end())
   {
      push_front(make_pair(from_p,successor_list()));
      from_it=begin();
   }
}

void
ssl_to_symb_state_plist_map::add(list<symb_state>::iterator from_p,list<symb_state>::iterator to_p, distribution_info t)
{
   // insert edge from from_p to to_p, adding vertices if necessary 
   
   // cycle through from_ps to find whether it exists
   my_list::iterator from_it=begin();
   while (from_it!=end() && from_it->first!=from_p)
      ++from_it;
   // if not found, add a new one
   if (from_it==end())
   {
      push_front(make_pair(from_p,successor_list()));
      from_it=begin();
   }
   // Check if the destination already exists
   // to do: this should be superfluous
   if (true)
   {
      my_list::iterator to_it=begin();
      while (to_it!=end() && to_it->first!=to_p)
         ++to_it;
      // if not found, add a new one
      if (to_it==end())
      {
         push_front(make_pair(to_p,successor_list()));
         to_it=begin();
      }
   }   
   // check if it's already in the list
   // if not, add it
   pair<list<symb_state>::iterator, distribution_info> successor = make_pair(to_p, t);

   for(successor_list::iterator i = from_it->second.begin(); i != from_it->second.end(); i++)
   {
	if(*i == successor) return;
   }
   from_it->second.push_back(successor);
}

void 
ssl_to_symb_state_plist_map::erase(list<symb_state>::iterator from_p)
{
   // go through from and to lists and remove any iterator == from_p
   
   my_list::iterator from_it=begin();
   successor_list::iterator pit;
   while (from_it!=end())
   {
      if (from_it->first==from_p)
      {
         from_it=my_list::erase(from_it);
      }
      else
      {
         pit=from_it->second.begin();
         while (pit!=from_it->second.end())
         {
            if (pit->first==from_p)
               pit=from_it->second.erase(pit);
            else
               ++pit;
         }
         ++from_it;
      }
   }   
}

void 
ssl_to_symb_state_plist_map::duplicate(list<symb_state>::iterator from_p,list<symb_state>::iterator to_p)
{
   // go through from and to lists and add to any occurance of from_p also to_p
   
   if (from_p != to_p) // otherwise we'll get an infinite loop
   {
      my_list::iterator from_it=begin();
      successor_list::iterator pit;
      while (from_it!=end())
      {
         if (from_it->first==from_p)
         {
            push_back(make_pair(to_p,from_it->second)); // add at end so it will be processed later by this loop
         }
         pit=from_it->second.begin();
         while (pit!=from_it->second.end())
         {
            if (pit->first==from_p)
            {
               distribution_info distr_info = pit->second;
               ++pit;
               from_it->second.insert(pit,make_pair(to_p,distr_info)); // to_p is inserted before pit, so increase pit beforehand, thus inserting to_p afterwards
            }
            else
               ++pit;
         }
         ++from_it;
      }
   }  
}

void 
ssl_to_symb_state_plist_map::print(ostream& o, const map <location_ref,string>& loc_names_map, const map<label_ref,string>& label_names) const
{
   o << size() << endl; // Number of polyhedra
   
   // first, print location_refs
   int cnt(0);
   my_list::const_iterator from_it=begin();
   while (from_it!=end())
   {
      o << cnt << " ";
      if (loc_names_map.find(from_it->first->loc)!=loc_names_map.end())
         o << loc_names_map.find(from_it->first->loc)->second << endl;
      else
         o << "[location # " << from_it->first->loc << "]" << endl;
      ++cnt;
      ++from_it;
   }
   o << endl;
   
   // second, print adjacency lists
   cnt=0;
   from_it=begin();
   while (from_it!=end())
   {
      o << cnt << " ";
      for (successor_list::const_iterator pit=from_it->second.begin();pit!=from_it->second.end();++pit)
      {
         if (pit!=from_it->second.begin())
            o << ",";
         // figure out the corresponding number of the pointer
         // for lack of enthusiasm: count
         int pcnt(0);
         my_list::const_iterator pfrom_it=begin();
         while (pfrom_it!=end() && pfrom_it->first!=pit->first)
         {
            ++pcnt;
            ++pfrom_it;
         }
         if (pfrom_it!=end())
            o << pcnt;
         else
            o << "???";
         //print transition label
         //if(label_names.find(pit->second) != label_names.end())
         //    o << " " << label_names.find(pit->second)->second;
         //else
         //    o << " ???";
      }
      o << " -1" << endl;
      ++cnt;
      ++from_it;
   }
   o << endl;   
}

void 
ssl_to_symb_state_plist_map::print2(string file_name, const automaton &aut, const symb_states_type &unsafe) const
{
   ofstream o;
   o.open(file_name.c_str());
   if(!o)
   {
       cerr << "Failed to open file " << file_name;
       return;
   }

/*
	message(12, "initial states: " + int2string(aut.ini_states.size()));
   symb_states_type::const_iterator ini = aut.ini_states.begin();
	cout << "loc: " << ini->first << "\n";
	cout << "cvs: " << ini->second << "\n";
*/

   map<location_ref,string> loc_names_map = aut.get_loc_names_map();
   map<label_ref,string> label_names = aut.get_label_names_map();

   o << "INIT\n";
   int cnt(0);
   my_list::const_iterator from_it=begin();
   while (from_it!=end())
   {
	symb_states_type states;
	states.add(from_it->first->loc, *(from_it->first));

	//if (aut.ini_states.contains(states, false))
	states.intersection_assign(aut.ini_states, false);
	if (!states.is_empty())
	{
		o << cnt << endl;
	}
	++cnt;
	++from_it;
   }

   // print unsafe states
   o << "UNSAFE\n";
   cnt = 0;
   from_it=begin();
   while (from_it!=end())
   {
	symb_states_type states;

	if (loc_names_map.find(from_it->first->loc)!=loc_names_map.end())
        	states.add(loc_names_map.find(from_it->first->loc)->second, from_it->first->loc, *(from_it->first));
	else
        	states.add(from_it->first->loc, *(from_it->first));

	//if (unsafe.contains(states, true)) 
	states.intersection_assign(unsafe, true);
	if (!states.is_empty()) 
	{
		o << cnt << endl;
	}
	++cnt;
	++from_it;
   }
   
   o << "DISTRIBUTIONS\n";
   for(unsigned int i = 0; i < aut.distributions.size(); ++i)
   	for(unsigned int j = 0; j < aut.distributions[i].size(); ++j)
   	{
   		o << "d" << i << "_" << j << " " << i << " " << aut.distributions[i][j] << endl;
   	}

   // print adjacency lists
   o << "TRANSITIONS\n";
   cnt=0;
   from_it=begin();

   while (from_it!=end())
   {
      for (successor_list::const_iterator pit=from_it->second.begin();pit!=from_it->second.end();++pit)
      {
         // figure out the corresponding number of the pointer
         // for lack of enthusiasm: count
         int pcnt(0);
         my_list::const_iterator pfrom_it=begin();
         while (pfrom_it!=end() && pfrom_it->first!=pit->first)
         {
            ++pcnt;
            ++pfrom_it;
         }
         if (pfrom_it!=end())
           o << cnt << " " << pcnt;
         else
            o << "???";
	 distribution_info di = pit->second;
	 o << " d" << di.distribution << "_" << di.distribution_entry;
         o << endl;
      }
      ++cnt;
      ++from_it;
   }
   o << "END" << endl;
   o.close();
}

// ---------------------------------
// symb_state_maplist
// ---------------------------------

symb_state_maplist::iterator
symb_state_maplist::add(const location_ref& loc, clock_val_set cvs, list<symb_state>::iterator& pred, distribution_ref distr, unsigned int distr_entry)
{
   // to do: there should be a better way without making a copy of cvs
      
   
   bool found=false;
   list<symb_state>::iterator new_it(end());
   
   if (iter_map.find(loc)!=iter_map.end()) // loc already exists
   {
      list< list<symb_state>::iterator >::iterator map_iter=iter_map[loc].begin();
      while (!found && (map_iter!=iter_map[loc].end()))
      {
         if ((*map_iter)->contains_return_others(cvs))
         {
      //        if ((*map_iter)->contains_simple(cvs))
      //        if ((*map_iter)->contains(cvs))
            found=true;
            if (pred != symb_state_maplist_dummy_iterator)
            {
               creation_graph.add(pred,*map_iter, distribution_info(distr, distr_entry));
            }
         }
         ++map_iter;
      };
   };
   if (!found)
   {
      //symb_state state(loc,cvs);
      if (MEMORY_MODE>=4)
      cvs.minimize_memory();
      push_front(symb_state(loc,cvs));
      new_it=begin();
      iter_map[loc].push_front(new_it);
      // add iterator to creation_graph
      if (pred != symb_state_maplist_dummy_iterator)
      {
         creation_graph.add(pred,new_it, distribution_info(distr, distr_entry));
      }
      
      return new_it;
   };
   return new_it;
}

symb_state_maplist::iterator
symb_state_maplist::convex_hull_add(const location_ref& loc, clock_val_set cvs, list<symb_state>::iterator& pred, distribution_ref distr, unsigned int distr_entry)
{
	// to be consistent with the reachability iteration, it must search the waiting list newstates only up to the current iteration
  // to do: there should be a better way without making a copy of cvs
	stopwatch sw(2048000,"convex_hull_add");
		
  bool found=false;
  if (iter_map.find(loc)!=iter_map.end()) // loc already exists
  {
    list< list<symb_state>::iterator >::iterator map_iter=iter_map[loc].begin();
    // there is only one cvs per location
    // new cvs to by convex hull
    if ((*map_iter)->contains_return_others(cvs))
    {
      found=true;
      if (pred != symb_state_maplist_dummy_iterator)
      {
         creation_graph.add(pred,*map_iter, distribution_info(distr, distr_entry));
      }
    }
    else
    {
      (*map_iter)->convex_hull_assign(cvs);
      if (pred != symb_state_maplist_dummy_iterator)
      {
         creation_graph.add(pred,*map_iter, distribution_info(distr, distr_entry));
      }

            
    if (MEMORY_MODE>=4)
      (*map_iter)->minimize_memory();
//  		(*map_iter)->limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
			
//			if (CONVEX_HULL_ADD_WIDENING)
//				(*map_iter)->ccvs_list.begin()->BHRZ03_widening_assign(cvs.ccvs_list.begin());
			

 if (DEBUG_OUTPUT>1 && sw.value() > 0.5) 
  cout << endl << "Exceeding time in convex_hull_add, took " << sw.value() << " for " << cvs.size() << " polyhedra" << endl << flush; 
			return *map_iter;
    };
  }
  else
  {
    if (MEMORY_MODE>=4)
      cvs.minimize_memory();
  
    symb_state state(loc,cvs);
    state.convex_hull_assign();
    push_front(state);
    iter_map[loc].push_front(begin());
  	
   if (pred != symb_state_maplist_dummy_iterator)
   {
      creation_graph.add(pred,begin(),distribution_info(distr, distr_entry));
   }
//		begin()->limit_constraints_and_bits(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
		
if (sw.value() > 0.2) { if (DEBUG_OUTPUT>1)
  cout << endl << "Exceeding time in convex_hull_add, took " << sw.value() << " for " << cvs.size() << " polyhedra" << endl << flush;}; 
		return begin();
  };
	return end();
}

void
symb_state_maplist::copy_new(const location_ref& loc, clock_val_set cvs, symb_state_plist& newstates)
{
  // simply add the cvs to the newstates
  // to do: don't keep the old ones?

  symb_state state(loc,cvs);
  push_front(state);
  iter_map[loc].push_front(begin());
  newstates.push_back(begin());
}

bool
symb_state_maplist::intersection_is_empty(const symb_states_type& states)
{
  bool found=false;
  location_ref loc;
  clock_val_set cvs,cvs2;
  symb_states_type::const_iterator i=states.begin();
  list< list<symb_state>::iterator >::iterator j;

  while ((i!=states.end()) && (!found))
  {
    loc=i->first;
    if (iter_map.find(loc)!=iter_map.end())
    {
      j=iter_map[loc].begin();
      while ((j!=iter_map[loc].end()) && (!found))
      {
        cvs.intersection_assign_from(i->second,*(*j));
        if (!cvs.is_empty())
          found=true;
        ++j;
      };
    };
    ++i;
  };
  return !found;
}

void
symb_state_maplist::get_all_states(symb_state_plist& newstates)
{
  for (list< symb_state >::iterator i=begin();i!=end();++i)
  {
    newstates.push_front(i);
  };
}

bool 
symb_state_maplist::is_empty(const location_ref& loc)
{
	if (iter_map.find(loc)!=iter_map.end())
	{
		return false;
		
/*	  list< list<symb_state>::iterator >::iterator j=iter_map[loc].begin();
		while ((j!=iter_map[loc].end()))
		{
			if (!(*j)->is_empty())
				return false;
			++j;
		};		*/
	};
	return true;	
}

bool 
symb_state_maplist::assign_empty(const location_ref& loc, symb_state_plist& check_states)
{
	// empty all symb_states of location loc
	// return true if something has changed, false otherwise
	if (iter_map.find(loc)!=iter_map.end())
	{
		// erase all references to loc in iter_map
		symb_state_plist::iterator pit;
	   list< list<symb_state>::iterator >::iterator j=iter_map[loc].begin();
		while ((j!=iter_map[loc].end()))
		{
			// find reference in check_states and remove it
			pit=check_states.begin();
			while (pit!=check_states.end());
			{
				if ((*pit)==(*j))
				{
					pit=check_states.erase(pit);
				}
				else
					++pit;
				//pit=check_states.find(*j);
			};
         // erase the reference in the creation graph
         creation_graph.erase(*j);
			// erase the actual symbolic state
			list< symb_state >::erase(*j);
			// erase the reference in the iter_map
			j=iter_map[loc].erase(j);
//			++j;
		};		
		
		// erase iter_map entry itself
		iter_map.erase(iter_map.find(loc));
	};
	return false;	
}

void
symb_state_maplist::print()
{
  for (map<location_ref, symb_state_plist >::const_iterator i=iter_map.begin();i!=iter_map.end();++i)
  {
    cout << "Location " << i->first << ":"  << endl;
    for (symb_state_plist::const_iterator j=i->second.begin();j!=i->second.end();++j)
    {
      (*j)->print();
    };
  };
}

unsigned int
symb_state_maplist::cvs_size() const
{
  unsigned int s=0;
  for (map<location_ref, symb_state_plist >::const_iterator i=iter_map.begin();i!=iter_map.end();++i)
  {
    for (symb_state_plist::const_iterator j=i->second.begin();j!=i->second.end();++j)
    {
      s+=(*j)->size();
    };
  };
  return s;
}

unsigned int
symb_state_maplist::loc_size() const
{
  return iter_map.size();
}

//  symb_states_type get_symb_states(dimension_type dim, unsigned int nstates)
symb_states_type
symb_state_maplist::get_symb_states()
{
  symb_states_type states;

  // copy all states from map to states[i]
  for (map<location_ref, symb_state_plist >::const_iterator i=iter_map.begin();i!=iter_map.end();++i)
  {
    for (symb_state_plist::const_iterator j=i->second.begin();j!=i->second.end();++j)
    {
      if (states.find(i->first)!=states.end())
      {
        states[i->first].union_assign(*(*j));
//        states[i->first].simplify();
      }
      else
      {
        states[i->first]=*(*j);
//        states[i->first].simplify();
      };
    };
  };

  /*
  for (symb_states_type::iterator i=states.begin();i!=states.end();++i)
  {
      i->second.simplify();
  };
  */

  return states;
}

//  symb_states_type get_symb_states(dimension_type dim, unsigned int nstates)
clock_val_set
symb_state_maplist::get_clock_val_set(location_ref loc) const
{
	map<location_ref, symb_state_plist >::const_iterator i(iter_map.find(loc));
	if (empty())
		return clock_val_set(0,Parma_Polyhedra_Library::EMPTY);
	else if (i==iter_map.end())
	{
		return clock_val_set(begin()->dim,Parma_Polyhedra_Library::EMPTY);
	}
	else
	{ // *this is not empty, and iter_map contains loc
		symb_state_plist::const_iterator j=i->second.begin();
		clock_val_set cvs(*(*j));

		// copy the rest of the states
		++j;
		while (j!=i->second.end())
		{
			cvs.union_assign(*(*j));
		};					
		return cvs;
  };
}

symb_states_type
symb_state_maplist::transfer_symb_states()
{
	// transfer the states to output and destruct *this in the process
  symb_states_type states;

  // copy all states from map to states[i]
	while (!empty())
	{
		if (states.find(begin()->loc)!=states.end())
		{
			states[begin()->loc].union_assign(*begin());
//        states[i->first].simplify();
		}
		else
		{
			states[begin()->loc]=*begin();
//        states[i->first].simplify();
		};
		erase(begin());
  };

  return states;
}

symb_states_type
symb_state_maplist::get_symb_states(symb_state_plist& newstates)
{
  symb_states_type states;

  // copy states in newstates from map to states[i]
  for (symb_state_plist::const_iterator j=newstates.begin();j!=newstates.end();++j)
  {
    if (states.find((*j)->loc)!=states.end())
    {
      states[(*j)->loc].union_assign(*(*j));
//      states[(*j)->loc].simplify();
    }
    else
    {
      states[(*j)->loc]=*(*j);
//      states[(*j)->loc].simplify();
    };
  };

  /*
  for (symb_states_type::iterator i=states.begin();i!=states.end();++i)
  {
      i->second.simplify();
  };
  */

  return states;
}


int
symb_state_maplist::max_bit_size(symb_state_plist& newstates) const
{
  symb_states_type states;
	int m=0;
	int dum;

  for (symb_state_plist::const_iterator j=newstates.begin();j!=newstates.end();++j)
  {
		dum = (*j)->max_bit_size();
		if (dum>m)
			m=dum;
  };

  return m;
}

int
symb_state_maplist::max_constraint_size(symb_state_plist& newstates) const
{
  symb_states_type states;
	int m=0;
	int dum;

  for (symb_state_plist::const_iterator j=newstates.begin();j!=newstates.end();++j)
  {
		dum = (*j)->max_constraint_size();
		if (dum>m)
			m=dum;
  };

  return m;
}

void
symb_state_maplist::split(location_ref oldloc, const clock_val_set& oldinv, location_ref newloc, const clock_val_set& newinv,symb_state_plist& check_states, symb_state_plist& new_states, bool convex)
{
	// For splitting a location in two
	
	clock_val_set cvs;
	symb_state_maplist::iterator itnew;
	//symb_state_plist dummylist;
	bool erase_me(false);
	
//cout << "Before splitting with :" << oldinv << " and " << newinv << endl;
//print();	
	
	// iterate itold through iter_map[oldloc]
	symb_state_maplist::iterator itold=begin(); 
	while (itold!=end())
	{
		erase_me=false;
		if (itold->loc==oldloc)
		{
			// - add intersection with newinv to maplist and get iterator itnew
			cvs.intersection_assign_from(*itold,newinv);
			if (!cvs.is_empty())
			{
				if (!convex)
					itnew=add(newloc,cvs);
				else
					itnew=convex_hull_add(newloc,cvs);
			}
			else
				itnew=end();
         if (itnew!=end())
            creation_graph.duplicate(itold,itnew);
            
			// - intersect with invariant of oldloc
			itold->intersection_assign(oldinv);
			// - if itold is in newstates, add itnew to to newstates
			if (itnew != end())
			{
				if (new_states.find(itold)!=new_states.end() && new_states.find(itnew)==new_states.end())
					new_states.insert(new_states.find(itold),itnew); // insert the copy before the old ones
				if (check_states.find(itold)!=check_states.end() && check_states.find(itnew)==check_states.end())
					check_states.insert(check_states.find(itold),itnew); // insert the copy before the old ones
			};
			// erase itold if it's empty now
			if (itold->is_empty())
			{
				if (new_states.find(itold)!=new_states.end())
					new_states.erase(itold);
				if (check_states.find(itold)!=check_states.end())
					check_states.erase(itold);
				erase_me=true;
			};
		};
		if (erase_me)
      {
         creation_graph.erase(itold);
			itold=erase(itold);
      }
		else
			++itold;
	};

//cout << "After splitting:" << endl;
//print();	

}
