#ifndef GUARD_symb_states_h
#define GUARD_symb_states_h
/***************************************************************************
                          symb_states.h  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <algorithm>
#include <stdexcept>
//#include <ext/hash_map>

#include "clock_val_set.h"
#include "symb_states_type.h"
#include "probabilistic_alternative.h"

//using namespace Parma_Polyhedra_Library;
//using namespace Parma_Polyhedra_Library::IO_Operators;
//using namespace std;

extern int REACH_CONSTRAINT_LIMIT;
extern int CONSTRAINT_BITSIZE;
extern bool CREATION_GRAPH_OUTPUT;
 
typedef pair<location_ref, clock_val_set> symb_states_pair;


class symb_states_pair_type : public map<pair<location_ref,location_ref>, pair<clock_val_set,clock_val_set> > // states of several locations
{
  public:
  void print() const;
};

class loc_ref_vec : public vector<location_ref>
{
  friend ostream&
    operator<<( ostream& os, const loc_ref_vec &locs );

  public:
  loc_ref_vec() {};
  loc_ref_vec(uint dim) : vector<location_ref>(dim) {};
  
  bool compare_wildcard(const loc_ref_vec &locs, const unsigned int &wildcard) const;

  bool contains_wildcard(const unsigned int &wildcard) const;
};

class location_ref_pair : public pair<location_ref,location_ref>
{
  friend ostream&
    operator<<( ostream& os, const location_ref_pair &lrp );

  public:
  location_ref_pair();
  location_ref_pair(const location_ref& a, const location_ref& b);
};

class location_ref_pair_list : public list < location_ref_pair >
{
  // todo: could sort this list to make the search faster

  public:
  void add(const location_ref_pair& lrp);
};

class location_ref_to_location_ref_pair_map : public map <location_ref,location_ref_pair>
{
  public:
  location_ref_to_location_ref_pair_map::iterator find(location_ref& loc);

  bool find(location_ref_pair& lrp, location_ref& loc, bool alarm=true);

  void print();
};

typedef map<loc_ref_vec, clock_val_set>::value_type symb_vec_state_type;

class loc_ref_vec_to_loc_ref_map : public map < loc_ref_vec,location_ref >
{
  public:

  bool find(location_ref& loc, loc_ref_vec& lrv);

  void remap(location_ref_to_location_ref_pair_map& lprmap, unsigned int vec_size);

  void print();
};

//typedef pair < loc_ref_vec,location_ref >  loc_ref_vec_loc_ref_pair;

class symb_vec_states_type : public map<loc_ref_vec, clock_val_set>
{
  public:
  symb_vec_states_type();

  symb_vec_states_type(const symb_states_type& states);

  symb_vec_states_type(const symb_states_type& states, const location_ref& loc);

  bool contains(const loc_ref_vec& tlocs, const clock_val_set& cvs);

  void add(const loc_ref_vec& locs, clock_val_set& cvs);

  bool intersection_is_empty(const symb_vec_states_type& svs, const unsigned int &wildc=MAX_UNSIGNED_INT) const;

  bool intersection_is_empty(const loc_ref_vec& locs, const clock_val_set& lcvs, const unsigned int &wildc=MAX_UNSIGNED_INT) const;

  symb_states_type to_loc_ref(loc_ref_vec_to_loc_ref_map lmap, const unsigned int &wildc) const;

  void print() const;
};

typedef pair<loc_ref_vec, convex_clock_val_set> symb_vec_ccvs_pair;

class symb_vec_ccvs_list : public list<symb_vec_ccvs_pair>
{
  public:
  void append(const loc_ref_vec& locs, const convex_clock_val_set& ccvs);

  void append(const loc_ref_vec& locs, const clock_val_set& cvs);

  void print() const;

};
// ------------------------------------------------------------------------

class state_relation : public map < location_ref_pair , clock_val_set >
{
  // Note: if location_ref_pair is not in state_relation, the corresponding clock_val_set is considered empty!
  public:
  location_ref_pair_list get_location_ref_pairs() const;
  
  void intersection_assign(state_relation& R);
  
  void difference_assign(state_relation& R);

  symb_states_type project_to_first(dimension_type& first_dim) const;
  symb_states_type project_to_first(const symb_states_type& q) const;
  
  state_relation transpose(dimension_type dim1,dimension_type dim2);

  void intersect_ident_symmetric(const location_ref_pair& lrp);

  void assign_ident_symmetric();

  void print() const;

  void print_size() const;
  void message_size(unsigned int level) const;
};

// -----------------------------------------------------

class symb_state : public clock_val_set
{
  public:
  symb_state(const location_ref& l, const clock_val_set& cvs);// : clock_val_set(cvs),loc(l)

	void print() { cout << "[" << loc << "]:" << endl; clock_val_set::print(); };
  location_ref loc;
};

// for symb_states.h
static list<symb_state>::iterator symb_state_maplist_dummy_iterator;

class symb_state_plist : public list< list<symb_state>::iterator >
{
  public:
  unsigned int ccvs_size()
  {
    unsigned int s=0;
    for (list< list<symb_state>::iterator >::const_iterator it=begin(); it!=end(); ++it)
      s+=(*it)->size();
    return s;
  };
	
	list< list<symb_state>::iterator >::iterator find(const  list<symb_state>::iterator key )
	{
		list< list<symb_state>::iterator >::iterator it;
		for (it=begin(); it!=end(); ++it)
			if (*it==key)
				return it;
		return it;
	};

	list< list<symb_state>::iterator >::iterator find_up_to(const  list<symb_state>::iterator key, list< list<symb_state>::iterator >::iterator stop_pos )
	{
		list< list<symb_state>::iterator >::iterator it;
		for (it=begin(); it!=end() && it!=stop_pos; ++it)
			if (*it==key)
				return it;
		return end();
	};
	
	list< list<symb_state>::iterator >::iterator find_except(const  list<symb_state>::iterator key, list< list<symb_state>::iterator >::iterator stop_pos )
	{
		list< list<symb_state>::iterator >::iterator it;
		for (it=begin(); it!=end(); ++it)
			if (*it==key && it!=stop_pos)
				return it;
		return end();
	};
	
	symb_state_plist::iterator erase(const symb_state_plist::iterator it )
	{
		return list< list<symb_state>::iterator >::erase(it);
	};
	
	void erase(const  list<symb_state>::iterator key )
	{
		symb_state_plist::iterator it=begin();
//		list< list<symb_state>::iterator >::iterator it2=begin();
		while (it!=end())
		{
			if (*it==key)
			{
//				it2=it;
//				++it2;
				it=erase(it);
//				it=it2;
			}
			else
				++it;
		};
	};	
	
	void add_locations(loc_ref_set& lrs) const
	{ // add the locations in *this to lrs
		for (symb_state_plist::const_iterator it=begin(); it!=end(); ++it)
			lrs.insert((*it)->loc);
	};
	
	void print() const
	{
		for (symb_state_plist::const_iterator it=begin(); it!=end(); ++it)
			(*it)->print();
	};
};

//symb_state_maplist::iterator symb_state_maplist_dummy_iterator;

/*
struct list_symb_state_iter_comp {
bool operator()(const list<symb_state>::iterator& i1, const list<symb_state>::iterator& i2) const {
cout << std::distance(i1, i2) << "/" << std::distance(i2o, i1o) << ",";
return std::distance(i1, i2) < 0;
}
};
*/

class automaton;
typedef list < pair < list<symb_state>::iterator, distribution_info > > successor_list;

class ssl_to_symb_state_plist_map : public list < pair < list<symb_state>::iterator, successor_list > > 
{ 
   typedef list < pair < list<symb_state>::iterator, successor_list > > my_list;

   public:
   ssl_to_symb_state_plist_map() {};
   
   void add(list<symb_state>::iterator from_p);
   void add(list<symb_state>::iterator from_p,list<symb_state>::iterator to_p, distribution_info t);
   void erase(list<symb_state>::iterator from_p);
   void duplicate(list<symb_state>::iterator from_p,list<symb_state>::iterator to_p);
   void print(ostream& o, const map <location_ref,string>& loc_names_map, const map <label_ref,string>& label_names_map) const;
   void print2(string file_name, const automaton& aut, const symb_states_type& unsafe) const;
};

class symb_state_maplist : public list< symb_state >
{
  // Note the maplist is designed to be strictly increasing.
  // The entries must not be changed, otherwise the pointers in any associated symb_state_plist are void.
  
  public:
  symb_state_maplist();

  symb_state_maplist(const symb_states_type& states, symb_state_plist& newstates);
	
	void clear();
	
  void initialize(const symb_states_type& states, symb_state_plist& newstates, bool use_convex_hull);
	
	symb_state_maplist::iterator erase(const symb_state_maplist::iterator it);

   symb_state_maplist::iterator add(const location_ref& loc, clock_val_set cvs, list<symb_state>::iterator& pred=symb_state_maplist_dummy_iterator, distribution_ref distr = 0, unsigned int distr_entry = 0);
   symb_state_maplist::iterator convex_hull_add(const location_ref& loc, clock_val_set cvs, list<symb_state>::iterator& pred=symb_state_maplist_dummy_iterator, distribution_ref distr = 0, unsigned int distr_entry = 0);

  void copy_new(const location_ref& loc, clock_val_set cvs, symb_state_plist& newstates);

  bool intersection_is_empty(const symb_states_type& states);

  void get_all_states(symb_state_plist& newstates);
	
	bool is_empty(const location_ref& loc);
	bool assign_empty(const location_ref& loc, symb_state_plist& check_states);
	
	void split(location_ref oldloc, const clock_val_set& oldinv, location_ref newloc, const clock_val_set& newinv,symb_state_plist& check_states, symb_state_plist& new_states, bool convex);

  void print();

  unsigned int cvs_size() const;
  
  unsigned int loc_size() const;
  
  symb_states_type get_symb_states();
  symb_states_type get_symb_states(symb_state_plist& newstates);
  symb_states_type transfer_symb_states();

	clock_val_set get_clock_val_set(location_ref loc) const;
	  
  int max_bit_size(symb_state_plist& newstates) const;
  int max_constraint_size(symb_state_plist& newstates) const;
  
	// Properties

//  map<location_ref, list< list<symb_state>::iterator > > iter_map;
  map<location_ref, symb_state_plist > iter_map;
  
//   __gnu_cxx::hash_map< list<symb_state>::iterator,list<list<symb_state>::iterator> > creation_graph;
   //list < pair < list<symb_state>::iterator, symb_state_plist > > creation_graph;
   ssl_to_symb_state_plist_map creation_graph;
};

#endif
