/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #include "variable_time_elapse_func.h"
 
linear_vtef::linear_vtef(const Constraint_List& tp, dimension_type dim) : mydim(dim),mytp(tp)
{
	// add the extra dimensions to the variables that must be quantified
	for (dimension_type i=dim; i<mytp.space_dimension(); ++i)
	{ vars.insert(i); };
	
	mytp.add_space_dimensions_and_embed_to_dim(2*dim); // bring up to full dimension to avoid problems with map_dimensions etc
	
	static_tp=convex_clock_val_set(dim);
	
	// transfer static constraints to static_tp
	Constraint_List::iterator i=mytp.begin(); 
	while (i!=mytp.end())
	{
//cout << *i << endl << flush;	

		if (get_true_dimension(*i)<=dim)
		{
//cout << "static: " << *i << endl << flush;	
			static_tp.add_constraint(Constraint_restrict_to_dim(*i,dim));
//cout << "static_tp: " << static_tp << endl << flush;	
			i=mytp.erase(i);
		}
/* gf 051129
		else if (i->is_equality())
		{
			mytp.constraint_to_equality(i);
		}*/
		else
		{
			++i;
		};
	};
	
}

void 
linear_vtef::intersection_assign(const linear_vtef& lv)
{
	if (mydim != lv.mydim)
		throw_error("Dimensions incompatible at linear_vtef::intersection_assign");
	vars.union_assign(lv.vars);
	
//	if (mytp.space_dimension()!=lv.mytp.space_dimension())
		//throw_error("Incomaptible dimension in mytp " + int2string(mytp.space_dimension()) + " vs " + int2string(lv.mytp.space_dimension()));
	mytp.union_assign(lv.mytp); // the intersection of two conjuncts is the union of their constraints
	
	if (static_tp.space_dimension()!=lv.static_tp.space_dimension())
		throw_error("Incomaptible dimension static_tp " + int2string(static_tp.space_dimension()) + " vs " + int2string(lv.static_tp.space_dimension()));
	static_tp.intersection_assign(lv.static_tp);
}
	
void 
linear_vtef::add_space_dimensions_and_embed(dimension_type ndims)
{
	static_tp.add_space_dimensions_and_embed(ndims);
	mytp.add_space_dimensions_and_embed(2*ndims);
	
	// map the variables
	clock_ref_set newvars;
	for (clock_ref_set::iterator i=vars.begin(); i!=vars.end(); ++i)
	{
		newvars.insert(*i+ndims);
	};
	vars=newvars;
	
	// shift up the quant. variables in tp
	mytp.dimension_move_assign(mydim,2*mydim-1,mydim+ndims);
	
	mydim+=ndims;
}
	
// convex_clock_val_set 
// linear_vtef::vtef_at_generator(const Generator g)
// {
// 	// Todo: This should really take into account the type of generator
// 	// For now: assume it's point
// 	convex_clock_val_set tp=mytp;
// 
// 	// todo: what if g isn't a point?
// //cout << "unquantified: " << tp.space_dimension() << tp << endl << flush;	
// //cout << vars << endl;			
// //cout << "generator: ("<< g.space_dimension() << "): " << g << endl;
// 	if (g.is_point() || g.is_closure_point()) // otherwise it doesn't have a divisor
// 	{
// 		for (clock_ref_set::const_iterator it=vars.begin();it!=vars.end();++it)
// 		{
// //cout << "var " << *it << "-" << mydim << endl;
// 				tp.add_constraint(g.divisor()*Variable(*it)==g.coefficient(Variable(*it-mydim)));
// 		};
// 	}
// 	else
// 		throw_error("Can only handle bounded spaces in refinement, please bound all variables.");
// //cout << "quantified: " << tp << endl << flush;
// 	
// 	// Remove excess dimensions
// 	tp.remove_higher_space_dimensions(mydim);
// 	return tp;
// };
	
convex_clock_val_set 
linear_vtef::time_post(const clock_val_set& inv) const
{ 
	convex_clock_val_set ccvs(mydim);
	
// cout << endl << "Computing new time_post for mytp "<< mytp << endl << flush;		
// cout << "within invariant "  << inv << endl;

	// check for emptiness
	if (inv.is_empty())
		return convex_clock_val_set(mydim,EMPTY);

	// From now on we know that inv is not empty
	if (REFINE_DERIVATIVE_METHOD == 0 || REFINE_DERIVATIVE_METHOD == 1)	// push constraints to outsidex
	{
		Constraint c(0*Variable(mydim-1)<0); // dummy init
		Constraint c2(0*Variable(mydim-1)<0); // dummy init
		bool isnotemptyandbounded(true);
		bool c2_active(false);
		for (Constraint_List::const_iterator i=mytp.begin(); i!=mytp.end(); ++i)
		{
			c=*i;
	//		isnotemptyandbounded=minimize_constraint_from_dim(c,inv,mydim);  // push c towards the outside
			isnotemptyandbounded=minimize_constraint_from_dim(c,inv,mydim,c2,c2_active);  // push c towards the outside
			if (isnotemptyandbounded || c2_active)
				ccvs.add_constraint_and_minimize(c);
			if (c2_active)
				ccvs.add_constraint_and_minimize(c2);
		};
	//cout << "in: " << inv << endl;
	//cout << "tp: " << ccvs << endl;	
	};

	if (REFINE_DERIVATIVE_METHOD == 2 || REFINE_DERIVATIVE_METHOD == 3 || REFINE_DERIVATIVE_METHOD == 4) // exact
	{
//cout << "i:" << inv.dim << "," << inv.ccvs_list.begin()->space_dimension() << "+" << mydim << endl;   
		clock_val_set cvs(inv);
		cvs.add_space_dimensions_and_embed_before(mydim);
		cvs.add_constraint(mytp);
//cout << "before static: " << cvs;		
		clock_val_set cvs2(static_tp);
//cout << "static: " << static_tp;		
		cvs.intersection_assign(cvs2,true);
//cout << "after static: " << cvs;		
		cvs.remove_space_dimensions(mydim,2*mydim-1);
		ccvs=cvs.get_convex_hull();
//cout << "projected & convex hull: " << ccvs;		
	};

	if (REFINE_DERIVATIVE_METHOD == 1 || REFINE_DERIVATIVE_METHOD == 3) // bounding box of 1 or 2
	{
		// use bounding box
		convex_clock_val_set ccvs2(mydim);
		ccvs.shrink_bounding_box(ccvs2);
		ccvs.swap(ccvs2);
	};
		
	if (REFINE_DERIVATIVE_METHOD == 6) // vertice based
// ATTENTION: incomplete and obsolete
// to do: instantiate generators instead of constraints!!!
	{
		convex_clock_val_set ccvs2(mydim);
		// construct the tp in each vertice
		// the final tp is the convex hull of these
		Generator_List gl;
		// get the vertices of inv
		clock_val_set inv2=inv;
		inv2.convex_hull_assign();
		inv2.get_and_add_generators(gl);
		ccvs=convex_clock_val_set(mydim,EMPTY);
		// for each of the generators
		for (Generator_List::const_iterator it=gl.begin();it!=gl.end();++it)
		{
			ccvs2=convex_clock_val_set(mydim);
			if (it->is_point() || it->is_closure_point())
			{
				// instantiate each constraint at this point, and add it to the ccvs2;
				for (Constraint_List::const_iterator jt=mytp.begin();jt!=mytp.end();++jt)
				{
					// build constraint at this point
					// first copy the derivatives
					Linear_Expression l=Constraint2Linear_Expression_up_to(&(*jt),mydim-1);
					// now multiply with the denominator
					l*=it->divisor();
					// now add the rest of the coefficients * the value of x (generator)
					for (uint i=0;i<mydim;++i)
					{
						l+=jt->coefficient(Variable(i+mydim))*it->coefficient(Variable(i));
					};
					if (jt->is_equality())
						ccvs2.add_constraint(l==0); 
					else if (jt->is_strict_inequality() || it->is_point())
						ccvs2.add_constraint(l>0);
					else
						ccvs2.add_constraint(l>=0);
				};
				// add ccvs2 to ccvs
				ccvs.poly_hull_assign_and_minimize(ccvs2);
			}
			else
			{
				cout << inv;
				cout << *it;
				throw_error("vertice based derivatives only allow closed and bounded regions");
			};
		};
	};


ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
		if (!static_tp.is_universe())
			ccvs.intersection_assign_and_minimize(static_tp);
		return ccvs; 
}

/*
convex_clock_val_set 
linear_vtef::time_post(const clock_val_set& inv)
{ 
	convex_clock_val_set ccvs(mydim,EMPTY);
	
//cout << "Computing new time_post" << endl << flush;		
	// Get vertices
	Generator_List gl;
	inv.get_and_add_generators(gl);
	
	// instantiate constraints at vertices
	for (Generator_List::const_iterator i=gl.begin(); i!=gl.end(); ++i)
	{
		ccvs.poly_hull_assign_and_minimize(vtef_at_generator(*i));
	};
	ccvs.intersection_assign_and_minimize(static_tp);
	return ccvs; 
};
*/

void
linear_vtef::map_space_dimensions(PFunction pfunc)
	{
      dimension_t newdim;
      newdim=pfunc.max_in_codomain()+1;
//cout << "mapping " << mydim << " to " << newdim;      
		static_tp.map_space_dimensions(pfunc);
		// double pfunc, since the variable coefficients must be changed, too
 //cout << "Orig:" << mytp;		
		PartialFunction_Double(pfunc,mydim);
		mytp.map_space_dimensions(pfunc);
 //cout << pfunc << endl;		
 //cout << "Remapped:" << mytp;		
		// map the variables
		clock_ref_set newvars;
		for (clock_ref_set::iterator i=vars.begin(); i!=vars.end(); ++i)
		{
			newvars.insert(pfunc.get_map(*i));
		};
		vars=newvars;
      mydim=newdim;
	}

	
void
linear_vtef::print() const
{
	cout << "Dimension: " << mydim << endl;
	cout << "Dynamic: " << mytp << endl;
	if (!static_tp.is_universe())
		cout << "Static: " << static_tp << endl;
	else
		cout << "Static: none" << endl;
}

void
linear_vtef::get_linear_system_matrices(TNT::Array2D<Integer>& A, TNT::Array1D<Integer>& b, TNT::Array1D<Integer>& den) const
{
	// clear A and b
	A=TNT::Array2D<Integer>(mydim,mydim,Integer(0));
	b=TNT::Array1D<Integer>(mydim,Integer(0));
	den=TNT::Array1D<Integer>(mydim,Integer(0));
	
	const Constraint_List& cl(mytp);
	//cout << cl << endl << flush;
	// Go through the coefficients of cl to get the coefficients of A and B matrices
	dimension_type row_index(0);
	vector<bool> found(mydim);
	for (uint i = 0; i<found.size(); ++i) found[i]=false;
	for (Constraint_List::const_iterator i=cl.begin();i!=cl.end();++i)
	{
	//cout << "constraint " << *i << endl << flush;
		if (i->space_dimension()<mydim)
			throw_error("get_linear_system_matrices: incompatible dimensions");
		// Note: constraints define dynamics as in c dx/dt = A x + b
		// for each constraint, go through the coefficients
		
      // get C
		// to do: assert that there's an even number of dimensions
		bool first_found(false);
		for (dimension_type j=0;j<mydim;++j)
		{
			if (i->coefficient(Variable(j)) != Integer(0))
				if (!first_found) // the first nonzero variable
				{
					row_index=j;
					den[row_index] = i->coefficient(Variable(j));
//cout << row_index << " -> " << *i;
               first_found=true;               
				}
				else 
					throw_error("get_linear_system_matrices: more than one dotted variable");
		}
		if (found[row_index])
			throw_error("More than one equation for derivative of variable #" + int2string(row_index));
//cout << "l1 " << row_index << endl << flush;
		found[row_index]=true;
		for (dimension_type j=0;j<mydim;++j)
		{
			A[row_index][j] = -i->coefficient(Variable(j+mydim));
			b[row_index] = -i->inhomogeneous_term();
		}
	}
	// check if all rows were found
	bool found_all(true);
	for (uint i = 0; i<found.size(); ++i) found_all=found_all && found[i];
	if (!found_all)
		throw_error("Couldn't find all derivatives for constructing A matrix");

}

int linear_vtef::get_memory() const
{
   int m=0;
   m += 1 + vars.size();
   m += static_tp.get_memory() + mytp.get_memory();
   return m;
}

	
 //----------------------------------------------------------------
 
 void variable_time_elapse_func_dummfunc()
 {}
 

