#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <string>
#include <boost/program_options.hpp>
#include "IterationVectorsMDP.h"

namespace prohver {
  class SparseLoader;

  class Controller {
  public:
    Controller(int, char **);
    
  private:
    void readOptions(int, char **);
    void showHelp(const char *,
		  const boost::program_options::options_description &);
    void parseCommandLine
      (int, char **, boost::program_options::variables_map &);
    void loadModel();
    boost::program_options::variables_map vm;
    void printResults
      (SparseLoader &,
       IterationVectorsMDP &);
    void printGraph
      (IterationVectorsMDP &);
    bool verbose;
    double precision;
    bool minProb;
  };
}

#endif
