#ifndef MDP_EXPORTER_H
#define MDP_EXPORTER_H

#include <string>
#include <vector>
#include <boost/dynamic_bitset_fwd.hpp>

namespace prohver {
  class IterationVectorsMDP;

  class MDPExporter {
  public:
    void setOutput(const std::string &);
    void setIterationVectors(const IterationVectorsMDP &);
    void setPrintMarkovChain(bool);
    virtual void exportGraph() = 0;

  protected:
    virtual std::string nodeColor(bool, bool);
    void computeIncludeStates(boost::dynamic_bitset<> &);
    void computeReach(unsigned, std::vector<unsigned> &);

    std::string outFn;
    const IterationVectorsMDP *iters;
    bool printMarkovChain;
  };
}

#endif
