#ifndef SPARSE_LOADER_H
#define SPARSE_LOADER_H

#include <string>
#include <vector>
#include <iosfwd>
#include <boost/program_options.hpp>
#include "IterationVectorsMDP.h"

namespace prohver {
  /**
   * Object to load an MDP in the format generated by HSolver.
   */
  class SparseLoader {
  public:
    SparseLoader(std::istream &, IterationVectorsMDP &);
    bool readNext();
    inline unsigned getNumStates() const {
      return sparse.getNumStates();
    }

    inline unsigned getNumTransitions() const {
      return numTransitions;
    }

  private:
    void readDistributions(char *);
    void buildChoice(unsigned, unsigned, unsigned,
                     std::vector<unsigned> &, std::vector<double> &);
    void buildChoice(unsigned, unsigned);
    void buildChoices(unsigned);
    void readTransitions(char *);
    void prepareDistrSlots();
    void prepareDistrSlots(unsigned);
    bool readLabel2DistrLine(char *, std::string &, unsigned &, double &);
    bool readTransitionLine(char *, unsigned &, unsigned &, unsigned &);
    void readInitStates(char *);
    void readUnsafeStates(char *);
    void addInits();
    void addUnsafes();
    void clearAll();

    /** Support size of distributions */
    std::vector<unsigned> distrSizes;
    /** maps label names to label numbers */
    std::map<std::string, unsigned> name2label;
    /** maps label numbers to distribution numbers */
    std::vector<unsigned> label2Distr;
    /** maps label number to number within distribution
     * (starting from 0 ending in distrSizes[distr] - 1 */
    std::vector<unsigned> label2Number;
    /** obtain probability associated with the label */
    std::vector<double> label2Prob;
    /** Will contain for distribution for each label of 'a' the possible
     * target states. */
    std::vector<std::vector<std::vector<unsigned> > > targetSlots;
    /** contains target probabilities corresponding to @a targetSlots */
    std::vector<std::vector<std::vector<double> > > probSlots;
    /** IterationVector to be filled */
    IterationVectorsMDP &iters;
    /** MDP of the IterationVector to be filled (for convenicence) */
    SparseNonDet &sparse;
    std::istream &graphStream;
    std::vector<unsigned> inits;
    std::vector<unsigned> targets;
    unsigned numTransitions;
  };
}

#endif
