#include <iostream>
#include <fstream>
#include "Sparse.h"

namespace prohver {
  using namespace std;

  /**
   * Reset sparse matrix to initial state.
   */
  void Sparse::clear() {
    numStates = 0;
    vertices_added = 0;
    nonZeros.clear();
    transRewards.clear();
    cols.clear();
    rows.clear();
    rows.push_back(0);
    init.clear();
    transReward.clear();
  }

  /**
   * Print sparse matrix to cout.
   */
  void Sparse::print() {
    print(cout);
  }

  /**
   * Print sparse matrix to @a stream.
   *
   * @param stream output stream to print to
   */
  void Sparse::print(ostream &stream) {
    for (unsigned i = 0; i < rows.size(); i++) {
      stream << "rows[" << i << "] = " << rows[i] << endl;
    }
    for (unsigned i = 0; i < cols.size(); i++) {
      stream << "cols,nz[" << i << "] = " << cols[i] << " "
	   << nonZeros[i] << endl;
    }
  }

  /**
   * Print sparse matrix in MRMC format to cout
   */
  void Sparse::printMRMCTra() {
    printMRMCTra(cout);
  }

  /**
   * Print sparse matrix in MRMC format to @a filename.
   *
   * @param filename file to print to
   */
  void Sparse::printMRMCTra(const string &filename) {
    ofstream file(filename.c_str (), ios::out);
    printMRMCTra(file);
    file.close ();
  }

  /**
   * Print sparse matrix in MRMC format to @a stream
   *
   * @param stream output stream to print to
   */
  void Sparse::printMRMCTra(ostream &stream) {
    stream << "STATES " << numStates << endl;
    stream << "TRANSITIONS " << nonZeros.size() << endl;
    for (unsigned stateNr = 0; stateNr < rows.size() - 1; stateNr++) {
      unsigned stateBegin = rows[stateNr];
      unsigned stateEnd = rows[stateNr + 1];
      for (unsigned traNr = stateBegin; traNr < stateEnd; traNr++) {
	stream << (stateNr+1) << " " << (cols[traNr]+1) << " "
	       << nonZeros[traNr] << endl;
      }
    }
  }

  /**
   * Print MRMC state labelling to cout.
   */
  void Sparse::printMRMCLab() {
    printMRMCLab(cout);
  }

  /**
   * Print MRMC state labelling to @a filename.
   *
   * @param filename file to print to
   */
  void Sparse::printMRMCLab(const string &filename) {
    ofstream file (filename.c_str (), ios::out);
    printMRMCLab(file);
    file.close ();
  }

  /**
   * Print MRMC state labelling to @a sream.
   *
   * @param stream output stream to print to
   */
  void Sparse::printMRMCLab(ostream &stream) {
    stream << "#DECLARATION" << endl;
    stream << "target sink border" << endl;
    stream << "#END" << endl;
    for (unsigned state(0); state < numStates; state++) {
      stream << (state + 1) << " border" << endl;
    }
  }

  void Sparse::printMRMCRew(vector<double> &rewards) {
    printMRMCRew(cout, rewards);
  }

  void Sparse::printMRMCRew
  (const std::string &filename, vector<double> &rewards) {
    ofstream file (filename.c_str (), ios::out);
    printMRMCRew(file, rewards);
    file.close();
  }

  void Sparse::printMRMCRew
  (std::ostream &stream, vector<double> &rewards) {
    for (unsigned state(0); state < rewards.size(); state++) {
      stream << (state + 1) << " " << rewards[state] << "\n";
    }
  }

}
