/***************************************************************************
                          ag_sim.cpp  -  description
                             -------------------
    begin                : Sat Mar 6 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ag_sim.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

map <label_ref,state_relation> ag_sim_get_nBtr(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, location_ref_to_location_ref_pair_map lr_lrp_map, const state_relation& R)
{
  // Attention: P1, Q2, Q1, P1Q2 are all assumed to be over the same label_refs!
  // Note: R is used to cycle through the triples of locations, its continuous state space is not touched
  // lr_lrp_map is from P1||Q2 to pair<P1||Q2>
  clock_val_set cvs(P1Q2.dim),cvs2;
  map <label_ref,state_relation> l_to_sr_map;
  location_ref k1,l1,l2,k1l2;
  label_ref_set labels;

  // Get maps for placing variables in the right orders
  PFunction P1_to_P1Q2=get_PFunction(P1,P1Q2); // note: must be of full dimension (P1Q2,P1Q2) so no variables are cut off
  PFunction Q2_to_P1Q2=get_PFunction(Q2,P1Q2);

  // Get labels = Sigma_P1 & Sigma_Q1 & Sigma_Q2
  labels=P1.labels;
  labels.intersection_assign(Q2.labels);
  labels.intersection_assign(Q1.labels);

  // Cycle through states that are in R
  for (state_relation::const_iterator i=R.begin();i!=R.end();++i)
  {
    k1l2=(i->first).first;
    l1=(i->first).second;
    k1=lr_lrp_map[k1l2].first;
    l2=lr_lrp_map[k1l2].second;

    // Cycle through labels
    for (label_ref_set::const_iterator plab=labels.begin();plab!=labels.end();++plab)
    {
      cvs=clock_val_set(P1Q2.dim+Q1.dim);
      // take away Union of mu1 (P1) with label *plab
      cvs2=P1.get_union_of_exit_sets(k1,*plab);
      cvs2.add_space_dimensions_and_embed(P1Q2.dim-cvs2.dim); // to get it up to P1Q2
      cvs2.map_space_dimensions(P1_to_P1Q2);
      cvs2.add_space_dimensions_and_embed(Q1.dim);
      cvs.difference_assign(cvs2);
      // Union of nu2 (Q2) with label *plab
      cvs2=Q2.get_union_of_exit_sets(l2,*plab); // ranges over variables of Q2
      cvs2.add_space_dimensions_and_embed(P1Q2.dim-cvs2.dim); // to get it up to P1Q2
      cvs2.map_space_dimensions(Q2_to_P1Q2);
      cvs2.add_space_dimensions_and_embed(Q1.dim);
      cvs.union_assign(cvs2);
      // Union of nu1 (Q1) with label *plab
      cvs2=Q1.get_union_of_exit_sets(l1,*plab); // ranges over variables of Q2
      cvs2.add_space_dimensions_and_embed_before(P1Q2.dim); // to get it up to P1Q2+Q1
      cvs.union_assign(cvs2);
      // simplify
      cvs.simplify();
      // add to map
      l_to_sr_map[*plab].insert(make_pair(location_ref_pair(k1l2,l1),cvs));
    }; // for (label_ref_set::const_iterator plab
  };
  return l_to_sr_map;
}

state_relation ag_sim_get_Bte(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, location_ref_to_location_ref_pair_map lr_lrp_map, const state_relation& R)
{
  // Attention: P1, Q2, Q1, P1Q2 are all assumed to be over the same label_refs!
  // Note: R is used to cycle through the triples of locations, its continuous state space is not touched
  // lr_lrp_map is from P1||Q2 to pair<P1||Q2>
  clock_val_set cvs(P1Q2.dim),cvs2;
  state_relation Rt;
  location_ref k1,l1,l2,k1l2;
  label_ref_set labels;

  // Get maps for placing variables in the right orders
  PFunction P1_to_P1Q2=get_PFunction(P1,P1Q2); // note: must be of full dimension (P1Q2,P1Q2) so no variables are cut off
  PFunction Q2_to_P1Q2=get_PFunction(Q2,P1Q2);
  PFunction P1_to_P1Q2_Q1_t=P1_to_P1Q2;
  P1_to_P1Q2_Q1_t.fill_up_to(P1Q2.dim+Q1.dim+1);
  PFunction Q2_to_P1Q2_Q1_t=Q2_to_P1Q2;
  Q2_to_P1Q2_Q1_t.fill_up_to(P1Q2.dim+Q1.dim+1);

  // Cycle through states that are in R
  for (state_relation::const_iterator i=R.begin();i!=R.end();++i)
  {
    k1l2=(i->first).first;
    l1=(i->first).second;
    k1=lr_lrp_map[k1l2].first;
    l2=lr_lrp_map[k1l2].second;

    cvs=clock_val_set(P1Q2.dim+Q1.dim+1,EMPTY); // dim is v_P1Q2,v_Q1,t
    // get EP
    cvs2=P1.elapse_succ_set(clock_val_set(P1.dim),P1.locations[k1].time_post_poly(),P1.locations[k1].invariant()); // is u,u',t
    cvs2.remove_space_dimensions(P1.dim,P1.dim*2-1); // is u,t
    cvs2.add_space_dimensions_and_embed(P1Q2.dim-P1.dim+Q1.dim); // is u,t,(v_P1Q2-u),v_Q1
    cvs2.dimension_move_assign(P1.dim,P1.dim,P1Q2.dim+Q1.dim); // is u,(v_P1Q2-u),v_Q1,t
    cvs2.map_space_dimensions(P1_to_P1Q2_Q1_t); // is v_P1Q2,v_Q1,t (hopefully)
// todo: check this
    cvs=cvs2;
    // get EQ2
    cvs2=Q2.elapse_succ_set(clock_val_set(Q2.dim),Q2.locations[l2].time_post_poly(),Q2.locations[l2].invariant()); // is u,u',t
    cvs2.remove_space_dimensions(Q2.dim,Q2.dim*2-1); // is u,t
    cvs2.add_space_dimensions_and_embed(P1Q2.dim-Q2.dim+Q1.dim); // is u,t,(v_P1Q2-u),v_Q1
    cvs2.dimension_move_assign(Q2.dim,Q2.dim,P1Q2.dim+Q1.dim); // is u,(v_P1Q2-u),v_Q1,t
    cvs2.map_space_dimensions(Q2_to_P1Q2_Q1_t); // is v_P1Q2,v_Q1,t (hopefully)
// todo: check this
//cout << "get EQ2" << endl;
//cvs.print();
//cvs2.print();
    cvs.difference_assign(cvs2);
    // Get EQ1
    cvs2=Q1.elapse_succ_set(clock_val_set(Q1.dim),Q1.locations[l1].time_post_poly(),Q1.locations[l1].invariant()); // is u,u',t
    cvs2.remove_space_dimensions(Q1.dim,Q1.dim*2-1); // is v_Q1,t
    cvs2.add_space_dimensions_and_embed_before(P1Q2.dim); // is v_P1Q2,v_Q1,t
    cvs.difference_assign(cvs2);

//    // Project away t
//    cvs.remove_space_dimensions(cvs.dim-1,cvs.dim-1); // take away last dimension: t
    // simplify
    cvs.simplify();
    // add to relation
    Rt.insert(make_pair(location_ref_pair(k1l2,l1),cvs));
  };
  return Rt;
}

void get_ag_Rel_pre(clock_val_set& cvs_equiv_P1Q2Q1, automaton& P1, automaton& Q2, automaton& Q1, automaton& P2, automaton& P1Q2, location_ref_to_location_ref_pair_map& loc_map_P1Q2, state_relation& R1, map <string,label_ref>& label_map, map <label_ref,state_relation>& nBtr1, state_relation& Bte1)
{
  stopwatch sw(256000,"get_ag_Rel_pre");
  label_ref_set labels;

  loc_map_P1Q2=compose_discrete(P1Q2,P1,Q2);
  P1Q2.map_or_add_labels(label_map);

  // for now set variables with the same name as equivalent
  cvs_equiv_P1Q2Q1=P1Q2.get_cvs_equiv(Q1);

  // Priming R
  R1=P1Q2.prime_R(cvs_equiv_P1Q2Q1, Q1);
//cout << "Primed R: " << endl;
//R1.print();

  // Get Btr1
  nBtr1=ag_sim_get_nBtr(P1, Q2, Q1, P1Q2, loc_map_P1Q2, R1); // note: R1 only used for locations to cycle through
  // Get Bte1 (need it later)
  Bte1=ag_sim_get_Bte(P1, Q2, Q1, P1Q2, loc_map_P1Q2, R1);
//  // --------------
//  // Take away Bte1
//  // --------------
//  R1.difference_assign(Bte1);
//cout << "R without Bte: " << endl;
//R1.print();
  // --------------
  // Take away Btr1
  // --------------
  // Get labels = Sigma_P1 & Sigma_Q1 & Sigma_Q2
  labels=P1.labels;
  labels.intersection_assign(Q2.labels);
  labels.intersection_assign(Q1.labels);
  labels.difference_assign(P2.labels); // if P2.labels was included, it would be separate trimming
  for (label_ref_set::const_iterator plab=labels.begin();plab!=labels.end();++plab)
  {
    if (nBtr1.find(*plab)!=nBtr1.end()) // if lab is in nBtr1
      R1.intersection_assign(nBtr1[*plab]);
  };
//cout << "R without Btr: " << endl;
//R1.print();
  // --------------
  // Turn R into a simulation relation
  P1Q2.get_sim_rel(R1,Q1,cvs_equiv_P1Q2Q1);
}

map <label_ref,state_relation> ag_sim_get_Dtr(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, state_relation& R,map <label_ref,state_relation>& nBtr,location_ref_to_location_ref_pair_map& loc_map_P1Q2)
{
  map <label_ref,state_relation> Dtr;
  location_ref_pair lrp,k1l2,l2l1;
  location_ref l1,l2;
  label_ref lab;
  clock_val_set cvs;

  PFunction P1Q2_to_Q2=get_PFunction(P1Q2,Q2);
  // add dimensions for mapping v_P1Q2,v_Q1 to v_Q2,vQ1
  PFunction P1Q2_Q1_to_Q2_Q1=P1Q2_to_Q2;
  // add dimensions for Q1
  for (dimension_type d=0;d<Q1.dim;++d)
    P1Q2_Q1_to_Q2_Q1.insert(P1Q2.dim+d,Q2.dim+d);

  // cycle through states in Btr
  // if locs exist in R
  // intersect Btr and R and add result to Dtr(a)
  for (map <label_ref,state_relation>::const_iterator i=nBtr.begin();i!=nBtr.end();++i) // cycle through alphabets
  {
    lab=i->first;
    for (state_relation::const_iterator k=i->second.begin();k!=i->second.end();++k)
    {
      lrp=k->first;   // ((k1,l2),l1)
      // look for the same locations in R
      if (R.find(lrp)!=R.end())
      { // found locations in R
        // get critical states
        cvs=R[lrp];
        cvs.difference_assign(k->second); // because we're operating with nBtr, R \cap Btr = R \setdiff nBtr
                                          // is v_P1Q2,v_Q1
        cvs.map_space_dimensions(P1Q2_Q1_to_Q2_Q1);
        // get rid of the internal variables of P1
        if (!cvs.is_empty())
        {
          // get l1, l2
          l1 = lrp.second;
          if (loc_map_P1Q2.find(lrp.first)!=loc_map_P1Q2.end())
            k1l2=loc_map_P1Q2[lrp.first];
          else
            throw_error("Could not map location to location_pair in ag_sim_get_Dtr!");
          l2=k1l2.second;
          // look for l1,l2 in Dtr
          l2l1=location_ref_pair(l2,l1);
          if (Dtr[lab].find(l2l1)==Dtr[lab].end()) // if not existing, generate an empty one
            Dtr[lab][l2l1]=clock_val_set(cvs.dim,EMPTY);
          Dtr[lab][l2l1].union_assign(cvs);
        };
      };
    };
  };

  return Dtr;
}

state_relation ag_sim_get_Dte(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, state_relation& R,state_relation& Bte,location_ref_to_location_ref_pair_map& loc_map_P1Q2)
{
  state_relation Dte;
  location_ref_pair lrp,k1l2,l2l1;
  location_ref l1,l2;
  clock_val_set cvs;

  PFunction P1Q2_to_Q2=get_PFunction(P1Q2,Q2);
  // add dimensions for mapping v_P1Q2,v_Q1 to v_Q2,vQ1
  PFunction P1Q2_Q1_to_Q2_Q1_t=P1Q2_to_Q2;
  // add dimensions for Q1 and t
  for (dimension_type d=0;d<Q1.dim+1;++d)
    P1Q2_Q1_to_Q2_Q1_t.insert(P1Q2.dim+d,Q2.dim+d);

  // cycle through states in Bte
  // if locs exist in R
  // intersect Bte and R and add result to Dte
  for (state_relation::const_iterator k=Bte.begin();k!=Bte.end();++k)
  {
    lrp=k->first;   // ((k1,l2),l1)
    // look for the same locations in R
    if (R.find(lrp)!=R.end())
    { // found locations in R
      // intersect Bte with R
      cvs=R[lrp]; // is v_P1Q2,v_Q1
      cvs.add_space_dimensions_and_embed(1); // add t
      cvs.intersection_assign(k->second); // is v_P1Q2,v_Q1,t
      // remove internal variables of P1
      cvs.map_space_dimensions(P1Q2_Q1_to_Q2_Q1_t); // is v_Q2,v_Q1,t
      // now add to Dte
      if (!cvs.is_empty())
      {
        // get l1, l2
        l1 = lrp.second;
        if (loc_map_P1Q2.find(lrp.first)!=loc_map_P1Q2.end())
          k1l2=loc_map_P1Q2[lrp.first];
        else
          throw_error("Could not map location to location_pair in ag_sim_get_Dtr!");
        l2=k1l2.second;
        // look for l1,l2 in Dtr

        l2l1=location_ref_pair(l2,l1);
        if (Dte.find(l2l1)==Dte.end()) // if not existing, generate an empty one
          Dte[l2l1]=clock_val_set(cvs.dim,EMPTY);
        Dte[l2l1].union_assign(cvs);
      };
    };
  };
  return Dte;
}

void get_ag_Dts(automaton& P1, automaton& Q2, automaton& Q1, automaton& P2, automaton& P2Q1, state_relation& R2, map <label_ref,state_relation>& nBtr2, state_relation& Bte2, map <label_ref,state_relation>& Dtr2, state_relation& Dte2,location_ref_to_location_ref_pair_map& loc_map_P2Q1)
{
  stopwatch sw(128000,"get_ag_Dts");
if (DEBUG_OUTPUT>0) {
cout << "Getting Dtr" << endl << flush;
}
  Dtr2=ag_sim_get_Dtr(P2,Q1,Q2,P2Q1,R2,nBtr2,loc_map_P2Q1);
if (DEBUG_OUTPUT>0) {
  cout << "Getting Dte" << endl << flush;
}
  Dte2=ag_sim_get_Dte(P2,Q1,Q2,P2Q1,R2,Bte2,loc_map_P2Q1);
}

void get_ag_Rel_post(clock_val_set& cvs_equiv_P1Q2Q1, automaton& P1, automaton& Q2, automaton& Q1, automaton& P2, automaton& P1Q2, location_ref_to_location_ref_pair_map& loc_map_P1Q2, state_relation& R1, map <label_ref,state_relation>& Dtr2, state_relation& Dte2)
{
  stopwatch sw(128000,"get_ag_Rel_post");
  label_ref_set labels;
  location_ref_pair lrp;
  location_ref k1,l2,l1,k1l2;

  PFunction Q2_to_P1Q2=get_PFunction(Q2,P1Q2);
  PFunction Q2_remap=Q2_to_P1Q2;
  // add remaining dimensions for v_P1Q2,v_Q1
  for (dimension_type i=0;i<Q1.dim;++i)
  {
    Q2_remap.insert(P1Q2.dim+i,P1Q2.dim+i);
  };
  // and now with t
  PFunction Q2t_remap=Q2_remap;
  Q2t_remap.insert(P1Q2.dim+Q1.dim,P1Q2.dim+Q1.dim); // map t to t
  //
  PFunction P1_to_P1Q2=get_PFunction(P1,P1Q2);
  PFunction P1_remap=P1_to_P1Q2;
  // add remaining dimensions for v_P1Q2,v_Q1
  for (dimension_type i=0;i<Q1.dim;++i)
  {
    P1_remap.insert(P1Q2.dim+i,P1Q2.dim+i);
  };
  // and now with t
  PFunction P1t_remap=P1_remap;
  P1t_remap.insert(P1Q2.dim+Q1.dim,P1Q2.dim+Q1.dim); // map t to t

  clock_val_set cvs,cvs2;

  // --------------
  // Take away Btec1
  // --------------
  for (state_relation::iterator i=R1.begin();i!=R1.end();++i)
  {
    k1l2=(i->first).first;
    l1=(i->first).second;
    k1=loc_map_P1Q2[k1l2].first;
    l2=loc_map_P1Q2[k1l2].second;
    // get Btec1(k1,l2,l1)
    cvs=P1.elapse_succ_set(clock_val_set(P1.dim),P1.locations[k1].time_post_poly(),P1.locations[k1].invariant()); // is u,u',t
    cvs.remove_space_dimensions(P1.dim,P1.dim*2-1); // is u,t
    cvs.add_space_dimensions_and_embed(P1Q2.dim-P1.dim+Q1.dim); // is u,t,(v_P1Q2-u),v_Q1
    cvs.dimension_move_assign(P1.dim,P1.dim,P1Q2.dim+Q1.dim); // is u,(v_P1Q2-u),v_Q1,t
    cvs.map_space_dimensions(P1t_remap); // is v_P1Q2,v_Q1,t (hopefully)
    // intersect with Dte2
    lrp=location_ref_pair(l1,l2); // it is the other way round because it was formed from R2
    if (Dte2.find(lrp)!=Dte2.end())
    { // found the location pair
      cvs2=Dte2[lrp]; // is v_Q1,v_Q2,t
      cvs2.dimension_move_assign(0,Q1.dim-1,Q2.dim); // is v_Q2,v_Q1,t
      cvs2.add_space_dimensions_and_embed(P1Q2.dim-Q2.dim); // is v_Q2,v_Q1,t,(v_P1Q2-v_Q2)
      cvs2.dimension_move_assign(Q2.dim,Q2.dim+Q1.dim,P1Q2.dim); // is v_P1Q2,v_Q1,t
      cvs2.map_space_dimensions(Q2t_remap);
      // now substract from elapse states
      cvs.intersection_assign(cvs2);
      // quantize over time
      cvs.remove_space_dimensions(cvs.dim-1,cvs.dim-1); // remove time dimension, is v_P1Q2,v_Q1
      // now take away from R1
      i->second.difference_assign(cvs);
    };
  };
//cout << "R without Bte: " << endl;
//R1.print();

  // --------------
  // Take away Btrc1
  // --------------
  // Get labels = Sigma_P1 & Sigma_Q1 & Sigma_Q2 & Sigma_P2
  labels=P1.labels;
  labels.intersection_assign(Q2.labels);
  labels.intersection_assign(Q1.labels);
  labels.intersection_assign(P2.labels); // if P2.labels was included, it would be separate trimming
  for (state_relation::iterator i=R1.begin();i!=R1.end();++i)
  {
    k1l2=(i->first).first;
    l1=(i->first).second;
    k1=loc_map_P1Q2[k1l2].first;
    l2=loc_map_P1Q2[k1l2].second;
    // cycle through labels
    for (label_ref_set::const_iterator plab=labels.begin();plab!=labels.end();++plab)
    {
      if (Dtr2.find(*plab)!=Dtr2.end()) // if lab is in Dtr2
      {
        // start with exit-states
        cvs2=P1.get_union_of_exit_sets(k1,*plab);
        cvs2.add_space_dimensions_and_embed(P1Q2.dim-cvs2.dim); // to get it up to P1Q2
        cvs2.map_space_dimensions(P1_to_P1Q2);
        cvs2.add_space_dimensions_and_embed(Q1.dim); // now P1Q2xQ1
        cvs=cvs2;
        // remap Dtr2
        lrp=location_ref_pair(l1,l2);
        if (Dtr2[*plab].find(lrp)==Dtr2[*plab].end()) // if not existing, generate an empty one
          cvs2=clock_val_set(Q1.dim+Q2.dim,EMPTY);
        else
          cvs2=Dtr2[*plab][lrp]; // is Q1xQ2
        cvs2.dimension_move_assign(0,Q1.dim-1,Q2.dim); // is v_Q2,v_Q1
        cvs2.add_space_dimensions_and_embed(P1Q2.dim-Q2.dim); // is v_Q2,v_Q1,(v_P1Q2-v_Q2)
        cvs2.dimension_move_assign(Q2.dim,Q2.dim+Q1.dim-1,P1Q2.dim); // is v_P1Q2,v_Q1
        cvs2.map_space_dimensions(Q2_remap);
        // now intersect to Btrc1
        cvs.intersection_assign(cvs2);
        // now take away from R1
        i->second.difference_assign(cvs);
      };
    };
  };

//cout << "R without Btr: " << endl;
//R1.print();
  // --------------
  // Turn R into a simulation relation
  P1Q2.get_sim_rel(R1,Q1,cvs_equiv_P1Q2Q1);
}

bool is_ag_simulation(automaton& P1, automaton& P2, automaton& Q1, automaton& Q2)
{
  bool sim_result=true;
  bool sim_result1,sim_result2;
  stopwatch sw(2100,"is_ag_simulation");
  state_relation R1,R2;
  label_ref_set labels;
  clock_val_set cvs_equiv_P1Q2Q1,cvs_equiv_P2Q1Q2;  

  map <label_ref,state_relation> Dtr1,Dtr2;
  state_relation Dte1,Dte2;

  message(2100,"Checking for A/G-simulation");

  // Create a global map from label names to values, and impose this map on all automata
  map <string,label_ref> label_map;
  
  P1.map_or_add_labels(label_map);
  P2.map_or_add_labels(label_map);
  Q1.map_or_add_labels(label_map);
  Q2.map_or_add_labels(label_map);

//  // until Sigma-Simulation is implemented:
//  // add self-loops for labels that don't occur

//  P1.expand_labels(Q1.labels);
//  Q1.expand_labels(P1.labels);
//  P2.expand_labels(Q2.labels);
//  Q2.expand_labels(P2.labels);
// for testing: give all the same labels
  Q1.expand_labels(P1.labels,P1.label_name_to_label_ref_map);
//  Q1.expand_labels(Q2.labels,Q2.label_name_to_label_ref_map);
  Q1.expand_labels(P2.labels,P2.label_name_to_label_ref_map);
  Q2.expand_labels(P2.labels,P2.label_name_to_label_ref_map);
//  Q2.expand_labels(Q1.labels,Q1.label_name_to_label_ref_map);
  Q2.expand_labels(P1.labels,P1.label_name_to_label_ref_map);

  // restrict ini_states to invariants
  P1.restrict_to_invariant(P1.ini_states);
  P2.restrict_to_invariant(P2.ini_states);
  Q1.restrict_to_invariant(Q1.ini_states);
  Q2.restrict_to_invariant(Q2.ini_states);

  // ----------------------------------------
  // 1. Getting R1
  // ----------------------------------------
message(8500,"Getting simrel R1");

  automaton P1Q2;
  location_ref_to_location_ref_pair_map loc_map_P1Q2;
  map <label_ref,state_relation> nBtr1;
  state_relation Bte1;
  get_ag_Rel_pre(cvs_equiv_P1Q2Q1, P1, Q2, Q1, P2, P1Q2, loc_map_P1Q2, R1, label_map, nBtr1, Bte1);
if (DEBUG_OUTPUT>0) {
  R1.print();
};

  // ----------------------------------------
  // 2. Getting R2
  // ----------------------------------------
message(8500,"Getting simrel R2");

  automaton P2Q1;
  location_ref_to_location_ref_pair_map loc_map_P2Q1;
  map <label_ref,state_relation> nBtr2;
  state_relation Bte2;
  get_ag_Rel_pre(cvs_equiv_P2Q1Q2, P2, Q1, Q2, P2, P2Q1, loc_map_P2Q1, R2, label_map, nBtr2, Bte2);
if (DEBUG_OUTPUT>0) {
  R2.print();
};

  // ----------------------------------------
  // 3. Get Dtr and Dte
  // ----------------------------------------
message(8500,"Getting Dtr and Dte");

  get_ag_Dts(P2, Q1, Q2, P1, P1Q2, R1, nBtr1, Bte1, Dtr1, Dte1, loc_map_P1Q2);
  get_ag_Dts(P1, Q2, Q1, P2, P2Q1, R2, nBtr2, Bte2, Dtr2, Dte2, loc_map_P2Q1);

  // ----------------------------------------
  // 4. Check for Intersection of Dts
  // ----------------------------------------

  // maybe later...

  // ----------------------------------------
  // 5. Take away Dtr and Dte from R1 and R2 and rerun simulation algorithm
  // ----------------------------------------

  get_ag_Rel_post(cvs_equiv_P1Q2Q1, P1, Q2, Q1, P2, P1Q2, loc_map_P1Q2, R1, Dtr2, Dte2);
  get_ag_Rel_post(cvs_equiv_P2Q1Q2, P2, Q1, Q2, P1, P2Q1, loc_map_P2Q1, R2, Dtr1, Dte1);


  // Find if for all states in ini_states there is a state in spec_ini_states and in R
  sim_result1=P1Q2.check_ini_in_rel(cvs_equiv_P1Q2Q1, Q1, R1);
  sim_result2=P2Q1.check_ini_in_rel(cvs_equiv_P2Q1Q2, Q2, R2);
  sim_result=sim_result1 && sim_result2;

message(8100,"Ini states in R1: " + (string)((sim_result1) ? "yes" : "no"));
message(8100,"Ini states in R2: " + (string)((sim_result2) ? "yes" : "no"));
message(4100,"Ini states in R: " + (string)((sim_result1 && sim_result2) ? "yes" : "no"));

  return sim_result;
}
