#ifndef GUARD_agc_sim_h
#define GUARD_agc_sim_h
/***************************************************************************
                          agc_sim.h  -  description
                             -------------------
    begin                : Sat Mar 6 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stopwatch.h"
#include "automaton.h"
  
map <label_ref,state_relation> agc_sim_get_nBtr(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, location_ref_to_location_ref_pair_map lr_lrp_map, automaton& Q1Q2, location_ref_to_location_ref_pair_map lr_lrp_map2, const state_relation& R, bool Q1first);

state_relation agc_sim_get_Bte(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, location_ref_to_location_ref_pair_map lr_lrp_map, automaton& Q1Q2, location_ref_to_location_ref_pair_map lr_lrp_map2, const state_relation& R, bool Q1first);

void get_agc_Rel_pre(clock_val_set& cvs_equiv_P1Q2Q1Q2, automaton& P1, automaton& Q2, automaton& Q1, automaton& P2, automaton& P1Q2, location_ref_to_location_ref_pair_map& loc_map_P1Q2, automaton& Q1Q2, location_ref_to_location_ref_pair_map& loc_map_Q1Q2, state_relation& R1, map <string,label_ref>& label_map, map <label_ref,state_relation>& nBtr1, state_relation& Bte1, bool Q1first);

map <label_ref,state_relation> agc_sim_get_Dtr(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, state_relation& R,map <label_ref,state_relation>& nBtr,location_ref_to_location_ref_pair_map& loc_map_P1Q2,location_ref_to_location_ref_pair_map& loc_map_Q1Q2);
state_relation agc_sim_get_Dte(automaton& P1, automaton& Q2, automaton& Q1, automaton& P1Q2, state_relation& R,state_relation& Bte,location_ref_to_location_ref_pair_map& loc_map_P1Q2,location_ref_to_location_ref_pair_map& loc_map_Q1Q2);
void get_agc_Dts(automaton& P1, automaton& Q2, automaton& Q1, automaton& P2, automaton& P2Q1, state_relation& R2, map <label_ref,state_relation>& nBtr2, state_relation& Bte2, map <label_ref,state_relation>& Dtr2, state_relation& Dte2,location_ref_to_location_ref_pair_map& loc_map_P2Q1,location_ref_to_location_ref_pair_map& loc_map_Q1Q2);

void get_agc_Rel_post(clock_val_set& cvs_equiv_P1Q2Q1Q2, automaton& P1, automaton& Q2, automaton& Q1, automaton& P2, automaton& P1Q2, location_ref_to_location_ref_pair_map& loc_map_P1Q2, automaton& Q1Q2, location_ref_to_location_ref_pair_map& loc_map_Q1Q2, state_relation& R1, map <label_ref,state_relation>& Dtr2, state_relation& Dte2, bool Q1first);

bool is_agc_simulation(automaton& P1, automaton& P2, automaton& Q1, automaton& Q2);

#endif
