/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #include "automaton.h"
  
  void get_loc_vert(automaton& aut,location_ref loc,double_point_list& pl)
 {
  // get the vertices
  pl.clear();
  add_cvs_to_double_point_list(aut.locations[loc].invariant(),pl);
 }
 
 void get_loc_deriv(automaton& aut,location_ref loc,double_point_list& vert_list,double_point_list& deriv_list)
 {
  // get the derivatives in the vertices in vert_list
  uint dim=aut.locations[loc].invariant().dim;
  deriv_list.clear();
  
	if (REFINE_USE_FP)
	{
		double_point p(dim,0.0);
		for (double_point_list::iterator i=vert_list.begin();i!=vert_list.end();++i)
		{
			// get the derivative
			get_derivative(aut.name,*i,p);
			deriv_list.push_back(p.copy());
		};
	}
	else
	{
		add_ccvs_to_double_point_list(aut.locations[loc].time_post_poly(),deriv_list);
//for (double_point_list::const_iterator i=deriv_list.begin();i!=deriv_list.end();++i) cout << *i;		
	};
 }
 
void get_loc_deriv_nonfp(automaton& aut,location_ref loc,const clock_val_set& restr,double_point_list& deriv_list)
{
	add_ccvs_to_double_point_list(aut.locations[loc].time_post_poly(restr),deriv_list);	
}

Constraint_List get_deriv_over_states(automaton& aut,location_ref loc)
{
	// for each ccvs of the invariant, get the dynamics depending on x
	if (REFINE_USE_FP)
	{
		// for each of the vertices, get the state as well as the derivative
    // and add this to the polyhedron
		convex_clock_val_set ccvs(2*aut.dim,EMPTY);
  	double_point_list pl,dl;
  	get_loc_vert(aut,loc,pl);
	  get_loc_deriv(aut,loc,pl,dl);
		// transform each point in pl,dl to a generator
		Generator g=point(0*Variable(0),1); // dummy
		double_point p(2*aut.dim);
		
		double_point_list::iterator j=dl.begin();
		for (double_point_list::iterator i=pl.begin();i!=pl.end();++i)
		{
			p=append(*j,*i);
			double_point_to_generator(p,g);
			ccvs.add_generator(g);
			++j;
		};		
//cout <<"ccvs:" << ccvs << endl << flush;
		return convex_clock_val_set_to_Constraint_List(ccvs);
	}
	else
	{
		return aut.locations[loc].get_mylinvtef_tp();
	};	
}

 
void set_loc_deriv(automaton& aut,location_ref loc,double_point_list& deriv_list)
{
  // set the derivatives to the vertices in vert_list
  uint dim=aut.locations[loc].invariant().dim;
  
  // intersect the derivative!
/*  convex_clock_val_set ccvs(dim);
  double_point_list_to_ccvs(deriv_list, ccvs, dim);
  aut.locations[loc].time_post_poly.intersection_assign(ccvs);*/
	if (REFINE_DERIVATIVE_METHOD != 1)
	{
		convex_clock_val_set ccvs(dim);
		double_point_list_to_ccvs(deriv_list, ccvs, dim);
		aut.locations[loc].time_post_poly_assign(ccvs);
	}
	else
	{
		convex_clock_val_set ccvs(dim),ccvs2(dim);
		double_point_list_to_ccvs(deriv_list, ccvs, dim);
		// use bounding box
		ccvs.shrink_bounding_box(ccvs2);
		aut.locations[loc].time_post_poly_assign(ccvs2);
	};
}

convex_clock_val_set get_loc_deriv(automaton& aut,location_ref loc)
{
 // recompute and assign the derivative from the vertices
  double_point_list pl,dl;
  get_loc_vert(aut,loc,pl);
  get_loc_deriv(aut,loc,pl,dl);
  // set the derivatives to the vertices in vert_list
  uint dim=aut.locations[loc].invariant().dim;
  
  // intersect the derivative!
/*  convex_clock_val_set ccvs(dim);
  double_point_list_to_ccvs(deriv_list, ccvs, dim);
  aut.locations[loc].time_post_poly.intersection_assign(ccvs);*/
	if (REFINE_DERIVATIVE_METHOD == 0) // convex hull
	{
		convex_clock_val_set ccvs(dim);
		double_point_list_to_ccvs(dl, ccvs, dim);
//		aut.locations[loc].time_post_poly_assign(ccvs);
		return ccvs;
	}
	else
	if (REFINE_DERIVATIVE_METHOD == 2) // center
	{
		convex_clock_val_set ccvs(dim);
		double_point p(dim,0.0);
		get_double_point_list_center(dl,p);
//cout << dl << endl;		
		dl.clear();
		dl.push_back(p);
//cout << p << endl;		
		double_point_list_to_ccvs(dl, ccvs, dim);
//		aut.locations[loc].time_post_poly_assign(ccvs);
		return ccvs;
	}
	else // 1 = bounding box
	{
		convex_clock_val_set ccvs(dim),ccvs2(dim);
		double_point_list_to_ccvs(dl, ccvs, dim);
		// use bounding box
		ccvs.shrink_bounding_box(ccvs2);
//		aut.locations[loc].time_post_poly_assign(ccvs2);
		return ccvs2;
	};
}
 
convex_clock_val_set get_loc_deriv(automaton& aut,location_ref loc,clock_val_set restr)
{
 // recompute and assign the derivative from the vertices
  double_point_list pl,dl;
  //get_loc_vert(aut,loc,pl);
  
	if (REFINE_USE_FP)
	{
		add_cvs_to_double_point_list(restr,pl);
		get_loc_deriv(aut,loc,pl,dl);
	}
	else
	{
		get_loc_deriv_nonfp(aut,loc,restr,dl);
	};
			
  // set the derivatives to the vertices in vert_list
  uint dim=aut.locations[loc].invariant().dim;
  
  // intersect the derivative!
/*  convex_clock_val_set ccvs(dim);
  double_point_list_to_ccvs(deriv_list, ccvs, dim);
  aut.locations[loc].time_post_poly.intersection_assign(ccvs);*/
	if (REFINE_DERIVATIVE_METHOD == 0)
	{
		convex_clock_val_set ccvs(dim);
		double_point_list_to_ccvs(dl, ccvs, dim);
//		aut.locations[loc].time_post_poly_assign(ccvs);
		return ccvs;
	}
	else
	{
		convex_clock_val_set ccvs(dim),ccvs2(dim);
		double_point_list_to_ccvs(dl, ccvs, dim);
		// use bounding box
		ccvs.shrink_bounding_box(ccvs2);
//		aut.locations[loc].time_post_poly_assign(ccvs2);
		return ccvs2;
	};
}

void refine_loc_deriv(automaton& aut,location_ref loc)
{
 // recompute and assign the derivative from the vertices
  double_point_list pl,dl;
  get_loc_vert(aut,loc,pl);
  get_loc_deriv(aut,loc,pl,dl);
  set_loc_deriv(aut,loc,dl);
}

void refine_loc_deriv(automaton& aut,loc_ref_list& locs)
{
 // recompute and assign the derivative from the vertices
  for (loc_ref_list::iterator j=locs.begin();j!=locs.end();++j)
  {
    refine_loc_deriv(aut,*j);
  };
}
 
void refine_loc_deriv(automaton& aut)
{
  stopwatch sw(2100,"refine_loc_deriv");
	message(2100,"Refining derivative of " + aut.name +".");	
  for (uint i=0;i<aut.locations.size();++i)
    refine_loc_deriv(aut,i);
}

double get_loc_angle(automaton& aut, location_ref loc)
{
 // compute the angle spanned by the derivative in the vertices
  double_point_list pl,dl;
  get_loc_vert(aut,loc,pl);
  get_loc_deriv(aut,loc,pl,dl);
	return get_double_point_list_angle(dl);
}

double get_loc_angle(automaton& aut, location_ref loc, clock_val_set& restr)
{
 // compute the angle spanned by the derivative in the vertices of restr
  double_point_list pl,dl;
	if (REFINE_USE_FP)
	{
		add_cvs_to_double_point_list(restr,pl);
		get_loc_deriv(aut,loc,pl,dl);
	}
	else
	{
		get_loc_deriv_nonfp(aut,loc,restr,dl);
	};
	return get_double_point_list_angle(dl);
}

// Methods for splitting locations

void split_location(automaton& aut,label_ref splitting_silent_label,location_ref loc,Constraint c, loc_ref_list& new_locs)
{
  // divide location loc up using a closed-partition based on c
  // add the new locations to the list new_locs
  
  if (!c.OK()) // this is used for the case where c is false
    {} // throw_error("");
  else
  {
		if (c.is_equality()) // simply convert it into a non-strict inequality
			c=constraint_to_nonstrict_inequality(c);
    // create a new copy of loc
//    location_ref nloc = aut.copy_location(loc);
    // create a new copy of loc
    // add it to aut.locations
//    locations.push_back(locations[loc]);
//cout << c << endl;
// double_point p(aut.dim,0.0);
// double_point dx(aut.dim,0.0);
// constraint_to_double_point(c,dx);
// print_fp_raw(cout,p);
// print_fp_raw(cout,p+(0.01*dx));
// cout << endl;

    // increase partition level
		++aut.locations[loc].partition_level;

    string newname=aut.locations[loc].name+"@"+int2string(aut.locations.size())+"-";
		aut.locations[loc].name+="@"+int2string(aut.locations.size()) +"+";
//    location_ref nloc = aut.add_location(aut.locations[loc].invariant(),newname,aut.locations[loc].time_post_poly());
    location_ref nloc = aut.add_location(newname,aut.locations[loc]);
    
    // add complement of constraint to new loc
    Constraint cn=closed_inequality_complement(c);
    aut.locations[nloc].invariant_add_constraint(cn);
    aut.assume_loc_modification(nloc);
        
    clock_val_set mu;
    // copy all transitions from loc to nloc
    // incoming transitions
		clock_val_set cvs;
//		transition_ref tr;
		bool add_trans=true;
    for (trans_ref_set::const_iterator i=aut.locations[loc].in_trans.begin();i!=aut.locations[loc].in_trans.end();++i)
    {
			if (aut.transitions[*i].source_loc()!=loc) // don't do self-loops
			{
				// check if new invariant and incoming invariant are disjunct
				add_trans=true;
				if (aut.transitions[*i].label==splitting_silent_label) // only add transition after some checks
				{
					cvs.intersection_assign_from(aut.locations[nloc].invariant(),aut.locations[aut.transitions[*i].source_loc()].invariant());
					// if it's a silent transition, only copy it if it's at least a hyperplane (otherwise it's redundant with one of the hyperplanes)
					if (cvs.is_empty() || (!cvs.is_empty() && REFINE_CHECK_TRANS_DIMS && cvs.get_real_dimension()<cvs.dim-1))
						add_trans=false;
				};
				if (add_trans)
				{
				mu=aut.transitions[*i].unrestricted_mu();
//					mu=aut.get_restricted_mu(*i);
//					if (!mu.is_empty())
						aut.copy_transition_with_target(*i, nloc, mu); // make a copy of transition
				};
			};
    };
    // outgoing transitions
    for (trans_ref_set::const_iterator i=aut.locations[loc].out_trans.begin();i!=aut.locations[loc].out_trans.end();++i)
    {
			if (aut.transitions[*i].target_loc()!=loc) // don't do self-loops
			{
				// check if new invariant and incoming invariant are disjunct
				add_trans=true;
				if (aut.transitions[*i].label==splitting_silent_label) // only add transition after some checks
				{
					cvs.intersection_assign_from(aut.locations[nloc].invariant(),aut.locations[aut.transitions[*i].target_loc()].invariant());
					// if it's a silent transition, only copy it if it's at least a hyperplane (otherwise it's redundant with one of the hyperplanes)
					if (cvs.is_empty() || (!cvs.is_empty() && REFINE_CHECK_TRANS_DIMS && cvs.get_real_dimension()<cvs.dim-1))
						add_trans=false;
				};
				if (add_trans)
				{
				mu=aut.transitions[*i].unrestricted_mu();
//					mu=aut.get_restricted_mu(*i);
//					if (!mu.is_empty())
							aut.copy_transition_with_source(*i, nloc, mu); // make a copy of transition
				};
			};
    };
		// Make a copy of self-loops,
		// because they're not covered by either of the previous cases
    for (trans_ref_set::const_iterator i=aut.locations[loc].out_trans.begin();i!=aut.locations[loc].out_trans.end();++i)
    {
			if (aut.transitions[*i].target_loc()==loc) // it's a self loop
			{
				mu=aut.transitions[*i].unrestricted_mu();
//				mu=aut.get_restricted_mu(*i);
//				if (!mu.is_empty())
						aut.copy_transition_with_self_loop(*i, nloc, loc, mu); // make a copy of transition

			};
    };		
  
    new_locs.push_back(nloc);

    // add original constraint to original loc
		
    aut.locations[loc].invariant_add_constraint(c);
		aut.assume_loc_modification(loc);
    // to fix incoming and outgoing transitions 
		if (REFINE_CHECK_TRANS_DIMS)
			aut.location_remove_nonface_silents(loc,splitting_silent_label);
        
		// ----------------------------------------
    // add new transitions that connect the two
		// ----------------------------------------
    dimension_type dim=aut.locations[loc].invariant().dim;
   
    Constraint_System cs(equality_constraint(c));
    convex_clock_val_set ccvs(cs);
    mu=clock_val_set(ccvs);
    mu.add_space_dimensions_and_embed(2*dim-mu.dim);
    mu.intersection_assign(identity_trans_clock_val_set(dim));
		// test of transition is time relevant
		if (REFINE_CHECK_TIME_RELEVANCE)
		{
		  // already existing transitions
			if (REFINE_CHECK_TIME_RELEVANCE_DURING) //if (!REFINE_USE_FP) // if fp equations are used, there is no guarantee for conservativenss
			{
				aut.location_remove_nontimerel_silents(loc,splitting_silent_label);
				aut.location_remove_nontimerel_silents(nloc,splitting_silent_label);
			};
			
			// test transitions that will connect the old and new location
			// note: in pratice, one test should suffice?
			if (REFINE_USE_FP && !aut.locations[loc].is_time_post_poly_uptodate())
			{
				convex_clock_val_set ccvs(get_loc_deriv(aut,loc));
				if (aut.reversed) ccvs.pointmirror_assign();
		//cout << "tp: " << ccvs << endl;	
				bool changed=false;
				changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
				if (!changed)
					ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
				aut.locations[loc].time_post_poly_assign(ccvs);
			};
				if (REFINE_USE_FP && !aut.locations[nloc].is_time_post_poly_uptodate())
			{
				convex_clock_val_set ccvs(get_loc_deriv(aut,nloc));
				if (aut.reversed) ccvs.pointmirror_assign();
		//cout << "tp: " << ccvs << endl;	
				bool changed=false;
				changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
				if (!changed)
					ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
				aut.locations[nloc].time_post_poly_assign(ccvs);
			};
						
			bool c_rel_loc=is_time_relevant(c,aut.locations[loc].time_post_poly());
			bool c_rel_nloc=is_time_relevant(c,aut.locations[nloc].time_post_poly());
			bool cn_rel_loc=is_time_relevant(cn,aut.locations[loc].time_post_poly());
			bool cn_rel_nloc=is_time_relevant(cn,aut.locations[nloc].time_post_poly());
			if (c_rel_loc && c_rel_nloc)
				aut.add_transition(loc,splitting_silent_label,mu,nloc);
			if (cn_rel_loc && cn_rel_nloc)
				aut.add_transition(nloc,splitting_silent_label,mu,loc);							
		}
		else
		{
			aut.add_transition(loc,splitting_silent_label,mu,nloc);
			aut.add_transition(nloc,splitting_silent_label,mu,loc);
		};
		
		
    
    // fix initial states
    if (aut.ini_states.find(loc)!=aut.ini_states.end())
    {
      clock_val_set cvs=aut.ini_states[loc];
      aut.ini_states[loc].add_constraint(c);
      // remove if empty
      if (aut.ini_states[loc].is_empty())
      {
        aut.ini_states.erase(loc);
//cout << "erasing...." << endl << flush;
      };
      cvs.add_constraint(cn);
      if (!cvs.is_empty())
        aut.ini_states[nloc]=cvs;
    };
  }; 
}

void split_location(automaton& aut,label_ref splitting_silent_label,location_ref loc,clock_val_set& inv1, clock_val_set& inv2, loc_ref_list& new_locs)
{
  // divide location loc up into two locations with invariant inv1 and inv2 respectively
  // add the new locations to the list new_locs
  
	if (true)
  {
    // increase partition level
		++aut.locations[loc].partition_level;

    string newname=aut.locations[loc].name+"@"+int2string(aut.locations.size())+"-";
		aut.locations[loc].name+="@"+int2string(aut.locations.size()) +"+";

    location_ref nloc = aut.add_location(newname,aut.locations[loc]);

//cout << nloc << ":" << inv1 << ";" << inv2 << endl << flush;    
    // add complement of constraint to new loc
//    aut.locations[nloc].invariant_add_constraint(cn);
		aut.locations[nloc].invariant_assign(inv2);
    aut.assume_loc_modification(nloc);
    
    // reset the number of checks for each location
    aut.locations[loc].nr_checks=0;
    aut.locations[nloc].nr_checks=0;
            
    clock_val_set mu;
    // copy all transitions from loc to nloc
    // incoming transitions
		clock_val_set cvs;
//		transition_ref tr;
		bool add_trans=true;
    for (trans_ref_set::const_iterator i=aut.locations[loc].in_trans.begin();i!=aut.locations[loc].in_trans.end();++i)
    {
			if (aut.transitions[*i].source_loc()!=loc) // don't do self-loops
			{
				// check if new invariant and incoming invariant are disjunct
				add_trans=true;
				if (aut.transitions[*i].label==splitting_silent_label) // only add transition after some checks
				{
					cvs.intersection_assign_from(aut.locations[nloc].invariant(),aut.locations[aut.transitions[*i].source_loc()].invariant());
					// if it's a silent transition, only copy it if it's at least a hyperplane (otherwise it's redundant with one of the hyperplanes)
					if (cvs.is_empty() || (!cvs.is_empty() && REFINE_CHECK_TRANS_DIMS && cvs.get_real_dimension()<cvs.dim-1))
						add_trans=false;
				};
				if (add_trans)
				{
				mu=aut.transitions[*i].unrestricted_mu();
//					mu=aut.get_restricted_mu(*i);
//					if (!mu.is_empty())
						aut.copy_transition_with_target(*i, nloc, mu); // make a copy of transition
				};
			};
    };
    // outgoing transitions
    for (trans_ref_set::const_iterator i=aut.locations[loc].out_trans.begin();i!=aut.locations[loc].out_trans.end();++i)
    {
			if (aut.transitions[*i].target_loc()!=loc) // don't do self-loops
			{
				// check if new invariant and incoming invariant are disjunct
				add_trans=true;
				if (aut.transitions[*i].label==splitting_silent_label) // only add transition after some checks
				{
					cvs.intersection_assign_from(aut.locations[nloc].invariant(),aut.locations[aut.transitions[*i].target_loc()].invariant());
					// if it's a silent transition, only copy it if it's at least a hyperplane (otherwise it's redundant with one of the hyperplanes)
					if (cvs.is_empty() || (!cvs.is_empty() && REFINE_CHECK_TRANS_DIMS && cvs.get_real_dimension()<cvs.dim-1))
						add_trans=false;
				};
				if (add_trans)
				{
				mu=aut.transitions[*i].unrestricted_mu();
//					mu=aut.get_restricted_mu(*i);
//					if (!mu.is_empty())
							aut.copy_transition_with_source(*i, nloc, mu); // make a copy of transition
				};
			};
    };
		// Make a copy of self-loops,
		// because they're not covered by either of the previous cases
    for (trans_ref_set::const_iterator i=aut.locations[loc].out_trans.begin();i!=aut.locations[loc].out_trans.end();++i)
    {
			if (aut.transitions[*i].target_loc()==loc) // it's a self loop
			{
				mu=aut.transitions[*i].unrestricted_mu();
//				mu=aut.get_restricted_mu(*i);
//				if (!mu.is_empty())
						aut.copy_transition_with_self_loop(*i, nloc, loc, mu); // make a copy of transition
			};
    };		
  
    new_locs.push_back(nloc);

    // add original constraint to original loc
		
//    aut.locations[loc].invariant_add_constraint(c);
		aut.locations[loc].invariant_assign(inv1);
		aut.assume_loc_modification(loc);
    // to fix incoming and outgoing transitions 
		if (REFINE_CHECK_TRANS_DIMS)
			aut.location_remove_nonface_silents(loc,splitting_silent_label);
        
		// ----------------------------------------
    // add new transitions that connect the two
		// ----------------------------------------
    dimension_type dim=aut.locations[loc].invariant().dim;
   
//    Constraint_System cs(equality_constraint(c));
		mu=inv1;
		mu.intersection_assign(inv2);
    mu.add_space_dimensions_and_embed(2*dim-mu.dim);
    mu.intersection_assign(identity_trans_clock_val_set(dim));
// 		// test of transition is time relevant
// 		if (REFINE_CHECK_TIME_RELEVANCE)
// 		{
// 		  // already existing transitions
// 			if (REFINE_CHECK_TIME_RELEVANCE_DURING) //if (!REFINE_USE_FP) // if fp equations are used, there is no guarantee for conservativenss
// 			{
// 				aut.location_remove_nontimerel_silents(loc,splitting_silent_label);
// 				aut.location_remove_nontimerel_silents(nloc,splitting_silent_label);
// 			};
// 			
// 			// test transitions that will connect the old and new location
// 			// note: in pratice, one test should suffice?
// 	if (REFINE_USE_FP && !aut.locations[loc].is_time_post_poly_uptodate())
// 	{
// 		convex_clock_val_set ccvs(get_loc_deriv(aut,loc));
//                 if (aut.reversed) ccvs.pointmirror_assign();
// //cout << "tp: " << ccvs << endl;	
// 		bool changed=false;
// 		changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
// 		if (!changed)
// 			ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
// 		aut.locations[loc].time_post_poly_assign(ccvs);
// 	};
// 		if (REFINE_USE_FP && !aut.locations[nloc].is_time_post_poly_uptodate())
// 	{
// 		convex_clock_val_set ccvs(get_loc_deriv(aut,nloc));
//                 if (aut.reversed) ccvs.pointmirror_assign();
// //cout << "tp: " << ccvs << endl;	
// 		bool changed=false;
// 		changed=ccvs.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
// 		if (!changed)
// 			ccvs.limit_significant_bits(CONSTRAINT_BITSIZE);
// 		aut.locations[nloc].time_post_poly_assign(ccvs);
// 	};
// 						
// 			bool c_rel_loc=is_time_relevant(c,aut.locations[loc].time_post_poly());
// 			bool c_rel_nloc=is_time_relevant(c,aut.locations[nloc].time_post_poly());
// 			bool cn_rel_loc=is_time_relevant(cn,aut.locations[loc].time_post_poly());
// 			bool cn_rel_nloc=is_time_relevant(cn,aut.locations[nloc].time_post_poly());
// 			if (c_rel_loc && c_rel_nloc)
// 				aut.add_transition(loc,splitting_silent_label,mu,nloc);
// 			if (cn_rel_loc && cn_rel_nloc)
// 				aut.add_transition(nloc,splitting_silent_label,mu,loc);							
// 		}
// 		else
// 		{
// 			aut.add_transition(loc,splitting_silent_label,mu,nloc);
// 			aut.add_transition(nloc,splitting_silent_label,mu,loc);
// 		};
 			aut.add_transition(loc,splitting_silent_label,mu,nloc);
 			aut.add_transition(nloc,splitting_silent_label,mu,loc);
		
		
    
    // fix initial states
    if (aut.ini_states.find(loc)!=aut.ini_states.end())
    {
      clock_val_set cvs=aut.ini_states[loc];
//      aut.ini_states[loc].add_constraint(c);
      aut.ini_states[loc].intersection_assign(inv1);
      // remove if empty
      if (aut.ini_states[loc].is_empty())
      {
        aut.ini_states.erase(loc);
//cout << "erasing...." << endl << flush;
      };
//      cvs.add_constraint(cn);
			cvs.intersection_assign(inv2);
      if (!cvs.is_empty())
        aut.ini_states[nloc]=cvs;
    };
  }; 
}

void split_location(automaton& aut,label_ref splitting_silent_label,const Constraint_List& cl, loc_ref_list& locs)
{
  // divide location loc up using a closed-partition based on cl
  // add the new locations to the list locs, i.e., return all modified locations in locs
  
  
  loc_ref_list new_locs;
  
  for (Constraint_List::const_iterator i=cl.begin();i!=cl.end();++i)
  {
    new_locs.clear();
    for (loc_ref_list::iterator j=locs.begin();j!=locs.end();++j)
    {
      split_location(aut,splitting_silent_label,*j,*i,new_locs);
    };
    // add new locs to existing locs
//    locs.insert(locs.end(),new_locs.begin(),new_locs.end());
    locs.splice(locs.end(),new_locs);
  };
}

void get_splitting_constraints(automaton& aut, location_ref loc, Constraint_List& cl, refinement_method method)
{
  cl.clear();
  
  // get center point if necessary
  double_point_list pl;
  uint dim=aut.locations[loc].invariant().dim; // just a default initialization
  double_point p(dim,0.0); // default initialization
	double_point dx(dim,0.0);
	Constraint c=(0*Variable(dim)==1); //Constraint::zero_dim_false(); // dummy initialization
	TNT::Array2D<double> Jx(dim,dim);
	double_point ddx(dim,0.0);
  
  if (method==carth_center || method==carth0_center || method==carth1_center || method==deriv_center || method==jacob_center)
  {
    // find geometric center point of vertices of invariant of location loc
		// todo: actual geometric center, for now it's just the arithmetic mean
    get_loc_vert(aut,loc,pl);
    if (!pl.empty())
    {
      dim=pl.begin()->dim();
      p=double_point(dim,0.0);
      get_double_point_list_center(pl,p);
    };
  };
  if (method==deriv_dcenter || method==jacob_dcenter)
  {
    // find center point of derivative
		pl.clear();
		if (method==deriv_dcenter)
		{
//			refine_loc_deriv(aut,loc); // shouldn't need to do this all the time, but it's not expensive, so what the heck
			add_cvs_to_double_point_list(aut.locations[loc].time_post_poly(),pl); // note: this yields actually the convex hull of all the derivatives. Good or bad?
//cout << aut.locations[loc].time_post_poly;
		}
		else if (method==jacob_dcenter) // use Jacobian*dx instead of dx, everything else stays the same
		{
			get_loc_vert(aut,loc,pl);
			if (!pl.empty())
			{
				for (double_point_list::iterator i=pl.begin();i!=pl.end();++i)
				{
					get_derivative(aut.name,*i,dx);
					get_jacobian(aut.name,*i,Jx);
					*i=Jx*dx;
				};
			};
		};
				
    if (!pl.empty())
    {
      dim=pl.begin()->dim();
      dx=double_point(dim,0.0);
      get_double_point_list_center(pl,dx);
    };
  };	
  
  if (method==carth_center)
  {
    if (!pl.empty())
    {
      // build carthesian cross through center
      Linear_Expression linex;
      
      for (uint i=0;i<dim;++i)
      {
        linex=0*Variable(dim-1)+Variable(i); // ensure that linex has full dimension
        get_constraint_through_double_point(linex,p,c);
//cout << c << ":" << CONSTRAINT_BITSIZE << endl;
limit_bitsize(c,CONSTRAINT_BITSIZE);
//cout << c << endl;
        cl.push_back(c);
      };
    };
  }
  else if (method==carth0_center)
  {
    if (!pl.empty())
    {
      // build carthesian cross through center
      Linear_Expression linex;
			linex=0*Variable(dim-1)+Variable(0); // ensure that linex has full dimension
			get_constraint_through_double_point(linex,p,c);
limit_bitsize(c,CONSTRAINT_BITSIZE);
			cl.push_back(c);
    };
  }	
  else if (method==carth1_center)
  {
    if (!pl.empty())
    {
      // build carthesian cross through center
      Linear_Expression linex;
			linex=0*Variable(dim-1)+Variable(1); // ensure that linex has full dimension
			get_constraint_through_double_point(linex,p,c);
limit_bitsize(c,CONSTRAINT_BITSIZE);
			cl.push_back(c);
    };
  }		
  else if (method==deriv_center)
  {
    if (!pl.empty())
    {
      // first constraint is the derivative dx/dt
      get_derivative(aut.name,p,dx);
      get_constraint_through_double_point(dx,p,c);
limit_bitsize(c,CONSTRAINT_BITSIZE);
      cl.push_back(c);
    };
  }
  else if (method==jacob_center)
  {
    if (!pl.empty())
    {
      get_derivative(aut.name,p,dx);
      get_jacobian(aut.name,p,Jx);
      
			ddx=Jx*dx;
      get_constraint_through_double_point(ddx,p,c);
limit_bitsize(c,CONSTRAINT_BITSIZE);
      cl.push_back(c);
    };
  }
  else if (method==deriv_dcenter || method==jacob_dcenter)
  {
    if (!pl.empty())
    {
      // derivative is already known as center of all derivatives
			// now position the plane between the min and max
			pl.clear();
			get_loc_vert(aut,loc,pl);
			if (!pl.empty())
			{
				dim=pl.begin()->dim();
				p=double_point(dim,0.0);
				get_double_point_list_center(pl,p);
				
				// find min and max in pl with respect to dx, i.e., min and max of pl[i]*dx 
				double min_dx,max_dx;
				double_point x_max(dim,0.0),x_min(dim,0.0);
//				uint pos;
				get_double_point_list_min_max(pl,dx,min_dx,max_dx,x_min,x_max);
				get_constraint_through_double(dx,-(min_dx+max_dx)/2,c);

// 				// Weigh the min. and max. point according to how the derivative in them deviates from the chosen average derivative.
// 				// The weights are determined by the abs. of the scalar product.
// 				double s1,s2;
// 				double_point d1(dim,0.0),d2(dim,0.0);
// 				get_derivative(x_min,d1);
// 				get_derivative(x_max,d2);
// 				s1=abs(scalar_product(d1,dx));
// 				s2=abs(scalar_product(d2,dx));
// 				if (s1==0 && s2==0) // in case they're both zero the interpolation would fail
// 				{
// 					s1=1; s2=1;
// 				};
// 				double dfinal=(s1*min_dx+s2*max_dx)/(s1+s2);
// 				get_constraint_through_double(dx,-dfinal,c);
// 				
limit_bitsize(c,CONSTRAINT_BITSIZE);
				cl.push_back(c);
			};
    };
  }
  else
    cout << "unknown method : "<< method<< endl;
}

void refine_locs(automaton& aut,label_ref splitting_silent_label, loc_ref_list& locs, refinement_method method)
{
  stopwatch sw(2100,"refine_locs");
	message(2100,"Refining " + int2string(locs.size()) + " locations of " + aut.name +".");	
  
	// Refine all locations in locs.
  // Returns in locs the set of modified locations
  loc_ref_list dlocs,all_locs;
  Constraint_List cl;
  
  for (loc_ref_list::iterator j=locs.begin();j!=locs.end();++j)
  {
    // get splitting constraints for the location
    get_splitting_constraints(aut,*j,cl,method);
    // if there is a split
    if (!cl.empty())
    {
      // now split the location
      dlocs.clear(); // put current location on waiting list
      dlocs.push_back(*j);
      split_location(aut,splitting_silent_label,cl,dlocs);
      // if recursive scheme, add dlocs to locs and restart from locs.begin()
      
      // copy all modified locations to all_locs
      all_locs.insert(all_locs.end(),dlocs.begin(),dlocs.end());
    }
    else
    {
      all_locs.push_back(*j);
    };
  };
  
  locs=all_locs;

	message(3100,"Resulted in refined " + int2string(locs.size()) + " locations of " + aut.name + ", total " + int2string(aut.locations.size()) + " locs, " + int2string(aut.transitions.size()) + " trans.");	
}

void refine_locs(automaton& aut,label_ref splitting_silent_label, refinement_method method, int iter)
{
  loc_ref_list locs;
  for (uint i=0;i<aut.locations.size();++i)
    locs.push_back(i);
    
  for (int i=0;i<iter;++i)
	{
    refine_locs(aut,splitting_silent_label,locs,method);
  
//  aut.restrict_mu_to_invariants();
  // recompute derivative
//  refine_loc_deriv(aut,locs);
	};
}
 
bool get_refinement_constraint(automaton& aut,location_ref loc,const clock_val_set& inv,const clock_val_set& reached,Constraint& con,bool& splits_reached)
{
	bool not_empty(false);
	set<pair<refine_criterion,Constraint>,refine_criterion_comp > constraint_cand;
	Rational dmin(0,1),delta(0,1),dmax(0,1);
	Integer min_n,min_d,max_n,max_d;
	bool min_exists,max_exists,dummybool;
	Linear_Expression linexp;
	bool temp_sr(true);  // default: if we don't know, consider it to split reach
	Constraint temp_con(Constraint::zero_dim_false()); // dummy init
//	refine_criterion temp_crit=make_pair(1,Rational(0,1)); // dummy init
	refine_criterion temp_crit;
  // Note: list <ConstraintRatPair> REFINE_CONSTRAINTRATPAIRLIST
  //	int temp_sr_int(0);
	bool is_candidate(true);
	clock_val_set cvs;
	//double angle_now,
	double angle_1,angle_2;
	bool refine_only_if_greater_dmax(false);

// GF 05.11.28
// Allow choice of splitting in the center of the location or at an optimal point
if (REFINE_LOCATION_PLANE==0) // default
{	
	// --------------------------
	// Create the candidate list
	// --------------------------
	// for each constraint in REFINE_CONSTRAINTRATPAIRLIST
//cout << "loc " << loc << " : " <<	get_loc_angle(aut, loc) << endl;
	if ((REFINE_DERIV_MINANGLE<1) && (get_loc_angle(aut, loc)>=REFINE_DERIV_MINANGLE))	
		refine_only_if_greater_dmax=true;

	for (list<ConstraintRatPair>::const_iterator iter=REFINE_CONSTRAINTRATPAIRLIST.begin(); iter!=REFINE_CONSTRAINTRATPAIRLIST.end(); ++iter)
	{
	// - dmin = delta from ConstraintRatPair
		dmin=iter->second.first;
		dmax=iter->second.second;
		temp_crit.clear(); // start a fresh list
		is_candidate=true;
// cout << "dmin = " << dmin << endl << flush;	
	// - if dmin>0
		if (dmin>0)
		{
	//   - compute minimum and maximum
			linexp=ConstraintHom2Linear_Expression(&iter->first);
// cout << "linexp = " << linexp << endl << flush;	
			min_exists=inv.minimize(linexp,min_n,min_d,dummybool);
			if (min_exists)
			{
				max_exists=inv.maximize(linexp,max_n,max_d,dummybool);
	//   - if both exist
				if (max_exists)
				{
	//     - delta=max-min (no abs needed?) 
					delta=Rational(max_n*min_d-min_n*max_d,min_d*max_d);
//cout << "delta = " << delta << ", dmin = " << dmin <<endl << flush;	
	//     - if delta>dmin 
					if (REFINE_FORCE_SPLITTING || delta>dmin && (!refine_only_if_greater_dmax || (dmax>Rational(0) && delta>dmax)))
					{
	//       - find out if it splits_reached at the center
						temp_con=2*min_d*max_d*linexp>=max_n*min_d+min_n*max_d;
						
						// prioritize the refinement of the max. size that violates the min. cell size dmax
						if (dmax > Rational(0) && delta>dmax)
							temp_crit.push_back((-delta/dmax).get_d());  // this takes priority over anything else
						else
						{
							temp_crit.push_back(0); // this will always be the last choice, since -delta/dmax < 0
						
						
						if (REFINE_PRIORITIZE_ANGLE)
						{
							// get the angle of new locations
//							angle_now=get_loc_angle(aut,loc);
							cvs=aut.locations[loc].invariant();
							cvs.add_constraint(temp_con);
							angle_1=get_loc_angle(aut,loc,cvs);
							cvs=aut.locations[loc].invariant();
							cvs.add_constraint(closed_inequality_complement(temp_con));
							angle_2=get_loc_angle(aut,loc,cvs);
//							if (min(angle_1,angle_2)<=angle_now)
//								is_candidate=false; // don't add the constraint if it doesn't improve the angle
							temp_crit.push_back(-min(angle_1,angle_2)); // maximize the worst case (min) angle
							// todo: if the reachables states are on one side, just consider the reachable states
//cout << "angles " << angle_1 << "," << angle_2 << endl;							
						};

						if (REFINE_PRIORITIZE_REACH_SPLIT)
						{
							temp_sr=reached.splits(temp_con);
// cout << temp_con << ":" << temp_sr << endl;						
	//       - crit=pair(splits_reached,delta/dmin)
							if (temp_sr)  // also the default if it wasn't tested
								temp_crit.push_back((double)1);
							else 
								temp_crit.push_back((double)0);
						};
													
						if (REFINE_SMALLEST_FIRST)
//							temp_crit=make_pair(temp_sr_int,(delta)/dmin); // minimize delta/dmin, 
							temp_crit.push_back((delta/dmin).get_d());
						else
//							temp_crit=make_pair(temp_sr_int,(-delta)/dmin); // maximize delta/dmin, same as minimize -delta/dmin
							temp_crit.push_back((-delta/dmin).get_d());
						};
	//       - put onto candidate list 
						
						if (is_candidate || delta>dmax)
							constraint_cand.insert(make_pair(temp_crit,temp_con));
					};
				}
            else // no maximum
            {
               // add maximum in reachable set + delta
               max_exists=reached.maximize(linexp,max_n,max_d,dummybool);
               if (max_exists)
               {
                  temp_con=dmin.get_den()*max_d*linexp>=max_n*dmin.get_den()+max_d*dmin.get_num();
               }
               else
               { // to do:  if there is no max just take zero
		 // invent maximum: add dmin to min
                  temp_con=min_d*dmin.get_den()*linexp<=min_n*dmin.get_den()+dmin.get_num()*min_d;
               };
//cout << "max : " << temp_con;
               temp_crit.push_back(-1);
					constraint_cand.insert(make_pair(temp_crit,temp_con));
            };
			}
         else // no minimum
         {
            // add minimum in reachable set + delta
   			min_exists=reached.minimize(linexp,min_n,min_d,dummybool);
            if (min_exists)
            {
 				  temp_con=dmin.get_den()*min_d*linexp>=min_n*dmin.get_den()-min_d*dmin.get_num();
            }
            else
            { // to do:  if there is no max just take zero
 				  temp_con=linexp>=0;
            };
//cout << "min : " << temp_con;            
            temp_crit.push_back(-1);
				constraint_cand.insert(make_pair(temp_crit,temp_con));
         };
		};
	};
	
	// --------------------------
	// the best is the first
	// --------------------------
	// - if candidate list is not empty
	//   - return all the values for this candidate
	if (!constraint_cand.empty())
	{
		not_empty=true;
		con=constraint_cand.begin()->second;
//cout << "Chosen: " << (constraint_cand.begin()->first).second <<endl << flush;	
		if (REFINE_PRIORITIZE_REACH_SPLIT) // it was tested in the candidate list
		{
			splits_reached=(*(constraint_cand.begin()->first).begin() > 0);
		}
		else if (REFINE_TEST_REACH_SPLIT) // test it now
		{
			splits_reached=reached.splits(con);
		}
		else
			splits_reached=true; // default case, because it contains all possibilities
	};
}
else if (REFINE_LOCATION_PLANE>=1) // choose optimal plane according to Doyen, Henzinger, Raskin
{
	// just set the remaining variables to some default values
	splits_reached=false;
// Note: splits_reached should be false unless you know that both parts have to be checked

	// compute the optimal plane con
	// automaton& aut,location_ref loc,const clock_val_set& inv,const clock_val_set& reached
	// get_optimal_plane should return true if it was successful in finding a useful split
	bool failure;
	not_empty=get_optimal_split_plane(aut,loc,inv,reached,con,failure);
};

REFINE_FORCE_SPLITTING=false; //gf 060306 avoid recursion	
	return not_empty;
}

bool get_refinement_invariants(automaton& aut,location_ref loc,const clock_val_set& inv,const clock_val_set& reached,clock_val_set& inv1,clock_val_set& inv2,bool& splits_reached)
{
	bool not_empty(false);
	bool failure(false);

if (REFINE_LOCATION_PLANE==2) // choose optimal plane according to Doyen, Henzinger, Raskin
{
	Constraint c(Variable(0)==0);
	// just set the remaining variables to some default values
	splits_reached=true;

	// compute the optimal plane con
	// automaton& aut,location_ref loc,const clock_val_set& inv,const clock_val_set& reached
	// get_optimal_plane should return true if it was successful in finding a useful split
	not_empty=get_optimal_split_plane(aut,loc,inv,reached,c,failure);
	
	if (not_empty && !failure)
	{
		convex_clock_val_set tp=aut.locations[loc].time_post_poly();
		if (c.is_equality()) // simply convert it into a non-strict inequality
			c=constraint_to_nonstrict_inequality(c);
		Constraint cn=closed_inequality_complement(c);


//cout << c << ";" << cn << endl ;		
		clock_val_set d1(tp),d2(tp);
		d1.add_constraint(c);
		d2.add_constraint(cn);
//	cout << "d1,d2:" << d1 << ";" << d2 << endl;
		// get F
		clock_val_set cvs(inv);
//	cout << "inv : " << inv << endl;
		cvs.add_space_dimensions_and_embed_before(aut.dim);
//	cout << "tp:" << aut.locations[loc].get_mylinvtef_tp() << endl;
//		cvs.add_constraint(aut.locations[loc].get_mylinvtef_tp()); // add the time elapse function
		cvs.add_constraint(get_deriv_over_states(aut,loc));
//	cout << "F : " << cvs << endl;
//clock_val_set tmp(cvs);
//tmp.remove_space_dimensions(0,aut.dim-1);
//cout << "available : " << tmp;
		d1.add_space_dimensions_and_embed(aut.dim); //  up to x,x'
		d2.add_space_dimensions_and_embed(aut.dim); //  up to x,x'
		
		d1.intersection_assign(cvs);
		d2.intersection_assign(cvs);
//	cout << "intersected d1,d2:" << d1 << ";" << d2 << endl;
		
		d1.remove_space_dimensions(0,aut.dim-1);
		d2.remove_space_dimensions(0,aut.dim-1);
	
		inv1=d1;
		inv2=d2;

//cout << inv1 << endl;
//cout << inv2 << endl;	
//inv1.print_gen_fp_raw(cout);
//inv2.print_gen_fp_raw(cout);
//inv.print_gen_fp_raw(cout);

// check if intersection with strict invariant is not empty
//cout << inv1.contains(inv2) << " or " << inv2.contains(inv1) << endl;

// output inv1,inv2
		if (inv1.is_empty() || inv2.is_empty() || inv1.contains(inv2) || inv2.contains(inv1))
			not_empty=false;

		//cout << not_empty << "!" << endl;		
		splits_reached=false;
	};
};

 if (REFINE_LOCATION_PLANE >2 || failure)  
{
	// test: use the old function
	Constraint con(Variable(0)==0);
	int old_REFINE_LOCATION_PLANE=REFINE_LOCATION_PLANE;
REFINE_LOCATION_PLANE=0;
	not_empty=get_refinement_constraint(aut,loc,inv,reached,con,splits_reached);
REFINE_LOCATION_PLANE=old_REFINE_LOCATION_PLANE;
	clock_val_set d1(inv);
	clock_val_set d2(inv);
	if (con.is_equality()) // simply convert it into a non-strict inequality
		con=constraint_to_nonstrict_inequality(con);
	Constraint cn=closed_inequality_complement(con);
	d1.add_constraint(con);
	d2.add_constraint(cn);

	inv1=d1;
	inv2=d2;
//cout << inv1 << ";" << inv2 << endl;
	splits_reached=false;
};
	
	return not_empty;
}

bool refine_location_otf(automaton& aut,location_ref tloc,clock_val_set& reached,symb_state_maplist& states,symb_state_plist& check_states,symb_state_plist& new_states,loc_ref_set& succ_locs, bool convex)
{
//	if (REFINE_CONSTRAINTRATPAIRLIST.empty() || aut.locations[tloc].is_fully_refined || (!aut.locations[tloc].is_variable_time() && !REFINE_USE_FP)  ) // don't refine
	if (( !aut.locations[tloc].is_surface ||
//			(REFINE_MAX_PARTITION_LEVEL>0 && aut.locations[tloc].partition_level>=REFINE_MAX_PARTITION_LEVEL) || // don't refine further than set level
			REFINE_CONSTRAINTRATPAIRLIST.empty() || aut.locations[tloc].is_fully_refined ) && !REFINE_FORCE_SPLITTING ) // don't refine
	{
//cout << tloc << ";";	
//if (!aut.locations[tloc].is_fully_refined)
//cout << get_loc_angle(aut, tloc) << endl;
			succ_locs.insert(tloc);		
			return false;
	}
	else
	{
		stopwatch sw(1024000,"refine_location_otf");
	
		bool level_blocked=false;
		loc_ref_list wait_list,new_locs;
		location_ref loc,newloc;
		Constraint con(Constraint::zero_dim_false()); // dummy init
		bool more_splitting(false);
		bool splits_reached(false);
		clock_val_set inv1,inv2;
			
		// put tloc onto wait_list
		wait_list.push_front(tloc);
		int iter=0;
		
		while (!wait_list.empty())
		{
			++iter;
			// pop loc 
			loc=*wait_list.begin();
			wait_list.pop_front();

// cout << "refining loc " << loc<< endl;
									
			more_splitting=false;
//			if ((REFINE_DERIV_MINANGLE>=1) || (get_loc_angle(aut, loc)<REFINE_DERIV_MINANGLE))	
//			{
			// get constraint
			if ( REFINE_FORCE_SPLITTING || !reached.contains(aut.locations[loc].invariant()) )
			{
				if (REFINE_LOCATION_PLANE<=1)
					more_splitting=get_refinement_constraint(aut,loc,aut.locations[loc].invariant(),reached,con,splits_reached);
				else
					more_splitting=get_refinement_invariants(aut,loc,aut.locations[loc].invariant(),reached,inv1,inv2,splits_reached);
			};
//			};
//cout << con << ";" << con.space_dimension() << endl << flush;
//cout << aut.locations[loc].invariant() << flush;
			level_blocked=false;
			if (((REFINE_PARTITION_INSIDE && iter>1) || (REFINE_PARTITION_LEVEL_MAX>=0 && aut.locations[loc].partition_level>=REFINE_PARTITION_LEVEL_MAX)) && more_splitting)   // don't refine further than set level
				level_blocked=true;
			
//if (false)
			if (more_splitting && !level_blocked)
//			if (more_splitting)
			{
				new_locs.clear();
//cout << "splitting at " << con;				

				if (REFINE_LOCATION_PLANE<=1)
					split_location(aut,REFINEMENT_LABEL,loc,con,new_locs); // comment: new_locs only ever gets one element here
				else
					split_location(aut,REFINEMENT_LABEL,loc,inv1,inv2,new_locs); // comment: new_locs only ever gets one element here
//aut.print();
				if (new_locs.begin() != new_locs.end()) // if a new location was generated
				{
				newloc=*new_locs.begin();
// cout << " with new loc " << newloc << endl;				
				// split maplist and waiting lists check_states and new_states
				states.split(loc, aut.locations[loc].invariant(), newloc, aut.locations[newloc].invariant(), check_states, new_states, convex);
				//				states.print();
				//				cout << con << endl;
//--------------------------------------------
// surface property might not hold any more
if (REFINE_PARTITION_INSIDE)
{
aut.locations[loc].is_surface=false;
aut.locations[newloc].is_surface=false;
};
//--------------------------------------------
				};

				if (!splits_reached)
				{ // only put the loc back on wait_list list that splits
					// todo: this could be had simpler if we rememberd in get_refinement_constraint which had been on what side...
					//       however, this should be reasonably fast anyway
					if (!reached.is_disjoint_from(aut.locations[loc].invariant()))
						wait_list.push_front(loc);
					if (new_locs.begin() != new_locs.end())
						if (!reached.is_disjoint_from(aut.locations[newloc].invariant()))
							wait_list.push_front(newloc);
				}
				else
				{ // put both on wait_list
					wait_list.push_front(loc);
					if (new_locs.begin() != new_locs.end())
						wait_list.push_front(newloc);
				};
			}
			else // no more splitting
			{
				if (!level_blocked)
					aut.locations[loc].is_fully_refined=true;
				succ_locs.insert(loc);
				
				// test for useless tau transitions
				if (REFINE_CHECK_TIME_RELEVANCE_FINAL) //if (!REFINE_USE_FP) // if fp equations are used, there is no guarantee for conservativenss
				{
					aut.location_remove_nontimerel_silents(loc,REFINEMENT_LABEL);
				};
				
			};
// cout << "wait_list:" << endl;				
// copy(wait_list.begin(), wait_list.end(), ostream_iterator<unsigned int>(cout, " "));
// cout << endl;
 		};
	};
	return true;
}

void
refine_states(automaton& aut,symb_state_maplist& states,symb_state_plist& check_states)
{
  // refine the locations in check_states, which refers to states.
  location_ref tloc;
//      clock_val_set cvs;
  clock_val_set newcvs,newcvs2;
	loc_ref_set succ_locs;
	
//	bool checktime=true;

	symb_state_plist new_states;
  list< symb_state >::iterator state_it,new_iter;
  while (!check_states.empty())
  {
    state_it=*check_states.begin();
		check_states.pop_front();
		
    tloc=state_it->loc;
//        cvs=state_it->second;

		// succ operator - part that depends on transition
		newcvs=*state_it;

		// Refine location
		succ_locs.clear();
		//		cout << "before" << endl << flush;
		refine_location_otf(aut,tloc,newcvs,states,check_states,new_states,succ_locs,USE_CONVEX_HULL); 
//					succ_locs.insert(tloc);
/*cout << "Check" << endl << flush;
check_states.print();
cout << "New" << endl << flush;
new_states.print();
cout << "States" << endl << flush;
states.print();*/
//		cout << "after" << endl << flush;
//		aut.print();					
					for (loc_ref_set::const_iterator i=succ_locs.begin(); i!=succ_locs.end(); ++i)
					{
//cout << "Checking loc" << tloc << endl;					
						tloc=*i;
//cout << "orig: " << newcvs << endl;								
						newcvs2.intersection_assign_from(newcvs,aut.locations[tloc].invariant());
						if (!newcvs2.is_empty())
						{
//							if (checktime && ELAPSE_TIME)
//								time_post_assign(tloc,newcvs);
// cout << "after: " << tloc << ":" << newcvs << endl;											
	
							if (!REACH_ONLY_EXPLORE)
							{
								if (!USE_CONVEX_HULL)
									new_iter=states.add(tloc,newcvs2);
								else
									new_iter=states.convex_hull_add(tloc,newcvs2);
								aut.insert_maplist_iter(states,new_states,new_iter);								
							}
							else // only follow new states
								states.copy_new(tloc,newcvs2,new_states);
						};
//cout << "rest: " << newcvs << endl;											
					};
// new_states.print();					
			
  }; // end while
	
	// put the new_states back on the list
	check_states.swap(new_states);
	//check_states=new_states;};
}


void
refine_states(automaton& aut,symb_states_type& s)
{
	// refine the locations in s
	symb_state_plist check_states;
	symb_state_maplist states(s,check_states);
	refine_states(aut,states,check_states);
};
