#ifndef GUARD_automaton_vec_h
#define GUARD_automaton_vec_h
/***************************************************************************
                          automaton_vec.h  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>

//#include "cvs_class.h"
//#include "symb_states.h"
#include "stopwatch.h"
#include "automaton.h"

extern bool COMPOSE_WITH_REACH; // prime R with reach set of P||Q in minimization

 
class automaton_vec : public vector<automaton>
{
  public:
  automaton_vec(); // clock_dim_type d); //:dim(d) {};

  // ---------------------------------------------------------------------------
  // Manipulation
  // ---------------------------------------------------------------------------
  void add_automaton(const automaton& aut);

  unsigned int get_automaton_id(const string aut_name);
  bool is_automaton_id(const string aut_name);

  // ---------------------------------------------------------------------------
  // Composition
  // ---------------------------------------------------------------------------
  loc_ref_vec_to_loc_ref_map compose(automaton& aut);
  loc_ref_vec_to_loc_ref_map compose_minimized_up_to(const clock_val_set& equiv_cvs,automaton& aut,unsigned int imax,bool use_bisimulation=false, label_ref_set ulabs=empty_label_ref_set(), bool test_satisfiability=false);

  // ---------------------------------------------------------------------------
  // Reachability
  // ---------------------------------------------------------------------------
  void loc_ref_vec_print(loc_ref_vec locs);

  // -----------------
  // Public properties
  // -----------------
  clock_dim_type dim;
  label_ref_set               labels;
//  clock_ref_set               variables;
  vector <vector <clock_ref> >  clock_ref_vec_vec;
  map <string,label_ref>      label_name_to_label_ref_map;
  variable_id_map var_id_map;
};
#endif
